/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.Radio;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class Form
extends TypifiedElement {
    private static final String TEXT_INPUT_TYPE = "text";
    private static final String PASSWORD_INPUT_TYPE = "password";
    private static final String CHECKBOX_TYPE = "checkbox";
    private static final String RADIO_TYPE = "radio";

    public Form(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void fill(Map<String, Object> data) {
        for (String key : data.keySet()) {
            WebElement elementToFill = this.findElementByKey(key);
            if (elementToFill == null) continue;
            this.fillElement(elementToFill, data.get(key));
        }
    }

    public void submit() {
        this.getWrappedElement().submit();
    }

    protected WebElement findElementByKey(String key) {
        List elements = this.getWrappedElement().findElements(By.name((String)key));
        if (elements.isEmpty()) {
            return null;
        }
        return (WebElement)elements.get(0);
    }

    protected void fillElement(WebElement element, Object value) {
        if (value == null) {
            return;
        }
        if (this.isInput(element)) {
            String inputType = element.getAttribute("type");
            if (inputType.equals(CHECKBOX_TYPE)) {
                CheckBox checkBox = new CheckBox(element);
                checkBox.set(Boolean.parseBoolean(value.toString()));
            } else if (inputType.equals(RADIO_TYPE)) {
                Radio radio = new Radio(element);
                radio.selectByValue(value.toString());
            } else {
                element.sendKeys(new CharSequence[]{Form.getClearTextInputElementCharSequence(element) + value.toString()});
            }
        } else if (this.isSelect(element)) {
            Select select = new Select(element);
            select.selectByValue(value.toString());
        } else if (this.isTextArea(element)) {
            element.sendKeys(new CharSequence[]{Form.getClearTextInputElementCharSequence(element) + value.toString()});
        }
    }

    private static String getClearTextInputElementCharSequence(WebElement element) {
        return StringUtils.repeat((String)(Keys.DELETE.toString() + Keys.BACK_SPACE), (int)element.getText().length());
    }

    private boolean isInput(WebElement element) {
        return "input".equals(element.getTagName());
    }

    private boolean isSelect(WebElement element) {
        return "select".equals(element.getTagName());
    }

    private boolean isTextArea(WebElement element) {
        return "textarea".equals(element.getTagName());
    }
}

