/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class Radio
extends TypifiedElement {
    public Radio(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public List<WebElement> getButtons() {
        String radioName = this.getWrappedElement().getAttribute("name");
        String xpath = radioName == null ? "self::* | following::input[@type = 'radio'] | preceding::input[@type = 'radio']" : String.format("self::* | following::input[@type = 'radio' and @name = '%s'] | preceding::input[@type = 'radio' and @name = '%s']", radioName, radioName);
        return this.getWrappedElement().findElements(By.xpath((String)xpath));
    }

    public WebElement getSelectedButton() {
        for (WebElement button : this.getButtons()) {
            if (!button.isSelected()) continue;
            return button;
        }
        throw new NoSuchElementException("No selected button");
    }

    public boolean hasSelectedButton() {
        for (WebElement button : this.getButtons()) {
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void selectByValue(String value) {
        for (WebElement button : this.getButtons()) {
            String buttonValue = button.getAttribute("value");
            if (!value.equals(buttonValue)) continue;
            this.selectButton(button);
            return;
        }
        throw new NoSuchElementException(String.format("Cannot locate radio button with value: %s", value));
    }

    public void selectByIndex(int index) {
        List<WebElement> buttons = this.getButtons();
        if (index < 0 || index >= buttons.size()) {
            throw new NoSuchElementException(String.format("Cannot locate radio button with index: %d", index));
        }
        this.selectButton(buttons.get(index));
    }

    private void selectButton(WebElement button) {
        if (!button.isSelected()) {
            button.click();
        }
    }
}

