/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import org.openqa.selenium.By;
import org.openqa.selenium.support.FindBy;
import ru.yandex.qatools.htmlelements.annotations.Block;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.pagefactory.AnnotationsHandler;

public class HtmlElementClassAnnotationsHandler<T extends HtmlElement>
extends AnnotationsHandler {
    private final Class<T> htmlElementClass;

    public HtmlElementClassAnnotationsHandler(Class<T> htmlElementClass) {
        this.htmlElementClass = htmlElementClass;
    }

    @Override
    public By buildBy() {
        for (Class<T> clazz = this.htmlElementClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (clazz.isAnnotationPresent(Block.class)) {
                Block block = clazz.getAnnotation(Block.class);
                return this.buildByFromFindBy(block.value());
            }
            if (!clazz.isAnnotationPresent(FindBy.class)) continue;
            return this.buildByFromFindBy(clazz.getAnnotation(FindBy.class));
        }
        throw new HtmlElementsException(String.format("Cannot determine how to locate instance of %s", this.htmlElementClass));
    }

    @Override
    public boolean shouldCache() {
        return false;
    }
}

