/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.Field;
import java.util.List;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementFactory;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementDecorator
extends DefaultFieldDecorator {
    public HtmlElementDecorator(ElementLocatorFactory locatorFactory) {
        super(locatorFactory);
    }

    public HtmlElementDecorator(SearchContext searchContext) {
        this(new HtmlElementLocatorFactory(searchContext));
    }

    public Object decorate(ClassLoader loader, Field field) {
        if (!this.isDecoratableField(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        String elementName = HtmlElementUtils.getElementName(field);
        if (HtmlElementUtils.isTypifiedElement(field)) {
            Class<?> typifiedElementClass = field.getType();
            return this.decorateTypifiedElement(typifiedElementClass, loader, locator, elementName);
        }
        if (HtmlElementUtils.isHtmlElement(field)) {
            Class<?> htmlElementClass = field.getType();
            return this.decorateHtmlElement(htmlElementClass, loader, locator, elementName);
        }
        if (HtmlElementUtils.isWebElement(field)) {
            return this.decorateWebElement(loader, locator, elementName);
        }
        if (HtmlElementUtils.isTypifiedElementList(field)) {
            Class typifiedElementClass = HtmlElementUtils.getGenericParameterClass(field);
            return this.decorateTypifiedElementList(typifiedElementClass, loader, locator, elementName);
        }
        if (HtmlElementUtils.isHtmlElementList(field)) {
            Class htmlElementClass = HtmlElementUtils.getGenericParameterClass(field);
            return this.decorateHtmlElementList(htmlElementClass, loader, locator, elementName);
        }
        if (HtmlElementUtils.isWebElementList(field)) {
            return this.decorateWebElementList(loader, locator, elementName);
        }
        return null;
    }

    private boolean isDecoratableField(Field field) {
        if (HtmlElementUtils.isWebElement(field) && !field.getName().equals("wrappedElement")) {
            return true;
        }
        return HtmlElementUtils.isWebElementList(field) || HtmlElementUtils.isHtmlElement(field) || HtmlElementUtils.isHtmlElementList(field) || HtmlElementUtils.isTypifiedElement(field) || HtmlElementUtils.isTypifiedElementList(field);
    }

    private <T extends TypifiedElement> T decorateTypifiedElement(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String elementName) {
        WebElement elementToWrap = HtmlElementFactory.createNamedProxyForWebElement(loader, locator, elementName);
        T typifiedElementInstance = HtmlElementFactory.createTypifiedElementInstance(elementClass, elementToWrap);
        ((TypifiedElement)typifiedElementInstance).setName(elementName);
        return typifiedElementInstance;
    }

    private <T extends HtmlElement> T decorateHtmlElement(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String elementName) {
        WebElement elementToWrap = HtmlElementFactory.createNamedProxyForWebElement(loader, locator, elementName);
        T htmlElementInstance = HtmlElementFactory.createHtmlElementInstance(elementClass);
        ((HtmlElement)htmlElementInstance).setWrappedElement(elementToWrap);
        ((HtmlElement)htmlElementInstance).setName(elementName);
        PageFactory.initElements((FieldDecorator)new HtmlElementDecorator((SearchContext)elementToWrap), htmlElementInstance);
        return htmlElementInstance;
    }

    private WebElement decorateWebElement(ClassLoader loader, ElementLocator locator, String elementName) {
        return HtmlElementFactory.createNamedProxyForWebElement(loader, locator, elementName);
    }

    private <T extends TypifiedElement> List<T> decorateTypifiedElementList(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String listName) {
        return HtmlElementFactory.createNamedProxyForTypifiedElementList(elementClass, loader, locator, listName);
    }

    private <T extends HtmlElement> List<T> decorateHtmlElementList(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String listName) {
        return HtmlElementFactory.createNamedProxyForHtmlElementList(elementClass, loader, locator, listName);
    }

    private List<WebElement> decorateWebElementList(ClassLoader loader, ElementLocator locator, String listName) {
        return HtmlElementFactory.createNamedProxyForWebElementList(loader, locator, listName);
    }
}

