/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.HtmlElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.TypifiedElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.WebElementListNamedProxyHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.WebElementNamedProxyHandler;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementFactory {
    public static <T extends HtmlElement> T createHtmlElementInstance(Class<T> elementClass) {
        try {
            return (T)((HtmlElement)HtmlElementUtils.newInstance(elementClass, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new HtmlElementsException(e);
        }
        catch (InstantiationException e) {
            throw new HtmlElementsException(e);
        }
        catch (IllegalAccessException e) {
            throw new HtmlElementsException(e);
        }
        catch (InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static <T extends TypifiedElement> T createTypifiedElementInstance(Class<T> elementClass, WebElement elementToWrap) {
        try {
            return (T)((TypifiedElement)HtmlElementUtils.newInstance(elementClass, elementToWrap));
        }
        catch (NoSuchMethodException e) {
            throw new HtmlElementsException(e);
        }
        catch (InstantiationException e) {
            throw new HtmlElementsException(e);
        }
        catch (IllegalAccessException e) {
            throw new HtmlElementsException(e);
        }
        catch (InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static <T> T createPageObjectInstance(Class<T> pageObjectClass, WebDriver driver) {
        try {
            return HtmlElementUtils.newInstance(pageObjectClass, driver);
        }
        catch (NoSuchMethodException e) {
            throw new HtmlElementsException(e);
        }
        catch (InstantiationException e) {
            throw new HtmlElementsException(e);
        }
        catch (IllegalAccessException e) {
            throw new HtmlElementsException(e);
        }
        catch (InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static WebElement createNamedProxyForWebElement(ClassLoader loader, ElementLocator locator, String name) {
        WebElementNamedProxyHandler handler = new WebElementNamedProxyHandler(locator, name);
        return (WebElement)Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
    }

    public static List<WebElement> createNamedProxyForWebElementList(ClassLoader loader, ElementLocator locator, String name) {
        WebElementListNamedProxyHandler handler = new WebElementListNamedProxyHandler(locator, name);
        return (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
    }

    public static <T extends TypifiedElement> List<T> createNamedProxyForTypifiedElementList(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String name) {
        TypifiedElementListNamedProxyHandler<T> handler = new TypifiedElementListNamedProxyHandler<T>(elementClass, locator, name);
        return (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, handler);
    }

    public static <T extends HtmlElement> List<T> createNamedProxyForHtmlElementList(Class<T> elementClass, ClassLoader loader, ElementLocator locator, String name) {
        HtmlElementListNamedProxyHandler<T> handler = new HtmlElementListNamedProxyHandler<T>(elementClass, locator, name);
        return (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, handler);
    }
}

