/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.pagefactory;

import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import ru.yandex.qatools.htmlelements.pagefactory.AnnotationsHandler;

public class DefaultFieldAnnotationsHandler
extends AnnotationsHandler {
    private Field field;

    protected Field getField() {
        return this.field;
    }

    public DefaultFieldAnnotationsHandler(Field field) {
        this.field = field;
    }

    @Override
    public boolean shouldCache() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    @Override
    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        if (ans == null && findBys != null) {
            ans = this.buildByFromFindBys(findBys);
        }
        FindAll findAll = this.field.getAnnotation(FindAll.class);
        if (ans == null && findAll != null) {
            ans = this.buildBysFromFindAll(findAll);
        }
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (ans == null && findBy != null) {
            ans = this.buildByFromFindBy(findBy);
        }
        if (ans == null) {
            ans = this.buildByFromDefault();
        }
        if (ans == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return ans;
    }

    protected By buildByFromDefault() {
        return new ByIdOrName(this.field.getName());
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        FindAll findAll = this.field.getAnnotation(FindAll.class);
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBys != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBys' annotation");
        }
    }
}

