/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.gitlab;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabProject;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.gitlab.GitLabIssue;

public class GitLabClient {
    private final String hostUrl;
    private final String apiToken;
    private List<GitlabIssue> issues;

    public GitLabClient(String hostUrl, String apiToken) {
        this.hostUrl = hostUrl;
        this.apiToken = apiToken;
    }

    public Optional<GitLabIssue> getIssue(String projectName, Integer matchedIssue) throws GitChangelogIntegrationException {
        GitlabProject project;
        GitlabAPI gitLabApi = GitlabAPI.connect((String)this.hostUrl, (String)this.apiToken);
        try {
            project = gitLabApi.getProject((Serializable)((Object)projectName));
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException("Unable to find project \"" + projectName + "\". It should be \"tomas.bjerre85/violations-test\" for a repo like: https://gitlab.com/tomas.bjerre85/violations-test", e);
        }
        Integer projectId = project.getId();
        String httpUrl = project.getHttpUrl();
        try {
            if (this.issues == null) {
                this.issues = this.getAllIssues(this.hostUrl, this.apiToken, projectId);
            }
            for (GitlabIssue candidate : this.issues) {
                if (candidate.getIid() != matchedIssue.intValue()) continue;
                return Optional.of(this.createGitLabIssue(httpUrl, candidate));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new GitChangelogIntegrationException(e.getMessage(), e);
        }
    }

    private GitLabIssue createGitLabIssue(String projectUrl, GitlabIssue candidate) {
        String title = candidate.getTitle();
        String link = projectUrl + "/issues/" + candidate.getIid();
        ArrayList<String> labels = new ArrayList<String>();
        for (String l : candidate.getLabels()) {
            labels.add(l);
        }
        return new GitLabIssue(title, link, labels);
    }

    private List<GitlabIssue> getAllIssues(String hostUrl, String apiToken, Integer projectId) throws IOException {
        GitlabAPI gitLabApi = GitlabAPI.connect((String)hostUrl, (String)apiToken);
        GitlabProject project = new GitlabProject();
        project.setId(projectId);
        return gitLabApi.getIssues(project);
    }
}

