/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import se.bjurr.gitchangelog.internal.git.model.GitCommit;
import se.bjurr.gitchangelog.internal.model.interfaces.IGitCommitReferer;
import se.bjurr.gitchangelog.internal.settings.SettingsIssueType;
import se.bjurr.gitchangelog.internal.util.Preconditions;

public class ParsedIssue
implements IGitCommitReferer {
    private final List<GitCommit> gitCommits = new ArrayList<GitCommit>();
    private final String name;
    private final String title;
    private final String link;
    private final String issue;
    private final String issueType;
    private final List<String> linkedIssues;
    private final List<String> labels;
    private final String description;
    private final SettingsIssueType settingsIssueType;

    public ParsedIssue(SettingsIssueType settingsIssueType, String name, String issue, String description, String link, String title, String issueType, List<String> linkedIssues, List<String> labels) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.title = Preconditions.emptyToNull(title);
        this.issue = issue;
        this.link = link;
        this.issueType = issueType;
        this.settingsIssueType = settingsIssueType;
        this.linkedIssues = linkedIssues;
        this.labels = labels;
        this.description = description;
    }

    public SettingsIssueType getSettingsIssueType() {
        return this.settingsIssueType;
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    public GitCommit getGitCommit() {
        return Preconditions.checkNotNull(this.gitCommits.get(0), this.name);
    }

    public List<GitCommit> getGitCommits() {
        return this.gitCommits;
    }

    public String getLink() {
        return this.link;
    }

    public String getIssueType() {
        return this.issueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.name + this.issue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != ParsedIssue.class) {
            return false;
        }
        return this.name.equals(((ParsedIssue)obj).getName());
    }

    public void addCommit(GitCommit gitCommit) {
        this.gitCommits.add(gitCommit);
    }

    public String getIssue() {
        return this.issue;
    }

    public String getDescription() {
        return this.description;
    }

    public void addCommits(List<GitCommit> commits) {
        this.gitCommits.addAll(commits);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getLinkedIssues() {
        return this.linkedIssues;
    }
}

