/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.gitchangelog.internal.integrations.jira;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import se.bjurr.gitchangelog.api.exceptions.GitChangelogIntegrationException;
import se.bjurr.gitchangelog.internal.integrations.jira.JiraIssue;

public abstract class JiraClient {
    private final String api;

    public JiraClient(String api) {
        this.api = api.endsWith("/") ? api.substring(0, api.length() - 1) : api;
    }

    public String getApi() {
        return this.api;
    }

    protected String getEndpoint(String issue) {
        String endpoint = this.api + "/rest/api/2/issue/" + issue + "?fields=parent,summary,issuetype,labels,description,issuelinks";
        return endpoint;
    }

    protected JiraIssue toJiraIssue(String issue, String json) {
        String title = (String)JsonPath.read((String)json, (String)"$.fields.summary", (Predicate[])new Predicate[0]);
        String description = (String)JsonPath.read((String)json, (String)"$.fields.description", (Predicate[])new Predicate[0]);
        String type = (String)JsonPath.read((String)json, (String)"$.fields.issuetype.name", (Predicate[])new Predicate[0]);
        String link = this.api + "/browse/" + issue;
        List labels = (List)JsonPath.read((String)json, (String)"$.fields.labels", (Predicate[])new Predicate[0]);
        ArrayList<String> linkedIssues = new ArrayList<String>();
        List inwardKey = (List)JsonPath.read((String)json, (String)"$.fields.issuelinks[*].inwardIssue.key", (Predicate[])new Predicate[0]);
        List outwardKey = (List)JsonPath.read((String)json, (String)"$.fields.issuelinks[*].outwardIssue.key", (Predicate[])new Predicate[0]);
        linkedIssues.addAll(inwardKey);
        linkedIssues.addAll(outwardKey);
        JiraIssue jiraIssue = new JiraIssue(title, description, link, issue, type, linkedIssues, labels);
        return jiraIssue;
    }

    public abstract JiraClient withBasicCredentials(String var1, String var2);

    public abstract JiraClient withBearer(String var1);

    public abstract JiraClient withTokenCredentials(String var1);

    public abstract JiraClient withHeaders(Map<String, String> var1);

    public abstract Optional<JiraIssue> getIssue(String var1) throws GitChangelogIntegrationException;
}

