/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Zone;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;
import se.unlogic.eagledns.SecondaryZone;
import se.unlogic.eagledns.zoneproviders.ZoneProvider;

public class CachedSecondaryZone {
    private Logger log = Logger.getLogger(this.getClass());
    protected ZoneProvider zoneProvider;
    private SecondaryZone secondaryZone;

    public CachedSecondaryZone(ZoneProvider zoneProvider, SecondaryZone secondaryZone) {
        this.zoneProvider = zoneProvider;
        this.secondaryZone = secondaryZone;
        if (this.secondaryZone.getZoneCopy() != null) {
            this.log.info((Object)("Using stored zone data for sedondary zone " + this.secondaryZone.getZoneName()));
        }
    }

    public SecondaryZone getSecondaryZone() {
        return this.secondaryZone;
    }

    public void setSecondaryZone(SecondaryZone secondaryZone) {
        this.secondaryZone = secondaryZone;
    }

    public void update(int axfrTimeout) {
        try {
            ZoneTransferIn xfrin = ZoneTransferIn.newAXFR((Name)this.secondaryZone.getZoneName(), (String)this.secondaryZone.getRemoteServerAddress(), null);
            xfrin.setDClass(DClass.value((String)this.secondaryZone.getDclass()));
            xfrin.setTimeout(axfrTimeout);
            List records = xfrin.run();
            if (!xfrin.isAXFR()) {
                this.log.warn((Object)("Unable to transfer zone " + this.secondaryZone.getZoneName() + " from server " + this.secondaryZone.getRemoteServerAddress() + ", response is not a valid AXFR!"));
                return;
            }
            Zone axfrZone = new Zone(this.secondaryZone.getZoneName(), records.toArray(new Record[records.size()]));
            this.log.debug((Object)("Zone " + this.secondaryZone.getZoneName() + " successfully transfered from server " + this.secondaryZone.getRemoteServerAddress()));
            if (!axfrZone.getSOA().getName().equals((Object)this.secondaryZone.getZoneName())) {
                this.log.warn((Object)("Invalid AXFR zone name in response when updating secondary zone " + this.secondaryZone.getZoneName() + ". Got zone name " + axfrZone.getSOA().getName() + " in respons."));
            }
            if (this.secondaryZone.getZoneCopy() == null || this.secondaryZone.getZoneCopy().getSOA().getSerial() != axfrZone.getSOA().getSerial()) {
                this.secondaryZone.setZoneCopy(axfrZone);
                this.secondaryZone.setDownloaded(new Timestamp(System.currentTimeMillis()));
                this.zoneProvider.zoneUpdated(this.secondaryZone);
                this.log.info((Object)("Zone " + this.secondaryZone.getZoneName() + " successfully updated from server " + this.secondaryZone.getRemoteServerAddress()));
            } else {
                this.log.info((Object)("Zone " + this.secondaryZone.getZoneName() + " is already up to date with serial " + axfrZone.getSOA().getSerial()));
                this.zoneProvider.zoneChecked(this.secondaryZone);
            }
            this.secondaryZone.setDownloaded(new Timestamp(System.currentTimeMillis()));
        }
        catch (IOException e) {
            this.log.warn((Object)("Unable to transfer zone " + this.secondaryZone.getZoneName() + " from server " + this.secondaryZone.getRemoteServerAddress() + ", " + e));
            this.checkExpired();
        }
        catch (ZoneTransferException e) {
            this.log.warn((Object)("Unable to transfer zone " + this.secondaryZone.getZoneName() + " from server " + this.secondaryZone.getRemoteServerAddress() + ", " + (Object)((Object)e)));
            this.checkExpired();
        }
        catch (RuntimeException e) {
            this.log.warn((Object)("Unable to transfer zone " + this.secondaryZone.getZoneName() + " from server " + this.secondaryZone.getRemoteServerAddress() + ", " + e));
            this.checkExpired();
        }
    }

    private void checkExpired() {
        if (this.secondaryZone.getDownloaded() != null && this.secondaryZone.getZoneCopy() != null && System.currentTimeMillis() - this.secondaryZone.getDownloaded().getTime() > this.secondaryZone.getZoneCopy().getSOA().getExpire() * 1000L) {
            this.log.warn((Object)("AXFR copy of secondary zone " + this.secondaryZone.getZoneName() + " has expired, deleting zone data..."));
            this.secondaryZone.setZoneCopy(null);
            this.secondaryZone.setDownloaded(null);
            this.zoneProvider.zoneUpdated(this.secondaryZone);
        }
    }
}

