/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.plugins.zonereplicator;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.unlogic.eagledns.plugins.BasePlugin;
import se.unlogic.eagledns.plugins.zonereplicator.ReplicationException;
import se.unlogic.eagledns.plugins.zonereplicator.ReplicationLoginHandler;
import se.unlogic.eagledns.plugins.zonereplicator.ReplicationResponse;
import se.unlogic.eagledns.plugins.zonereplicator.ReplicationServer;
import se.unlogic.eagledns.zoneproviders.db.beans.DBZone;
import se.unlogic.standardutils.collections.CollectionUtils;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.QueryOperators;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.SimpleAnnotatedDAOFactory;
import se.unlogic.standardutils.dao.SimpleDataSource;
import se.unlogic.standardutils.dao.TransactionHandler;
import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.rmi.PasswordLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationServerPlugin
extends BasePlugin
implements Remote,
ReplicationServer {
    private String rmiPassword;
    private Integer rmiPort;
    private String driver;
    private String url;
    private String username;
    private String password;
    private AnnotatedDAO<DBZone> zoneDAO;
    private HighLevelQuery<DBZone> allZonesQuery = new HighLevelQuery(DBZone.RECORDS_RELATION);
    private QueryParameterFactory<DBZone, Integer> zoneIDParamFactory;
    private QueryParameterFactory<DBZone, Long> serialParamFactory;
    private QueryParameterFactory<DBZone, Boolean> enabledParamFactory;
    private ReplicationLoginHandler replicationLoginHandler;

    @Override
    public void init(String name) throws Exception {
        SimpleDataSource dataSource;
        super.init(name);
        try {
            dataSource = new SimpleDataSource(this.driver, this.url, this.username, this.password);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Unable to load JDBC driver " + this.driver), (Throwable)e);
            throw e;
        }
        SimpleAnnotatedDAOFactory annotatedDAOFactory = new SimpleAnnotatedDAOFactory();
        this.zoneDAO = new AnnotatedDAO<DBZone>(dataSource, DBZone.class, annotatedDAOFactory);
        this.zoneIDParamFactory = this.zoneDAO.getParamFactory("zoneID", Integer.class);
        this.serialParamFactory = this.zoneDAO.getParamFactory("serial", Long.class);
        this.enabledParamFactory = this.zoneDAO.getParamFactory("enabled", Boolean.TYPE);
        super.init(name);
        if (this.rmiPassword == null || this.rmiPort == null) {
            throw new RuntimeException("RMI port and/or password not set");
        }
        this.replicationLoginHandler = new ReplicationLoginHandler(this, this.rmiPassword);
        PasswordLogin loginHandler = (PasswordLogin)UnicastRemoteObject.exportObject((Remote)this.replicationLoginHandler, this.rmiPort);
        UnicastRemoteObject.exportObject((Remote)this, this.rmiPort);
        Registry registry = LocateRegistry.createRegistry(this.rmiPort);
        registry.bind("replicationLoginHandler", loginHandler);
        this.log.info((Object)("Plugin " + this.name + " started with RMI interface on port " + this.rmiPort));
    }

    @Override
    public ReplicationResponse replicate(List<DBZone> clientZones) throws ReplicationException, RemoteException, ServerNotActiveException {
        String clientURL = UnicastRemoteObject.getClientHost();
        this.log.debug((Object)("Starting replication for client connecting from " + clientURL + " with " + CollectionUtils.getSize(clientZones) + " zones."));
        TransactionHandler transactionHandler = null;
        try {
            transactionHandler = this.zoneDAO.createTransaction();
            if (clientZones == null) {
                List<DBZone> dbZones = this.zoneDAO.getAll(this.allZonesQuery, transactionHandler);
                if (dbZones == null) {
                    return null;
                }
                ReplicationResponse response = new ReplicationResponse(dbZones, null, null);
                this.log.info((Object)("Replication changes found for client connecting from " + clientURL + " sending " + response));
                ReplicationResponse replicationResponse = response;
                return replicationResponse;
            }
            List<DBZone> newZones = this.getNewZones(clientZones, transactionHandler);
            List<DBZone> updatedZones = this.getUpdatedZones(clientZones, transactionHandler);
            List<DBZone> deletedZones = this.getDeletedZones(clientZones, transactionHandler);
            transactionHandler.commit();
            if (newZones == null && updatedZones == null && deletedZones == null) {
                this.log.debug((Object)"Replication finished, no changes found");
                return null;
            }
            ReplicationResponse response = new ReplicationResponse(newZones, updatedZones, deletedZones);
            this.log.info((Object)("Replication changes found for client connecting from " + clientURL + " sending " + response));
            ReplicationResponse replicationResponse = response;
            return replicationResponse;
        }
        catch (SQLException e) {
            this.log.error((Object)"Error during replication", (Throwable)e);
            throw new ReplicationException();
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error during replication", (Throwable)e);
            throw new ReplicationException();
        }
        finally {
            TransactionHandler.autoClose(transactionHandler);
        }
    }

    private List<DBZone> getNewZones(List<DBZone> clientZones, TransactionHandler transactionHandler) throws SQLException {
        HighLevelQuery<DBZone> query = new HighLevelQuery<DBZone>(DBZone.RECORDS_RELATION);
        ArrayList<Integer> zoneIDList = new ArrayList<Integer>(clientZones.size());
        for (DBZone dbZone : clientZones) {
            zoneIDList.add(dbZone.getZoneID());
        }
        query.addParameter(this.zoneIDParamFactory.getWhereNotInParameter(zoneIDList));
        return this.zoneDAO.getAll(query, transactionHandler);
    }

    private List<DBZone> getUpdatedZones(List<DBZone> clientZones, TransactionHandler transactionHandler) throws SQLException {
        ArrayList<DBZone> updatedZones = new ArrayList<DBZone>(clientZones.size());
        for (DBZone dbZone : clientZones) {
            HighLevelQuery<DBZone> query = new HighLevelQuery<DBZone>(DBZone.RECORDS_RELATION);
            query.addParameter(this.zoneIDParamFactory.getParameter(dbZone.getZoneID()));
            if (dbZone.getSerial() != null) {
                query.addParameter(this.serialParamFactory.getParameter(dbZone.getSerial(), QueryOperators.NOT_EQUALS));
            } else {
                query.addParameter(this.serialParamFactory.getIsNotNullParameter());
            }
            DBZone updatedZone = this.zoneDAO.get(query, transactionHandler);
            if (updatedZone != null) {
                updatedZones.add(updatedZone);
                continue;
            }
            query = new HighLevelQuery(DBZone.RECORDS_RELATION);
            query.addParameter(this.zoneIDParamFactory.getParameter(dbZone.getZoneID()));
            query.addParameter(this.enabledParamFactory.getParameter(dbZone.isEnabled(), QueryOperators.NOT_EQUALS));
            updatedZone = this.zoneDAO.get(query, transactionHandler);
            if (updatedZone == null) continue;
            updatedZones.add(updatedZone);
        }
        if (updatedZones.isEmpty()) {
            return null;
        }
        clientZones.removeAll(updatedZones);
        return updatedZones;
    }

    private List<DBZone> getDeletedZones(List<DBZone> clientZones, TransactionHandler transactionHandler) throws SQLException {
        ArrayList<DBZone> deletedZones = new ArrayList<DBZone>(clientZones.size());
        for (DBZone dbZone : clientZones) {
            if (this.zoneDAO.beanExists(dbZone, transactionHandler)) continue;
            deletedZones.add(dbZone);
        }
        if (deletedZones.isEmpty()) {
            return null;
        }
        return deletedZones;
    }

    public void setRmiServerHostname(String serverHost) {
        System.getProperties().put("java.rmi.server.hostname", serverHost);
    }

    public void setRmiPassword(String rmiPassword) {
        this.rmiPassword = rmiPassword;
    }

    public void setRmiPort(String rmiPort) {
        this.rmiPort = NumberUtils.toInt(rmiPort);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

