/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.resolvers;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import se.unlogic.eagledns.EagleDNS;
import se.unlogic.eagledns.Request;
import se.unlogic.eagledns.plugins.BasePlugin;
import se.unlogic.eagledns.resolvers.Resolver;
import se.unlogic.standardutils.net.SocketUtils;

public class AuthoritativeResolver
extends BasePlugin
implements Resolver {
    public Message generateReply(Request request) throws Exception {
        Message query = request.getQuery();
        Record queryRecord = query.getQuestion();
        Name name = queryRecord.getName();
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            this.log.debug((Object)("Resolver " + this.name + " processing request for " + name + ", matching zone found "));
            int flags = 0;
            Header header = query.getHeader();
            if (header.getFlag(0)) {
                return null;
            }
            if (header.getRcode() != 0) {
                return null;
            }
            if (header.getOpcode() != 0) {
                return null;
            }
            TSIGRecord queryTSIG = query.getTSIG();
            TSIG tsig = null;
            if (queryTSIG != null && ((tsig = this.systemInterface.getTSIG(queryTSIG.getName())) == null || tsig.verify(query, request.getRawQuery(), request.getRawQueryLength(), null) != 0)) {
                return null;
            }
            OPTRecord queryOPT = query.getOPT();
            if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
                flags = 1;
            }
            Message response = new Message(query.getHeader().getID());
            response.getHeader().setFlag(0);
            if (query.getHeader().getFlag(7)) {
                response.getHeader().setFlag(7);
            }
            response.addRecord(queryRecord, 0);
            int type = queryRecord.getType();
            int dclass = queryRecord.getDClass();
            if (type == 252 && request.getSocket() != null) {
                return this.doAXFR(name, query, tsig, queryTSIG, request.getSocket());
            }
            if (!Type.isRR((int)type) && type != 255) {
                return null;
            }
            byte rcode = this.addAnswer(response, name, type, dclass, 0, flags, zone);
            if (rcode != 0 && rcode != 3) {
                return EagleDNS.errorMessage(query, rcode);
            }
            this.addAdditional(response, flags);
            if (queryOPT != null) {
                int optflags = flags == 1 ? 32768 : 0;
                OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
                response.addRecord((Record)opt, 3);
            }
            response.setTSIG(tsig, 0, queryTSIG);
            return response;
        }
        this.log.debug((Object)("Resolver " + this.name + " ignoring request for " + name + ", no matching zone found"));
        return null;
    }

    private final void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    private byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags, Zone zone) {
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        if (zone == null) {
            zone = this.findBestZone(name);
        }
        if (zone != null) {
            SetResponse sr = zone.findRecords(name, type);
            if (sr.isNXDOMAIN()) {
                response.getHeader().setRcode(3);
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = 3;
            } else if (sr.isNXRRSET()) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else if (sr.isDelegation()) {
                RRset nsRecords = sr.getNS();
                this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
            } else if (sr.isCNAME()) {
                CNAMERecord cname = sr.getCNAME();
                RRset rrset = new RRset((Record)cname);
                this.addRRset(name, response, rrset, 1, flags);
                if (zone != null && iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags, null);
            } else if (sr.isDNAME()) {
                Name newname;
                DNAMERecord dname = sr.getDNAME();
                RRset rrset = new RRset((Record)dname);
                this.addRRset(name, response, rrset, 1, flags);
                try {
                    newname = name.fromDNAME(dname);
                }
                catch (NameTooLongException e) {
                    return 6;
                }
                rrset = new RRset((Record)new CNAMERecord(name, dclass, 0L, newname));
                this.addRRset(name, response, rrset, 1, flags);
                if (zone != null && iterations == 0) {
                    response.getHeader().setFlag(5);
                }
                rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags, null);
            } else if (sr.isSuccessful()) {
                RRset[] rrsets;
                RRset[] rRsetArray = rrsets = sr.answers();
                int n = rrsets.length;
                int n2 = 0;
                while (n2 < n) {
                    RRset rrset = rRsetArray[n2];
                    this.addRRset(name, response, rrset, 1, flags);
                    ++n2;
                }
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        }
        return (byte)rcode;
    }

    private Message doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket socket) {
        boolean first = true;
        Zone zone = this.findBestZone(name);
        if (zone == null) {
            return EagleDNS.errorMessage(query, 5);
        }
        boolean axfrAllowed = false;
        Iterator nsIterator = zone.getNS().rrs();
        while (nsIterator.hasNext()) {
            NSRecord record = (NSRecord)nsIterator.next();
            try {
                String nsIP = InetAddress.getByName(record.getTarget().toString()).getHostAddress();
                if (!socket.getInetAddress().getHostAddress().equals(nsIP)) continue;
                axfrAllowed = true;
                break;
            }
            catch (UnknownHostException e) {
                this.log.warn((Object)("Unable to resolve hostname of nameserver " + record.getTarget() + " in zone " + zone.getOrigin() + " while processing AXFR request from " + socket.getRemoteSocketAddress()));
            }
        }
        if (!axfrAllowed) {
            this.log.warn((Object)("AXFR request of zone " + zone.getOrigin() + " from " + socket.getRemoteSocketAddress() + " refused!"));
            return EagleDNS.errorMessage(query, 5);
        }
        Iterator it = zone.AXFR();
        try {
            try {
                DataOutputStream dataOut = new DataOutputStream(socket.getOutputStream());
                int id = query.getHeader().getID();
                while (it.hasNext()) {
                    RRset rrset = (RRset)it.next();
                    Message response = new Message(id);
                    Header header = response.getHeader();
                    header.setFlag(0);
                    header.setFlag(5);
                    this.addRRset(rrset.getName(), response, rrset, 1, 1);
                    if (tsig != null) {
                        tsig.applyStream(response, qtsig, first);
                        qtsig = response.getTSIG();
                    }
                    first = false;
                    byte[] out = response.toWire();
                    dataOut.writeShort(out.length);
                    dataOut.write(out);
                }
            }
            catch (IOException ex) {
                this.log.warn((Object)"AXFR failed", (Throwable)ex);
                SocketUtils.closeSocket(socket);
            }
        }
        finally {
            SocketUtils.closeSocket(socket);
        }
        return null;
    }

    private final void addSOA(Message response, Zone zone) {
        response.addRecord((Record)zone.getSOA(), 2);
    }

    private final void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, 1, 1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        Record[] records;
        Record[] recordArray = records = response.getSectionArray(section);
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Record r = recordArray[n2];
            Name glueName = r.getAdditionalName();
            if (glueName != null) {
                this.addGlue(response, glueName, flags);
            }
            ++n2;
        }
    }

    private RRset findExactMatch(Name name, int type, int dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        return null;
    }

    private void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        Record r;
        int s = 1;
        while (s <= section) {
            if (response.findRRset(name, rrset.getType(), s)) {
                return;
            }
            ++s;
        }
        if ((flags & 2) == 0) {
            Iterator it = rrset.rrs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
        if ((flags & 3) != 0) {
            Iterator it = rrset.sigs();
            while (it.hasNext()) {
                r = (Record)it.next();
                if (r.getName().isWild() && !name.isWild()) {
                    r = r.withName(name);
                }
                response.addRecord(r, section);
            }
        }
    }

    private Zone findBestZone(Name name) {
        Zone foundzone = this.systemInterface.getZone(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        int i = 1;
        while (i < labels) {
            Name tname = new Name(name, i);
            foundzone = this.systemInterface.getZone(tname);
            if (foundzone != null) {
                return foundzone;
            }
            ++i;
        }
        return null;
    }
}

