/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.eagledns.zoneproviders.db.beans;

import java.io.IOException;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;
import se.unlogic.eagledns.zoneproviders.db.beans.DBZone;
import se.unlogic.standardutils.annotations.WebPopulate;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.Key;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.dao.annotations.OrderBy;
import se.unlogic.standardutils.dao.annotations.Table;
import se.unlogic.standardutils.xml.Elementable;
import se.unlogic.standardutils.xml.XMLElement;
import se.unlogic.standardutils.xml.XMLGenerator;

@XMLElement
@Table(name="records")
public class DBRecord
implements Elementable,
Serializable {
    private static final long serialVersionUID = 4151433903523683216L;
    @DAOManaged(autoGenerated=true)
    @Key
    @XMLElement
    private Integer recordID;
    @DAOManaged(columnName="zoneID")
    @ManyToOne(remoteKeyField="zoneID")
    @XMLElement
    private DBZone zone;
    @DAOManaged
    @OrderBy(priority=1)
    @XMLElement
    @WebPopulate(required=true, maxLength=255L)
    private String name;
    @DAOManaged
    @OrderBy
    @XMLElement
    @WebPopulate(required=true, maxLength=6L)
    private String type;
    @DAOManaged
    @XMLElement
    @WebPopulate(required=true, maxLength=6L)
    private String dclass;
    @DAOManaged
    @XMLElement
    @WebPopulate(required=true, maxLength=255L)
    private String content;
    @DAOManaged
    @XMLElement
    @WebPopulate(populatorID="ttl")
    private Long ttl;

    public DBRecord() {
    }

    public DBRecord(Record record, Name origin, long zoneTTL) {
        this.name = record.getName().relativize(origin).toString();
        this.type = Type.string((int)record.getType());
        this.dclass = DClass.string((int)record.getDClass());
        this.content = record.rdataToString();
        this.ttl = record.getTTL() == zoneTTL ? null : Long.valueOf(record.getTTL());
    }

    public Integer getRecordID() {
        return this.recordID;
    }

    public void setRecordID(Integer recordID) {
        this.recordID = recordID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Element toXML(Document doc) {
        return XMLGenerator.toXML(this, doc);
    }

    public DBZone getZone() {
        return this.zone;
    }

    public void setZone(DBZone zone) {
        this.zone = zone;
    }

    public Record getRecord(long zoneTTL, Name origin) throws TextParseException, IOException {
        long ttl = this.ttl == null ? zoneTTL : this.ttl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.content);
        String rdata = stringBuilder.toString();
        Record record = Record.fromString((Name)Name.fromString((String)this.name, (Name)origin), (int)Type.value((String)this.type), (int)DClass.value((String)this.dclass), (long)ttl, (String)rdata, (Name)origin);
        return record;
    }

    public String getDclass() {
        return this.dclass;
    }

    public void setDclass(String dclass) {
        this.dclass = dclass;
    }

    public String toString() {
        if (this.zone != null) {
            return String.valueOf(this.name) + " (ID: " + this.zone.getZoneID() + ")";
        }
        return this.name;
    }
}

