/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import se.unlogic.standardutils.dao.ResultSetField;
import se.unlogic.standardutils.populators.annotated.AnnotatedResultSetPopulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnKeyCollector<T> {
    private final ResultSetField resultSetField;
    private final int columnIndex;

    public ColumnKeyCollector(Field field, AnnotatedResultSetPopulator<T> populator, int columnIndex) {
        this.resultSetField = populator.getResultSetField(field);
        this.columnIndex = columnIndex;
    }

    public void collect(T bean, ResultSet rs) throws SQLException {
        try {
            if (this.resultSetField.getResultSetColumnIndexMethod() != null) {
                Object value = this.resultSetField.getResultSetColumnIndexMethod().invoke((Object)rs, this.columnIndex);
                if (value == null && !this.resultSetField.getBeanField().getType().isPrimitive()) {
                    this.resultSetField.getBeanField().set(bean, null);
                } else {
                    this.resultSetField.getBeanField().set(bean, value);
                }
            } else {
                String value = rs.getString(this.columnIndex);
                if (value != null || this.resultSetField.getBeanStringPopulator().getType().isPrimitive()) {
                    this.resultSetField.getBeanField().set(bean, this.resultSetField.getBeanStringPopulator().getValue(value));
                } else {
                    this.resultSetField.getBeanField().set(bean, null);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

