/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import se.unlogic.standardutils.dao.AnnotatedDAO;
import se.unlogic.standardutils.dao.AnnotatedDAOFactory;
import se.unlogic.standardutils.dao.HighLevelQuery;
import se.unlogic.standardutils.dao.OneToManyRelation;
import se.unlogic.standardutils.dao.QueryParameter;
import se.unlogic.standardutils.dao.QueryParameterFactory;
import se.unlogic.standardutils.dao.RelationQuery;
import se.unlogic.standardutils.dao.annotations.DAOManaged;
import se.unlogic.standardutils.dao.annotations.ManyToOne;
import se.unlogic.standardutils.reflection.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOneToManyRelation<LocalType, RemoteType>
implements OneToManyRelation<LocalType, RemoteType> {
    private final Field field;
    private Field remoteField;
    private final AnnotatedDAOFactory daoFactory;
    private AnnotatedDAO<RemoteType> annotatedDAO;
    private QueryParameterFactory<RemoteType, LocalType> queryParameterFactory;
    private final Class<LocalType> beanClass;
    private final Class<RemoteType> remoteClass;
    private boolean initialized;

    public DefaultOneToManyRelation(Class<LocalType> beanClass, Class<RemoteType> remoteClass, Field field, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        this.beanClass = beanClass;
        this.remoteClass = remoteClass;
        this.field = field;
        this.daoFactory = daoFactory;
        List<Field> fields = ReflectionUtils.getFields(remoteClass);
        for (Field remoteField : fields) {
            if (!remoteField.getType().equals(beanClass) || !remoteField.isAnnotationPresent(DAOManaged.class) || !remoteField.isAnnotationPresent(ManyToOne.class)) continue;
            this.remoteField = remoteField;
            ReflectionUtils.fixFieldAccess(this.remoteField);
            break;
        }
        if (this.remoteField == null) {
            throw new RuntimeException("Unable to to find corresponding @ManyToOne field in class " + remoteClass + " for @OneToMany annotated field " + field.getName() + " in " + beanClass);
        }
    }

    @Override
    public void getRemoteValue(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            HighLevelQuery<RemoteType> query = new HighLevelQuery<RemoteType>();
            query.addRelations(relationQuery);
            if (relationQuery != null) {
                query.disableAutoRelations(relationQuery.isDisableAutoRelations());
            }
            query.addParameter(this.queryParameterFactory.getParameter(bean));
            this.field.set(bean, this.annotatedDAO.getAll(query, connection));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            List remoteBeans = (List)this.field.get(bean);
            if (remoteBeans != null) {
                this.fixReferences(remoteBeans, bean);
                this.annotatedDAO.addAll(remoteBeans, connection, relationQuery);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void fixReferences(List<RemoteType> remoteBeans, LocalType bean) throws IllegalArgumentException, IllegalAccessException {
        for (RemoteType remoteBean : remoteBeans) {
            this.remoteField.set(remoteBean, bean);
        }
    }

    @Override
    public void update(LocalType bean, Connection connection, RelationQuery relationQuery) throws SQLException {
        if (!this.initialized) {
            this.init();
        }
        try {
            List remoteBeans = (List)this.field.get(bean);
            if (remoteBeans == null || remoteBeans.isEmpty()) {
                HighLevelQuery<RemoteType> query = new HighLevelQuery<RemoteType>();
                query.addRelations(relationQuery);
                if (relationQuery != null) {
                    query.disableAutoRelations(relationQuery.isDisableAutoRelations());
                }
                query.addParameter(this.queryParameterFactory.getParameter(bean));
                this.annotatedDAO.delete(query, connection);
            } else {
                this.fixReferences(remoteBeans, bean);
                QueryParameter<RemoteType, LocalType> queryParameter = this.queryParameterFactory.getParameter(bean);
                if (!this.annotatedDAO.deleteWhereNotIn(remoteBeans, connection, this.remoteField, queryParameter)) {
                    HighLevelQuery<RemoteType> query = new HighLevelQuery<RemoteType>();
                    query.addParameter(queryParameter);
                    this.annotatedDAO.delete(query, connection);
                }
                this.annotatedDAO.addOrUpdateAll(remoteBeans, connection, relationQuery);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() {
        if (this.annotatedDAO == null) {
            this.annotatedDAO = this.daoFactory.getDAO(this.remoteClass);
            this.queryParameterFactory = this.annotatedDAO.getParamFactory(this.remoteField, this.beanClass);
        }
        this.initialized = true;
    }

    public static <LT, RT> OneToManyRelation<LT, RT> getGenericInstance(Class<LT> beanClass, Class<RT> remoteClass, Field field, AnnotatedDAOFactory daoFactory, DAOManaged daoManaged) {
        return new DefaultOneToManyRelation<LT, RT>(beanClass, remoteClass, field, daoFactory, daoManaged);
    }
}

