/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.mime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import se.unlogic.standardutils.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeUtils {
    private static String UnknownMimeType = "application/x-unknown";
    private static Properties MimeTypes = new Properties();

    static {
        try {
            MimeTypes.load(MimeUtils.class.getResourceAsStream("mimetypes.properties"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getMimeType(File file) {
        return MimeUtils.getMimeType(file.getName());
    }

    public static String getMimeType(String filename) {
        String fileExtension = FileUtils.getFileExtension(filename);
        if (fileExtension == null) {
            return UnknownMimeType;
        }
        return MimeTypes.getProperty(fileExtension.toLowerCase(), UnknownMimeType);
    }

    public static int getMimeTypeCount() {
        return MimeTypes.size();
    }

    public static Set<Map.Entry<Object, Object>> getMimeTypes() {
        return MimeTypes.entrySet();
    }

    public static void loadMimeTypes(InputStream inputStream) throws IOException {
        MimeTypes.clear();
        MimeTypes.load(inputStream);
    }

    public void loadMimeTypesFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        MimeTypes.loadFromXML(in);
    }
}

