/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.populators;

import java.sql.SQLException;
import java.util.UUID;
import se.unlogic.standardutils.dao.querys.PreparedStatementQuery;
import se.unlogic.standardutils.populators.BaseStringPopulator;
import se.unlogic.standardutils.populators.QueryParameterPopulator;
import se.unlogic.standardutils.validation.StringFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDPopulator
extends BaseStringPopulator<UUID>
implements QueryParameterPopulator<UUID> {
    public UUIDPopulator() {
    }

    public UUIDPopulator(String populatorID, StringFormatValidator formatValidator) {
        super(populatorID, formatValidator);
    }

    public UUIDPopulator(String populatorID) {
        super(populatorID);
    }

    @Override
    protected boolean validateDefaultFormat(String value) {
        try {
            UUID.fromString(value);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public Class<? extends UUID> getType() {
        return UUID.class;
    }

    @Override
    public UUID getValue(String value) {
        return UUID.fromString(value);
    }

    @Override
    public void populate(PreparedStatementQuery query, int paramIndex, Object uuid) throws SQLException {
        if (uuid == null) {
            query.setObject(paramIndex, null);
            return;
        }
        query.setString(paramIndex, ((UUID)uuid).toString());
    }
}

