/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import se.unlogic.standardutils.reflection.ReflectionUtils;
import se.unlogic.standardutils.string.BeanTagSource;
import se.unlogic.standardutils.string.StringUtils;
import se.unlogic.standardutils.string.TagSourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTagSourceFactory<T>
implements TagSourceFactory<T> {
    private Class<T> beanClass;
    private HashMap<String, Method> tagMethodMap = new HashMap();
    private HashMap<String, Field> tagFieldMap = new HashMap();
    private HashSet<String> tagsSet = new HashSet();

    public BeanTagSourceFactory(Class<T> beanClass) {
        this.beanClass = beanClass;
    }

    public void addMethodMapping(String tag, String methodName) throws NoSuchMethodException {
        Method method = ReflectionUtils.getMethod(this.beanClass, methodName, Object.class, new Class[0]);
        if (method == null) {
            throw new NoSuchMethodException("Method " + methodName + " with no input parameters not found in " + this.beanClass);
        }
        this.addMethodMapping(tag, method);
    }

    protected void addMethodMapping(String tag, Method method) {
        if (!method.isAccessible()) {
            ReflectionUtils.fixMethodAccess(method);
        }
        this.tagMethodMap.put(tag, method);
        this.tagsSet.add(tag);
    }

    public void addFieldMapping(String tag, String fieldName) throws NoSuchFieldException {
        Field field = ReflectionUtils.getField(this.beanClass, fieldName);
        if (field == null) {
            throw new NoSuchFieldException("Field " + fieldName + " not found in " + this.beanClass);
        }
        this.addFieldMapping(tag, field);
    }

    protected void addFieldMapping(String tag, Field field) {
        if (!field.isAccessible()) {
            ReflectionUtils.fixFieldAccess(field);
        }
        this.tagFieldMap.put(tag, field);
        this.tagsSet.add(tag);
    }

    public void addAllFields(String fieldPrefix, String ... excludedFields) {
        List<String> exclusionList = null;
        if (excludedFields != null) {
            exclusionList = Arrays.asList(excludedFields);
        }
        List<Field> fields = ReflectionUtils.getFields(this.beanClass);
        for (Field field : fields) {
            if (exclusionList != null && exclusionList.contains(field.getName())) continue;
            if (!field.isAccessible()) {
                ReflectionUtils.fixFieldAccess(field);
            }
            this.tagFieldMap.put(String.valueOf(fieldPrefix) + field.getName(), field);
            this.tagsSet.add(String.valueOf(fieldPrefix) + field.getName());
        }
    }

    @Override
    public <X extends T> BeanTagSource<T> getTagSource(X bean) {
        return new BeanTagSource<X>(bean, this.tagMethodMap, this.tagFieldMap, this.tagsSet);
    }

    public HashSet<String> getTagsSet() {
        return new HashSet<String>(this.tagsSet);
    }

    @Override
    public String getAvailableTags() {
        return StringUtils.toCommaSeparatedString(this.tagsSet);
    }
}

