/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.StringNumberValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLongValidator
extends StringNumberValidator<Long> {
    public StringLongValidator() {
        super(null, null);
    }

    public StringLongValidator(Long minValue, Long maxValue) {
        super(minValue, maxValue);
    }

    @Override
    public boolean validateFormat(String value) {
        Long numberValue = NumberUtils.toLong(value);
        if (numberValue == null) {
            return false;
        }
        if (this.maxValue != null && this.minValue != null) {
            return numberValue <= (Long)this.maxValue && numberValue >= (Long)this.minValue;
        }
        if (this.maxValue != null) {
            return numberValue <= (Long)this.maxValue;
        }
        if (this.minValue != null) {
            return numberValue >= (Long)this.minValue;
        }
        return true;
    }
}

