/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.io.File;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import se.unlogic.standardutils.xml.CachedXSLTBase;

public class CachedXSLTFile
extends CachedXSLTBase {
    private File file;
    private URIResolver uriResolver;

    public void reloadStyleSheet() throws TransformerConfigurationException {
        this.cacheStyleSheet(this.file);
    }

    public CachedXSLTFile(File f) throws TransformerConfigurationException {
        this.file = f;
        this.cacheStyleSheet(f);
    }

    public CachedXSLTFile(File file, URIResolver uriResolver) throws TransformerConfigurationException {
        this.file = file;
        this.uriResolver = uriResolver;
        this.cacheStyleSheet(file);
    }

    private void cacheStyleSheet(File f) throws TransformerConfigurationException {
        StreamSource xsltSource = new StreamSource(f);
        TransformerFactory transFact = TransformerFactory.newInstance();
        if (this.uriResolver != null) {
            transFact.setURIResolver(this.uriResolver);
        }
        this.templates = transFact.newTemplates(xsltSource);
        this.file = f;
    }

    public String toString() {
        return "CachedXSLTFile: " + this.file;
    }
}

