/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.xml;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ClassPathURIResolver
implements URIResolver {
    private static final ClassPathURIResolver CLASS_PATH_URI_RESOLVER = new ClassPathURIResolver();
    public static final String PREFIX = "classpath://";

    public static ClassPathURIResolver getInstance() {
        return CLASS_PATH_URI_RESOLVER;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith(PREFIX) && href.length() > PREFIX.length()) {
            URL url = ClassPathURIResolver.getURL(href);
            if (url != null) {
                return new StreamSource(url.toString());
            }
            throw new TransformerException("Unable to resolve href " + href);
        }
        return null;
    }

    public static URL getURL(String href) {
        String classPath = "/" + href.substring(PREFIX.length());
        return ClassPathURIResolver.class.getResource(classPath);
    }
}

