/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import se.unlogic.standardutils.streams.StreamUtils;

public class ZipUtils {
    public static void addFile(File file, ZipOutputStream outputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(file.getName());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            outputStream.putNextEntry(zipEntry);
            StreamUtils.transfer(inputStream, outputStream);
            outputStream.closeEntry();
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(inputStream);
            throw throwable;
        }
        StreamUtils.closeStream(inputStream);
    }

    public static void addFiles(File[] files, ZipOutputStream outputStream) throws IOException {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ZipUtils.addFile(file, outputStream);
            ++n2;
        }
    }
}

