/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.util.ExceptionUnwrapper;

public class TransactionRunner {
    public static final int DEFAULT_MAX_RETRIES = 10;
    private Environment env;
    private CurrentTransaction currentTxn;
    private int maxRetries;
    private TransactionConfig config;
    private boolean allowNestedTxn;

    public TransactionRunner(Environment env) {
        this(env, 10, null);
    }

    public TransactionRunner(Environment env, int maxRetries, TransactionConfig config) {
        this.env = env;
        this.currentTxn = CurrentTransaction.getInstance(env);
        this.maxRetries = maxRetries;
        this.config = config;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean getAllowNestedTransactions() {
        return this.allowNestedTxn;
    }

    public void setAllowNestedTransactions(boolean allowNestedTxn) {
        if (allowNestedTxn) {
            throw new UnsupportedOperationException("Nested transactions are not supported.");
        }
        this.allowNestedTxn = allowNestedTxn;
    }

    public TransactionConfig getTransactionConfig() {
        return this.config;
    }

    public void setTransactionConfig(TransactionConfig config) {
        this.config = config;
    }

    public void run(TransactionWorker worker) throws DatabaseException, Exception {
        if (this.currentTxn != null && (this.allowNestedTxn || this.currentTxn.getTransaction() == null)) {
            int i = 0;
            while (true) {
                Transaction txn = null;
                try {
                    txn = this.currentTxn.beginTransaction(this.config);
                    worker.doWork();
                    if (txn != null && txn == this.currentTxn.getTransaction()) {
                        this.currentTxn.commitTransaction();
                    }
                    return;
                }
                catch (Throwable e) {
                    e = ExceptionUnwrapper.unwrapAny(e);
                    if (txn != null && txn == this.currentTxn.getTransaction()) {
                        try {
                            this.currentTxn.abortTransaction();
                        }
                        catch (Throwable e2) {
                            e2.printStackTrace();
                            i = this.maxRetries + 1;
                        }
                    }
                    if (i >= this.maxRetries || !(e instanceof DeadlockException)) {
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        throw (Error)e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        try {
            worker.doWork();
        }
        catch (Exception e) {
            throw ExceptionUnwrapper.unwrap(e);
        }
    }
}

