/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.Generation;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IN
extends Node
implements Comparable,
LoggableObject,
LogReadable {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte CLEAR_KNOWN_DELETED_BIT = -2;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    private static final byte MIGRATE_BIT = 4;
    private static final byte CLEAR_MIGRATE_BIT = -5;
    private static final byte PENDING_DELETED_BIT = 8;
    private static final byte CLEAR_PENDING_DELETED_BIT = -9;
    private static final int BYTES_PER_LSN_ENTRY = 4;
    private static final int MAX_FILE_OFFSET = 0xFFFFFE;
    private static final int THREE_BYTE_NEGATIVE_ONE = 0xFFFFFF;
    private static final int GROWTH_INCREMENT = 5;
    public static final int DBMAP_LEVEL = 131072;
    public static final int MAIN_LEVEL = 65536;
    public static final int LEVEL_MASK = 65535;
    public static final int MIN_LEVEL = -1;
    public static final int MAX_LEVEL = Integer.MAX_VALUE;
    public static final int BIN_LEVEL = 65537;
    public static final int MAY_NOT_EVICT = 0;
    public static final int MAY_EVICT_LNS = 1;
    public static final int MAY_EVICT_NODE = 2;
    protected SharedLatch latch;
    private long generation;
    private boolean dirty;
    private int nEntries;
    private byte[] identifierKey;
    private Node[] entryTargets;
    private byte[][] entryKeyVals;
    private long baseFileNumber;
    private byte[] entryLsnByteArray;
    private long[] entryLsnLongArray;
    private byte[] entryStates;
    private DatabaseImpl databaseImpl;
    private boolean isRoot;
    private int level;
    private long inMemorySize;
    private boolean inListResident;
    private long lastFullVersion = -1L;
    private List provisionalObsolete;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    private int accumulatedDelta = 0;
    public static int ACCUMULATED_LIMIT;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IN() {
        super(false);
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public IN(DatabaseImpl db, byte[] identifierKey, int capacity, int level) {
        super(true);
        this.init(db, identifierKey, capacity, this.generateLevel(db.getId(), level));
        this.initMemorySize();
    }

    protected void init(DatabaseImpl db, byte[] identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        EnvironmentImpl env = this.databaseImpl == null ? null : this.databaseImpl.getDbEnvironment();
        this.latch = LatchSupport.makeSharedLatch(this.shortClassName() + this.getNodeId(), env);
        this.latch.setExclusiveOnly(EnvironmentImpl.getSharedLatches() ? this.isAlwaysLatchedExclusively() : true);
        if (!$assertionsDisabled && !this.latch.setNoteLatch(true)) {
            throw new AssertionError();
        }
        this.generation = 0L;
        this.dirty = false;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entryTargets = new Node[initialCapacity];
        this.entryKeyVals = new byte[initialCapacity][];
        this.baseFileNumber = -1L;
        this.entryLsnByteArray = new byte[initialCapacity << 2];
        this.entryLsnLongArray = null;
        this.entryStates = new byte[initialCapacity];
        this.isRoot = false;
        this.level = level;
        this.inListResident = false;
    }

    protected void initMemorySize() {
        this.inMemorySize = this.computeMemorySize();
    }

    private long getEqualityKey() {
        int hash = System.identityHashCode(this);
        long hash2 = (long)hash << 32 | (long)hash;
        return hash2 ^ this.getNodeId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return this.getEqualityKey() == in.getEqualityKey();
    }

    public int hashCode() {
        return (int)this.getEqualityKey();
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        IN argIN = (IN)o;
        long argEqualityKey = argIN.getEqualityKey();
        long myEqualityKey = this.getEqualityKey();
        if (myEqualityKey < argEqualityKey) {
            return -1;
        }
        if (myEqualityKey > argEqualityKey) {
            return 1;
        }
        return 0;
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    boolean isAlwaysLatchedExclusively() {
        return false;
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        EnvironmentImpl env = db.getDbEnvironment();
        this.initMemorySize();
        env.getInMemoryINs().add(this);
    }

    public void postRecoveryInit(DatabaseImpl db, long sourceLsn) {
        this.setDatabase(db);
        this.setLastFullLsn(sourceLsn);
        this.initMemorySize();
    }

    void setLastFullLsn(long lsn) {
        this.lastFullVersion = lsn;
    }

    public long getLastFullVersion() {
        return this.lastFullVersion;
    }

    public void latch(boolean updateGeneration) throws DatabaseException {
        if (updateGeneration) {
            this.setGeneration();
        }
        this.latch.acquireExclusive();
    }

    public void latchShared(boolean updateGeneration) throws DatabaseException {
        if (updateGeneration) {
            this.setGeneration();
        }
        this.latch.acquireShared();
    }

    public boolean latchNoWait(boolean updateGeneration) throws DatabaseException {
        if (this.latch.acquireExclusiveNoWait()) {
            if (updateGeneration) {
                this.setGeneration();
            }
            return true;
        }
        return false;
    }

    public void latch() throws DatabaseException {
        this.latch(true);
    }

    public void latchShared() throws DatabaseException {
        this.latchShared(true);
    }

    public boolean latchNoWait() throws DatabaseException {
        return this.latchNoWait(true);
    }

    public void releaseLatch() throws LatchNotHeldException {
        this.latch.release();
    }

    public void releaseLatchIfOwner() throws LatchNotHeldException {
        this.latch.releaseIfOwner();
    }

    public boolean isLatchOwnerForRead() {
        return this.latch.isOwner();
    }

    public boolean isLatchOwnerForWrite() {
        return this.latch.isWriteLockedByCurrentThread();
    }

    public long getGeneration() {
        return this.generation;
    }

    public void setGeneration() {
        this.generation = Generation.getNextGeneration();
    }

    public void setGeneration(long newGeneration) {
        this.generation = newGeneration;
    }

    public int getLevel() {
        return this.level;
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isDbRoot() {
        return this.isRoot;
    }

    void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
        this.setDirty(true);
    }

    public byte[] getIdentifierKey() {
        return this.identifierKey;
    }

    void setIdentifierKey(byte[] key) {
        this.identifierKey = key;
        this.setDirty(true);
    }

    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return mainTreeKey;
    }

    public byte[] getDupKey() throws DatabaseException {
        throw new DatabaseException(this.shortClassName() + ".getDupKey() called");
    }

    public byte[] getDupTreeKey() {
        return null;
    }

    public byte[] getMainTreeKey() {
        return this.getIdentifierKey();
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    private void setEntryInternal(int from, int to) {
        this.entryTargets[to] = this.entryTargets[from];
        this.entryKeyVals[to] = this.entryKeyVals[from];
        this.entryStates[to] = this.entryStates[from];
        if (this.entryLsnLongArray == null) {
            int fromOff = from << 2;
            int toOff = to << 2;
            this.entryLsnByteArray[toOff++] = this.entryLsnByteArray[fromOff++];
            this.entryLsnByteArray[toOff++] = this.entryLsnByteArray[fromOff++];
            this.entryLsnByteArray[toOff++] = this.entryLsnByteArray[fromOff++];
            this.entryLsnByteArray[toOff] = this.entryLsnByteArray[fromOff];
        } else {
            this.entryLsnLongArray[to] = this.entryLsnLongArray[from];
        }
    }

    private void clearEntry(int idx) {
        this.entryTargets[idx] = null;
        this.entryKeyVals[idx] = null;
        this.setLsnElement(idx, -1L);
        this.entryStates[idx] = 0;
    }

    public byte[] getKey(int idx) {
        return this.entryKeyVals[idx];
    }

    private void setKey(int idx, byte[] keyVal) {
        this.entryKeyVals[idx] = keyVal;
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    public boolean getMigrate(int idx) {
        return (this.entryStates[idx] & 4) != 0;
    }

    public void setMigrate(int idx, boolean migrate) {
        if (migrate) {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 4);
        } else {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFB);
        }
    }

    public byte getState(int idx) {
        return this.entryStates[idx];
    }

    public Node getTarget(int idx) {
        return this.entryTargets[idx];
    }

    void setTarget(int idx, Node target) {
        this.entryTargets[idx] = target;
    }

    public long getLsn(int idx) {
        if (this.entryLsnLongArray == null) {
            int offset = idx << 2;
            int fileOffset = this.getFileOffset(offset);
            if (fileOffset == -1) {
                return -1L;
            }
            return DbLsn.makeLsn(this.baseFileNumber + (long)this.getFileNumberOffset(offset), fileOffset);
        }
        return this.entryLsnLongArray[idx];
    }

    private void setLsn(int idx, long lsn) {
        int oldSize = this.computeLsnOverhead();
        this.setLsnElement(idx, lsn);
        this.changeMemorySize(this.computeLsnOverhead() - oldSize);
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
    }

    long[] getEntryLsnLongArray() {
        return this.entryLsnLongArray;
    }

    byte[] getEntryLsnByteArray() {
        return this.entryLsnByteArray;
    }

    void initEntryLsn(int capacity) {
        this.entryLsnLongArray = null;
        this.entryLsnByteArray = new byte[capacity << 2];
        this.baseFileNumber = -1L;
    }

    void setLsnElement(int idx, long value) {
        int offset = idx << 2;
        if (this.entryLsnLongArray != null) {
            this.entryLsnLongArray[idx] = value;
            return;
        }
        if (value == -1L) {
            this.setFileNumberOffset(offset, (byte)0);
            this.setFileOffset(offset, -1);
            return;
        }
        long thisFileNumber = DbLsn.getFileNumber(value);
        if (this.baseFileNumber == -1L) {
            this.baseFileNumber = thisFileNumber;
            this.setFileNumberOffset(offset, (byte)0);
        } else {
            long fileNumberDifference;
            if (thisFileNumber < this.baseFileNumber) {
                if (!this.adjustFileNumbers(thisFileNumber)) {
                    this.mutateToLongArray(idx, value);
                    return;
                }
                this.baseFileNumber = thisFileNumber;
            }
            if ((fileNumberDifference = thisFileNumber - this.baseFileNumber) > 127L) {
                this.mutateToLongArray(idx, value);
                return;
            }
            this.setFileNumberOffset(offset, (byte)(thisFileNumber - this.baseFileNumber));
        }
        int fileOffset = (int)DbLsn.getFileOffset(value);
        if (fileOffset > 0xFFFFFE) {
            this.mutateToLongArray(idx, value);
            return;
        }
        this.setFileOffset(offset, fileOffset);
    }

    private void mutateToLongArray(int idx, long value) {
        int nElts = this.entryLsnByteArray.length >> 2;
        long[] newArr = new long[nElts];
        for (int i = 0; i < nElts; ++i) {
            newArr[i] = this.getLsn(i);
        }
        newArr[idx] = value;
        this.entryLsnLongArray = newArr;
        this.entryLsnByteArray = null;
    }

    private boolean adjustFileNumbers(long newBaseFileNumber) {
        long oldBaseFileNumber = this.baseFileNumber;
        for (int i = 0; i < this.entryLsnByteArray.length; i += 4) {
            if (this.getFileOffset(i) == -1) continue;
            long curEntryFileNumber = oldBaseFileNumber + (long)this.getFileNumberOffset(i);
            long newCurEntryFileNumberOffset = curEntryFileNumber - newBaseFileNumber;
            if (newCurEntryFileNumberOffset > 127L) {
                long undoOffset = oldBaseFileNumber - newBaseFileNumber;
                for (int j = i - 4; j >= 0; j -= 4) {
                    if (this.getFileOffset(j) == -1) continue;
                    this.setFileNumberOffset(j, (byte)((long)this.getFileNumberOffset(j) - undoOffset));
                }
                return false;
            }
            this.setFileNumberOffset(i, (byte)newCurEntryFileNumberOffset);
        }
        return true;
    }

    private void setFileNumberOffset(int offset, byte fileNumberOffset) {
        this.entryLsnByteArray[offset] = fileNumberOffset;
    }

    private byte getFileNumberOffset(int offset) {
        return this.entryLsnByteArray[offset];
    }

    private void setFileOffset(int offset, int fileOffset) {
        this.put3ByteInt(offset + 1, fileOffset);
    }

    private int getFileOffset(int offset) {
        return this.get3ByteInt(offset + 1);
    }

    private void put3ByteInt(int offset, int value) {
        this.entryLsnByteArray[offset++] = (byte)(value >>> 0);
        this.entryLsnByteArray[offset++] = (byte)(value >>> 8);
        this.entryLsnByteArray[offset] = (byte)(value >>> 16);
    }

    private int get3ByteInt(int offset) {
        int ret = (this.entryLsnByteArray[offset++] & 0xFF) << 0;
        ret += (this.entryLsnByteArray[offset++] & 0xFF) << 8;
        if ((ret += (this.entryLsnByteArray[offset] & 0xFF) << 16) == 0xFFFFFF) {
            ret = -1;
        }
        return ret;
    }

    public boolean isEntryPendingDeleted(int idx) {
        return (this.entryStates[idx] & 8) != 0;
    }

    public void setPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 8);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public void clearPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFF7);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    public boolean isEntryKnownDeleted(int idx) {
        return (this.entryStates[idx] & 1) != 0;
    }

    void setKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 1);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    void clearKnownDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFE);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
    }

    boolean isDirty(int idx) {
        return (this.entryStates[idx] & 2) != 0;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    static boolean isStateKnownDeleted(byte state) {
        return (state & 1) != 0;
    }

    static boolean isStatePendingDeleted(byte state) {
        return (state & 1) != 0;
    }

    int getMaxEntries() {
        return this.entryTargets.length;
    }

    public Node fetchTarget(int idx) throws DatabaseException {
        if (this.entryTargets[idx] == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                if (!this.isEntryKnownDeleted(idx)) {
                    throw new DatabaseException(IN.makeFetchErrorMsg("NULL_LSN without KnownDeleted", this, lsn, this.entryStates[idx]));
                }
            } else {
                try {
                    EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
                    Node node = (Node)env.getLogManager().get(lsn);
                    node.postFetchInit(this.databaseImpl, lsn);
                    if (!$assertionsDisabled && !this.isLatchOwnerForWrite()) {
                        throw new AssertionError();
                    }
                    this.entryTargets[idx] = node;
                    this.updateMemorySize(null, node);
                }
                catch (LogFileNotFoundException LNFE) {
                    if (!this.isEntryKnownDeleted(idx) && !this.isEntryPendingDeleted(idx)) {
                        throw new DatabaseException(IN.makeFetchErrorMsg(LNFE.toString(), this, lsn, this.entryStates[idx]));
                    }
                }
                catch (Exception e) {
                    throw new DatabaseException(IN.makeFetchErrorMsg(e.toString(), this, lsn, this.entryStates[idx]), e);
                }
            }
        }
        return this.entryTargets[idx];
    }

    static String makeFetchErrorMsg(String msg, IN in, long lsn, byte state) {
        StringBuffer sb = new StringBuffer();
        sb.append("fetchTarget of ");
        if (lsn == -1L) {
            sb.append("null lsn");
        } else {
            sb.append(DbLsn.getNoFormatString(lsn));
        }
        if (in != null) {
            sb.append(" parent IN=").append(in.getNodeId());
            sb.append(" lastFullVersion=");
            sb.append(DbLsn.getNoFormatString(in.getLastFullVersion()));
            sb.append(" parent.getDirty()=").append(in.getDirty());
        }
        sb.append(" state=").append(state);
        sb.append(" ").append(msg);
        return sb.toString();
    }

    public void setEntry(int idx, Node target, byte[] keyVal, long lsn, byte state) {
        long oldSize = this.getEntryInMemorySize(idx);
        int newNEntries = idx + 1;
        if (newNEntries > this.nEntries) {
            this.nEntries = newNEntries;
            oldSize = 0L;
        }
        this.entryTargets[idx] = target;
        this.entryKeyVals[idx] = keyVal;
        this.setLsnElement(idx, lsn);
        this.entryStates[idx] = state;
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, Node node) {
        long oldSize = this.getEntryInMemorySize(idx);
        this.setTarget(idx, node);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
    }

    public void updateEntry(int idx, Node node, long lsn) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, Node node, long lsn, byte[] key) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        this.setKey(idx, key);
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn) {
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn, byte state) {
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.entryStates[idx] = state;
        this.setDirty(true);
    }

    public void updateEntry(int idx, long lsn, long oldLNSize, long newLNSize) {
        this.updateMemorySize(oldLNSize, newLNSize);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setDirty(true);
    }

    private void updateEntryCompareKey(int idx, Node node, long lsn, byte[] key) {
        long oldSize = this.getEntryInMemorySize(idx);
        if (this.notOverwritingDeferredWriteEntry(lsn)) {
            this.setLsn(idx, lsn);
        }
        this.setTarget(idx, node);
        byte[] existingKey = this.getKey(idx);
        int s = Key.compareKeys(key, existingKey, this.getKeyComparator());
        if (s < 0) {
            this.setKey(idx, key);
        }
        long newSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSize, newSize);
        this.setDirty(true);
    }

    boolean notOverwritingDeferredWriteEntry(long newLsn) {
        return !this.databaseImpl.isDeferredWrite() || newLsn != -1L;
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            Tracer.trace(Level.INFO, this.databaseImpl.getDbEnvironment(), msg);
            System.out.println(msg);
            return false;
        }
        return true;
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    private long getEntryInMemorySize(int idx) {
        return this.getEntryInMemorySize(this.entryKeyVals[idx], this.entryTargets[idx]);
    }

    protected long getEntryInMemorySize(byte[] key, Node target) {
        long ret = 0L;
        if (key != null) {
            ret += (long)MemoryBudget.byteArraySize(key.length);
        }
        if (target != null) {
            ret += target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    protected long computeMemorySize() {
        MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
        long calcMemorySize = this.getMemoryOverhead(mb);
        calcMemorySize += (long)this.computeLsnOverhead();
        for (int i = 0; i < this.nEntries; ++i) {
            calcMemorySize += this.getEntryInMemorySize(i);
        }
        if (this.provisionalObsolete != null) {
            calcMemorySize += (long)(this.provisionalObsolete.size() * MemoryBudget.LONG_LIST_PER_ITEM_OVERHEAD);
        }
        return calcMemorySize;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.IN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    private int computeLsnOverhead() {
        if (this.entryLsnLongArray == null) {
            return MemoryBudget.byteArraySize(this.entryLsnByteArray.length);
        }
        return MemoryBudget.BYTE_ARRAY_OVERHEAD + this.entryLsnLongArray.length * MemoryBudget.LONG_OVERHEAD;
    }

    protected static long computeArraysOverhead(DbConfigManager configManager) throws DatabaseException {
        int capacity = configManager.getInt(EnvironmentParams.NODE_MAX);
        return MemoryBudget.byteArraySize(capacity) + capacity * (2 * MemoryBudget.ARRAY_ITEM_OVERHEAD);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getINOverhead();
    }

    protected void updateMemorySize(ChildReference oldRef, ChildReference newRef) {
        long delta = 0L;
        if (newRef != null) {
            delta = this.getEntryInMemorySize(newRef.getKey(), newRef.getTarget());
        }
        if (oldRef != null) {
            delta -= this.getEntryInMemorySize(oldRef.getKey(), oldRef.getTarget());
        }
        this.changeMemorySize(delta);
    }

    protected void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.changeMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.changeMemorySize(delta);
    }

    private void changeMemorySize(long delta) {
        this.inMemorySize += delta;
        if (this.inListResident) {
            MemoryBudget mb = this.databaseImpl.getDbEnvironment().getMemoryBudget();
            this.accumulatedDelta = (int)((long)this.accumulatedDelta + delta);
            if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
                mb.updateTreeMemoryUsage(this.accumulatedDelta);
                this.accumulatedDelta = 0;
            }
        }
    }

    public int getAccumulatedDelta() {
        return this.accumulatedDelta;
    }

    public void setInListResident(boolean resident) {
        this.inListResident = resident;
    }

    public boolean isKeyInBounds(byte[] keyVal) {
        if (this.nEntries < 2) {
            return false;
        }
        byte[] myKey = this.entryKeyVals[0];
        Comparator userCompareToFcn = this.getKeyComparator();
        int cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        if (cmp < 0) {
            return false;
        }
        myKey = this.entryKeyVals[this.nEntries - 1];
        cmp = Key.compareKeys(keyVal, myKey, userCompareToFcn);
        return cmp <= 0;
    }

    public int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact) {
        boolean entryZeroSpecialCompare;
        int high = this.nEntries - 1;
        int low = 0;
        int middle = 0;
        Comparator userCompareToFcn = this.getKeyComparator();
        boolean bl = entryZeroSpecialCompare = this.entryZeroKeyComparesLow() && !exact && !indicateIfDuplicate;
        if (!$assertionsDisabled && this.nEntries < 0) {
            throw new AssertionError();
        }
        while (low <= high) {
            int s;
            middle = (high + low) / 2;
            byte[] middleKey = null;
            if (middle == 0 && entryZeroSpecialCompare) {
                s = 1;
            } else {
                middleKey = this.entryKeyVals[middle];
                s = Key.compareKeys(key, middleKey, userCompareToFcn);
            }
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            int ret = indicateIfDuplicate ? middle | 0x10000 : middle;
            if (ret >= 0 && exact && this.isEntryKnownDeleted(ret & 0xFFFF)) {
                return -1;
            }
            return ret;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public boolean insertEntry(ChildReference entry) throws DatabaseException {
        return (this.insertEntry1(entry) & 0x20000) != 0;
    }

    public int insertEntry1(ChildReference entry) throws DatabaseException {
        if (this.nEntries >= this.entryTargets.length) {
            this.compress(null, true);
        }
        if (this.nEntries < this.entryTargets.length) {
            byte[] key = entry.getKey();
            int index = this.findEntry(key, true, false);
            if (index >= 0 && (index & 0x10000) != 0) {
                return index;
            }
            if (++index < this.nEntries) {
                int oldSize = this.computeLsnOverhead();
                this.shiftEntriesRight(index);
                this.changeMemorySize(this.computeLsnOverhead() - oldSize);
            }
            this.entryTargets[index] = entry.getTarget();
            this.entryKeyVals[index] = entry.getKey();
            this.setLsnElement(index, entry.getLsn());
            this.entryStates[index] = entry.getState();
            ++this.nEntries;
            this.adjustCursorsForInsert(index);
            this.updateMemorySize(0L, this.getEntryInMemorySize(index));
            this.setDirty(true);
            return index | 0x20000;
        }
        throw new InconsistentNodeException("Node " + this.getNodeId() + " should have been split before calling insertEntry");
    }

    boolean deleteEntry(byte[] key, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        int index = this.findEntry(key, false, true);
        if (index < 0) {
            return false;
        }
        return this.deleteEntry(index, maybeValidate);
    }

    public boolean deleteEntry(int index, boolean maybeValidate) throws DatabaseException {
        if (this.nEntries == 0) {
            return false;
        }
        if (!$assertionsDisabled && maybeValidate && !this.validateSubtreeBeforeDelete(index)) {
            throw new AssertionError();
        }
        if (index < this.nEntries) {
            this.updateMemorySize(this.getEntryInMemorySize(index), 0L);
            int oldLSNArraySize = this.computeLsnOverhead();
            for (int i = index; i < this.nEntries - 1; ++i) {
                this.setEntryInternal(i + 1, i);
            }
            this.clearEntry(this.nEntries - 1);
            this.updateMemorySize(oldLSNArraySize, this.computeLsnOverhead());
            --this.nEntries;
            this.setDirty(true);
            this.setProhibitNextDelta();
            this.traceDelete(Level.FINEST, index);
            return true;
        }
        return false;
    }

    public void setProhibitNextDelta() {
    }

    public boolean compress(BINReference binRef, boolean canFetch) throws DatabaseException {
        return false;
    }

    public boolean isCompressible() {
        return false;
    }

    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        if (index >= this.nEntries) {
            return true;
        }
        Node child = this.fetchTarget(index);
        return child != null && child.isValidForDelete();
    }

    public boolean needsSplitting() {
        return this.entryTargets.length - this.nEntries < 1;
    }

    boolean entryZeroKeyComparesLow() {
        return true;
    }

    void split(IN parent, int childIndex, int maxEntries) throws DatabaseException {
        this.splitInternal(parent, childIndex, maxEntries, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void splitInternal(IN parent, int childIndex, int maxEntries, int splitIndex) throws DatabaseException {
        int high;
        int low;
        if (this.identifierKey == null) {
            throw new InconsistentNodeException("idkey is null");
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        IN newSibling = null;
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        byte[] newIdKey = this.entryKeyVals[low];
        long parentLsn = -1L;
        newSibling = this.createNewInstance(newIdKey, maxEntries, this.level);
        newSibling.latch();
        long oldMemorySize = this.inMemorySize;
        try {
            boolean insertOk;
            int toIdx = 0;
            boolean deletedEntrySeen = false;
            BINReference binRef = null;
            for (int i = low; i < high; ++i) {
                byte[] thisKey = this.entryKeyVals[i];
                if (this.isEntryPendingDeleted(i)) {
                    if (!deletedEntrySeen) {
                        deletedEntrySeen = true;
                        binRef = new BINReference(newSibling.getNodeId(), this.databaseImpl.getId(), newIdKey);
                    }
                    binRef.addDeletedKey(new Key(thisKey));
                }
                newSibling.setEntry(toIdx++, this.entryTargets[i], thisKey, this.getLsn(i), this.entryStates[i]);
                this.clearEntry(i);
            }
            if (deletedEntrySeen) {
                this.databaseImpl.getDbEnvironment().addToCompressorQueue(binRef, false);
            }
            int newSiblingNEntries = high - low;
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            newSibling.nEntries = toIdx;
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            this.adjustCursors(newSibling, low, high);
            EnvironmentImpl env = this.databaseImpl.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            long newSiblingLsn = newSibling.optionalLogProvisional(logManager, parent);
            long myNewLsn = this.optionalLogProvisional(logManager, parent);
            if (low == 0) {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, newSibling, newSiblingLsn, newIdKey);
                } else {
                    parent.updateEntry(childIndex, newSibling, newSiblingLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(this, this.entryKeyVals[0], myNewLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            } else {
                if (childIndex == 0) {
                    parent.updateEntryCompareKey(childIndex, this, myNewLsn, this.entryKeyVals[0]);
                } else {
                    parent.updateEntry(childIndex, this, myNewLsn);
                }
                insertOk = parent.insertEntry(new ChildReference(newSibling, newIdKey, newSiblingLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            }
            parentLsn = parent.optionalLog(logManager);
            if (parent.isRoot()) {
                parent.setDirty(true);
            }
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            inMemoryINs.add(newSibling);
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
        }
        finally {
            newSibling.releaseLatch();
        }
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && index == this.nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, this.nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public Comparator getKeyComparator() {
        return this.databaseImpl.getBtreeComparator();
    }

    private void shiftEntriesRight(int index) {
        for (int i = this.nEntries; i > index; --i) {
            this.setEntryInternal(i - 1, i);
        }
        this.clearEntry(index);
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        int i;
        for (i = 0; i < this.nEntries - byHowMuch; ++i) {
            this.setEntryInternal(i + byHowMuch, i);
        }
        for (i = this.nEntries - byHowMuch; i < this.nEntries; ++i) {
            this.clearEntry(i);
        }
        this.setDirty(true);
    }

    public void verify(byte[] maxKey) throws DatabaseException {
    }

    void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.getTarget(i);
            if (n == null) continue;
            n.rebuildINList(inList);
        }
    }

    void accountForSubtreeRemoval(INList inList, UtilizationTracker tracker) throws DatabaseException {
        if (this.nEntries > 1) {
            throw new DatabaseException("Found non-deletable IN " + this.getNodeId() + " while flushing INList. nEntries = " + this.nEntries);
        }
        inList.removeLatchAlreadyHeld(this);
        if (this.lastFullVersion != -1L) {
            tracker.countObsoleteNode(this.lastFullVersion, this.getLogType());
        }
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.fetchTarget(i);
            if (n == null) continue;
            n.accountForSubtreeRemoval(inList, tracker);
        }
    }

    boolean isValidForDelete() throws DatabaseException {
        if (this.nEntries > 1) {
            return false;
        }
        if (this.nEntries == 1) {
            Node child = this.fetchTarget(0);
            if (child == null) {
                return false;
            }
            child.latchShared();
            boolean ret = child.isValidForDelete();
            child.releaseLatch();
            return ret;
        }
        return true;
    }

    void findParent(Tree.SearchType searchType, long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, byte[] targetMainTreeKey, byte[] targetDupTreeKey, SearchResult result, boolean requireExactMatch, boolean updateGeneration, int targetLevel, List trackingList, boolean doFetch) throws DatabaseException {
        if (!$assertionsDisabled && !this.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        if (this.getNodeId() == targetNodeId) {
            this.releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            result.parent = null;
            return;
        }
        if (this.getNEntries() == 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
                result.index = -1;
            }
            return;
        }
        if (searchType == Tree.SearchType.NORMAL) {
            result.index = this.findEntry(this.selectKey(targetMainTreeKey, targetDupTreeKey), false, false);
        } else if (searchType == Tree.SearchType.LEFT) {
            result.index = 0;
        } else if (searchType == Tree.SearchType.RIGHT) {
            result.index = this.nEntries - 1;
        } else {
            throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
        }
        if (result.index < 0) {
            result.keepSearching = false;
            result.exactParentFound = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
            return;
        }
        Node child = null;
        boolean isDeleted = false;
        if (this.isEntryKnownDeleted(result.index)) {
            isDeleted = true;
        } else if (doFetch) {
            child = this.fetchTarget(result.index);
            if (child == null) {
                isDeleted = true;
            }
        } else {
            child = this.getTarget(result.index);
        }
        if (isDeleted) {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                result.parent = null;
                this.releaseLatch();
            } else {
                result.parent = this;
            }
            return;
        }
        if (targetLevel >= 0 && this.level == targetLevel + 1) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        if (child == null) {
            if (!$assertionsDisabled && doFetch) {
                throw new AssertionError();
            }
            result.keepSearching = false;
            result.exactParentFound = false;
            result.parent = this;
            result.childNotResident = true;
            return;
        }
        long childLsn = this.getLsn(result.index);
        if (child.isSoughtNode(targetNodeId, updateGeneration)) {
            result.exactParentFound = true;
            result.parent = this;
            result.keepSearching = false;
            return;
        }
        this.descendOnParentSearch(result, targetContainsDuplicates, targetIsRoot, targetNodeId, child, requireExactMatch);
        if (trackingList != null && result.parent != this && result.parent != null) {
            trackingList.add(new TrackingInfo(childLsn, child.getNodeId()));
        }
    }

    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            this.releaseLatch();
            result.parent = (IN)child;
        } else {
            ((IN)child).releaseLatch();
            result.exactParentFound = false;
            result.keepSearching = false;
            if (requireExactMatch) {
                this.releaseLatch();
                result.parent = null;
            } else {
                result.parent = this;
            }
        }
    }

    protected boolean isSoughtNode(long nid, boolean updateGeneration) throws DatabaseException {
        this.latch(updateGeneration);
        if (this.getNodeId() == nid) {
            this.releaseLatch();
            return true;
        }
        return false;
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return true;
    }

    public boolean isEvictable() {
        if (this.isEvictionProhibited()) {
            return false;
        }
        return !this.hasResidentChildren();
    }

    public int getEvictionType() {
        if (this.isEvictionProhibited()) {
            return 0;
        }
        return this.getChildEvictionType();
    }

    boolean isEvictionProhibited() {
        return this.isDbRoot();
    }

    int getChildEvictionType() {
        return this.hasResidentChildren() ? 0 : 2;
    }

    private boolean hasResidentChildren() {
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getTarget(i) == null) continue;
            return true;
        }
        return false;
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyChildren() throws DatabaseException {
        EnvironmentImpl envImpl = this.getDatabase().getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            IN child = (IN)this.getTarget(i);
            if (child == null) continue;
            child.latch(false);
            try {
                if (!child.getDirty()) continue;
                child.logDirtyChildren();
                long childLsn = child.log(envImpl.getLogManager(), false, true, false, this);
                this.updateEntry(i, childLsn);
                continue;
            }
            finally {
                child.releaseLatch();
            }
        }
    }

    public long log(LogManager logManager) throws DatabaseException {
        return this.logInternal(logManager, false, false, false, null);
    }

    public long log(LogManager logManager, boolean allowDeltas, boolean isProvisional, boolean proactiveMigration, IN parent) throws DatabaseException {
        return this.logInternal(logManager, allowDeltas, isProvisional, proactiveMigration, parent);
    }

    public long optionalLog(LogManager logManager) throws DatabaseException {
        if (this.databaseImpl.isDeferredWrite()) {
            return -1L;
        }
        return this.logInternal(logManager, false, false, false, null);
    }

    public long optionalLogProvisional(LogManager logManager, IN parent) throws DatabaseException {
        if (this.databaseImpl.isDeferredWrite()) {
            return -1L;
        }
        return this.logInternal(logManager, false, true, false, parent);
    }

    protected long logInternal(LogManager logManager, boolean allowDeltas, boolean isProvisional, boolean proactiveMigration, IN parent) throws DatabaseException {
        long lsn = logManager.log(new INLogEntry(this), isProvisional, isProvisional ? -1L : this.lastFullVersion);
        if (isProvisional) {
            if (parent != null) {
                parent.trackProvisionalObsolete(this, this.lastFullVersion, -1L);
            }
        } else {
            this.flushProvisionalObsolete(logManager);
        }
        this.setLastFullLsn(lsn);
        this.setDirty(false);
        return lsn;
    }

    void trackProvisionalObsolete(IN child, long obsoleteLsn1, long obsoleteLsn2) {
        int memDelta = 0;
        if (child.provisionalObsolete != null) {
            int childMemDelta = child.provisionalObsolete.size() * MemoryBudget.LONG_LIST_PER_ITEM_OVERHEAD;
            if (this.provisionalObsolete != null) {
                this.provisionalObsolete.addAll(child.provisionalObsolete);
            } else {
                this.provisionalObsolete = child.provisionalObsolete;
            }
            child.provisionalObsolete = null;
            child.changeMemorySize(0 - childMemDelta);
            memDelta += childMemDelta;
        }
        if (obsoleteLsn1 != -1L || obsoleteLsn2 != -1L) {
            if (this.provisionalObsolete == null) {
                this.provisionalObsolete = new ArrayList();
            }
            if (obsoleteLsn1 != -1L) {
                this.provisionalObsolete.add(new Long(obsoleteLsn1));
                memDelta += MemoryBudget.LONG_LIST_PER_ITEM_OVERHEAD;
            }
            if (obsoleteLsn2 != -1L) {
                this.provisionalObsolete.add(new Long(obsoleteLsn2));
                memDelta += MemoryBudget.LONG_LIST_PER_ITEM_OVERHEAD;
            }
        }
        if (memDelta != 0) {
            this.changeMemorySize(memDelta);
        }
    }

    void flushProvisionalObsolete(LogManager logManager) throws DatabaseException {
        if (this.provisionalObsolete != null) {
            int memDelta = this.provisionalObsolete.size() * MemoryBudget.LONG_LIST_PER_ITEM_OVERHEAD;
            logManager.countObsoleteINs(this.provisionalObsolete);
            this.provisionalObsolete = null;
            this.changeMemorySize(0 - memDelta);
        }
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    public int getLogSize() {
        boolean compactLsnsRep;
        int size = super.getLogSize();
        size += LogUtils.getByteArrayLogSize(this.identifierKey);
        size += LogUtils.getBooleanLogSize();
        size += 4;
        size += 4;
        size += 4;
        size += LogUtils.getBooleanLogSize();
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            size += 4;
        }
        for (int i = 0; i < this.nEntries; ++i) {
            size += LogUtils.getByteArrayLogSize(this.entryKeyVals[i]) + (compactLsnsRep ? 4 : LogUtils.getLongLogSize()) + 1;
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeByteArray(logBuffer, this.identifierKey);
        LogUtils.writeBoolean(logBuffer, this.isRoot);
        LogUtils.writeInt(logBuffer, this.nEntries);
        LogUtils.writeInt(logBuffer, this.level);
        LogUtils.writeInt(logBuffer, this.entryTargets.length);
        boolean compactLsnsRep = this.entryLsnLongArray == null;
        LogUtils.writeBoolean(logBuffer, compactLsnsRep);
        if (compactLsnsRep) {
            LogUtils.writeInt(logBuffer, (int)this.baseFileNumber);
        }
        int i = 0;
        while (i < this.nEntries) {
            LogUtils.writeByteArray(logBuffer, this.entryKeyVals[i]);
            if (!$assertionsDisabled && !this.checkForNullLSN(i)) {
                throw new AssertionError((Object)("logging IN " + this.getNodeId() + " with null lsn child " + " db=" + this.databaseImpl.getDebugName() + " isDeferredWrite=" + this.databaseImpl.isDeferredWrite()));
            }
            if (compactLsnsRep) {
                int offset = i << 2;
                int fileOffset = this.getFileOffset(offset);
                logBuffer.put(this.getFileNumberOffset(offset));
                logBuffer.put((byte)(fileOffset >>> 0 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 8 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 16 & 0xFF));
            } else {
                LogUtils.writeLong(logBuffer, this.entryLsnLongArray[i]);
            }
            logBuffer.put(this.entryStates[i]);
            int n = i++;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
        }
    }

    private boolean checkForNullLSN(int index) {
        boolean ok = this instanceof BIN ? this.getLsn(index) != -1L || (this.entryStates[index] & 1) != 0 : this.getLsn(index) != -1L;
        return ok;
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        this.identifierKey = LogUtils.readByteArray(itemBuffer);
        this.isRoot = LogUtils.readBoolean(itemBuffer);
        this.nEntries = LogUtils.readInt(itemBuffer);
        this.level = LogUtils.readInt(itemBuffer);
        int length = LogUtils.readInt(itemBuffer);
        this.entryTargets = new Node[length];
        this.entryKeyVals = new byte[length][];
        this.baseFileNumber = -1L;
        long storedBaseFileNumber = -1L;
        this.entryLsnByteArray = new byte[length << 2];
        this.entryLsnLongArray = null;
        this.entryStates = new byte[length];
        boolean compactLsnsRep = false;
        if (entryTypeVersion > 1 && (compactLsnsRep = LogUtils.readBoolean(itemBuffer))) {
            storedBaseFileNumber = this.baseFileNumber = (long)(LogUtils.readInt(itemBuffer) & 0xFFFFFFFF);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            long lsn;
            this.entryKeyVals[i] = LogUtils.readByteArray(itemBuffer);
            if (compactLsnsRep) {
                byte fileNumberOffset = itemBuffer.get();
                int fileOffset = itemBuffer.get() & 0xFF;
                fileOffset |= (itemBuffer.get() & 0xFF) << 8;
                lsn = (fileOffset |= (itemBuffer.get() & 0xFF) << 16) == 0xFFFFFF ? -1L : DbLsn.makeLsn(storedBaseFileNumber + (long)fileNumberOffset, fileOffset);
            } else {
                lsn = LogUtils.readLong(itemBuffer);
            }
            this.setLsnElement(i, lsn);
            byte entryState = itemBuffer.get();
            entryState = (byte)(entryState & 0xFFFFFFFD);
            entryState = (byte)(entryState & 0xFFFFFFFB);
            if (lsn == -1L) {
                entryState = (byte)(entryState | 1);
            }
            this.entryStates[i] = entryState;
        }
        this.latch.setName(this.shortClassName() + this.getNodeId());
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        boolean compactLsnsRep;
        sb.append(this.beginTag());
        super.dumpLog(sb, verbose);
        sb.append(Key.dumpString(this.identifierKey, 0));
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot);
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.entryTargets.length);
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            sb.append("\" baseFileNumber=\"");
            sb.append(this.baseFileNumber);
        }
        sb.append("\">");
        if (verbose) {
            for (int i = 0; i < this.nEntries; ++i) {
                sb.append("<ref knownDeleted=\"").append(this.isEntryKnownDeleted(i));
                sb.append("\" pendingDeleted=\"").append(this.isEntryPendingDeleted(i));
                sb.append("\">");
                sb.append(Key.dumpString(this.entryKeyVals[i], 0));
                sb.append(DbLsn.toString(this.getLsn(i)));
                sb.append("</ref>");
            }
        }
        sb.append("</entries>");
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    protected void dumpLogAdditional(StringBuffer sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    void dumpKeys() throws DatabaseException {
        for (int i = 0; i < this.nEntries; ++i) {
            System.out.println(Key.dumpString(this.entryKeyVals[i], 0));
        }
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(super.dumpString(nSpaces + 2, true));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : Key.dumpString(this.identifierKey, 0));
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.dirty).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<generation val=\"").append(this.generation).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        for (int i = 0; i < this.nEntries; ++i) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"" + i + "\">");
            sb.append('\n');
            if (this.getLsn(i) == -1L) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<lsn/>");
            } else {
                sb.append(DbLsn.dumpString(this.getLsn(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryKeyVals[i] == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<key/>");
            } else {
                sb.append(Key.dumpString(this.entryKeyVals[i], nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryTargets[i] == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<target/>");
            } else {
                sb.append(this.entryTargets[i].dumpString(nSpaces + 6, true));
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 6));
            IN.dumpDeletedState(sb, this.getState(i));
            sb.append("<dirty val=\"").append(this.isDirty(i)).append("\"/>");
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    static void dumpDeletedState(StringBuffer sb, byte state) {
        sb.append("<knownDeleted val=\"");
        sb.append(IN.isStateKnownDeleted(state)).append("\"/>");
        sb.append("<pendingDeleted val=\"");
        sb.append(IN.isStatePendingDeleted(state)).append("\"/>");
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    private void traceSplit(Level level, IN parent, IN newSibling, long parentLsn, long myNewLsn, long newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(DbLsn.getNoFormatString(parentLsn));
            sb.append(" childLsn = ");
            sb.append(DbLsn.getNoFormatString(myNewLsn));
            sb.append(" newSiblingLsn = ");
            sb.append(DbLsn.getNoFormatString(newSiblingLsn));
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            logger.log(level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !IN.class.desiredAssertionStatus();
        ACCUMULATED_LIMIT = 1000;
    }
}

