/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeStats;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tree
implements LogWritable,
LogReadable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private static final String TRACE_DUP_ROOT_SPLIT = "DupRootSplit:";
    private static final String TRACE_MUTATE = "Mut:";
    private static final String TRACE_INSERT = "Ins:";
    private static final String TRACE_INSERT_DUPLICATE = "InsD:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private boolean purgeRoot;
    private SharedLatch rootLatch;
    private TreeStats treeStats;
    private ThreadLocal treeStatsAccumulatorTL = new ThreadLocal();
    private static SplitRequiredException splitRequiredException;
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;
    private static RelatchRequiredException relatchRequiredException;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Tree(DatabaseImpl database) throws DatabaseException {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() throws DatabaseException {
        this.init(null);
        this.maxMainTreeEntriesPerNode = 0;
        this.maxDupTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = LatchSupport.makeSharedLatch("RootLatch", database != null ? database.getDbEnvironment() : null);
        this.treeStats = new TreeStats();
        this.root = null;
        this.database = database;
    }

    public void setDatabase(DatabaseImpl database) throws DatabaseException {
        this.database = database;
        this.maxMainTreeEntriesPerNode = database.getNodeMaxEntries();
        this.maxDupTreeEntriesPerNode = database.getNodeMaxDupTreeEntries();
        DbConfigManager configManager = database.getDbEnvironment().getConfigManager();
        this.purgeRoot = configManager.getBoolean(EnvironmentParams.COMPRESSOR_PURGE_ROOT);
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        if (!($assertionsDisabled || notLatched || this.rootLatch.isWriteLockedByCurrentThread())) {
            throw new AssertionError();
        }
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private ChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    TreeStats getTreeStats() {
        return this.treeStats;
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return (TreeWalkerStatsAccumulator)this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireExclusive();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireShared();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] idKey, UtilizationTracker tracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        IN subtreeRootIN = null;
        ArrayList nodeLadder = new ArrayList();
        IN rootIN = null;
        boolean rootNeedsUpdating = false;
        this.rootLatch.acquireExclusive();
        try {
            if (!this.rootExists()) {
                return;
            }
            rootIN = (IN)this.root.fetchTarget(this.database, null);
            rootIN.latch(false);
            this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
                if (this.purgeRoot && (subtreeRootIN = this.logTreeRemoval(rootIN)) != null) {
                    rootNeedsUpdating = true;
                }
            } else {
                SplitInfo detachPoint = (SplitInfo)nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                if (!$assertionsDisabled && !deleteOk) {
                    throw new AssertionError();
                }
                rootNeedsUpdating = this.cascadeUpdates(nodeLadder, null, -1);
                subtreeRootIN = detachPoint.child;
            }
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
        }
        if (subtreeRootIN != null) {
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            if (rootNeedsUpdating) {
                DbTree dbTree = envImpl.getDbMapTree();
                dbTree.optionalModifyDbRoot(this.database);
                RecoveryManager.traceRootDeletion(Level.FINE, this.database);
            }
            INList inList = envImpl.getInMemoryINs();
            this.accountForSubtreeRemoval(inList, subtreeRootIN, tracker);
        }
    }

    private void releaseNodeLadderLatches(ArrayList nodeLadder) throws DatabaseException {
        ListIterator iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = (SplitInfo)iter.previous();
            info.child.releaseLatch();
        }
    }

    private IN logTreeRemoval(IN rootIN) throws DatabaseException {
        if (!$assertionsDisabled && !this.rootLatch.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        IN detachedRootIN = null;
        if (rootIN.getNEntries() <= 1 && rootIN.validateSubtreeBeforeDelete(0)) {
            this.root = null;
            INDeleteInfo info = new INDeleteInfo(rootIN.getNodeId(), rootIN.getIdentifierKey(), this.database.getId());
            info.optionalLog(this.database.getDbEnvironment().getLogManager(), this.database);
            detachedRootIN = rootIN;
        }
        return detachedRootIN;
    }

    private boolean cascadeUpdates(ArrayList nodeLadder, BIN binRoot, int index) throws DatabaseException {
        ListIterator iter = nodeLadder.listIterator(nodeLadder.size());
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        LogManager logManager = envImpl.getLogManager();
        long newLsn = -1L;
        SplitInfo info = null;
        while (iter.hasPrevious()) {
            info = (SplitInfo)iter.previous();
            if (newLsn != -1L) {
                info.parent.updateEntry(info.index, newLsn);
            }
            newLsn = info.parent.optionalLog(logManager);
        }
        boolean rootNeedsUpdating = false;
        if (info != null) {
            if (info.parent.isDbRoot()) {
                if (!$assertionsDisabled && !this.rootLatch.isWriteLockedByCurrentThread()) {
                    throw new AssertionError();
                }
                this.root.updateLsnAfterOptionalLog(this.database, newLsn);
                rootNeedsUpdating = true;
            } else if (binRoot != null && info.parent.isRoot()) {
                binRoot.updateEntry(index, newLsn);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        return rootNeedsUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDup(byte[] idKey, byte[] mainKey, UtilizationTracker tracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        IN in = this.search(mainKey, SearchType.NORMAL, -1L, null, false);
        IN deletedSubtreeRoot = null;
        try {
            if (!$assertionsDisabled && !in.isLatchOwnerForWrite()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !(in instanceof BIN)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && in.getNEntries() <= 0) {
                throw new AssertionError();
            }
            int index = in.findEntry(mainKey, false, true);
            if (index >= 0) {
                deletedSubtreeRoot = this.deleteDupSubtree(idKey, (BIN)in, index);
            }
        }
        finally {
            in.releaseLatch();
        }
        if (deletedSubtreeRoot != null) {
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            this.accountForSubtreeRemoval(envImpl.getInMemoryINs(), deletedSubtreeRoot, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IN deleteDupSubtree(byte[] idKey, BIN bin, int index) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        boolean dupCountLNLocked = false;
        DupCountLN dcl = null;
        BasicLocker locker = new BasicLocker(envImpl);
        DIN duplicateRoot = (DIN)bin.fetchTarget(index);
        duplicateRoot.latch(false);
        ArrayList nodeLadder = new ArrayList();
        IN subtreeRootIN = null;
        try {
            ChildReference dclRef = duplicateRoot.getDupCountLNRef();
            dcl = (DupCountLN)dclRef.fetchTarget(this.database, duplicateRoot);
            LockResult lockResult = locker.nonBlockingLock(dcl.getNodeId(), LockType.READ, this.database);
            if (lockResult.getLockGrant() == LockGrantType.DENIED) {
                throw CursorsExistException.CURSORS_EXIST;
            }
            dupCountLNLocked = true;
            this.searchDeletableSubTree(duplicateRoot, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
                if (bin.nCursors() != 0) throw CursorsExistException.CURSORS_EXIST;
                boolean deleteOk = bin.deleteEntry(index, true);
                if (!$assertionsDisabled && !deleteOk) {
                    throw new AssertionError();
                }
                INDupDeleteInfo info = new INDupDeleteInfo(duplicateRoot.getNodeId(), duplicateRoot.getMainTreeKey(), duplicateRoot.getDupTreeKey(), this.database.getId());
                info.optionalLog(envImpl.getLogManager(), this.database);
                subtreeRootIN = duplicateRoot;
                if (bin.getNEntries() != 0) return subtreeRootIN;
                this.database.getDbEnvironment().addToCompressorQueue(bin, null, false);
                return subtreeRootIN;
            } else {
                SplitInfo detachPoint = (SplitInfo)nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                if (!$assertionsDisabled && !deleteOk) {
                    throw new AssertionError();
                }
                this.cascadeUpdates(nodeLadder, bin, index);
                subtreeRootIN = detachPoint.child;
            }
            return subtreeRootIN;
        }
        finally {
            this.releaseNodeLadderLatches(nodeLadder);
            if (dupCountLNLocked) {
                locker.releaseLock(dcl.getNodeId());
            }
            if (duplicateRoot != null) {
                duplicateRoot.releaseLatch();
            }
        }
    }

    public IN getFirstNode() throws DatabaseException {
        return this.search(null, SearchType.LEFT, -1L, null, true);
    }

    public IN getLastNode() throws DatabaseException {
        return this.search(null, SearchType.RIGHT, -1L, null, true);
    }

    public DBIN getFirstNode(DIN dupRoot) throws DatabaseException {
        if (dupRoot == null) {
            throw new IllegalArgumentException("getFirstNode passed null root");
        }
        if (!$assertionsDisabled && !dupRoot.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(dupRoot, null, SearchType.LEFT, -1L, null, true);
        return (DBIN)ret;
    }

    public DBIN getLastNode(DIN dupRoot) throws DatabaseException {
        if (dupRoot == null) {
            throw new IllegalArgumentException("getLastNode passed null root");
        }
        if (!$assertionsDisabled && !dupRoot.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(dupRoot, null, SearchType.RIGHT, -1L, null, true);
        return (DBIN)ret;
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, boolean updateGeneration) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, updateGeneration, -1, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, boolean updateGeneration, int targetLevel, List trackingList) throws DatabaseException {
        if (child == null) {
            throw new IllegalArgumentException("getParentNode passed null");
        }
        if (!$assertionsDisabled && !child.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        byte[] mainTreeKey = child.getMainTreeKey();
        byte[] dupTreeKey = child.getDupTreeKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), child.containsDuplicates(), isRoot, mainTreeKey, dupTreeKey, requireExactMatch, updateGeneration, targetLevel, trackingList, true);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, byte[] targetMainTreeKey, byte[] targetDupTreeKey, boolean requireExactMatch, boolean updateGeneration, int targetLevel, List trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = this.getRootINLatchedExclusive(updateGeneration);
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId()));
            }
            IN potentialParent = rootIN;
            try {
                while (result.keepSearching) {
                    if (!$assertionsDisabled && !TestHookExecute.doHookIfSet(this.searchHook)) {
                        throw new AssertionError();
                    }
                    potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetContainsDuplicates, targetIsRoot, targetMainTreeKey, targetDupTreeKey, result, requireExactMatch, updateGeneration, targetLevel, trackingList, doFetch);
                    potentialParent = result.parent;
                }
            }
            catch (Exception e) {
                potentialParent.releaseLatchIfOwner();
                throw new DatabaseException(e);
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] mainKey, byte[] dupKey, LN ln, boolean splitsAllowed, boolean findDeletedEntries, boolean searchDupTree, boolean updateGeneration) throws DatabaseException {
        IN searchResult = null;
        try {
            searchResult = splitsAllowed ? this.searchSplitsAllowed(mainKey, -1L, updateGeneration) : this.search(mainKey, SearchType.NORMAL, -1L, null, updateGeneration);
            location.bin = (BIN)searchResult;
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer();
            if (searchResult != null) {
                searchResult.releaseLatchIfOwner();
                msg.append("searchResult=" + searchResult.getClass() + " nodeId=" + searchResult.getNodeId() + " nEntries=" + searchResult.getNEntries());
            }
            throw new DatabaseException(msg.toString(), e);
        }
        if (location.bin == null) {
            return false;
        }
        boolean exactSearch = false;
        boolean indicateIfExact = true;
        if (!findDeletedEntries) {
            exactSearch = true;
            indicateIfExact = false;
        }
        location.index = location.bin.findEntry(mainKey, indicateIfExact, exactSearch);
        boolean match = false;
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            if (!location.bin.isEntryKnownDeleted(location.index) && this.database.getSortedDuplicates()) {
                Node childNode = location.bin.fetchTarget(location.index);
                try {
                    if (childNode != null) {
                        if (ln.containsDuplicates()) {
                            return this.searchDupTreeForDupCountLNParent(location, mainKey, childNode);
                        }
                        if (childNode.containsDuplicates()) {
                            if (dupKey == null) {
                                return this.searchDupTreeByNodeId(location, childNode, ln, searchDupTree, updateGeneration);
                            }
                            return this.searchDupTreeForDBIN(location, dupKey, (DIN)childNode, ln, findDeletedEntries, indicateIfExact, exactSearch, splitsAllowed, updateGeneration);
                        }
                    }
                }
                catch (DatabaseException e) {
                    location.bin.releaseLatchIfOwner();
                    throw e;
                }
            }
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        location.lnKey = mainKey;
        return false;
    }

    private boolean searchDupTreeByNodeId(TreeLocation location, Node childNode, LN ln, boolean searchDupTree, boolean updateGeneration) throws DatabaseException {
        if (searchDupTree) {
            BIN oldBIN = location.bin;
            if (childNode.matchLNByNodeId(location, ln.getNodeId())) {
                location.index &= 0xFFFEFFFF;
                if (oldBIN != null) {
                    oldBIN.releaseLatch();
                }
                location.bin.latch(updateGeneration);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean searchDupTreeForDupCountLNParent(TreeLocation location, byte[] mainKey, Node childNode) throws DatabaseException {
        location.lnKey = mainKey;
        if (childNode instanceof DIN) {
            DIN dupRoot = (DIN)childNode;
            location.childLsn = dupRoot.getDupCountLNRef().getLsn();
            return true;
        }
        return false;
    }

    private boolean searchDupTreeForDBIN(TreeLocation location, byte[] dupKey, DIN dupRoot, LN ln, boolean findDeletedEntries, boolean indicateIfExact, boolean exactSearch, boolean splitsAllowed, boolean updateGeneration) throws DatabaseException {
        if (!$assertionsDisabled && dupKey == null) {
            throw new AssertionError();
        }
        dupRoot.latch();
        try {
            boolean match;
            if (this.maybeSplitDuplicateRoot(location.bin, location.index)) {
                dupRoot = (DIN)location.bin.fetchTarget(location.index);
            }
            location.bin.releaseLatch();
            location.lnKey = dupKey;
            if (splitsAllowed) {
                try {
                    location.bin = (BIN)this.searchSubTreeSplitsAllowed(dupRoot, location.lnKey, ln.getNodeId(), updateGeneration);
                }
                catch (SplitRequiredException e) {
                    throw new DatabaseException(e);
                }
            } else {
                location.bin = (BIN)this.searchSubTree(dupRoot, location.lnKey, SearchType.NORMAL, ln.getNodeId(), null, updateGeneration);
            }
            location.index = location.bin.findEntry(location.lnKey, indicateIfExact, exactSearch);
            if (findDeletedEntries) {
                match = location.index >= 0 && (location.index & 0x10000) != 0;
                location.index &= 0xFFFEFFFF;
            } else {
                boolean bl = match = location.index >= 0;
            }
            if (match) {
                location.childLsn = location.bin.getLsn(location.index);
                return true;
            }
            return false;
        }
        catch (DatabaseException e) {
            dupRoot.releaseLatchIfOwner();
            throw e;
        }
    }

    public BIN getNextBin(BIN bin, boolean traverseWithinDupTree) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, true);
    }

    public BIN getPrevBin(BIN bin, boolean traverseWithinDupTree) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BIN getNextBinInternal(boolean traverseWithinDupTree, BIN bin, boolean forward) throws DatabaseException {
        byte[] idKey = null;
        idKey = bin.getNEntries() == 0 ? bin.getIdentifierKey() : (forward ? bin.getKey(bin.getNEntries() - 1) : bin.getKey(0));
        BIN bIN = bin;
        boolean nextIsLatched = false;
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 1) {
            throw new AssertionError((Object)LatchSupport.latchesHeldToString());
        }
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        try {
            while (true) {
                block23: {
                    void var5_6;
                    SearchResult result = null;
                    if (!traverseWithinDupTree) {
                        nextIsLatched = false;
                        result = this.getParentINForChildIN((IN)var5_6, true, true);
                        if (result.exactParentFound) {
                            parent = result.parent;
                            break block23;
                        } else {
                            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                                throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                            }
                            return null;
                        }
                    }
                    if (var5_6.isRoot()) {
                        var5_6.releaseLatch();
                        return null;
                    }
                    result = this.getParentINForChildIN((IN)var5_6, true, true);
                    nextIsLatched = false;
                    if (!result.exactParentFound) return null;
                    parent = result.parent;
                }
                if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 1) {
                    throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                }
                int index = parent.findEntry(idKey, false, false);
                boolean moreEntriesThisBin = false;
                if (forward) {
                    if (++index < parent.getNEntries()) {
                        moreEntriesThisBin = true;
                    }
                } else {
                    if (index > 0) {
                        moreEntriesThisBin = true;
                    }
                    --index;
                }
                if (moreEntriesThisBin) {
                    nextIN = (IN)parent.fetchTarget(index);
                    nextIN.latch();
                    nextINIsLatched = true;
                    if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 2) {
                        throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                    }
                    if (nextIN instanceof BIN) {
                        parent.releaseLatch();
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        return (BIN)nextIN;
                    }
                    nextINIsLatched = false;
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, -1L, null, true);
                    parent.releaseLatch();
                    if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 1) {
                        throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                    }
                    if (ret instanceof BIN) {
                        return (BIN)ret;
                    }
                    throw new InconsistentNodeException("subtree did not have a BIN for leaf");
                }
                IN iN = parent;
                nextIsLatched = true;
            }
        }
        catch (DatabaseException e) {
            if (nextIsLatched) {
                bIN.releaseLatchIfOwner();
                nextIsLatched = false;
            }
            if (parent != null) {
                parent.releaseLatchIfOwner();
            }
            if (nextIN != null && nextINIsLatched) {
                nextIN.releaseLatchIfOwner();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot() throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch();
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxMainTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch();
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            try {
                curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
                logLsn = newRoot.optionalLog(logManager);
            }
            catch (DatabaseException e) {
                curRoot.setIsRoot(true);
                throw e;
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, this.maxMainTreeEntriesPerNode);
            this.root.setLsn(newRoot.getLastFullVersion());
        }
        finally {
            newRoot.releaseLatch();
            curRoot.releaseLatch();
        }
        ++this.treeStats.nRootSplits;
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, boolean updateGeneration) throws DatabaseException {
        IN rootIN = this.getRootIN(true);
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, nid, binBoundary, updateGeneration);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN searchSplitsAllowed(byte[] key, long nid, boolean updateGeneration) throws DatabaseException {
        IN insertTarget = null;
        while (insertTarget == null) {
            this.rootLatch.acquireShared();
            boolean rootLatched = true;
            boolean rootLatchedExclusive = false;
            IN rootIN = null;
            try {
                while (this.rootExists()) {
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (rootIN.needsSplitting()) {
                        if (!rootLatchedExclusive) {
                            rootIN = null;
                            this.rootLatch.release();
                            this.rootLatch.acquireExclusive();
                            rootLatchedExclusive = true;
                            continue;
                        }
                        this.splitRoot();
                        this.rootLatch.release();
                        rootLatched = false;
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        env.getDbMapTree().optionalModifyDbRoot(this.database);
                        rootLatched = true;
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                    }
                    rootIN.latch();
                    break;
                }
            }
            finally {
                if (rootLatched) {
                    this.rootLatch.release();
                }
            }
            if (rootIN == null) break;
            try {
                insertTarget = this.searchSubTreeSplitsAllowed(rootIN, key, nid, updateGeneration);
            }
            catch (SplitRequiredException e) {}
        }
        return insertTarget;
    }

    public IN searchSubTree(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, boolean updateGeneration) throws DatabaseException {
        for (int i = 0; i < 2; ++i) {
            try {
                return this.searchSubTreeInternal(parent, key, searchType, nid, binBoundary, updateGeneration);
            }
            catch (RelatchRequiredException RRE) {
                parent = this.getRootINLatchedExclusive(updateGeneration);
                continue;
            }
        }
        throw new DatabaseException("searchSubTreeInternal should have completed in two tries");
    }

    public IN searchSubTreeInternal(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, boolean updateGeneration) throws DatabaseException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw new IllegalArgumentException("searchSubTree passed key and left/right search");
        }
        if (!$assertionsDisabled && !parent.isLatchOwnerForRead()) {
            throw new AssertionError();
        }
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        IN child = null;
        IN grandParent = null;
        boolean childIsLatched = false;
        boolean grandParentIsLatched = false;
        boolean maintainGrandParentLatches = !parent.isLatchOwnerForWrite();
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        try {
            do {
                int index;
                if (treeStatsAccumulator != null) {
                    parent.accumulateStats(treeStatsAccumulator);
                }
                if (parent.getNEntries() == 0) {
                    IN iN = parent;
                    return iN;
                }
                if (searchType == SearchType.NORMAL) {
                    index = parent.findEntry(key, false, false);
                } else if (searchType == SearchType.LEFT) {
                    index = 0;
                } else if (searchType == SearchType.RIGHT) {
                    index = parent.getNEntries() - 1;
                } else {
                    throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
                }
                if (!$assertionsDisabled && index < 0) {
                    throw new AssertionError();
                }
                if (binBoundary != null) {
                    if (index != parent.getNEntries() - 1) {
                        binBoundary.isLastBin = false;
                    }
                    if (index != 0) {
                        binBoundary.isFirstBin = false;
                    }
                }
                if (maintainGrandParentLatches && parent.getTarget(index) == null && !parent.isAlwaysLatchedExclusively()) {
                    if (grandParent == null) {
                        throw relatchRequiredException;
                    }
                    parent.releaseLatch();
                    parent.latch();
                    if (grandParent != null) {
                        grandParent.releaseLatch();
                        grandParentIsLatched = false;
                        grandParent = null;
                    }
                }
                child = (IN)parent.fetchTarget(index);
                if (grandParent != null) {
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                }
                if (maintainGrandParentLatches) {
                    child.latchShared(updateGeneration);
                } else {
                    child.latch(updateGeneration);
                }
                childIsLatched = true;
                if (treeStatsAccumulator != null) {
                    child.accumulateStats(treeStatsAccumulator);
                }
                if (child.getNodeId() == nid) {
                    child.releaseLatch();
                    childIsLatched = false;
                    IN iN = parent;
                    return iN;
                }
                if (maintainGrandParentLatches) {
                    grandParent = parent;
                    grandParentIsLatched = true;
                    continue;
                }
                parent.releaseLatch();
            } while (!((parent = child) instanceof BIN));
            IN iN = child;
            return iN;
        }
        catch (Throwable t) {
            if (child != null && childIsLatched) {
                child.releaseLatchIfOwner();
            }
            if (parent != child) {
                parent.releaseLatchIfOwner();
            }
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        finally {
            if (grandParent != null && grandParentIsLatched) {
                grandParent.releaseLatch();
                grandParentIsLatched = false;
            }
        }
    }

    public void searchDeletableSubTree(IN parent, byte[] key, ArrayList nodeLadder) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !parent.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        IN child = null;
        IN lowestMultipleEntryIN = null;
        while (parent.getNEntries() != 0) {
            if (parent.getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
            }
            int index = parent.findEntry(key, false, false);
            if (!$assertionsDisabled && index < 0) {
                throw new AssertionError();
            }
            child = (IN)parent.fetchTarget(index);
            child.latch(false);
            nodeLadder.add(new SplitInfo(parent, child, index));
            parent = child;
            if (!(parent instanceof BIN)) continue;
        }
        if (child != null && child instanceof BIN) {
            if (child.getNEntries() != 0) {
                throw NodeNotEmptyException.NODE_NOT_EMPTY;
            }
            if (((BIN)child).nCursors() > 0) {
                throw CursorsExistException.CURSORS_EXIST;
            }
        }
        if (lowestMultipleEntryIN != null) {
            ListIterator iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = (SplitInfo)iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private IN searchSubTreeSplitsAllowed(IN parent, byte[] key, long nid, boolean updateGeneration) throws DatabaseException, SplitRequiredException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, nid, updateGeneration);
                }
                catch (SplitRequiredException e) {
                    if (this.waitHook != null) {
                        this.waitHook.doHook();
                    }
                    this.forceSplit(parent, key);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    private IN searchSubTreeUntilSplit(IN parent, byte[] key, long nid, boolean updateGeneration) throws DatabaseException, SplitRequiredException {
        if (parent == null) {
            return null;
        }
        if (!$assertionsDisabled && !parent.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        IN child = null;
        boolean childIsLatched = false;
        try {
            do {
                if (parent.getNEntries() == 0) {
                    return parent;
                }
                int index = parent.findEntry(key, false, false);
                if (!$assertionsDisabled && index < 0) {
                    throw new AssertionError();
                }
                child = (IN)parent.fetchTarget(index);
                child.latch(updateGeneration);
                childIsLatched = true;
                if (child.needsSplitting()) {
                    child.releaseLatch();
                    childIsLatched = false;
                    parent.releaseLatch();
                    throw splitRequiredException;
                }
                if (child.getNodeId() == nid) {
                    child.releaseLatch();
                    childIsLatched = false;
                    return parent;
                }
                parent.releaseLatch();
            } while (!((parent = child) instanceof BIN));
            return parent;
        }
        catch (DatabaseException e) {
            if (child != null && childIsLatched) {
                child.releaseLatchIfOwner();
            }
            if (parent != child) {
                parent.releaseLatchIfOwner();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceSplit(IN parent, byte[] key) throws DatabaseException, SplitRequiredException {
        boolean isRootLatched;
        ListIterator iter;
        ArrayList<SplitInfo> nodeLadder;
        block24: {
            IN originalParent;
            block25: {
                nodeLadder = new ArrayList<SplitInfo>();
                boolean allLeftSideDescent = true;
                boolean allRightSideDescent = true;
                IN child = null;
                originalParent = parent;
                iter = null;
                isRootLatched = false;
                boolean success = false;
                try {
                    int index;
                    if (originalParent.isDbRoot()) {
                        this.rootLatch.acquireExclusive();
                        isRootLatched = true;
                    }
                    originalParent.latch();
                    if (originalParent.needsSplitting() || !originalParent.isRoot()) {
                        throw splitRequiredException;
                    }
                    while (parent.getNEntries() != 0) {
                        index = parent.findEntry(key, false, false);
                        if (index != 0) {
                            allLeftSideDescent = false;
                        }
                        if (index != parent.getNEntries() - 1) {
                            allRightSideDescent = false;
                        }
                        if (!$assertionsDisabled && index < 0) {
                            throw new AssertionError();
                        }
                        child = (IN)parent.getTarget(index);
                        if (child == null) break;
                        child.latch();
                        nodeLadder.add(new SplitInfo(parent, child, index));
                        parent = child;
                        if (!(parent instanceof BIN)) continue;
                    }
                    boolean startedSplits = false;
                    LogManager logManager = this.database.getDbEnvironment().getLogManager();
                    iter = nodeLadder.listIterator(nodeLadder.size());
                    long lastParentForSplit = -1L;
                    while (iter.hasPrevious()) {
                        SplitInfo info = (SplitInfo)iter.previous();
                        child = info.child;
                        parent = info.parent;
                        index = info.index;
                        if (child.needsSplitting()) {
                            int maxEntriesPerNode;
                            int n = maxEntriesPerNode = child.containsDuplicates() ? this.maxDupTreeEntriesPerNode : this.maxMainTreeEntriesPerNode;
                            if (allLeftSideDescent || allRightSideDescent) {
                                child.splitSpecial(parent, index, maxEntriesPerNode, key, allLeftSideDescent);
                            } else {
                                child.split(parent, index, maxEntriesPerNode);
                            }
                            lastParentForSplit = parent.getNodeId();
                            startedSplits = true;
                            if (parent.isDbRoot()) {
                                if (!$assertionsDisabled && !isRootLatched) {
                                    throw new AssertionError();
                                }
                                this.root.setLsn(parent.getLastFullVersion());
                                parent.setDirty(true);
                            }
                        } else if (startedSplits) {
                            long newLsn = 0L;
                            newLsn = lastParentForSplit == child.getNodeId() ? child.getLastFullVersion() : child.optionalLog(logManager);
                            parent.updateEntry(index, newLsn);
                        }
                        child.releaseLatch();
                        child = null;
                        iter.remove();
                    }
                    success = true;
                    if (success) break block24;
                    if (child == null) break block25;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (child != null) {
                            child.releaseLatchIfOwner();
                        }
                        originalParent.releaseLatchIfOwner();
                    }
                    if (nodeLadder.size() > 0) {
                        iter = nodeLadder.listIterator(nodeLadder.size());
                        while (iter.hasPrevious()) {
                            SplitInfo info = (SplitInfo)iter.previous();
                            info.child.releaseLatchIfOwner();
                        }
                    }
                    if (isRootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                child.releaseLatchIfOwner();
            }
            originalParent.releaseLatchIfOwner();
        }
        if (nodeLadder.size() > 0) {
            iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = (SplitInfo)iter.previous();
                info.child.releaseLatchIfOwner();
            }
        }
        if (isRootLatched) {
            this.rootLatch.release();
        }
    }

    public IN getRootIN(boolean updateGeneration) throws DatabaseException {
        return this.getRootINInternal(updateGeneration, false);
    }

    public IN getRootINLatchedExclusive(boolean updateGeneration) throws DatabaseException {
        return this.getRootINInternal(updateGeneration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(boolean updateGeneration, boolean exclusive) throws DatabaseException {
        this.rootLatch.acquireShared();
        IN rootIN = null;
        try {
            if (this.rootExists()) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (exclusive) {
                    rootIN.latch(updateGeneration);
                } else {
                    rootIN.latchShared(updateGeneration);
                }
            }
            IN iN = rootIN;
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(LN ln, byte[] key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock) throws DatabaseException {
        this.validateInsertArgs(allowDuplicates);
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        BIN bin = null;
        try {
            bin = this.findBinForInsert(key, logManager, inMemoryINs, cursor);
            if (!$assertionsDisabled && !bin.isLatchOwnerForWrite()) {
                throw new AssertionError();
            }
            ChildReference newLNRef = new ChildReference(ln, key, -1L);
            cursor.setBIN(bin);
            int index = bin.insertEntry1(newLNRef);
            if ((index & 0x20000) != 0) {
                cursor.updateBin(bin, index &= 0xFFFDFFFF);
                long newLsn = -1L;
                try {
                    newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker());
                }
                finally {
                    if (newLsn == -1L && !this.database.isDeferredWrite()) {
                        bin.setKnownDeleted(index);
                    }
                }
                lnLock.setAbortLsn(-1L, true, true);
                bin.updateEntry(index, newLsn);
                this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
                boolean bl = true;
                return bl;
            }
            cursor.updateBin(bin, index &= 0xFFFEFFFF);
            LN currentLN = null;
            boolean isDup = false;
            Node n = bin.fetchTarget(index);
            if (n == null || n instanceof LN) {
                currentLN = (LN)n;
            } else {
                isDup = true;
            }
            boolean isDeleted = false;
            LockResult currentLock = null;
            if (!isDup) {
                if (currentLN == null) {
                    isDeleted = true;
                } else {
                    currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                    currentLN = currentLock.getLN();
                    bin = cursor.getBIN();
                    index = cursor.getIndex();
                    if (cursor.getDupBIN() != null) {
                        cursor.clearDupBIN(true);
                        isDup = true;
                    } else if (bin.isEntryKnownDeleted(index) || currentLN == null || currentLN.isDeleted()) {
                        isDeleted = true;
                    }
                }
            }
            if (isDeleted) {
                long abortLsn = bin.getLsn(index);
                boolean abortKnownDeleted = true;
                if (currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING) {
                    long nodeId = currentLN.getNodeId();
                    Locker locker = cursor.getLocker();
                    WriteLockInfo info = locker.getWriteLockInfo(nodeId);
                    abortLsn = info.getAbortLsn();
                    abortKnownDeleted = info.getAbortKnownDeleted();
                }
                lnLock.setAbortLsn(abortLsn, abortKnownDeleted);
                long newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker());
                bin.updateEntry(index, ln, newLsn, key);
                bin.clearKnownDeleted(index);
                bin.clearPendingDeleted(index);
                this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
                boolean bl = true;
                return bl;
            }
            boolean bl = this.insertDuplicate(key, bin, ln, logManager, inMemoryINs, cursor, lnLock, allowDuplicates);
            return bl;
        }
        finally {
            cursor.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean insertDuplicate(byte[] key, BIN bin, LN newLN, LogManager logManager, INList inMemoryINs, CursorImpl cursor, LockResult lnLock, boolean allowDuplicates) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        int index = cursor.getIndex();
        boolean successfulInsert = false;
        DIN dupRoot = null;
        Node n = bin.fetchTarget(index);
        long binNid = bin.getNodeId();
        if (n instanceof DIN) {
            IN dupBin = null;
            try {
                DupCountLN dcl;
                dupRoot = (DIN)n;
                dupRoot.latch();
                LockResult dclLockResult = cursor.lockDupCountLN(dupRoot, LockType.WRITE);
                bin = cursor.getBIN();
                index = cursor.getIndex();
                if (!allowDuplicates && (dcl = (DupCountLN)dclLockResult.getLN()).getDupCount() > 0) {
                    boolean bl = false;
                    return bl;
                }
                this.maybeSplitDuplicateRoot(bin, index);
                dupRoot = (DIN)bin.fetchTarget(index);
                byte[] newLNKey = newLN.getData();
                long previousLsn = dupRoot.getLastFullVersion();
                try {
                    dupBin = (DBIN)this.searchSubTreeSplitsAllowed(dupRoot, newLNKey, -1L, true);
                }
                catch (SplitRequiredException e) {
                    throw new DatabaseException(e);
                }
                long currentLsn = dupRoot.getLastFullVersion();
                if (currentLsn != previousLsn) {
                    bin.updateEntry(index, currentLsn);
                }
                cursor.releaseBIN();
                bin = null;
                dupRoot = null;
                ChildReference newLNRef = new ChildReference(newLN, newLNKey, -1L);
                int dupIndex = dupBin.insertEntry1(newLNRef);
                if ((dupIndex & 0x20000) != 0) {
                    cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFDFFFF);
                    long newLsn = -1L;
                    try {
                        newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker());
                    }
                    finally {
                        if (newLsn == -1L && !this.database.isDeferredWrite()) {
                            ((BIN)dupBin).setKnownDeleted(dupIndex);
                        }
                    }
                    lnLock.setAbortLsn(-1L, true, true);
                    dupBin.updateEntry(dupIndex, newLsn);
                    this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                    successfulInsert = true;
                } else {
                    cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFEFFFF);
                    LN currentLN = (LN)dupBin.fetchTarget(dupIndex);
                    boolean isDeleted = false;
                    LockResult currentLock = null;
                    if (currentLN == null) {
                        isDeleted = true;
                    } else {
                        currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                        currentLN = currentLock.getLN();
                        dupBin = cursor.getDupBIN();
                        if (dupBin.isEntryKnownDeleted(dupIndex = cursor.getDupIndex()) || currentLN == null || currentLN.isDeleted()) {
                            isDeleted = true;
                        }
                    }
                    if (isDeleted) {
                        long abortLsn = dupBin.getLsn(dupIndex);
                        boolean abortKnownDeleted = true;
                        if (currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING) {
                            long nodeId = currentLN.getNodeId();
                            Locker locker = cursor.getLocker();
                            WriteLockInfo info = locker.getWriteLockInfo(nodeId);
                            abortLsn = info.getAbortLsn();
                            abortKnownDeleted = info.getAbortKnownDeleted();
                        }
                        lnLock.setAbortLsn(abortLsn, abortKnownDeleted);
                        long newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker());
                        dupBin.updateEntry(dupIndex, newLN, newLsn, newLNKey);
                        ((BIN)dupBin).clearKnownDeleted(dupIndex);
                        dupBin.clearPendingDeleted(dupIndex);
                        this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                        successfulInsert = true;
                    } else {
                        successfulInsert = false;
                    }
                }
                dupBin.releaseLatch();
                dupBin = null;
                if (!successfulInsert) return successfulInsert;
                cursor.latchBIN();
                dupRoot = cursor.getLatchedDupRoot(false);
                cursor.releaseBIN();
                dupRoot.incrementDuplicateCount(dclLockResult, key, cursor.getLocker(), true);
                return successfulInsert;
            }
            finally {
                if (dupBin != null) {
                    dupBin.releaseLatchIfOwner();
                }
                if (dupRoot != null) {
                    dupRoot.releaseLatchIfOwner();
                }
            }
        }
        if (!(n instanceof LN)) throw new InconsistentNodeException("neither LN or DIN found in BIN");
        if (!allowDuplicates) {
            return false;
        }
        try {
            lnLock.setAbortLsn(-1L, true, true);
            dupRoot = this.createDuplicateTree(key, logManager, inMemoryINs, newLN, cursor);
            return successfulInsert;
        }
        finally {
            if (dupRoot != null) {
                dupRoot.releaseLatch();
                successfulInsert = true;
            } else {
                successfulInsert = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeSplitDuplicateRoot(BIN bin, int index) throws DatabaseException {
        DIN curRoot = (DIN)bin.fetchTarget(index);
        if (curRoot.needsSplitting()) {
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            byte[] rootIdKey = curRoot.getKey(0);
            DIN newRoot = new DIN(this.database, rootIdKey, this.maxDupTreeEntriesPerNode, curRoot.getDupKey(), curRoot.getDupCountLNRef(), curRoot.getLevel() + 1);
            newRoot.latch();
            long curRootLsn = 0L;
            long logLsn = 0L;
            try {
                newRoot.setIsRoot(true);
                curRoot.setDupCountLN(null);
                curRoot.setIsRoot(false);
                try {
                    curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                    boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, bin.getLsn(index)));
                    if (!$assertionsDisabled && !insertOk) {
                        throw new AssertionError();
                    }
                    logLsn = newRoot.optionalLog(logManager);
                }
                catch (DatabaseException e) {
                    curRoot.setIsRoot(true);
                    throw e;
                }
                inMemoryINs.add(newRoot);
                bin.updateEntry(index, newRoot, logLsn);
                curRoot.split(newRoot, 0, this.maxDupTreeEntriesPerNode);
            }
            finally {
                curRoot.releaseLatch();
            }
            this.traceSplitRoot(Level.FINE, TRACE_DUP_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
            return true;
        }
        return false;
    }

    private DIN createDuplicateTree(byte[] key, LogManager logManager, INList inMemoryINs, LN newLN, CursorImpl cursor) throws DatabaseException {
        long nodeId;
        boolean keysEqual;
        boolean existingLNIsDeleted;
        EnvironmentImpl env = this.database.getDbEnvironment();
        DIN dupRoot = null;
        DBIN dupBin = null;
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        LN existingLN = (LN)bin.fetchTarget(index);
        boolean bl = existingLNIsDeleted = bin.isEntryKnownDeleted(index) || existingLN.isDeleted();
        if (!$assertionsDisabled && existingLN == null) {
            throw new AssertionError();
        }
        byte[] existingKey = existingLN.getData();
        byte[] newLNKey = newLN.getData();
        boolean bl2 = keysEqual = Key.compareKeys(newLNKey, existingKey, this.database.getDuplicateComparator()) == 0;
        if (keysEqual) {
            return null;
        }
        Locker locker = cursor.getLocker();
        int startingCount = locker.createdNode(nodeId = existingLN.getNodeId()) || existingLNIsDeleted || locker.getWriteLockInfo(nodeId).getAbortKnownDeleted() ? 0 : 1;
        DupCountLN dupCountLN = new DupCountLN(startingCount);
        long firstDupCountLNLsn = dupCountLN.optionalLogProvisional(env, this.database, key, -1L);
        dupRoot = new DIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, new ChildReference(dupCountLN, key, firstDupCountLNLsn), 2);
        dupRoot.latch();
        dupRoot.setIsRoot(true);
        dupBin = new DBIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, 1);
        dupBin.latch();
        ChildReference newExistingLNRef = new ChildReference(existingLN, existingKey, bin.getLsn(index), bin.getState(index));
        boolean insertOk = dupBin.insertEntry(newExistingLNRef);
        if (!$assertionsDisabled && !insertOk) {
            throw new AssertionError();
        }
        try {
            long dbinLsn = dupBin.optionalLogProvisional(logManager, dupRoot);
            inMemoryINs.add(dupBin);
            dupRoot.setEntry(0, dupBin, dupBin.getKey(0), dbinLsn, dupBin.getState(0));
            long dinLsn = dupRoot.optionalLog(logManager);
            inMemoryINs.add(dupRoot);
            LockResult lockResult = locker.lock(dupCountLN.getNodeId(), LockType.WRITE, false, this.database);
            lockResult.setAbortLsn(firstDupCountLNLsn, false);
            dupCountLN.setDupCount(2);
            long dupCountLsn = dupCountLN.optionalLog(env, this.database, key, firstDupCountLNLsn, locker);
            dupRoot.updateDupCountLNRef(dupCountLsn);
            long newLsn = newLN.optionalLog(env, this.database, key, -1L, locker);
            int dupIndex = dupBin.insertEntry1(new ChildReference(newLN, newLNKey, newLsn));
            cursor.updateDBin(dupBin, dupIndex &= 0xFFFDFFFF);
            bin.adjustCursorsForMutation(index, dupBin, dupIndex ^ 1, cursor);
            dupBin.releaseLatch();
            bin.updateEntry(index, dupRoot, dinLsn);
            bin.setMigrate(index, false);
            this.traceMutate(Level.FINE, bin, existingLN, newLN, newLsn, dupCountLN, dupCountLsn, dupRoot, dinLsn, dupBin, dbinLsn);
        }
        catch (DatabaseException e) {
            dupBin.releaseLatchIfOwner();
            dupRoot.releaseLatchIfOwner();
            throw e;
        }
        return dupRoot;
    }

    private void validateInsertArgs(boolean allowDuplicates) throws DatabaseException {
        if (allowDuplicates && !this.database.getSortedDuplicates()) {
            throw new DatabaseException("allowDuplicates passed to insert but database doesn't have allow duplicates set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BIN findBinForInsert(byte[] key, LogManager logManager, INList inMemoryINs, CursorImpl cursor) throws DatabaseException {
        BIN bin;
        block11: {
            bin = cursor.latchBIN();
            if (bin != null) {
                if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                    return bin;
                }
                bin.releaseLatch();
            }
            boolean rootLatchIsHeld = false;
            try {
                IN in;
                while (true) {
                    rootLatchIsHeld = true;
                    this.rootLatch.acquireShared();
                    if (!this.rootExists()) {
                        this.rootLatch.release();
                        this.rootLatch.acquireExclusive();
                        if (this.rootExists()) {
                            this.rootLatch.release();
                            rootLatchIsHeld = false;
                            continue;
                        }
                        bin = new BIN(this.database, key, this.maxMainTreeEntriesPerNode, 1);
                        bin.latch();
                        long logLsn = bin.optionalLogProvisional(logManager, null);
                        IN rootIN = new IN(this.database, key, this.maxMainTreeEntriesPerNode, 2);
                        rootIN.latch();
                        rootIN.setIsRoot(true);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        if (!$assertionsDisabled && !insertOk) {
                            throw new AssertionError();
                        }
                        logLsn = rootIN.optionalLog(logManager);
                        rootIN.setDirty(true);
                        this.root = new ChildReference(rootIN, new byte[0], logLsn);
                        rootIN.releaseLatch();
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        break block11;
                    }
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                    in = this.searchSplitsAllowed(key, -1L, true);
                    if (in != null) break;
                }
                bin = (BIN)in;
            }
            finally {
                if (rootLatchIsHeld) {
                    this.rootLatch.release();
                }
            }
        }
        if (this.ckptHook != null) {
            this.ckptHook.doHook();
        }
        return bin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accountForSubtreeRemoval(INList inList, IN subtreeRoot, UtilizationTracker tracker) throws DatabaseException {
        inList.latchMajor();
        try {
            subtreeRoot.accountForSubtreeRemoval(inList, tracker);
        }
        finally {
            inList.releaseMajorLatch();
        }
        Tracer.trace(Level.FINE, this.database.getDbEnvironment(), "SubtreeRemoval: subtreeRoot = " + subtreeRoot.getNodeId());
    }

    public int getLogSize() {
        int size = LogUtils.getBooleanLogSize();
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeBoolean(logBuffer, this.root != null);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) {
        boolean rootExists = LogUtils.readBoolean(itemBuffer);
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryTypeVersion);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
            }
            finally {
                this.rootLatch.release();
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            boolean bl = rootIN.validateSubtreeBeforeDelete(index);
            return bl;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.getINs().contains(parent)) {
                throw new DatabaseException("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray node " + node.getNodeId() + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            logger.log(level, sb.toString());
        }
    }

    private void traceMutate(Level level, BIN theBin, LN existingLn, LN newLn, long newLsn, DupCountLN dupCountLN, long dupRootLsn, DIN dupRoot, long ddinLsn, DBIN dupBin, long dbinLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_MUTATE);
            sb.append(" existingLn=");
            sb.append(existingLn.getNodeId());
            sb.append(" newLn=");
            sb.append(newLn.getNodeId());
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            sb.append(" dupCountLN=");
            sb.append(dupCountLN.getNodeId());
            sb.append(" dupRootLsn=");
            sb.append(DbLsn.getNoFormatString(dupRootLsn));
            sb.append(" rootdin=");
            sb.append(dupRoot.getNodeId());
            sb.append(" ddinLsn=");
            sb.append(DbLsn.getNoFormatString(ddinLsn));
            sb.append(" dbin=");
            sb.append(dupBin.getNodeId());
            sb.append(" dbinLsn=");
            sb.append(DbLsn.getNoFormatString(dbinLsn));
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            logger.log(level, sb.toString());
        }
    }

    private void traceInsert(Level level, EnvironmentImpl env, BIN insertingBin, LN ln, long lnLsn, int index) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    private void traceInsertDuplicate(Level level, EnvironmentImpl env, BIN insertingDBin, LN ln, long lnLsn, long binNid) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT_DUPLICATE);
            sb.append(" dbin=");
            sb.append(insertingDBin.getNodeId());
            sb.append(" bin=");
            sb.append(binNid);
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Tree.class.desiredAssertionStatus();
        splitRequiredException = new SplitRequiredException();
        relatchRequiredException = new RelatchRequiredException();
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private static class RelatchRequiredException
    extends DatabaseException {
        private RelatchRequiredException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private class RootChildReference
    extends ChildReference {
        static final /* synthetic */ boolean $assertionsDisabled;

        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        private RootChildReference(Node target, byte[] key, long lsn, byte existingState) {
            super(target, key, lsn, existingState);
        }

        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
            }
            return super.fetchTarget(database, in);
        }

        public void setTarget(Node target) {
            if (!$assertionsDisabled && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                throw new AssertionError();
            }
            super.setTarget(target);
        }

        public void clearTarget() {
            if (!$assertionsDisabled && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                throw new AssertionError();
            }
            super.clearTarget();
        }

        public void setLsn(long lsn) {
            if (!$assertionsDisabled && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                throw new AssertionError();
            }
            super.setLsn(lsn);
        }

        void updateLsnAfterOptionaLog(DatabaseImpl dbImpl, long lsn) {
            if (!$assertionsDisabled && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                throw new AssertionError();
            }
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$tree$Tree == null ? (class$com$sleepycat$je$tree$Tree = Tree.class$("com.sleepycat.je.tree.Tree")) : class$com$sleepycat$je$tree$Tree).desiredAssertionStatus();
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

