/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.AutoTxn;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ReadCommittedLocker;
import com.sleepycat.je.txn.ThreadLocker;

public class LockerFactory {
    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional) throws DatabaseException {
        return LockerFactory.getWritableLocker(env, userTxn, dbIsTransactional, false, null);
    }

    public static Locker getWritableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional, boolean retainNonTxnLocks, TransactionConfig autoCommitConfig) throws DatabaseException {
        Transaction xaLocker;
        EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(env);
        boolean envIsTransactional = envImpl.isTransactional();
        if (userTxn == null && (xaLocker = env.getThreadTransaction()) != null) {
            return DbInternal.getLocker(xaLocker);
        }
        if (dbIsTransactional && userTxn == null) {
            if (autoCommitConfig == null) {
                autoCommitConfig = DbInternal.getDefaultTxnConfig(env);
            }
            return new AutoTxn(envImpl, autoCommitConfig);
        }
        if (userTxn == null) {
            if (retainNonTxnLocks) {
                return new BasicLocker(envImpl);
            }
            return new ThreadLocker(envImpl);
        }
        if (!envIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the environment was opened non-transactionally");
        }
        if (!dbIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = DbInternal.getLocker(userTxn);
        if (locker.isReadCommittedIsolation() && !retainNonTxnLocks) {
            return new ReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }

    public static Locker getReadableLocker(Environment env, Transaction userTxn, boolean dbIsTransactional, boolean retainNonTxnLocks, boolean readCommittedIsolation) throws DatabaseException {
        if (userTxn != null && !dbIsTransactional) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        Locker locker = null;
        if (userTxn != null && (locker = DbInternal.getLocker(userTxn)).isReadCommittedIsolation()) {
            readCommittedIsolation = true;
        }
        return LockerFactory.getReadableLocker(env, locker, retainNonTxnLocks, readCommittedIsolation);
    }

    public static Locker getReadableLocker(Environment env, Database dbHandle, Locker locker, boolean retainNonTxnLocks, boolean readCommittedIsolation) throws DatabaseException {
        DatabaseImpl dbImpl = DbInternal.dbGetDatabaseImpl(dbHandle);
        if (!dbImpl.isTransactional() && locker != null && locker.isTransactional()) {
            throw new DatabaseException("A Transaction cannot be used because the database was opened non-transactionally");
        }
        if (locker != null && !locker.isTransactional() && !retainNonTxnLocks) {
            locker = null;
        }
        if (locker != null && locker.isReadCommittedIsolation()) {
            readCommittedIsolation = true;
        }
        return LockerFactory.getReadableLocker(env, locker, retainNonTxnLocks, readCommittedIsolation);
    }

    private static Locker getReadableLocker(Environment env, Locker locker, boolean retainNonTxnLocks, boolean readCommittedIsolation) throws DatabaseException {
        Transaction xaTxn;
        EnvironmentImpl envImpl = DbInternal.envGetEnvironmentImpl(env);
        if (locker == null && (xaTxn = env.getThreadTransaction()) != null) {
            return DbInternal.getLocker(xaTxn);
        }
        if (locker == null) {
            locker = retainNonTxnLocks ? new BasicLocker(envImpl) : new ThreadLocker(envImpl);
        } else if (readCommittedIsolation && !retainNonTxnLocks) {
            locker = new ReadCommittedLocker(envImpl, locker);
        }
        return locker;
    }
}

