/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawAccessor;
import com.sleepycat.persist.impl.ReflectionAccessor;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.raw.RawField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeKeyFormat
extends Format {
    private static final long serialVersionUID = 306843428409314630L;
    private ClassMetadata metadata;
    private List<FieldInfo> fields;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private transient Map<String, RawField> rawFields;

    static String[] getFieldNameArray(List<FieldMetadata> list) {
        int index = 0;
        String[] a = new String[list.size()];
        for (FieldMetadata f : list) {
            a[index] = f.getName();
            ++index;
        }
        return a;
    }

    CompositeKeyFormat(Class cls, ClassMetadata metadata, List<FieldMetadata> fieldNames) {
        this(cls, metadata, CompositeKeyFormat.getFieldNameArray(fieldNames));
    }

    CompositeKeyFormat(Class cls, ClassMetadata metadata, String[] fieldNames) {
        super(cls);
        this.metadata = metadata;
        Class superCls = cls.getSuperclass();
        if (superCls != Object.class) {
            throw new IllegalArgumentException("Composite key class must be derived from Object: " + cls.getName());
        }
        List<FieldInfo> instanceFields = FieldInfo.getInstanceFields(cls);
        this.fields = new ArrayList<FieldInfo>(instanceFields.size());
        for (String fieldName : fieldNames) {
            FieldInfo field = null;
            for (FieldInfo tryField : instanceFields) {
                if (!fieldName.equals(tryField.getName())) continue;
                field = tryField;
                break;
            }
            if (field == null) {
                throw new IllegalArgumentException("Composite key field is not an instance field:" + this.getClassName() + '.' + fieldName);
            }
            this.fields.add(field);
            instanceFields.remove(field);
            if (SimpleCatalog.isSimpleType(field.getFieldClass())) continue;
            throw new IllegalArgumentException("Composite key field is not a simple type: " + this.getClassName() + '.' + fieldName);
        }
        if (instanceFields.size() > 0) {
            throw new IllegalArgumentException("All composite key instance fields must be key fields: " + this.getClassName() + '.' + instanceFields.get(0).getName());
        }
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    ClassMetadata getClassMetadata() {
        if (this.metadata == null) {
            throw new IllegalStateException(this.getClassName());
        }
        return this.metadata;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> map = new HashMap<String, RawField>();
            for (FieldInfo field : this.fields) {
                map.put(field.getName(), field);
            }
            this.rawFields = map;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        for (FieldInfo field : this.fields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
    }

    @Override
    void initialize(Catalog catalog) {
        for (FieldInfo field : this.fields) {
            field.initialize(catalog);
        }
        Class type = this.getType();
        this.objAccessor = EnhancedAccessor.isEnhanced(type) ? new EnhancedAccessor(type) : new ReflectionAccessor(catalog, type, this.fields);
        this.rawAccessor = new RawAccessor(this, this.fields);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CompositeKeyFormat) {
            CompositeKeyFormat o = (CompositeKeyFormat)other;
            return super.equals(o) && ((Object)this.fields).equals(o.fields) && this.metadata.equals(o.metadata);
        }
        return false;
    }

    @Override
    Object newInstance(EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    Object newArray(int len) {
        return this.objAccessor.newArray(len);
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writeNonKeyFields(o, output);
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readNonKeyFields(o, input, 0, Integer.MAX_VALUE, -1);
    }

    @Override
    void skipContents(EntityInput input) {
        int maxNum = this.fields.size();
        for (int i = 0; i < maxNum; ++i) {
            this.fields.get(i).getType().skipContents(input);
        }
    }

    @Override
    void copySecKey(EntityInput input, EntityOutput output) {
        int maxNum = this.fields.size();
        for (int i = 0; i < maxNum; ++i) {
            this.fields.get(i).getType().copySecKey(input, output);
        }
    }
}

