/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.VisitedObjects;
import com.sleepycat.persist.raw.RawObject;

public class EntityOutput
extends TupleOutput {
    static final int PRI_KEY_VISITED_OFFSET = 0x7FFFFFFE;
    private Catalog catalog;
    private boolean rawAccess;
    private VisitedObjects visited;

    EntityOutput(Catalog catalog, boolean rawAccess) {
        this.catalog = catalog;
        this.rawAccess = rawAccess;
    }

    public void writeObject(Object o, Format fieldFormat) {
        Format format;
        int offset;
        if (o == null) {
            this.writePackedInt(0);
            return;
        }
        if (this.visited != null && (offset = this.visited.getOffset(o)) > 0) {
            this.writePackedInt(-(offset + 1));
            return;
        }
        if (this.rawAccess) {
            assert (fieldFormat != null);
            if (o instanceof RawObject) {
                format = (Format)((RawObject)o).getType();
            } else {
                format = this.catalog.getFormat(o.getClass());
                if (!format.isSimple() || format.isEnum()) {
                    throw new IllegalArgumentException("Not a RawObject or a non-enum simple type: " + format.getClassName());
                }
            }
            if (!format.isAssignableTo(fieldFormat)) {
                throw new IllegalArgumentException("Not a subtype of " + fieldFormat.getClassName() + ": " + format.getClassName());
            }
            Format proxiedFormat = format.getProxiedFormat();
            if (proxiedFormat != null) {
                format = proxiedFormat;
            }
        } else {
            format = this.catalog.getFormat(o.getClass());
        }
        if (format.getProxiedFormat() != null) {
            throw new IllegalArgumentException("May not store proxy classes directly: " + format.getClassName());
        }
        if (format.isEntity()) {
            throw new IllegalArgumentException("References to entities are not allowed: " + o.getClass().getName());
        }
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(o, this.size());
        this.writePackedInt(format.getId());
        format.writeObject(o, this, this.rawAccess);
    }

    public void writeKeyObject(Object o, Format fieldFormat) {
        Format format;
        if (o == null) {
            throw new IllegalArgumentException("Key field object may not be null");
        }
        if (this.rawAccess) {
            if (o instanceof RawObject) {
                format = (Format)((RawObject)o).getType();
            } else {
                format = this.catalog.getFormat(o.getClass());
                if (fieldFormat.isPrimitive()) {
                    fieldFormat = fieldFormat.getWrapperFormat();
                }
            }
        } else {
            format = this.catalog.getFormat(o.getClass());
        }
        if (fieldFormat != format) {
            throw new IllegalArgumentException("The key field object class (" + o.getClass().getName() + ") must be the field's declared class: " + fieldFormat.getClassName());
        }
        fieldFormat.writeObject(o, this, this.rawAccess);
    }

    public void registerPriKeyObject(Object o) {
        if (this.visited == null) {
            this.visited = new VisitedObjects();
        }
        this.visited.add(o, 0x7FFFFFFE);
    }
}

