package software.amazon.awscdk;

/**
 * Represents a date of expiration.
 * <p>
 * The amount can be specified either as a Date object, timestamp, Duration or string.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * Expiration expiration = Expiration.after(Duration.minutes(30));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.097Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Expiration")
public class Expiration extends software.amazon.jsii.JsiiObject {

    protected Expiration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Expiration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Expire once the specified duration has passed since deployment time.
     * <p>
     * @param t the duration to wait before expiring. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Expiration after(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Expiration.class, "after", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Expire at the specified date.
     * <p>
     * @param d date to expire at. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Expiration atDate(final @org.jetbrains.annotations.NotNull java.time.Instant d) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Expiration.class, "atDate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class), new Object[] { java.util.Objects.requireNonNull(d, "d is required") });
    }

    /**
     * Expire at the specified timestamp.
     * <p>
     * @param t timestamp in unix milliseconds. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Expiration atTimestamp(final @org.jetbrains.annotations.NotNull java.lang.Number t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Expiration.class, "atTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Expire at specified date, represented as a string.
     * <p>
     * @param s the string that represents date to expire at. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.Expiration fromString(final @org.jetbrains.annotations.NotNull java.lang.String s) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Expiration.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class), new Object[] { java.util.Objects.requireNonNull(s, "s is required") });
    }

    /**
     * Check if Expiration expires after input.
     * <p>
     * @param t the duration to check against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isAfter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.Kernel.call(this, "isAfter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Check if Expiration expires before input.
     * <p>
     * @param t the duration to check against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isBefore(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.Kernel.call(this, "isBefore", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * Expiration Value in a formatted Unix Epoch Time in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number toEpoch() {
        return software.amazon.jsii.Kernel.call(this, "toEpoch", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Expiration value as a Date object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.time.Instant getDate() {
        return software.amazon.jsii.Kernel.get(this, "date", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
    }
}
