package software.amazon.awscdk;

/**
 * Base class for implementing an IStackSynthesizer.
 * <p>
 * This class needs to exist to provide public surface area for external
 * implementations of stack synthesizers. The protected methods give
 * access to functions that are otherwise
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.159Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.StackSynthesizer")
public abstract class StackSynthesizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.IStackSynthesizer {

    protected StackSynthesizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StackSynthesizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected StackSynthesizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Add a CfnRule to the bound stack that checks whether an SSM parameter exceeds a given version.
     * <p>
     * This will modify the template, so must be called before the stack is synthesized.
     * <p>
     * @param requiredVersion This parameter is required.
     * @param bootstrapStackVersionSsmParameter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void addBootstrapVersionRule(final @org.jetbrains.annotations.NotNull java.lang.Number requiredVersion, final @org.jetbrains.annotations.NotNull java.lang.String bootstrapStackVersionSsmParameter) {
        software.amazon.jsii.Kernel.call(this, "addBootstrapVersionRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(requiredVersion, "requiredVersion is required"), java.util.Objects.requireNonNull(bootstrapStackVersionSsmParameter, "bootstrapStackVersionSsmParameter is required") });
    }

    /**
     * Register a Docker Image Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset);

    /**
     * Register a File Asset.
     * <p>
     * Returns the parameters that can be used to refer to the asset inside the template.
     * <p>
     * The synthesizer must rely on some out-of-band mechanism to make sure the given files
     * are actually placed in the returned location before the deployment happens. This can
     * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
     * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
     * mechanism.
     * <p>
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset);

    /**
     * Bind to the stack this environment is going to be used on.
     * <p>
     * Must be called before any of the other methods are called.
     * <p>
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * Turn a docker asset location into a CloudFormation representation of that location.
     * <p>
     * If any of the fields contain placeholders, the result will be wrapped in a <code>Fn.sub</code>.
     * <p>
     * @param dest This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation cloudFormationLocationFromDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.DockerImageDestination dest) {
        return software.amazon.jsii.Kernel.call(this, "cloudFormationLocationFromDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(dest, "dest is required") });
    }

    /**
     * Turn a file asset location into a CloudFormation representation of that location.
     * <p>
     * If any of the fields contain placeholders, the result will be wrapped in a <code>Fn.sub</code>.
     * <p>
     * @param location This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation cloudFormationLocationFromFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloudassembly.schema.FileDestination location) {
        return software.amazon.jsii.Kernel.call(this, "cloudFormationLocationFromFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(location, "location is required") });
    }

    /**
     * Write the CloudFormation stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session. The Stack artifact will control the settings for the
     * CloudFormation deployment.
     * <p>
     * @param session This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void emitArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SynthesizeStackArtifactOptions options) {
        software.amazon.jsii.Kernel.call(this, "emitArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required"), options });
    }

    /**
     * Write the CloudFormation stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session. The Stack artifact will control the settings for the
     * CloudFormation deployment.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void emitArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "emitArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * (deprecated) Write the stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     * <p>
     * @deprecated Use <code>emitArtifact</code> instead
     * @param stack This parameter is required.
     * @param session This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void emitStackArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SynthesizeStackArtifactOptions options) {
        software.amazon.jsii.Kernel.call(this, "emitStackArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required"), options });
    }

    /**
     * (deprecated) Write the stack artifact to the session.
     * <p>
     * Use default settings to add a CloudFormationStackArtifact artifact to
     * the given synthesis session.
     * <p>
     * @deprecated Use <code>emitArtifact</code> instead
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void emitStackArtifact(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "emitStackArtifact", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Synthesize the associated stack to the session.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public abstract void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session);

    /**
     * (deprecated) Have the stack write out its template.
     * <p>
     * @deprecated Use <code>synthesizeTemplate</code> instead
     * @param stack This parameter is required.
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    protected void synthesizeStackTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack stack, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        software.amazon.jsii.Kernel.call(this, "synthesizeStackTemplate", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Write the stack template to the given session.
     * <p>
     * Return a descriptor that represents the stack template as a file asset
     * source, for adding to an asset manifest (if desired). This can be used to
     * have the asset manifest system (<code>cdk-assets</code>) upload the template to S3
     * using the appropriate role, so that afterwards only a CloudFormation
     * deployment is necessary.
     * <p>
     * If the template is uploaded as an asset, the <code>stackTemplateAssetObjectUrl</code>
     * property should be set when calling <code>emitArtifact.</code>
     * <p>
     * If the template is <em>NOT</em> uploaded as an asset first and the template turns
     * out to be &gt;50KB, it will need to be uploaded to S3 anyway. At that point
     * the credentials will be the same identity that is doing the <code>UpdateStack</code>
     * call, which may not have the right permissions to write to S3.
     * <p>
     * @param session This parameter is required.
     * @param lookupRoleArn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource synthesizeTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session, final @org.jetbrains.annotations.Nullable java.lang.String lookupRoleArn) {
        return software.amazon.jsii.Kernel.call(this, "synthesizeTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetSource.class), new Object[] { java.util.Objects.requireNonNull(session, "session is required"), lookupRoleArn });
    }

    /**
     * Write the stack template to the given session.
     * <p>
     * Return a descriptor that represents the stack template as a file asset
     * source, for adding to an asset manifest (if desired). This can be used to
     * have the asset manifest system (<code>cdk-assets</code>) upload the template to S3
     * using the appropriate role, so that afterwards only a CloudFormation
     * deployment is necessary.
     * <p>
     * If the template is uploaded as an asset, the <code>stackTemplateAssetObjectUrl</code>
     * property should be set when calling <code>emitArtifact.</code>
     * <p>
     * If the template is <em>NOT</em> uploaded as an asset first and the template turns
     * out to be &gt;50KB, it will need to be uploaded to S3 anyway. At that point
     * the credentials will be the same identity that is doing the <code>UpdateStack</code>
     * call, which may not have the right permissions to write to S3.
     * <p>
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource synthesizeTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
        return software.amazon.jsii.Kernel.call(this, "synthesizeTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetSource.class), new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Retrieve the bound stack.
     * <p>
     * Fails if the stack hasn't been bound yet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getBoundStack() {
        return software.amazon.jsii.Kernel.get(this, "boundStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
    }

    /**
     * The qualifier used to bootstrap this stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBootstrapQualifier() {
        return software.amazon.jsii.Kernel.get(this, "bootstrapQualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role used to lookup for this stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLookupRole() {
        return software.amazon.jsii.Kernel.get(this, "lookupRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.StackSynthesizer implements software.amazon.awscdk.IStackSynthesizer.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Register a Docker Image Asset.
         * <p>
         * Returns the parameters that can be used to refer to the asset inside the template.
         * <p>
         * The synthesizer must rely on some out-of-band mechanism to make sure the given files
         * are actually placed in the returned location before the deployment happens. This can
         * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
         * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
         * mechanism.
         * <p>
         * @param asset This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetLocation addDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerImageAssetSource asset) {
            return software.amazon.jsii.Kernel.call(this, "addDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerImageAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
        }

        /**
         * Register a File Asset.
         * <p>
         * Returns the parameters that can be used to refer to the asset inside the template.
         * <p>
         * The synthesizer must rely on some out-of-band mechanism to make sure the given files
         * are actually placed in the returned location before the deployment happens. This can
         * be by writing the instructions to the asset manifest (for use by the <code>cdk-assets</code> tool),
         * by relying on the CLI to upload files (legacy behavior), or some other operator controlled
         * mechanism.
         * <p>
         * @param asset This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetLocation addFileAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.FileAssetSource asset) {
            return software.amazon.jsii.Kernel.call(this, "addFileAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.FileAssetLocation.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
        }

        /**
         * Synthesize the associated stack to the session.
         * <p>
         * @param session This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void synthesize(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ISynthesisSession session) {
            software.amazon.jsii.Kernel.call(this, "synthesize", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
        }
    }
}
