package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Authorize WebSocket API Routes with IAM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketIamAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * // This function handles your connect route
 * Function connectHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "WebSocketApi");
 * webSocketApi.addRoute("$connect", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("Integration", connectHandler))
 *         .authorizer(new WebSocketIamAuthorizer())
 *         .build());
 * // Create an IAM user (identity)
 * User user = new User(this, "User");
 * String webSocketArn = Stack.of(this).formatArn(ArnComponents.builder()
 *         .service("execute-api")
 *         .resource(webSocketApi.getApiId())
 *         .build());
 * // Grant access to the IAM user
 * user.attachInlinePolicy(Policy.Builder.create(this, "AllowInvoke")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(webSocketArn))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.760Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.WebSocketIamAuthorizer")
public class WebSocketIamAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer {

    protected WebSocketIamAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketIamAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketIamAuthorizer() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Bind this authorizer to a specified WebSocket route.
     * <p>
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerBindOptions _options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(_options, "_options is required") });
    }
}
