package software.amazon.awscdk.cloudassembly.schema;

/**
 * Information needed to access an IAM role created as part of the bootstrap process.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * BootstrapRole bootstrapRole = BootstrapRole.builder()
 *         .arn("arn")
 *         // the properties below are optional
 *         .assumeRoleExternalId("assumeRoleExternalId")
 *         .bootstrapStackVersionSsmParameter("bootstrapStackVersionSsmParameter")
 *         .requiresBootstrapStackVersion(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:41.178Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.BootstrapRole")
@software.amazon.jsii.Jsii.Proxy(BootstrapRole.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BootstrapRole extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IAM role created as part of bootrapping e.g. lookupRoleArn.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * External ID to use when assuming the bootstrap role.
     * <p>
     * Default: - No external ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleExternalId() {
        return null;
    }

    /**
     * Name of SSM parameter with bootstrap stack version.
     * <p>
     * Default: - Discover SSM parameter by reading stack
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBootstrapStackVersionSsmParameter() {
        return null;
    }

    /**
     * Version of bootstrap stack required to use this role.
     * <p>
     * Default: - No bootstrap stack required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BootstrapRole}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BootstrapRole}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BootstrapRole> {
        java.lang.String arn;
        java.lang.String assumeRoleExternalId;
        java.lang.String bootstrapStackVersionSsmParameter;
        java.lang.Number requiresBootstrapStackVersion;

        /**
         * Sets the value of {@link BootstrapRole#getArn}
         * @param arn The ARN of the IAM role created as part of bootrapping e.g. lookupRoleArn. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arn(java.lang.String arn) {
            this.arn = arn;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapRole#getAssumeRoleExternalId}
         * @param assumeRoleExternalId External ID to use when assuming the bootstrap role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleExternalId(java.lang.String assumeRoleExternalId) {
            this.assumeRoleExternalId = assumeRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapRole#getBootstrapStackVersionSsmParameter}
         * @param bootstrapStackVersionSsmParameter Name of SSM parameter with bootstrap stack version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bootstrapStackVersionSsmParameter(java.lang.String bootstrapStackVersionSsmParameter) {
            this.bootstrapStackVersionSsmParameter = bootstrapStackVersionSsmParameter;
            return this;
        }

        /**
         * Sets the value of {@link BootstrapRole#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to use this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BootstrapRole}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BootstrapRole build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BootstrapRole}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BootstrapRole {
        private final java.lang.String arn;
        private final java.lang.String assumeRoleExternalId;
        private final java.lang.String bootstrapStackVersionSsmParameter;
        private final java.lang.Number requiresBootstrapStackVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleExternalId = software.amazon.jsii.Kernel.get(this, "assumeRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bootstrapStackVersionSsmParameter = software.amazon.jsii.Kernel.get(this, "bootstrapStackVersionSsmParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requiresBootstrapStackVersion = software.amazon.jsii.Kernel.get(this, "requiresBootstrapStackVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            this.assumeRoleExternalId = builder.assumeRoleExternalId;
            this.bootstrapStackVersionSsmParameter = builder.bootstrapStackVersionSsmParameter;
            this.requiresBootstrapStackVersion = builder.requiresBootstrapStackVersion;
        }

        @Override
        public final java.lang.String getArn() {
            return this.arn;
        }

        @Override
        public final java.lang.String getAssumeRoleExternalId() {
            return this.assumeRoleExternalId;
        }

        @Override
        public final java.lang.String getBootstrapStackVersionSsmParameter() {
            return this.bootstrapStackVersionSsmParameter;
        }

        @Override
        public final java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("arn", om.valueToTree(this.getArn()));
            if (this.getAssumeRoleExternalId() != null) {
                data.set("assumeRoleExternalId", om.valueToTree(this.getAssumeRoleExternalId()));
            }
            if (this.getBootstrapStackVersionSsmParameter() != null) {
                data.set("bootstrapStackVersionSsmParameter", om.valueToTree(this.getBootstrapStackVersionSsmParameter()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.BootstrapRole"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BootstrapRole.Jsii$Proxy that = (BootstrapRole.Jsii$Proxy) o;

            if (!arn.equals(that.arn)) return false;
            if (this.assumeRoleExternalId != null ? !this.assumeRoleExternalId.equals(that.assumeRoleExternalId) : that.assumeRoleExternalId != null) return false;
            if (this.bootstrapStackVersionSsmParameter != null ? !this.bootstrapStackVersionSsmParameter.equals(that.bootstrapStackVersionSsmParameter) : that.bootstrapStackVersionSsmParameter != null) return false;
            return this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.arn.hashCode();
            result = 31 * result + (this.assumeRoleExternalId != null ? this.assumeRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.bootstrapStackVersionSsmParameter != null ? this.bootstrapStackVersionSsmParameter.hashCode() : 0);
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            return result;
        }
    }
}
