/**
 * <h1>AWS Lambda Layer with kubectl (and helm)</h1>
 * <p>
 * This module exports a single class called <code>KubectlLayer</code> which is a <code>lambda.Layer</code> that bundles the <a href="https://kubernetes.io/docs/reference/kubectl/kubectl/"><code>kubectl</code></a> and the <a href="https://helm.sh/"><code>helm</code></a> command line.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>Helm Version: 3.5.4</li>
 * <li>Kubectl Version: 1.20.0</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // KubectlLayer bundles the 'kubectl' and 'helm' command lines
 * import software.amazon.awscdk.lambdalayer.kubectl.KubectlLayer;
 * 
 * Function fn;
 * 
 * fn.addLayers(new KubectlLayer(this, "KubectlLayer"));
 * </pre></blockquote>
 * <p>
 * <code>kubectl</code> will be installed under <code>/opt/kubectl/kubectl</code>, and <code>helm</code> will be installed under <code>/opt/helm/helm</code>.
 * <p>
 * <h2>Alternatives</h2>
 * <p>
 * This module bundles Kubectl v1.20.0 and the associated helm version
 * To use alternative Kubectl versions, including the latest available,
 * you can use the external module
 * <a href="https://github.com/cdklabs/awscdk-asset-kubectl">awscdk-asset-kubectl</a>.
 */
package software.amazon.awscdk.lambdalayer.kubectl;
