package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Vpc vpc = new Vpc(this, "VPC");
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "NLB")
 *         .vpc(vpc)
 *         .build();
 * VpcLink link = VpcLink.Builder.create(this, "link")
 *         .targets(List.of(nlb))
 *         .build();
 * Integration integration = Integration.Builder.create()
 *         .type(IntegrationType.HTTP_PROXY)
 *         .integrationHttpMethod("ANY")
 *         .options(IntegrationOptions.builder()
 *                 .connectionType(ConnectionType.VPC_LINK)
 *                 .vpcLink(link)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:27.510Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.IntegrationProps")
@software.amazon.jsii.Jsii.Proxy(IntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies an API method integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IntegrationType getType();

    /**
     * The integration's HTTP method type.
     * <p>
     * Required unless you use a MOCK integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationHttpMethod() {
        return null;
    }

    /**
     * Integration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
        return null;
    }

    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * <p>
     * <ul>
     * <li>If you specify HTTP for the <code>type</code> property, specify the API endpoint URL.</li>
     * <li>If you specify MOCK for the <code>type</code> property, don't specify this property.</li>
     * <li>If you specify AWS for the <code>type</code> property, specify an AWS service that
     * follows this form: <code>arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.</code>
     * For example, a Lambda function URI follows this form:
     * arn:partition:apigateway:region:lambda:path/path. The path is usually in the
     * form /2015-03-31/functions/LambdaFunctionARN/invocations.</li>
     * </ul>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri">https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationProps> {
        software.amazon.awscdk.services.apigateway.IntegrationType type;
        java.lang.String integrationHttpMethod;
        software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        java.lang.Object uri;

        /**
         * Sets the value of {@link IntegrationProps#getType}
         * @param type Specifies an API method integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationProps#getIntegrationHttpMethod}
         * @param integrationHttpMethod The integration's HTTP method type.
         *                              Required unless you use a MOCK integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationProps#getOptions}
         * @param options Integration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationProps#getUri}
         * @param uri The Uniform Resource Identifier (URI) for the integration.
         *            <ul>
         *            <li>If you specify HTTP for the <code>type</code> property, specify the API endpoint URL.</li>
         *            <li>If you specify MOCK for the <code>type</code> property, don't specify this property.</li>
         *            <li>If you specify AWS for the <code>type</code> property, specify an AWS service that
         *            follows this form: <code>arn:partition:apigateway:region:subdomain.service|service:path|action/service_api.</code>
         *            For example, a Lambda function URI follows this form:
         *            arn:partition:apigateway:region:lambda:path/path. The path is usually in the
         *            form /2015-03-31/functions/LambdaFunctionARN/invocations.</li>
         *            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.Object uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProps {
        private final software.amazon.awscdk.services.apigateway.IntegrationType type;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.Object uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationType.class));
            this.integrationHttpMethod = software.amazon.jsii.Kernel.get(this, "integrationHttpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IntegrationOptions.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.integrationHttpMethod = builder.integrationHttpMethod;
            this.options = builder.options;
            this.uri = builder.uri;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.Object getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getIntegrationHttpMethod() != null) {
                data.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.IntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationProps.Jsii$Proxy that = (IntegrationProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
