package software.amazon.awscdk.services.appsync;

/**
 * An AppSync GraphQL API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * GraphqlApi api = GraphqlApi.Builder.create(this, "EventBridgeApi")
 *         .name("EventBridgeApi")
 *         .definition(Definition.fromFile(join(__dirname, "appsync.eventbridge.graphql")))
 *         .build();
 * EventBus bus = EventBus.Builder.create(this, "DestinationEventBus").build();
 * EventBridgeDataSource dataSource = api.addEventBridgeDataSource("NoneDS", bus);
 * dataSource.createResolver("EventResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("emitEvent")
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:28.434Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.GraphqlApi")
public class GraphqlApi extends software.amazon.awscdk.services.appsync.GraphqlApiBase {

    protected GraphqlApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GraphqlApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a GraphQL API through this function.
     * <p>
     * @param scope scope. This parameter is required.
     * @param id id. This parameter is required.
     * @param attrs GraphQL API Attributes of an API. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IGraphqlApi fromGraphqlApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.GraphqlApi.class, "fromGraphqlApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IGraphqlApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add schema dependency to a given construct.
     * <p>
     * @param construct the dependee. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.Boolean addSchemaDependency(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource construct) {
        return software.amazon.jsii.Kernel.call(this, "addSchemaDependency", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...). This parameter is required.
     * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.IamResource resources, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), java.util.Objects.requireNonNull(resources, "resources is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Mutations (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantMutation(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantMutation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Queries (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
     * <p>
     * @param grantee The principal. This parameter is required.
     * @param fields The fields to grant access to that are Subscriptions (leave blank for all). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantSubscription(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... fields) {
        return software.amazon.jsii.Kernel.call(this, "grantSubscription", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(fields)).toArray(Object[]::new));
    }

    /**
     * an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AppSyncDomainName of the associated custom domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppSyncDomainName() {
        return software.amazon.jsii.Kernel.get(this, "appSyncDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the ARN of the API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getArn() {
        return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the URL of the endpoint created by AppSync.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGraphqlUrl() {
        return software.amazon.jsii.Kernel.get(this, "graphqlUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the CloudWatch Log Group for this API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * The Authorization Types for this GraphQL Api.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))));
    }

    /**
     * the name of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the schema attached to this api (only available for GraphQL APIs, not available for merged APIs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ISchema getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ISchema.class));
    }

    /**
     * the configured API key, if present.
     * <p>
     * Default: - no api key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApiKey() {
        return software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.GraphqlApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.GraphqlApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.GraphqlApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.GraphqlApiProps.Builder();
        }

        /**
         * the name of the GraphQL API.
         * <p>
         * @return {@code this}
         * @param name the name of the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Optional authorization configuration.
         * <p>
         * Default: - API Key authorization
         * <p>
         * @return {@code this}
         * @param authorizationConfig Optional authorization configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationConfig(final software.amazon.awscdk.services.appsync.AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        /**
         * Definition (schema file or source APIs) for this GraphQL Api.
         * <p>
         * @return {@code this}
         * @param definition Definition (schema file or source APIs) for this GraphQL Api. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.services.appsync.Definition definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * The domain name configuration for the GraphQL API.
         * <p>
         * The Route 53 hosted zone and CName DNS record must be configured in addition to this setting to
         * enable custom domain URL
         * <p>
         * Default: - no domain name
         * <p>
         * @return {@code this}
         * @param domainName The domain name configuration for the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final software.amazon.awscdk.services.appsync.DomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * A value indicating whether the API to enable (ENABLED) or disable (DISABLED) introspection.
         * <p>
         * Default: IntrospectionConfig.ENABLED
         * <p>
         * @return {@code this}
         * @param introspectionConfig A value indicating whether the API to enable (ENABLED) or disable (DISABLED) introspection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder introspectionConfig(final software.amazon.awscdk.services.appsync.IntrospectionConfig introspectionConfig) {
            this.props.introspectionConfig(introspectionConfig);
            return this;
        }

        /**
         * Logging configuration for this api.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param logConfig Logging configuration for this api. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(final software.amazon.awscdk.services.appsync.LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        /**
         * (deprecated) GraphQL schema definition. Specify how you want to define your schema.
         * <p>
         * SchemaFile.fromAsset(filePath: string) allows schema definition through schema.graphql file
         * <p>
         * Default: - schema will be generated code-first (i.e. addType, addObjectType, etc.)
         * <p>
         * @return {@code this}
         * @deprecated use Definition.schema instead
         * @param schema GraphQL schema definition. Specify how you want to define your schema. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder schema(final software.amazon.awscdk.services.appsync.ISchema schema) {
            this.props.schema(schema);
            return this;
        }

        /**
         * A value indicating whether the API is accessible from anywhere (GLOBAL) or can only be access from a VPC (PRIVATE).
         * <p>
         * Default: - GLOBAL
         * <p>
         * @return {@code this}
         * @param visibility A value indicating whether the API is accessible from anywhere (GLOBAL) or can only be access from a VPC (PRIVATE). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibility(final software.amazon.awscdk.services.appsync.Visibility visibility) {
            this.props.visibility(visibility);
            return this;
        }

        /**
         * A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param xrayEnabled A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(final java.lang.Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.GraphqlApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.GraphqlApi build() {
            return new software.amazon.awscdk.services.appsync.GraphqlApi(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
