package software.amazon.awscdk.services.cloudfront;

/**
 * A distribution tells CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket sourceBucket;
 * Distribution myDistribution = Distribution.Builder.create(this, "MyCfWebDistribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new S3Origin(sourceBucket))
 *                 .build())
 *         .build();
 * CfnDistribution cfnDistribution = (CfnDistribution)myDistribution.getNode().getDefaultChild();
 * cfnDistribution.overrideLogicalId("MyDistributionCFDistribution3H55TI9Q");
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.202Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution")
public class CfnDistribution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnDistribution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The domain name of the resource, such as <code>d111111abcdef8.cloudfront.net</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The distribution's identifier.
     * <p>
     * For example: <code>E1U5RQF7T870K0</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The distribution's configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDistributionConfig() {
        return software.amazon.jsii.Kernel.get(this, "distributionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The distribution's configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }

    /**
     * The distribution's configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A complex type that contains zero or more <code>Tag</code> elements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A complex type that describes how CloudFront processes requests.
     * <p>
     * You must create at least as many cache behaviors (including the default cache behavior) as you have origins if you want CloudFront to serve objects from all of the origins. Each cache behavior specifies the one origin from which you want CloudFront to get objects. If you have two origins and only the default cache behavior, the default cache behavior will cause CloudFront to get objects from one of the origins, but the other origin is never used.
     * <p>
     * For the current quota (formerly known as limit) on the number of cache behaviors that you can add to a distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * If you don't want to specify any cache behaviors, include only an empty <code>CacheBehaviors</code> element. Don't include an empty <code>CacheBehavior</code> element because this is invalid.
     * <p>
     * To delete all cache behaviors in an existing distribution, update the distribution configuration and include only an empty <code>CacheBehaviors</code> element.
     * <p>
     * To add, change, or remove one or more cache behaviors, update the distribution configuration and specify all of the cache behaviors that you want to include in the updated distribution.
     * <p>
     * For more information about cache behaviors, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesCacheBehavior">Cache Behavior Settings</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CacheBehaviorProperty cacheBehaviorProperty = CacheBehaviorProperty.builder()
     *         .pathPattern("pathPattern")
     *         .targetOriginId("targetOriginId")
     *         .viewerProtocolPolicy("viewerProtocolPolicy")
     *         // the properties below are optional
     *         .allowedMethods(List.of("allowedMethods"))
     *         .cachedMethods(List.of("cachedMethods"))
     *         .cachePolicyId("cachePolicyId")
     *         .compress(false)
     *         .defaultTtl(123)
     *         .fieldLevelEncryptionId("fieldLevelEncryptionId")
     *         .forwardedValues(ForwardedValuesProperty.builder()
     *                 .queryString(false)
     *                 // the properties below are optional
     *                 .cookies(CookiesProperty.builder()
     *                         .forward("forward")
     *                         // the properties below are optional
     *                         .whitelistedNames(List.of("whitelistedNames"))
     *                         .build())
     *                 .headers(List.of("headers"))
     *                 .queryStringCacheKeys(List.of("queryStringCacheKeys"))
     *                 .build())
     *         .functionAssociations(List.of(FunctionAssociationProperty.builder()
     *                 .eventType("eventType")
     *                 .functionArn("functionArn")
     *                 .build()))
     *         .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
     *                 .eventType("eventType")
     *                 .includeBody(false)
     *                 .lambdaFunctionArn("lambdaFunctionArn")
     *                 .build()))
     *         .maxTtl(123)
     *         .minTtl(123)
     *         .originRequestPolicyId("originRequestPolicyId")
     *         .realtimeLogConfigArn("realtimeLogConfigArn")
     *         .responseHeadersPolicyId("responseHeadersPolicyId")
     *         .smoothStreaming(false)
     *         .trustedKeyGroups(List.of("trustedKeyGroups"))
     *         .trustedSigners(List.of("trustedSigners"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The pattern (for example, <code>images/*.jpg</code> ) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution.
         * <p>
         * <blockquote>
         * <p>
         * You can optionally include a slash ( <code>/</code> ) at the beginning of the path pattern. For example, <code>/images/*.jpg</code> . CloudFront behavior is the same with or without the leading <code>/</code> .
         * <p>
         * </blockquote>
         * <p>
         * The path pattern for the default cache behavior is <code>*</code> and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path Pattern</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-pathpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-pathpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPathPattern();

        /**
         * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they match this cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-targetoriginid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-targetoriginid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code> .
         * <p>
         * You can specify the following options:
         * <p>
         * <ul>
         * <li><code>allow-all</code> : Viewers can use HTTP or HTTPS.</li>
         * <li><code>redirect-to-https</code> : If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.</li>
         * <li><code>https-only</code> : If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).</li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-viewerprotocolpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-viewerprotocolpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
         * <p>
         * There are three choices:
         * <p>
         * <ul>
         * <li>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</li>
         * <li>CloudFront forwards only <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
         * <li>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code> , and <code>DELETE</code> requests.</li>
         * </ul>
         * <p>
         * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-allowedmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-allowedmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods.
         * <p>
         * There are two choices:
         * <p>
         * <ul>
         * <li>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</li>
         * <li>CloudFront caches responses to <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
         * </ul>
         * <p>
         * If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachedmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachedmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * The unique identifier of the cache policy that is attached to this cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachepolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachepolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * Whether you want CloudFront to automatically compress certain files for this cache behavior.
         * <p>
         * If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-compress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-compress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 86400
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-defaultttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-defaultttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-fieldlevelencryptionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-fieldlevelencryptionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
         * <p>
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-forwardedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-forwardedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * A list of CloudFront functions that are associated with this cache behavior.
         * <p>
         * CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-functionassociations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-functionassociations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionAssociations() {
            return null;
        }

        /**
         * A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-lambdafunctionassociations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-lambdafunctionassociations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 31536000
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-maxttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-maxttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code> , if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code> ).
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-minttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-minttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * The unique identifier of the origin request policy that is attached to this cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-originrequestpolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-originrequestpolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-realtimelogconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-realtimelogconfigarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRealtimeLogConfigArn() {
            return null;
        }

        /**
         * The identifier for a response headers policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-responseheaderspolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-responseheaderspolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponseHeadersPolicyId() {
            return null;
        }

        /**
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
         * <p>
         * If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-smoothstreaming">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-smoothstreaming</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * <p>
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedkeygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedkeygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedKeyGroups() {
            return null;
        }

        /**
         * <blockquote><p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code> .<p></blockquote>
         * <p>
         * A list of AWS account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         * <p>
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS account . The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedsigners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedsigners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            java.lang.String pathPattern;
            java.lang.String targetOriginId;
            java.lang.String viewerProtocolPolicy;
            java.util.List<java.lang.String> allowedMethods;
            java.util.List<java.lang.String> cachedMethods;
            java.lang.String cachePolicyId;
            java.lang.Object compress;
            java.lang.Number defaultTtl;
            java.lang.String fieldLevelEncryptionId;
            java.lang.Object forwardedValues;
            java.lang.Object functionAssociations;
            java.lang.Object lambdaFunctionAssociations;
            java.lang.Number maxTtl;
            java.lang.Number minTtl;
            java.lang.String originRequestPolicyId;
            java.lang.String realtimeLogConfigArn;
            java.lang.String responseHeadersPolicyId;
            java.lang.Object smoothStreaming;
            java.util.List<java.lang.String> trustedKeyGroups;
            java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link CacheBehaviorProperty#getPathPattern}
             * @param pathPattern The pattern (for example, <code>images/*.jpg</code> ) that specifies which requests to apply the behavior to. When CloudFront receives a viewer request, the requested path is compared with path patterns in the order in which cache behaviors are listed in the distribution. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    You can optionally include a slash ( <code>/</code> ) at the beginning of the path pattern. For example, <code>/images/*.jpg</code> . CloudFront behavior is the same with or without the leading <code>/</code> .
             *                    <p>
             *                    </blockquote>
             *                    <p>
             *                    The path pattern for the default cache behavior is <code>*</code> and cannot be changed. If the request for an object does not match the path pattern for any cache behaviors, CloudFront applies the behavior in the default cache behavior.
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesPathPattern">Path Pattern</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPattern(java.lang.String pathPattern) {
                this.pathPattern = pathPattern;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they match this cache behavior. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code> . This parameter is required.
             *                             You can specify the following options:
             *                             <p>
             *                             <ul>
             *                             <li><code>allow-all</code> : Viewers can use HTTP or HTTPS.</li>
             *                             <li><code>redirect-to-https</code> : If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.</li>
             *                             <li><code>https-only</code> : If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).</li>
             *                             </ul>
             *                             <p>
             *                             For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
             *                       There are three choices:
             *                       <p>
             *                       <ul>
             *                       <li>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</li>
             *                       <li>CloudFront forwards only <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
             *                       <li>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code> , and <code>DELETE</code> requests.</li>
             *                       </ul>
             *                       <p>
             *                       If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods.
             *                      There are two choices:
             *                      <p>
             *                      <ul>
             *                      <li>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</li>
             *                      <li>CloudFront caches responses to <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
             *                      </ul>
             *                      <p>
             *                      If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId The unique identifier of the cache policy that is attached to this cache behavior.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                      <p>
             *                      A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
             *                 If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
             *                 If so, specify true; if not, specify false. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl This field is deprecated.
             *                   We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                   <p>
             *                   The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for this cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues This field is deprecated.
             *                        We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             *                        <p>
             *                        A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues This field is deprecated.
             *                        We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        A <code>CacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             *                        <p>
             *                        A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations A list of CloudFront functions that are associated with this cache behavior.
             *                             CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(software.amazon.awscdk.IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations A list of CloudFront functions that are associated with this cache behavior.
             *                             CloudFront functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(java.util.List<? extends java.lang.Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<? extends java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMaxTtl}
             * @param maxTtl This field is deprecated.
             *               We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMinTtl}
             * @param minTtl This field is deprecated.
             *               We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code> , if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId The unique identifier of the origin request policy that is attached to this cache behavior.
             *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getRealtimeLogConfigArn}
             * @param realtimeLogConfigArn The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeLogConfigArn(java.lang.String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getResponseHeadersPolicyId}
             * @param responseHeadersPolicyId The identifier for a response headers policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseHeadersPolicyId(java.lang.String responseHeadersPolicyId) {
                this.responseHeadersPolicyId = responseHeadersPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
             *                        If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
             *                        If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTrustedKeyGroups}
             * @param trustedKeyGroups A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
             *                         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedKeyGroups(java.util.List<java.lang.String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners <blockquote><p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code> .<p></blockquote>
             *                       A list of AWS account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
             *                       <p>
             *                       When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in the trusted signer's AWS account . The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheBehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheBehaviorProperty {
            private final java.lang.String pathPattern;
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object functionAssociations;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.String realtimeLogConfigArn;
            private final java.lang.String responseHeadersPolicyId;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedKeyGroups;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetOriginId = software.amazon.jsii.Kernel.get(this, "targetOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = software.amazon.jsii.Kernel.get(this, "cachePolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fieldLevelEncryptionId = software.amazon.jsii.Kernel.get(this, "fieldLevelEncryptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originRequestPolicyId = software.amazon.jsii.Kernel.get(this, "originRequestPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realtimeLogConfigArn = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseHeadersPolicyId = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pathPattern = java.util.Objects.requireNonNull(builder.pathPattern, "pathPattern is required");
                this.targetOriginId = java.util.Objects.requireNonNull(builder.targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(builder.viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = builder.allowedMethods;
                this.cachedMethods = builder.cachedMethods;
                this.cachePolicyId = builder.cachePolicyId;
                this.compress = builder.compress;
                this.defaultTtl = builder.defaultTtl;
                this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
                this.forwardedValues = builder.forwardedValues;
                this.functionAssociations = builder.functionAssociations;
                this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
                this.maxTtl = builder.maxTtl;
                this.minTtl = builder.minTtl;
                this.originRequestPolicyId = builder.originRequestPolicyId;
                this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
                this.responseHeadersPolicyId = builder.responseHeadersPolicyId;
                this.smoothStreaming = builder.smoothStreaming;
                this.trustedKeyGroups = builder.trustedKeyGroups;
                this.trustedSigners = builder.trustedSigners;
            }

            @Override
            public final java.lang.String getPathPattern() {
                return this.pathPattern;
            }

            @Override
            public final java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public final java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public final java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public final java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public final java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public final java.lang.Object getFunctionAssociations() {
                return this.functionAssociations;
            }

            @Override
            public final java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public final java.lang.String getRealtimeLogConfigArn() {
                return this.realtimeLogConfigArn;
            }

            @Override
            public final java.lang.String getResponseHeadersPolicyId() {
                return this.responseHeadersPolicyId;
            }

            @Override
            public final java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedKeyGroups() {
                return this.trustedKeyGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getFunctionAssociations() != null) {
                    data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getRealtimeLogConfigArn() != null) {
                    data.set("realtimeLogConfigArn", om.valueToTree(this.getRealtimeLogConfigArn()));
                }
                if (this.getResponseHeadersPolicyId() != null) {
                    data.set("responseHeadersPolicyId", om.valueToTree(this.getResponseHeadersPolicyId()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedKeyGroups() != null) {
                    data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheBehaviorProperty.Jsii$Proxy that = (CacheBehaviorProperty.Jsii$Proxy) o;

                if (!pathPattern.equals(that.pathPattern)) return false;
                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.realtimeLogConfigArn != null ? !this.realtimeLogConfigArn.equals(that.realtimeLogConfigArn) : that.realtimeLogConfigArn != null) return false;
                if (this.responseHeadersPolicyId != null ? !this.responseHeadersPolicyId.equals(that.responseHeadersPolicyId) : that.responseHeadersPolicyId != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pathPattern.hashCode();
                result = 31 * result + (this.targetOriginId.hashCode());
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.realtimeLogConfigArn != null ? this.realtimeLogConfigArn.hashCode() : 0);
                result = 31 * result + (this.responseHeadersPolicyId != null ? this.responseHeadersPolicyId.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This field is deprecated.
     * <p>
     * We recommend that you use a cache policy or an origin request policy instead of this field.
     * <p>
     * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CookiesProperty cookiesProperty = CookiesProperty.builder()
     *         .forward("forward")
     *         // the properties below are optional
     *         .whitelistedNames(List.of("whitelistedNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CookiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the <code>WhitelistedNames</code> complex type.
         * <p>
         * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the <code>Forward</code> element.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-forward">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-forward</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getForward();

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Required if you specify <code>whitelist</code> for the value of <code>Forward</code> . A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
         * <p>
         * If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code> , omit <code>WhitelistedNames</code> . If you change the value of <code>Forward</code> from <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.
         * <p>
         * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">CloudFront Limits</a> in the <em>AWS General Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-whitelistednames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-whitelistednames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWhitelistedNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesProperty> {
            java.lang.String forward;
            java.util.List<java.lang.String> whitelistedNames;

            /**
             * Sets the value of {@link CookiesProperty#getForward}
             * @param forward This field is deprecated. This parameter is required.
             *                We recommend that you use a cache policy or an origin request policy instead of this field.
             *                <p>
             *                If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies specified in the <code>WhitelistedNames</code> complex type.
             *                <p>
             *                Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify none for the <code>Forward</code> element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forward(java.lang.String forward) {
                this.forward = forward;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getWhitelistedNames}
             * @param whitelistedNames This field is deprecated.
             *                         We recommend that you use a cache policy or an origin request policy instead of this field.
             *                         <p>
             *                         If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                         <p>
             *                         If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                         <p>
             *                         Required if you specify <code>whitelist</code> for the value of <code>Forward</code> . A complex type that specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if you want to forward selected cookies, the names of those cookies.
             *                         <p>
             *                         If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code> , omit <code>WhitelistedNames</code> . If you change the value of <code>Forward</code> from <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.
             *                         <p>
             *                         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">CloudFront Limits</a> in the <em>AWS General Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder whitelistedNames(java.util.List<java.lang.String> whitelistedNames) {
                this.whitelistedNames = whitelistedNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesProperty {
            private final java.lang.String forward;
            private final java.util.List<java.lang.String> whitelistedNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.forward = software.amazon.jsii.Kernel.get(this, "forward", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.whitelistedNames = software.amazon.jsii.Kernel.get(this, "whitelistedNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.forward = java.util.Objects.requireNonNull(builder.forward, "forward is required");
                this.whitelistedNames = builder.whitelistedNames;
            }

            @Override
            public final java.lang.String getForward() {
                return this.forward;
            }

            @Override
            public final java.util.List<java.lang.String> getWhitelistedNames() {
                return this.whitelistedNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("forward", om.valueToTree(this.getForward()));
                if (this.getWhitelistedNames() != null) {
                    data.set("whitelistedNames", om.valueToTree(this.getWhitelistedNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CookiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesProperty.Jsii$Proxy that = (CookiesProperty.Jsii$Proxy) o;

                if (!forward.equals(that.forward)) return false;
                return this.whitelistedNames != null ? this.whitelistedNames.equals(that.whitelistedNames) : that.whitelistedNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.forward.hashCode();
                result = 31 * result + (this.whitelistedNames != null ? this.whitelistedNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that controls:.
     * <p>
     * <ul>
     * <li>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</li>
     * <li>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</li>
     * </ul>
     * <p>
     * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CustomErrorResponseProperty customErrorResponseProperty = CustomErrorResponseProperty.builder()
     *         .errorCode(123)
     *         // the properties below are optional
     *         .errorCachingMinTtl(123)
     *         .responseCode(123)
     *         .responsePagePath("responsePagePath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomErrorResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomErrorResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomErrorResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP status code for which you want to specify a custom error page and/or a caching duration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getErrorCode();

        /**
         * The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in <code>ErrorCode</code> .
         * <p>
         * When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 300
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcachingminttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcachingminttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorCachingMinTtl() {
            return null;
        }

        /**
         * The HTTP status code that you want CloudFront to return to the viewer along with the custom error page.
         * <p>
         * There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
         * <p>
         * <ul>
         * <li>Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute <code>200</code> , the response typically won't be intercepted.</li>
         * <li>If you don't care about distinguishing among different client errors or server errors, you can specify <code>400</code> or <code>500</code> as the <code>ResponseCode</code> for all 4xx or 5xx errors.</li>
         * <li>You might want to return a <code>200</code> status code (OK) and static website so your customers don't know that your website is down.</li>
         * </ul>
         * <p>
         * If you specify a value for <code>ResponseCode</code> , you must also specify a value for <code>ResponsePagePath</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getResponseCode() {
            return null;
        }

        /**
         * The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by <code>ErrorCode</code> , for example, <code>/4xx-errors/403-forbidden.html</code> . If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:.
         * <p>
         * <ul>
         * <li>The value of <code>PathPattern</code> matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named <code>/4xx-errors</code> . Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, <code>/4xx-errors/*</code> .</li>
         * <li>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code> element for the origin that contains your custom error pages.</li>
         * </ul>
         * <p>
         * If you specify a value for <code>ResponsePagePath</code> , you must also specify a value for <code>ResponseCode</code> .
         * <p>
         * We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsepagepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsepagepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponsePagePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomErrorResponseProperty> {
            java.lang.Number errorCode;
            java.lang.Number errorCachingMinTtl;
            java.lang.Number responseCode;
            java.lang.String responsePagePath;

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCode}
             * @param errorCode The HTTP status code for which you want to specify a custom error page and/or a caching duration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCode(java.lang.Number errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCachingMinTtl}
             * @param errorCachingMinTtl The minimum amount of time, in seconds, that you want CloudFront to cache the HTTP status code specified in <code>ErrorCode</code> .
             *                           When this time period has elapsed, CloudFront queries your origin to see whether the problem that caused the error has been resolved and the requested object is now available.
             *                           <p>
             *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCachingMinTtl(java.lang.Number errorCachingMinTtl) {
                this.errorCachingMinTtl = errorCachingMinTtl;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponseCode}
             * @param responseCode The HTTP status code that you want CloudFront to return to the viewer along with the custom error page.
             *                     There are a variety of reasons that you might want CloudFront to return a status code different from the status code that your origin returned to CloudFront, for example:
             *                     <p>
             *                     <ul>
             *                     <li>Some Internet devices (some firewalls and corporate proxies, for example) intercept HTTP 4xx and 5xx and prevent the response from being returned to the viewer. If you substitute <code>200</code> , the response typically won't be intercepted.</li>
             *                     <li>If you don't care about distinguishing among different client errors or server errors, you can specify <code>400</code> or <code>500</code> as the <code>ResponseCode</code> for all 4xx or 5xx errors.</li>
             *                     <li>You might want to return a <code>200</code> status code (OK) and static website so your customers don't know that your website is down.</li>
             *                     </ul>
             *                     <p>
             *                     If you specify a value for <code>ResponseCode</code> , you must also specify a value for <code>ResponsePagePath</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseCode(java.lang.Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponsePagePath}
             * @param responsePagePath The path to the custom error page that you want CloudFront to return to a viewer when your origin returns the HTTP status code specified by <code>ErrorCode</code> , for example, <code>/4xx-errors/403-forbidden.html</code> . If you want to store your objects and your custom error pages in different locations, your distribution must include a cache behavior for which the following is true:.
             *                         <ul>
             *                         <li>The value of <code>PathPattern</code> matches the path to your custom error messages. For example, suppose you saved custom error pages for 4xx errors in an Amazon S3 bucket in a directory named <code>/4xx-errors</code> . Your distribution must include a cache behavior for which the path pattern routes requests for your custom error pages to that location, for example, <code>/4xx-errors/*</code> .</li>
             *                         <li>The value of <code>TargetOriginId</code> specifies the value of the <code>ID</code> element for the origin that contains your custom error pages.</li>
             *                         </ul>
             *                         <p>
             *                         If you specify a value for <code>ResponsePagePath</code> , you must also specify a value for <code>ResponseCode</code> .
             *                         <p>
             *                         We recommend that you store custom error pages in an Amazon S3 bucket. If you store custom error pages on an HTTP server and the server starts to return 5xx errors, CloudFront can't get the files that you want to return to viewers because the origin server is unavailable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responsePagePath(java.lang.String responsePagePath) {
                this.responsePagePath = responsePagePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomErrorResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomErrorResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomErrorResponseProperty {
            private final java.lang.Number errorCode;
            private final java.lang.Number errorCachingMinTtl;
            private final java.lang.Number responseCode;
            private final java.lang.String responsePagePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorCode = software.amazon.jsii.Kernel.get(this, "errorCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.errorCachingMinTtl = software.amazon.jsii.Kernel.get(this, "errorCachingMinTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.responseCode = software.amazon.jsii.Kernel.get(this, "responseCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.responsePagePath = software.amazon.jsii.Kernel.get(this, "responsePagePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorCode = java.util.Objects.requireNonNull(builder.errorCode, "errorCode is required");
                this.errorCachingMinTtl = builder.errorCachingMinTtl;
                this.responseCode = builder.responseCode;
                this.responsePagePath = builder.responsePagePath;
            }

            @Override
            public final java.lang.Number getErrorCode() {
                return this.errorCode;
            }

            @Override
            public final java.lang.Number getErrorCachingMinTtl() {
                return this.errorCachingMinTtl;
            }

            @Override
            public final java.lang.Number getResponseCode() {
                return this.responseCode;
            }

            @Override
            public final java.lang.String getResponsePagePath() {
                return this.responsePagePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("errorCode", om.valueToTree(this.getErrorCode()));
                if (this.getErrorCachingMinTtl() != null) {
                    data.set("errorCachingMinTtl", om.valueToTree(this.getErrorCachingMinTtl()));
                }
                if (this.getResponseCode() != null) {
                    data.set("responseCode", om.valueToTree(this.getResponseCode()));
                }
                if (this.getResponsePagePath() != null) {
                    data.set("responsePagePath", om.valueToTree(this.getResponsePagePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomErrorResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomErrorResponseProperty.Jsii$Proxy that = (CustomErrorResponseProperty.Jsii$Proxy) o;

                if (!errorCode.equals(that.errorCode)) return false;
                if (this.errorCachingMinTtl != null ? !this.errorCachingMinTtl.equals(that.errorCachingMinTtl) : that.errorCachingMinTtl != null) return false;
                if (this.responseCode != null ? !this.responseCode.equals(that.responseCode) : that.responseCode != null) return false;
                return this.responsePagePath != null ? this.responsePagePath.equals(that.responsePagePath) : that.responsePagePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorCode.hashCode();
                result = 31 * result + (this.errorCachingMinTtl != null ? this.errorCachingMinTtl.hashCode() : 0);
                result = 31 * result + (this.responseCode != null ? this.responseCode.hashCode() : 0);
                result = 31 * result + (this.responsePagePath != null ? this.responsePagePath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom origin.
     * <p>
     * A custom origin is any origin that is <em>not</em> an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with static website hosting</a> <em>is</em> a custom origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * CustomOriginConfigProperty customOriginConfigProperty = CustomOriginConfigProperty.builder()
     *         .originProtocolPolicy("originProtocolPolicy")
     *         // the properties below are optional
     *         .httpPort(123)
     *         .httpsPort(123)
     *         .originKeepaliveTimeout(123)
     *         .originReadTimeout(123)
     *         .originSslProtocols(List.of("originSslProtocols"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomOriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomOriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomOriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:.
         * <p>
         * <ul>
         * <li><code>http-only</code> – CloudFront always uses HTTP to connect to the origin.</li>
         * <li><code>match-viewer</code> – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.</li>
         * <li><code>https-only</code> – CloudFront always uses HTTPS to connect to the origin.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originprotocolpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originprotocolpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginProtocolPolicy();

        /**
         * The HTTP port that CloudFront uses to connect to the origin.
         * <p>
         * Specify the HTTP port that the origin listens on.
         * <p>
         * Default: - 80
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
            return null;
        }

        /**
         * The HTTPS port that CloudFront uses to connect to the origin.
         * <p>
         * Specify the HTTPS port that the origin listens on.
         * <p>
         * Default: - 443
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpsport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpsport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
            return null;
        }

        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * <p>
         * The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 5
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originkeepalivetimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originkeepalivetimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginKeepaliveTimeout() {
            return null;
        }

        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin.
         * <p>
         * This is also known as the <em>origin response timeout</em> . The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 30
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originreadtimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originreadtimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginReadTimeout() {
            return null;
        }

        /**
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
         * <p>
         * Valid values include <code>SSLv3</code> , <code>TLSv1</code> , <code>TLSv1.1</code> , and <code>TLSv1.2</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originsslprotocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originsslprotocols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOriginSslProtocols() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomOriginConfigProperty> {
            java.lang.String originProtocolPolicy;
            java.lang.Number httpPort;
            java.lang.Number httpsPort;
            java.lang.Number originKeepaliveTimeout;
            java.lang.Number originReadTimeout;
            java.util.List<java.lang.String> originSslProtocols;

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginProtocolPolicy}
             * @param originProtocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. Valid values are:. This parameter is required.
             *                             <ul>
             *                             <li><code>http-only</code> – CloudFront always uses HTTP to connect to the origin.</li>
             *                             <li><code>match-viewer</code> – CloudFront connects to the origin using the same protocol that the viewer used to connect to CloudFront.</li>
             *                             <li><code>https-only</code> – CloudFront always uses HTTPS to connect to the origin.</li>
             *                             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originProtocolPolicy(java.lang.String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpPort}
             * @param httpPort The HTTP port that CloudFront uses to connect to the origin.
             *                 Specify the HTTP port that the origin listens on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPort(java.lang.Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpsPort}
             * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin.
             *                  Specify the HTTPS port that the origin listens on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPort(java.lang.Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginKeepaliveTimeout}
             * @param originKeepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin.
             *                               The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 5 seconds.
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginKeepaliveTimeout">Origin Keep-alive Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originKeepaliveTimeout(java.lang.Number originKeepaliveTimeout) {
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginReadTimeout}
             * @param originReadTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin.
             *                          This is also known as the <em>origin response timeout</em> . The minimum timeout is 1 second, the maximum is 60 seconds, and the default (if you don't specify otherwise) is 30 seconds.
             *                          <p>
             *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originReadTimeout(java.lang.Number originReadTimeout) {
                this.originReadTimeout = originReadTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginSslProtocols}
             * @param originSslProtocols Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
             *                           Valid values include <code>SSLv3</code> , <code>TLSv1</code> , <code>TLSv1.1</code> , and <code>TLSv1.2</code> .
             *                           <p>
             *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginSSLProtocols">Minimum Origin SSL Protocol</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSslProtocols(java.util.List<java.lang.String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomOriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomOriginConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomOriginConfigProperty {
            private final java.lang.String originProtocolPolicy;
            private final java.lang.Number httpPort;
            private final java.lang.Number httpsPort;
            private final java.lang.Number originKeepaliveTimeout;
            private final java.lang.Number originReadTimeout;
            private final java.util.List<java.lang.String> originSslProtocols;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originProtocolPolicy = software.amazon.jsii.Kernel.get(this, "originProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originKeepaliveTimeout = software.amazon.jsii.Kernel.get(this, "originKeepaliveTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originReadTimeout = software.amazon.jsii.Kernel.get(this, "originReadTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originProtocolPolicy = java.util.Objects.requireNonNull(builder.originProtocolPolicy, "originProtocolPolicy is required");
                this.httpPort = builder.httpPort;
                this.httpsPort = builder.httpsPort;
                this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
                this.originReadTimeout = builder.originReadTimeout;
                this.originSslProtocols = builder.originSslProtocols;
            }

            @Override
            public final java.lang.String getOriginProtocolPolicy() {
                return this.originProtocolPolicy;
            }

            @Override
            public final java.lang.Number getHttpPort() {
                return this.httpPort;
            }

            @Override
            public final java.lang.Number getHttpsPort() {
                return this.httpsPort;
            }

            @Override
            public final java.lang.Number getOriginKeepaliveTimeout() {
                return this.originKeepaliveTimeout;
            }

            @Override
            public final java.lang.Number getOriginReadTimeout() {
                return this.originReadTimeout;
            }

            @Override
            public final java.util.List<java.lang.String> getOriginSslProtocols() {
                return this.originSslProtocols;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
                if (this.getHttpPort() != null) {
                    data.set("httpPort", om.valueToTree(this.getHttpPort()));
                }
                if (this.getHttpsPort() != null) {
                    data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
                }
                if (this.getOriginKeepaliveTimeout() != null) {
                    data.set("originKeepaliveTimeout", om.valueToTree(this.getOriginKeepaliveTimeout()));
                }
                if (this.getOriginReadTimeout() != null) {
                    data.set("originReadTimeout", om.valueToTree(this.getOriginReadTimeout()));
                }
                if (this.getOriginSslProtocols() != null) {
                    data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomOriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomOriginConfigProperty.Jsii$Proxy that = (CustomOriginConfigProperty.Jsii$Proxy) o;

                if (!originProtocolPolicy.equals(that.originProtocolPolicy)) return false;
                if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
                if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
                if (this.originKeepaliveTimeout != null ? !this.originKeepaliveTimeout.equals(that.originKeepaliveTimeout) : that.originKeepaliveTimeout != null) return false;
                if (this.originReadTimeout != null ? !this.originReadTimeout.equals(that.originReadTimeout) : that.originReadTimeout != null) return false;
                return this.originSslProtocols != null ? this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols == null;
            }

            @Override
            public final int hashCode() {
                int result = this.originProtocolPolicy.hashCode();
                result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
                result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
                result = 31 * result + (this.originKeepaliveTimeout != null ? this.originKeepaliveTimeout.hashCode() : 0);
                result = 31 * result + (this.originReadTimeout != null ? this.originReadTimeout.hashCode() : 0);
                result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or if request URLs don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements.
     * <p>
     * You must create exactly one default cache behavior.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * DefaultCacheBehaviorProperty defaultCacheBehaviorProperty = DefaultCacheBehaviorProperty.builder()
     *         .targetOriginId("targetOriginId")
     *         .viewerProtocolPolicy("viewerProtocolPolicy")
     *         // the properties below are optional
     *         .allowedMethods(List.of("allowedMethods"))
     *         .cachedMethods(List.of("cachedMethods"))
     *         .cachePolicyId("cachePolicyId")
     *         .compress(false)
     *         .defaultTtl(123)
     *         .fieldLevelEncryptionId("fieldLevelEncryptionId")
     *         .forwardedValues(ForwardedValuesProperty.builder()
     *                 .queryString(false)
     *                 // the properties below are optional
     *                 .cookies(CookiesProperty.builder()
     *                         .forward("forward")
     *                         // the properties below are optional
     *                         .whitelistedNames(List.of("whitelistedNames"))
     *                         .build())
     *                 .headers(List.of("headers"))
     *                 .queryStringCacheKeys(List.of("queryStringCacheKeys"))
     *                 .build())
     *         .functionAssociations(List.of(FunctionAssociationProperty.builder()
     *                 .eventType("eventType")
     *                 .functionArn("functionArn")
     *                 .build()))
     *         .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
     *                 .eventType("eventType")
     *                 .includeBody(false)
     *                 .lambdaFunctionArn("lambdaFunctionArn")
     *                 .build()))
     *         .maxTtl(123)
     *         .minTtl(123)
     *         .originRequestPolicyId("originRequestPolicyId")
     *         .realtimeLogConfigArn("realtimeLogConfigArn")
     *         .responseHeadersPolicyId("responseHeadersPolicyId")
     *         .smoothStreaming(false)
     *         .trustedKeyGroups(List.of("trustedKeyGroups"))
     *         .trustedSigners(List.of("trustedSigners"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.DefaultCacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultCacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultCacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use the default cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-targetoriginid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-targetoriginid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code> .
         * <p>
         * You can specify the following options:
         * <p>
         * <ul>
         * <li><code>allow-all</code> : Viewers can use HTTP or HTTPS.</li>
         * <li><code>redirect-to-https</code> : If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.</li>
         * <li><code>https-only</code> : If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).</li>
         * </ul>
         * <p>
         * For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-viewerprotocolpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-viewerprotocolpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
         * <p>
         * There are three choices:
         * <p>
         * <ul>
         * <li>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</li>
         * <li>CloudFront forwards only <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
         * <li>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code> , and <code>DELETE</code> requests.</li>
         * </ul>
         * <p>
         * If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-allowedmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-allowedmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods.
         * <p>
         * There are two choices:
         * <p>
         * <ul>
         * <li>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</li>
         * <li>CloudFront caches responses to <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
         * </ul>
         * <p>
         * If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachedmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachedmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * The unique identifier of the cache policy that is attached to the default cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachepolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachepolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * Whether you want CloudFront to automatically compress certain files for this cache behavior.
         * <p>
         * If so, specify <code>true</code> ; if not, specify <code>false</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-compress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-compress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 86400
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-defaultttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-defaultttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-fieldlevelencryptionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-fieldlevelencryptionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
         * <p>
         * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-forwardedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-forwardedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * A list of CloudFront functions that are associated with this cache behavior.
         * <p>
         * Your functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-functionassociations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-functionassociations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionAssociations() {
            return null;
        }

        /**
         * A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-lambdafunctionassociations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-lambdafunctionassociations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - 31536000
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-maxttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-maxttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code> , if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code> ).
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-minttl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-minttl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * The unique identifier of the origin request policy that is attached to the default cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-originrequestpolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-originrequestpolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-realtimelogconfigarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-realtimelogconfigarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRealtimeLogConfigArn() {
            return null;
        }

        /**
         * The identifier for a response headers policy.
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-responseheaderspolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-responseheaderspolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponseHeadersPolicyId() {
            return null;
        }

        /**
         * Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
         * <p>
         * If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-smoothstreaming">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-smoothstreaming</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
         * <p>
         * When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedkeygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedkeygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedKeyGroups() {
            return null;
        }

        /**
         * <blockquote><p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code> .<p></blockquote>
         * <p>
         * A list of AWS account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
         * <p>
         * When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS account . The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedsigners">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedsigners</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultCacheBehaviorProperty> {
            java.lang.String targetOriginId;
            java.lang.String viewerProtocolPolicy;
            java.util.List<java.lang.String> allowedMethods;
            java.util.List<java.lang.String> cachedMethods;
            java.lang.String cachePolicyId;
            java.lang.Object compress;
            java.lang.Number defaultTtl;
            java.lang.String fieldLevelEncryptionId;
            java.lang.Object forwardedValues;
            java.lang.Object functionAssociations;
            java.lang.Object lambdaFunctionAssociations;
            java.lang.Number maxTtl;
            java.lang.Number minTtl;
            java.lang.String originRequestPolicyId;
            java.lang.String realtimeLogConfigArn;
            java.lang.String responseHeadersPolicyId;
            java.lang.Object smoothStreaming;
            java.util.List<java.lang.String> trustedKeyGroups;
            java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId The value of <code>ID</code> for the origin that you want CloudFront to route requests to when they use the default cache behavior. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy The protocol that viewers can use to access the files in the origin specified by <code>TargetOriginId</code> when a request matches the path pattern in <code>PathPattern</code> . This parameter is required.
             *                             You can specify the following options:
             *                             <p>
             *                             <ul>
             *                             <li><code>allow-all</code> : Viewers can use HTTP or HTTPS.</li>
             *                             <li><code>redirect-to-https</code> : If a viewer submits an HTTP request, CloudFront returns an HTTP status code of 301 (Moved Permanently) to the viewer along with the HTTPS URL. The viewer then resubmits the request using the new URL.</li>
             *                             <li><code>https-only</code> : If a viewer sends an HTTP request, CloudFront returns an HTTP status code of 403 (Forbidden).</li>
             *                             </ul>
             *                             <p>
             *                             For more information about requiring the HTTPS protocol, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-viewers-to-cloudfront.html">Requiring HTTPS Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             The only way to guarantee that viewers retrieve an object that was fetched from the origin using HTTPS is never to use any other protocol to fetch the object. If you have recently changed from HTTP to HTTPS, we recommend that you clear your objects' cache because cached objects are protocol agnostic. That means that an edge location will return an object from the cache regardless of whether the current request protocol matches the protocol used previously. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing Cache Expiration</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods A complex type that controls which HTTP methods CloudFront processes and forwards to your Amazon S3 bucket or your custom origin.
             *                       There are three choices:
             *                       <p>
             *                       <ul>
             *                       <li>CloudFront forwards only <code>GET</code> and <code>HEAD</code> requests.</li>
             *                       <li>CloudFront forwards only <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
             *                       <li>CloudFront forwards <code>GET, HEAD, OPTIONS, PUT, PATCH, POST</code> , and <code>DELETE</code> requests.</li>
             *                       </ul>
             *                       <p>
             *                       If you pick the third choice, you may need to restrict access to your Amazon S3 bucket or to your custom origin so users can't perform operations that you don't want them to. For example, you might not want users to have permissions to delete objects from your origin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods A complex type that controls whether CloudFront caches the response to requests using the specified HTTP methods.
             *                      There are two choices:
             *                      <p>
             *                      <ul>
             *                      <li>CloudFront caches responses to <code>GET</code> and <code>HEAD</code> requests.</li>
             *                      <li>CloudFront caches responses to <code>GET</code> , <code>HEAD</code> , and <code>OPTIONS</code> requests.</li>
             *                      </ul>
             *                      <p>
             *                      If you pick the second choice for your Amazon S3 Origin, you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers, and Origin headers for the responses to be cached correctly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId The unique identifier of the cache policy that is attached to the default cache behavior.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                      <p>
             *                      A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
             *                 If so, specify <code>true</code> ; if not, specify <code>false</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
             *                 If so, specify <code>true</code> ; if not, specify <code>false</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html">Serving Compressed Files</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl This field is deprecated.
             *                   We recommend that you use the <code>DefaultTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                   <p>
             *                   The default amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin does not add HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId The value of <code>ID</code> for the field-level encryption configuration that you want CloudFront to use for encrypting specific fields of data for the default cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues This field is deprecated.
             *                        We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             *                        <p>
             *                        A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues This field is deprecated.
             *                        We recommend that you use a cache policy or an origin request policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/working-with-policies.html">Working with policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                        <p>
             *                        A <code>DefaultCacheBehavior</code> must include either a <code>CachePolicyId</code> or <code>ForwardedValues</code> . We recommend that you use a <code>CachePolicyId</code> .
             *                        <p>
             *                        A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations A list of CloudFront functions that are associated with this cache behavior.
             *                             Your functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(software.amazon.awscdk.IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations A list of CloudFront functions that are associated with this cache behavior.
             *                             Your functions must be published to the <code>LIVE</code> stage to associate them with a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(java.util.List<? extends java.lang.Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations A complex type that contains zero or more Lambda&#64;Edge function associations for a cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<? extends java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMaxTtl}
             * @param maxTtl This field is deprecated.
             *               We recommend that you use the <code>MaxTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               The maximum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. The value that you specify applies only when your origin adds HTTP headers such as <code>Cache-Control max-age</code> , <code>Cache-Control s-maxage</code> , and <code>Expires</code> to objects. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMinTtl}
             * @param minTtl This field is deprecated.
             *               We recommend that you use the <code>MinTTL</code> field in a cache policy instead of this field. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html">Using the managed cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               The minimum amount of time that you want objects to stay in CloudFront caches before CloudFront forwards another request to your origin to determine whether the object has been updated. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Expiration.html">Managing How Long Content Stays in an Edge Cache (Expiration)</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *               <p>
             *               You must specify <code>0</code> for <code>MinTTL</code> if you configure CloudFront to forward all headers to your origin (under <code>Headers</code> , if you specify <code>1</code> for <code>Quantity</code> and <code>*</code> for <code>Name</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId The unique identifier of the origin request policy that is attached to the default cache behavior.
             *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> or <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-origin-request-policies.html">Using the managed origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getRealtimeLogConfigArn}
             * @param realtimeLogConfigArn The Amazon Resource Name (ARN) of the real-time log configuration that is attached to this cache behavior.
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeLogConfigArn(java.lang.String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getResponseHeadersPolicyId}
             * @param responseHeadersPolicyId The identifier for a response headers policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseHeadersPolicyId(java.lang.String responseHeadersPolicyId) {
                this.responseHeadersPolicyId = responseHeadersPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
             *                        If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming Indicates whether you want to distribute media files in the Microsoft Smooth Streaming format using the origin that is associated with this cache behavior.
             *                        If so, specify <code>true</code> ; if not, specify <code>false</code> . If you specify <code>true</code> for <code>SmoothStreaming</code> , you can still distribute other content using this cache behavior if the content matches the value of <code>PathPattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTrustedKeyGroups}
             * @param trustedKeyGroups A list of key groups that CloudFront can use to validate signed URLs or signed cookies.
             *                         When a cache behavior contains trusted key groups, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedKeyGroups(java.util.List<java.lang.String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners <blockquote><p>We recommend using <code>TrustedKeyGroups</code> instead of <code>TrustedSigners</code> .<p></blockquote>
             *                       A list of AWS account IDs whose public keys CloudFront can use to validate signed URLs or signed cookies.
             *                       <p>
             *                       When a cache behavior contains trusted signers, CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or cookies must be signed with the private key of a CloudFront key pair in a trusted signer's AWS account . The signed URL or cookie contains information about which public key CloudFront should use to verify the signature. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private content</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultCacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultCacheBehaviorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultCacheBehaviorProperty {
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object functionAssociations;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.String realtimeLogConfigArn;
            private final java.lang.String responseHeadersPolicyId;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedKeyGroups;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetOriginId = software.amazon.jsii.Kernel.get(this, "targetOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = software.amazon.jsii.Kernel.get(this, "cachePolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fieldLevelEncryptionId = software.amazon.jsii.Kernel.get(this, "fieldLevelEncryptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originRequestPolicyId = software.amazon.jsii.Kernel.get(this, "originRequestPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realtimeLogConfigArn = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseHeadersPolicyId = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetOriginId = java.util.Objects.requireNonNull(builder.targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(builder.viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = builder.allowedMethods;
                this.cachedMethods = builder.cachedMethods;
                this.cachePolicyId = builder.cachePolicyId;
                this.compress = builder.compress;
                this.defaultTtl = builder.defaultTtl;
                this.fieldLevelEncryptionId = builder.fieldLevelEncryptionId;
                this.forwardedValues = builder.forwardedValues;
                this.functionAssociations = builder.functionAssociations;
                this.lambdaFunctionAssociations = builder.lambdaFunctionAssociations;
                this.maxTtl = builder.maxTtl;
                this.minTtl = builder.minTtl;
                this.originRequestPolicyId = builder.originRequestPolicyId;
                this.realtimeLogConfigArn = builder.realtimeLogConfigArn;
                this.responseHeadersPolicyId = builder.responseHeadersPolicyId;
                this.smoothStreaming = builder.smoothStreaming;
                this.trustedKeyGroups = builder.trustedKeyGroups;
                this.trustedSigners = builder.trustedSigners;
            }

            @Override
            public final java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public final java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public final java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public final java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public final java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public final java.lang.Object getFunctionAssociations() {
                return this.functionAssociations;
            }

            @Override
            public final java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public final java.lang.String getRealtimeLogConfigArn() {
                return this.realtimeLogConfigArn;
            }

            @Override
            public final java.lang.String getResponseHeadersPolicyId() {
                return this.responseHeadersPolicyId;
            }

            @Override
            public final java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedKeyGroups() {
                return this.trustedKeyGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getFunctionAssociations() != null) {
                    data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getRealtimeLogConfigArn() != null) {
                    data.set("realtimeLogConfigArn", om.valueToTree(this.getRealtimeLogConfigArn()));
                }
                if (this.getResponseHeadersPolicyId() != null) {
                    data.set("responseHeadersPolicyId", om.valueToTree(this.getResponseHeadersPolicyId()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedKeyGroups() != null) {
                    data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.DefaultCacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultCacheBehaviorProperty.Jsii$Proxy that = (DefaultCacheBehaviorProperty.Jsii$Proxy) o;

                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.realtimeLogConfigArn != null ? !this.realtimeLogConfigArn.equals(that.realtimeLogConfigArn) : that.realtimeLogConfigArn != null) return false;
                if (this.responseHeadersPolicyId != null ? !this.responseHeadersPolicyId.equals(that.responseHeadersPolicyId) : that.responseHeadersPolicyId != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetOriginId.hashCode();
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.realtimeLogConfigArn != null ? this.realtimeLogConfigArn.hashCode() : 0);
                result = 31 * result + (this.responseHeadersPolicyId != null ? this.responseHeadersPolicyId.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A distribution configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * DistributionConfigProperty distributionConfigProperty = DistributionConfigProperty.builder()
     *         .defaultCacheBehavior(DefaultCacheBehaviorProperty.builder()
     *                 .targetOriginId("targetOriginId")
     *                 .viewerProtocolPolicy("viewerProtocolPolicy")
     *                 // the properties below are optional
     *                 .allowedMethods(List.of("allowedMethods"))
     *                 .cachedMethods(List.of("cachedMethods"))
     *                 .cachePolicyId("cachePolicyId")
     *                 .compress(false)
     *                 .defaultTtl(123)
     *                 .fieldLevelEncryptionId("fieldLevelEncryptionId")
     *                 .forwardedValues(ForwardedValuesProperty.builder()
     *                         .queryString(false)
     *                         // the properties below are optional
     *                         .cookies(CookiesProperty.builder()
     *                                 .forward("forward")
     *                                 // the properties below are optional
     *                                 .whitelistedNames(List.of("whitelistedNames"))
     *                                 .build())
     *                         .headers(List.of("headers"))
     *                         .queryStringCacheKeys(List.of("queryStringCacheKeys"))
     *                         .build())
     *                 .functionAssociations(List.of(FunctionAssociationProperty.builder()
     *                         .eventType("eventType")
     *                         .functionArn("functionArn")
     *                         .build()))
     *                 .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
     *                         .eventType("eventType")
     *                         .includeBody(false)
     *                         .lambdaFunctionArn("lambdaFunctionArn")
     *                         .build()))
     *                 .maxTtl(123)
     *                 .minTtl(123)
     *                 .originRequestPolicyId("originRequestPolicyId")
     *                 .realtimeLogConfigArn("realtimeLogConfigArn")
     *                 .responseHeadersPolicyId("responseHeadersPolicyId")
     *                 .smoothStreaming(false)
     *                 .trustedKeyGroups(List.of("trustedKeyGroups"))
     *                 .trustedSigners(List.of("trustedSigners"))
     *                 .build())
     *         .enabled(false)
     *         // the properties below are optional
     *         .aliases(List.of("aliases"))
     *         .cacheBehaviors(List.of(CacheBehaviorProperty.builder()
     *                 .pathPattern("pathPattern")
     *                 .targetOriginId("targetOriginId")
     *                 .viewerProtocolPolicy("viewerProtocolPolicy")
     *                 // the properties below are optional
     *                 .allowedMethods(List.of("allowedMethods"))
     *                 .cachedMethods(List.of("cachedMethods"))
     *                 .cachePolicyId("cachePolicyId")
     *                 .compress(false)
     *                 .defaultTtl(123)
     *                 .fieldLevelEncryptionId("fieldLevelEncryptionId")
     *                 .forwardedValues(ForwardedValuesProperty.builder()
     *                         .queryString(false)
     *                         // the properties below are optional
     *                         .cookies(CookiesProperty.builder()
     *                                 .forward("forward")
     *                                 // the properties below are optional
     *                                 .whitelistedNames(List.of("whitelistedNames"))
     *                                 .build())
     *                         .headers(List.of("headers"))
     *                         .queryStringCacheKeys(List.of("queryStringCacheKeys"))
     *                         .build())
     *                 .functionAssociations(List.of(FunctionAssociationProperty.builder()
     *                         .eventType("eventType")
     *                         .functionArn("functionArn")
     *                         .build()))
     *                 .lambdaFunctionAssociations(List.of(LambdaFunctionAssociationProperty.builder()
     *                         .eventType("eventType")
     *                         .includeBody(false)
     *                         .lambdaFunctionArn("lambdaFunctionArn")
     *                         .build()))
     *                 .maxTtl(123)
     *                 .minTtl(123)
     *                 .originRequestPolicyId("originRequestPolicyId")
     *                 .realtimeLogConfigArn("realtimeLogConfigArn")
     *                 .responseHeadersPolicyId("responseHeadersPolicyId")
     *                 .smoothStreaming(false)
     *                 .trustedKeyGroups(List.of("trustedKeyGroups"))
     *                 .trustedSigners(List.of("trustedSigners"))
     *                 .build()))
     *         .cnamEs(List.of("cnamEs"))
     *         .comment("comment")
     *         .continuousDeploymentPolicyId("continuousDeploymentPolicyId")
     *         .customErrorResponses(List.of(CustomErrorResponseProperty.builder()
     *                 .errorCode(123)
     *                 // the properties below are optional
     *                 .errorCachingMinTtl(123)
     *                 .responseCode(123)
     *                 .responsePagePath("responsePagePath")
     *                 .build()))
     *         .customOrigin(LegacyCustomOriginProperty.builder()
     *                 .dnsName("dnsName")
     *                 .originProtocolPolicy("originProtocolPolicy")
     *                 .originSslProtocols(List.of("originSslProtocols"))
     *                 // the properties below are optional
     *                 .httpPort(123)
     *                 .httpsPort(123)
     *                 .build())
     *         .defaultRootObject("defaultRootObject")
     *         .httpVersion("httpVersion")
     *         .ipv6Enabled(false)
     *         .logging(LoggingProperty.builder()
     *                 .bucket("bucket")
     *                 // the properties below are optional
     *                 .includeCookies(false)
     *                 .prefix("prefix")
     *                 .build())
     *         .originGroups(OriginGroupsProperty.builder()
     *                 .quantity(123)
     *                 // the properties below are optional
     *                 .items(List.of(OriginGroupProperty.builder()
     *                         .failoverCriteria(OriginGroupFailoverCriteriaProperty.builder()
     *                                 .statusCodes(StatusCodesProperty.builder()
     *                                         .items(List.of(123))
     *                                         .quantity(123)
     *                                         .build())
     *                                 .build())
     *                         .id("id")
     *                         .members(OriginGroupMembersProperty.builder()
     *                                 .items(List.of(OriginGroupMemberProperty.builder()
     *                                         .originId("originId")
     *                                         .build()))
     *                                 .quantity(123)
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .origins(List.of(OriginProperty.builder()
     *                 .domainName("domainName")
     *                 .id("id")
     *                 // the properties below are optional
     *                 .connectionAttempts(123)
     *                 .connectionTimeout(123)
     *                 .customOriginConfig(CustomOriginConfigProperty.builder()
     *                         .originProtocolPolicy("originProtocolPolicy")
     *                         // the properties below are optional
     *                         .httpPort(123)
     *                         .httpsPort(123)
     *                         .originKeepaliveTimeout(123)
     *                         .originReadTimeout(123)
     *                         .originSslProtocols(List.of("originSslProtocols"))
     *                         .build())
     *                 .originAccessControlId("originAccessControlId")
     *                 .originCustomHeaders(List.of(OriginCustomHeaderProperty.builder()
     *                         .headerName("headerName")
     *                         .headerValue("headerValue")
     *                         .build()))
     *                 .originPath("originPath")
     *                 .originShield(OriginShieldProperty.builder()
     *                         .enabled(false)
     *                         .originShieldRegion("originShieldRegion")
     *                         .build())
     *                 .s3OriginConfig(S3OriginConfigProperty.builder()
     *                         .originAccessIdentity("originAccessIdentity")
     *                         .build())
     *                 .build()))
     *         .priceClass("priceClass")
     *         .restrictions(RestrictionsProperty.builder()
     *                 .geoRestriction(GeoRestrictionProperty.builder()
     *                         .restrictionType("restrictionType")
     *                         // the properties below are optional
     *                         .locations(List.of("locations"))
     *                         .build())
     *                 .build())
     *         .s3Origin(LegacyS3OriginProperty.builder()
     *                 .dnsName("dnsName")
     *                 // the properties below are optional
     *                 .originAccessIdentity("originAccessIdentity")
     *                 .build())
     *         .staging(false)
     *         .viewerCertificate(ViewerCertificateProperty.builder()
     *                 .acmCertificateArn("acmCertificateArn")
     *                 .cloudFrontDefaultCertificate(false)
     *                 .iamCertificateId("iamCertificateId")
     *                 .minimumProtocolVersion("minimumProtocolVersion")
     *                 .sslSupportMethod("sslSupportMethod")
     *                 .build())
     *         .webAclId("webAclId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.DistributionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DistributionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DistributionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements.
         * <p>
         * You must create exactly one default cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultcachebehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultcachebehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDefaultCacheBehavior();

        /**
         * From this field, you can enable or disable the selected distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cachebehaviors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cachebehaviors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviors() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCnamEs() {
            return null;
        }

        /**
         * A comment to describe the distribution.
         * <p>
         * The comment cannot be longer than 128 characters.
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * The identifier of a continuous deployment policy.
         * <p>
         * For more information, see <code>CreateContinuousDeploymentPolicy</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-continuousdeploymentpolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-continuousdeploymentpolicyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContinuousDeploymentPolicyId() {
            return null;
        }

        /**
         * A complex type that controls the following:.
         * <p>
         * <ul>
         * <li>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</li>
         * <li>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</li>
         * </ul>
         * <p>
         * For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customerrorresponses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customerrorresponses</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomErrorResponses() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customorigin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customorigin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOrigin() {
            return null;
        }

        /**
         * The object that you want CloudFront to request from your origin (for example, <code>index.html</code> ) when a viewer requests the root URL for your distribution ( <code>https://www.example.com</code> ) instead of an object in your distribution ( <code>https://www.example.com/product-description.html</code> ). Specifying a default root object avoids exposing the contents of your distribution.
         * <p>
         * Specify only the object name, for example, <code>index.html</code> . Don't add a <code>/</code> before the object name.
         * <p>
         * If you don't want to specify a default root object when you create a distribution, include an empty <code>DefaultRootObject</code> element.
         * <p>
         * To delete the default root object from an existing distribution, update the distribution configuration and include an empty <code>DefaultRootObject</code> element.
         * <p>
         * To replace the default root object, update the distribution configuration and specify the new object.
         * <p>
         * For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultrootobject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultrootobject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootObject() {
            return null;
        }

        /**
         * (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CloudFront .
         * <p>
         * The default value for new distributions is <code>http1.1</code> .
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
         * <p>
         * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see <a href="https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html">Supported protocols and ciphers between viewers and CloudFront</a> .
         * <p>
         * Default: - "http1.1"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-httpversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-httpversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpVersion() {
            return null;
        }

        /**
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify <code>true</code> .
         * <p>
         * If you specify <code>false</code> , CloudFront responds to IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
         * <p>
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you're using an Amazon Route 53 AWS Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
         * <p>
         * <ul>
         * <li>You enable IPv6 for the distribution</li>
         * <li>You're using alternate domain names in the URLs for your objects</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <em>Amazon Route 53 AWS Integration Developer Guide</em> .
         * <p>
         * If you created a CNAME resource record set, either with Amazon Route 53 AWS Integration or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-ipv6enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-ipv6enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Enabled() {
            return null;
        }

        /**
         * A complex type that controls whether access logs are written for the distribution.
         * <p>
         * For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-logging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * A complex type that contains information about origin groups for this distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origingroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origingroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginGroups() {
            return null;
        }

        /**
         * A complex type that contains information about origins for this distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origins</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrigins() {
            return null;
        }

        /**
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         * <p>
         * If you specify <code>PriceClass_All</code> , CloudFront responds to requests for your objects from all CloudFront edge locations.
         * <p>
         * If you specify a price class other than <code>PriceClass_All</code> , CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
         * <p>
         * For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class for a CloudFront Distribution</a> in the <em>Amazon CloudFront Developer Guide</em> . For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see <a href="https://docs.aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a> .
         * <p>
         * Default: - "PriceClass_All"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-priceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-priceclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPriceClass() {
            return null;
        }

        /**
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictions() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-s3origin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-s3origin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Origin() {
            return null;
        }

        /**
         * A Boolean that indicates whether this is a staging distribution.
         * <p>
         * When this value is <code>true</code> , this is a staging distribution. When this value is <code>false</code> , this is not a staging distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-staging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-staging</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaging() {
            return null;
        }

        /**
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-viewercertificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-viewercertificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getViewerCertificate() {
            return null;
        }

        /**
         * A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
         * <p>
         * To specify a web ACL created using the latest version of AWS WAF , use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> .
         * <p>
         * AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about AWS WAF , see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer Guide</a> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-webaclid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-webaclid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebAclId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DistributionConfigProperty> {
            java.lang.Object defaultCacheBehavior;
            java.lang.Object enabled;
            java.util.List<java.lang.String> aliases;
            java.lang.Object cacheBehaviors;
            java.util.List<java.lang.String> cnamEs;
            java.lang.String comment;
            java.lang.String continuousDeploymentPolicyId;
            java.lang.Object customErrorResponses;
            java.lang.Object customOrigin;
            java.lang.String defaultRootObject;
            java.lang.String httpVersion;
            java.lang.Object ipv6Enabled;
            java.lang.Object logging;
            java.lang.Object originGroups;
            java.lang.Object origins;
            java.lang.String priceClass;
            java.lang.Object restrictions;
            java.lang.Object s3Origin;
            java.lang.Object staging;
            java.lang.Object viewerCertificate;
            java.lang.String webAclId;

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. This parameter is required.
             *                             You must create exactly one default cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.IResolvable defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code> elements. This parameter is required.
             *                             You must create exactly one default cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.services.cloudfront.CfnDistribution.DefaultCacheBehaviorProperty defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled From this field, you can enable or disable the selected distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled From this field, you can enable or disable the selected distribution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getAliases}
             * @param aliases A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors A complex type that contains zero or more <code>CacheBehavior</code> elements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(software.amazon.awscdk.IResolvable cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors A complex type that contains zero or more <code>CacheBehavior</code> elements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(java.util.List<? extends java.lang.Object> cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCnamEs}
             * @param cnamEs the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cnamEs(java.util.List<java.lang.String> cnamEs) {
                this.cnamEs = cnamEs;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getComment}
             * @param comment A comment to describe the distribution.
             *                The comment cannot be longer than 128 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getContinuousDeploymentPolicyId}
             * @param continuousDeploymentPolicyId The identifier of a continuous deployment policy.
             *                                     For more information, see <code>CreateContinuousDeploymentPolicy</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder continuousDeploymentPolicyId(java.lang.String continuousDeploymentPolicyId) {
                this.continuousDeploymentPolicyId = continuousDeploymentPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses A complex type that controls the following:.
             *                             <ul>
             *                             <li>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</li>
             *                             <li>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</li>
             *                             </ul>
             *                             <p>
             *                             For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(software.amazon.awscdk.IResolvable customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses A complex type that controls the following:.
             *                             <ul>
             *                             <li>Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before returning the response to the viewer.</li>
             *                             <li>How long CloudFront caches HTTP status codes in the 4xx and 5xx range.</li>
             *                             </ul>
             *                             <p>
             *                             For more information about custom error pages, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing Error Responses</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(java.util.List<? extends java.lang.Object> customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomOrigin}
             * @param customOrigin the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOrigin(software.amazon.awscdk.IResolvable customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomOrigin}
             * @param customOrigin the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOrigin(software.amazon.awscdk.services.cloudfront.CfnDistribution.LegacyCustomOriginProperty customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultRootObject}
             * @param defaultRootObject The object that you want CloudFront to request from your origin (for example, <code>index.html</code> ) when a viewer requests the root URL for your distribution ( <code>https://www.example.com</code> ) instead of an object in your distribution ( <code>https://www.example.com/product-description.html</code> ). Specifying a default root object avoids exposing the contents of your distribution.
             *                          Specify only the object name, for example, <code>index.html</code> . Don't add a <code>/</code> before the object name.
             *                          <p>
             *                          If you don't want to specify a default root object when you create a distribution, include an empty <code>DefaultRootObject</code> element.
             *                          <p>
             *                          To delete the default root object from an existing distribution, update the distribution configuration and include an empty <code>DefaultRootObject</code> element.
             *                          <p>
             *                          To replace the default root object, update the distribution configuration and specify the new object.
             *                          <p>
             *                          For more information about the default root object, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a Default Root Object</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRootObject(java.lang.String defaultRootObject) {
                this.defaultRootObject = defaultRootObject;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getHttpVersion}
             * @param httpVersion (Optional) Specify the maximum HTTP version(s) that you want viewers to use to communicate with CloudFront .
             *                    The default value for new distributions is <code>http1.1</code> .
             *                    <p>
             *                    For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name Indication (SNI).
             *                    <p>
             *                    For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection. For more information about connection migration, see <a href="https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html">Supported protocols and ciphers between viewers and CloudFront</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpVersion(java.lang.String httpVersion) {
                this.httpVersion = httpVersion;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify <code>true</code> .
             *                    If you specify <code>false</code> , CloudFront responds to IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
             *                    <p>
             *                    In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    If you're using an Amazon Route 53 AWS Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
             *                    <p>
             *                    <ul>
             *                    <li>You enable IPv6 for the distribution</li>
             *                    <li>You're using alternate domain names in the URLs for your objects</li>
             *                    </ul>
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <em>Amazon Route 53 AWS Integration Developer Guide</em> .
             *                    <p>
             *                    If you created a CNAME resource record set, either with Amazon Route 53 AWS Integration or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(java.lang.Boolean ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify <code>true</code> .
             *                    If you specify <code>false</code> , CloudFront responds to IPv6 DNS requests with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for an IPv4 address for your distribution.
             *                    <p>
             *                    In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access to other content (or restrict access but not by IP address), you can create two distributions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html">Creating a Signed URL Using a Custom Policy</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    If you're using an Amazon Route 53 AWS Integration alias resource record set to route traffic to your CloudFront distribution, you need to create a second alias resource record set when both of the following are true:
             *                    <p>
             *                    <ul>
             *                    <li>You enable IPv6 for the distribution</li>
             *                    <li>You're using alternate domain names in the URLs for your objects</li>
             *                    </ul>
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <em>Amazon Route 53 AWS Integration Developer Guide</em> .
             *                    <p>
             *                    If you created a CNAME resource record set, either with Amazon Route 53 AWS Integration or with another DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution regardless of the IP address format of the viewer request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(software.amazon.awscdk.IResolvable ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging A complex type that controls whether access logs are written for the distribution.
             *                For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging A complex type that controls whether access logs are written for the distribution.
             *                For more information about logging, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.cloudfront.CfnDistribution.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups A complex type that contains information about origin groups for this distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.IResolvable originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups A complex type that contains information about origin groups for this distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupsProperty originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins A complex type that contains information about origins for this distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(software.amazon.awscdk.IResolvable origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins A complex type that contains information about origins for this distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(java.util.List<? extends java.lang.Object> origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getPriceClass}
             * @param priceClass The price class that corresponds with the maximum price that you want to pay for CloudFront service.
             *                   If you specify <code>PriceClass_All</code> , CloudFront responds to requests for your objects from all CloudFront edge locations.
             *                   <p>
             *                   If you specify a price class other than <code>PriceClass_All</code> , CloudFront serves your objects from the CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who are in or near regions that are excluded from your specified price class may encounter slower performance.
             *                   <p>
             *                   For more information about price classes, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price Class for a CloudFront Distribution</a> in the <em>Amazon CloudFront Developer Guide</em> . For information about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see <a href="https://docs.aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priceClass(java.lang.String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions A complex type that identifies ways in which you want to restrict distribution of your content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions A complex type that identifies ways in which you want to restrict distribution of your content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.cloudfront.CfnDistribution.RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getS3Origin}
             * @param s3Origin the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getS3Origin}
             * @param s3Origin the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.services.cloudfront.CfnDistribution.LegacyS3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getStaging}
             * @param staging A Boolean that indicates whether this is a staging distribution.
             *                When this value is <code>true</code> , this is a staging distribution. When this value is <code>false</code> , this is not a staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staging(java.lang.Boolean staging) {
                this.staging = staging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getStaging}
             * @param staging A Boolean that indicates whether this is a staging distribution.
             *                When this value is <code>true</code> , this is a staging distribution. When this value is <code>false</code> , this is not a staging distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staging(software.amazon.awscdk.IResolvable staging) {
                this.staging = staging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.IResolvable viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.services.cloudfront.CfnDistribution.ViewerCertificateProperty viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getWebAclId}
             * @param webAclId A unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution.
             *                 To specify a web ACL created using the latest version of AWS WAF , use the ACL ARN, for example <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> .
             *                 <p>
             *                 AWS WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, CloudFront responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to return a custom error page when a request is blocked. For more information about AWS WAF , see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">AWS WAF Developer Guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webAclId(java.lang.String webAclId) {
                this.webAclId = webAclId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DistributionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DistributionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionConfigProperty {
            private final java.lang.Object defaultCacheBehavior;
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object cacheBehaviors;
            private final java.util.List<java.lang.String> cnamEs;
            private final java.lang.String comment;
            private final java.lang.String continuousDeploymentPolicyId;
            private final java.lang.Object customErrorResponses;
            private final java.lang.Object customOrigin;
            private final java.lang.String defaultRootObject;
            private final java.lang.String httpVersion;
            private final java.lang.Object ipv6Enabled;
            private final java.lang.Object logging;
            private final java.lang.Object originGroups;
            private final java.lang.Object origins;
            private final java.lang.String priceClass;
            private final java.lang.Object restrictions;
            private final java.lang.Object s3Origin;
            private final java.lang.Object staging;
            private final java.lang.Object viewerCertificate;
            private final java.lang.String webAclId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultCacheBehavior = software.amazon.jsii.Kernel.get(this, "defaultCacheBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheBehaviors = software.amazon.jsii.Kernel.get(this, "cacheBehaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cnamEs = software.amazon.jsii.Kernel.get(this, "cnamEs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.continuousDeploymentPolicyId = software.amazon.jsii.Kernel.get(this, "continuousDeploymentPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customErrorResponses = software.amazon.jsii.Kernel.get(this, "customErrorResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customOrigin = software.amazon.jsii.Kernel.get(this, "customOrigin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultRootObject = software.amazon.jsii.Kernel.get(this, "defaultRootObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpVersion = software.amazon.jsii.Kernel.get(this, "httpVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipv6Enabled = software.amazon.jsii.Kernel.get(this, "ipv6Enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originGroups = software.amazon.jsii.Kernel.get(this, "originGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.origins = software.amazon.jsii.Kernel.get(this, "origins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priceClass = software.amazon.jsii.Kernel.get(this, "priceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.restrictions = software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Origin = software.amazon.jsii.Kernel.get(this, "s3Origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.staging = software.amazon.jsii.Kernel.get(this, "staging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.viewerCertificate = software.amazon.jsii.Kernel.get(this, "viewerCertificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webAclId = software.amazon.jsii.Kernel.get(this, "webAclId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultCacheBehavior = java.util.Objects.requireNonNull(builder.defaultCacheBehavior, "defaultCacheBehavior is required");
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.aliases = builder.aliases;
                this.cacheBehaviors = builder.cacheBehaviors;
                this.cnamEs = builder.cnamEs;
                this.comment = builder.comment;
                this.continuousDeploymentPolicyId = builder.continuousDeploymentPolicyId;
                this.customErrorResponses = builder.customErrorResponses;
                this.customOrigin = builder.customOrigin;
                this.defaultRootObject = builder.defaultRootObject;
                this.httpVersion = builder.httpVersion;
                this.ipv6Enabled = builder.ipv6Enabled;
                this.logging = builder.logging;
                this.originGroups = builder.originGroups;
                this.origins = builder.origins;
                this.priceClass = builder.priceClass;
                this.restrictions = builder.restrictions;
                this.s3Origin = builder.s3Origin;
                this.staging = builder.staging;
                this.viewerCertificate = builder.viewerCertificate;
                this.webAclId = builder.webAclId;
            }

            @Override
            public final java.lang.Object getDefaultCacheBehavior() {
                return this.defaultCacheBehavior;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Object getCacheBehaviors() {
                return this.cacheBehaviors;
            }

            @Override
            public final java.util.List<java.lang.String> getCnamEs() {
                return this.cnamEs;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.String getContinuousDeploymentPolicyId() {
                return this.continuousDeploymentPolicyId;
            }

            @Override
            public final java.lang.Object getCustomErrorResponses() {
                return this.customErrorResponses;
            }

            @Override
            public final java.lang.Object getCustomOrigin() {
                return this.customOrigin;
            }

            @Override
            public final java.lang.String getDefaultRootObject() {
                return this.defaultRootObject;
            }

            @Override
            public final java.lang.String getHttpVersion() {
                return this.httpVersion;
            }

            @Override
            public final java.lang.Object getIpv6Enabled() {
                return this.ipv6Enabled;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public final java.lang.Object getOriginGroups() {
                return this.originGroups;
            }

            @Override
            public final java.lang.Object getOrigins() {
                return this.origins;
            }

            @Override
            public final java.lang.String getPriceClass() {
                return this.priceClass;
            }

            @Override
            public final java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            public final java.lang.Object getS3Origin() {
                return this.s3Origin;
            }

            @Override
            public final java.lang.Object getStaging() {
                return this.staging;
            }

            @Override
            public final java.lang.Object getViewerCertificate() {
                return this.viewerCertificate;
            }

            @Override
            public final java.lang.String getWebAclId() {
                return this.webAclId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultCacheBehavior", om.valueToTree(this.getDefaultCacheBehavior()));
                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getCacheBehaviors() != null) {
                    data.set("cacheBehaviors", om.valueToTree(this.getCacheBehaviors()));
                }
                if (this.getCnamEs() != null) {
                    data.set("cnamEs", om.valueToTree(this.getCnamEs()));
                }
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getContinuousDeploymentPolicyId() != null) {
                    data.set("continuousDeploymentPolicyId", om.valueToTree(this.getContinuousDeploymentPolicyId()));
                }
                if (this.getCustomErrorResponses() != null) {
                    data.set("customErrorResponses", om.valueToTree(this.getCustomErrorResponses()));
                }
                if (this.getCustomOrigin() != null) {
                    data.set("customOrigin", om.valueToTree(this.getCustomOrigin()));
                }
                if (this.getDefaultRootObject() != null) {
                    data.set("defaultRootObject", om.valueToTree(this.getDefaultRootObject()));
                }
                if (this.getHttpVersion() != null) {
                    data.set("httpVersion", om.valueToTree(this.getHttpVersion()));
                }
                if (this.getIpv6Enabled() != null) {
                    data.set("ipv6Enabled", om.valueToTree(this.getIpv6Enabled()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getOriginGroups() != null) {
                    data.set("originGroups", om.valueToTree(this.getOriginGroups()));
                }
                if (this.getOrigins() != null) {
                    data.set("origins", om.valueToTree(this.getOrigins()));
                }
                if (this.getPriceClass() != null) {
                    data.set("priceClass", om.valueToTree(this.getPriceClass()));
                }
                if (this.getRestrictions() != null) {
                    data.set("restrictions", om.valueToTree(this.getRestrictions()));
                }
                if (this.getS3Origin() != null) {
                    data.set("s3Origin", om.valueToTree(this.getS3Origin()));
                }
                if (this.getStaging() != null) {
                    data.set("staging", om.valueToTree(this.getStaging()));
                }
                if (this.getViewerCertificate() != null) {
                    data.set("viewerCertificate", om.valueToTree(this.getViewerCertificate()));
                }
                if (this.getWebAclId() != null) {
                    data.set("webAclId", om.valueToTree(this.getWebAclId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.DistributionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DistributionConfigProperty.Jsii$Proxy that = (DistributionConfigProperty.Jsii$Proxy) o;

                if (!defaultCacheBehavior.equals(that.defaultCacheBehavior)) return false;
                if (!enabled.equals(that.enabled)) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.cacheBehaviors != null ? !this.cacheBehaviors.equals(that.cacheBehaviors) : that.cacheBehaviors != null) return false;
                if (this.cnamEs != null ? !this.cnamEs.equals(that.cnamEs) : that.cnamEs != null) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.continuousDeploymentPolicyId != null ? !this.continuousDeploymentPolicyId.equals(that.continuousDeploymentPolicyId) : that.continuousDeploymentPolicyId != null) return false;
                if (this.customErrorResponses != null ? !this.customErrorResponses.equals(that.customErrorResponses) : that.customErrorResponses != null) return false;
                if (this.customOrigin != null ? !this.customOrigin.equals(that.customOrigin) : that.customOrigin != null) return false;
                if (this.defaultRootObject != null ? !this.defaultRootObject.equals(that.defaultRootObject) : that.defaultRootObject != null) return false;
                if (this.httpVersion != null ? !this.httpVersion.equals(that.httpVersion) : that.httpVersion != null) return false;
                if (this.ipv6Enabled != null ? !this.ipv6Enabled.equals(that.ipv6Enabled) : that.ipv6Enabled != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                if (this.originGroups != null ? !this.originGroups.equals(that.originGroups) : that.originGroups != null) return false;
                if (this.origins != null ? !this.origins.equals(that.origins) : that.origins != null) return false;
                if (this.priceClass != null ? !this.priceClass.equals(that.priceClass) : that.priceClass != null) return false;
                if (this.restrictions != null ? !this.restrictions.equals(that.restrictions) : that.restrictions != null) return false;
                if (this.s3Origin != null ? !this.s3Origin.equals(that.s3Origin) : that.s3Origin != null) return false;
                if (this.staging != null ? !this.staging.equals(that.staging) : that.staging != null) return false;
                if (this.viewerCertificate != null ? !this.viewerCertificate.equals(that.viewerCertificate) : that.viewerCertificate != null) return false;
                return this.webAclId != null ? this.webAclId.equals(that.webAclId) : that.webAclId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultCacheBehavior.hashCode();
                result = 31 * result + (this.enabled.hashCode());
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.cacheBehaviors != null ? this.cacheBehaviors.hashCode() : 0);
                result = 31 * result + (this.cnamEs != null ? this.cnamEs.hashCode() : 0);
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.continuousDeploymentPolicyId != null ? this.continuousDeploymentPolicyId.hashCode() : 0);
                result = 31 * result + (this.customErrorResponses != null ? this.customErrorResponses.hashCode() : 0);
                result = 31 * result + (this.customOrigin != null ? this.customOrigin.hashCode() : 0);
                result = 31 * result + (this.defaultRootObject != null ? this.defaultRootObject.hashCode() : 0);
                result = 31 * result + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
                result = 31 * result + (this.ipv6Enabled != null ? this.ipv6Enabled.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.originGroups != null ? this.originGroups.hashCode() : 0);
                result = 31 * result + (this.origins != null ? this.origins.hashCode() : 0);
                result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
                result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
                result = 31 * result + (this.s3Origin != null ? this.s3Origin.hashCode() : 0);
                result = 31 * result + (this.staging != null ? this.staging.hashCode() : 0);
                result = 31 * result + (this.viewerCertificate != null ? this.viewerCertificate.hashCode() : 0);
                result = 31 * result + (this.webAclId != null ? this.webAclId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This field is deprecated.
     * <p>
     * We recommend that you use a cache policy or an origin request policy instead of this field.
     * <p>
     * If you want to include values in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * If you want to send values to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * A complex type that specifies how CloudFront handles query strings, cookies, and HTTP headers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ForwardedValuesProperty forwardedValuesProperty = ForwardedValuesProperty.builder()
     *         .queryString(false)
     *         // the properties below are optional
     *         .cookies(CookiesProperty.builder()
     *                 .forward("forward")
     *                 // the properties below are optional
     *                 .whitelistedNames(List.of("whitelistedNames"))
     *                 .build())
     *         .headers(List.of("headers"))
     *         .queryStringCacheKeys(List.of("queryStringCacheKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.ForwardedValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardedValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardedValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code> , if any:
         * <p>
         * If you specify true for <code>QueryString</code> and you don't specify any values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
         * <p>
         * If you specify true for <code>QueryString</code> and you specify one or more values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
         * <p>
         * If you specify false for <code>QueryString</code> , CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryString();

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-cookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-cookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookies() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include headers in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A complex type that specifies the <code>Headers</code> , if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">Caching Content Based on Request Headers</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * This field is deprecated.
         * <p>
         * We recommend that you use a cache policy or an origin request policy instead of this field.
         * <p>
         * If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystringcachekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystringcachekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStringCacheKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardedValuesProperty> {
            java.lang.Object queryString;
            java.lang.Object cookies;
            java.util.List<java.lang.String> headers;
            java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString This field is deprecated. This parameter is required.
             *                    We recommend that you use a cache policy or an origin request policy instead of this field.
             *                    <p>
             *                    If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code> , if any:
             *                    <p>
             *                    If you specify true for <code>QueryString</code> and you don't specify any values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
             *                    <p>
             *                    If you specify true for <code>QueryString</code> and you specify one or more values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
             *                    <p>
             *                    If you specify false for <code>QueryString</code> , CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Boolean queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString This field is deprecated. This parameter is required.
             *                    We recommend that you use a cache policy or an origin request policy instead of this field.
             *                    <p>
             *                    If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                    <p>
             *                    Indicates whether you want CloudFront to forward query strings to the origin that is associated with this cache behavior and cache based on the query string parameters. CloudFront behavior depends on the value of <code>QueryString</code> and on the values that you specify for <code>QueryStringCacheKeys</code> , if any:
             *                    <p>
             *                    If you specify true for <code>QueryString</code> and you don't specify any values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin and caches based on all query string parameters. Depending on how many query string parameters and values you have, this can adversely affect performance because CloudFront must forward more requests to the origin.
             *                    <p>
             *                    If you specify true for <code>QueryString</code> and you specify one or more values for <code>QueryStringCacheKeys</code> , CloudFront forwards all query string parameters to the origin, but it only caches based on the query string parameters that you specify.
             *                    <p>
             *                    If you specify false for <code>QueryString</code> , CloudFront doesn't forward any query string parameters to the origin, and doesn't cache based on query string parameters.
             *                    <p>
             *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/QueryStringParameters.html">Configuring CloudFront to Cache Based on Query String Parameters</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(software.amazon.awscdk.IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies This field is deprecated.
             *                We recommend that you use a cache policy or an origin request policy instead of this field.
             *                <p>
             *                If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies This field is deprecated.
             *                We recommend that you use a cache policy or an origin request policy instead of this field.
             *                <p>
             *                If you want to include cookies in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                If you want to send cookies to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones. For more information about forwarding cookies to the origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">How CloudFront Forwards, Caches, and Logs Cookies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.services.cloudfront.CfnDistribution.CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getHeaders}
             * @param headers This field is deprecated.
             *                We recommend that you use a cache policy or an origin request policy instead of this field.
             *                <p>
             *                If you want to include headers in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                If you want to send headers to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                <p>
             *                A complex type that specifies the <code>Headers</code> , if any, that you want CloudFront to forward to the origin for this cache behavior (whitelisted headers). For the headers that you specify, CloudFront also caches separate versions of a specified object that is based on the header values in viewer requests.
             *                <p>
             *                For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/header-caching.html">Caching Content Based on Request Headers</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryStringCacheKeys}
             * @param queryStringCacheKeys This field is deprecated.
             *                             We recommend that you use a cache policy or an origin request policy instead of this field.
             *                             <p>
             *                             If you want to include query strings in the cache key, use a cache policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy">Creating cache policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             If you want to send query strings to the origin but not include them in the cache key, use an origin request policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy">Creating origin request policies</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             A complex type that contains information about the query string parameters that you want CloudFront to use for caching for this cache behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringCacheKeys(java.util.List<java.lang.String> queryStringCacheKeys) {
                this.queryStringCacheKeys = queryStringCacheKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardedValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardedValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardedValuesProperty {
            private final java.lang.Object queryString;
            private final java.lang.Object cookies;
            private final java.util.List<java.lang.String> headers;
            private final java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringCacheKeys = software.amazon.jsii.Kernel.get(this, "queryStringCacheKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
                this.cookies = builder.cookies;
                this.headers = builder.headers;
                this.queryStringCacheKeys = builder.queryStringCacheKeys;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getCookies() {
                return this.cookies;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStringCacheKeys() {
                return this.queryStringCacheKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryString", om.valueToTree(this.getQueryString()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getQueryStringCacheKeys() != null) {
                    data.set("queryStringCacheKeys", om.valueToTree(this.getQueryStringCacheKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.ForwardedValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardedValuesProperty.Jsii$Proxy that = (ForwardedValuesProperty.Jsii$Proxy) o;

                if (!queryString.equals(that.queryString)) return false;
                if (this.cookies != null ? !this.cookies.equals(that.cookies) : that.cookies != null) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                return this.queryStringCacheKeys != null ? this.queryStringCacheKeys.equals(that.queryStringCacheKeys) : that.queryStringCacheKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryString.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.queryStringCacheKeys != null ? this.queryStringCacheKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * FunctionAssociationProperty functionAssociationProperty = FunctionAssociationProperty.builder()
     *         .eventType("eventType")
     *         .functionArn("functionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.FunctionAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code> .
         * <p>
         * You cannot use origin-facing event types ( <code>origin-request</code> and <code>origin-response</code> ) with a CloudFront function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html#cfn-cloudfront-distribution-functionassociation-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html#cfn-cloudfront-distribution-functionassociation-eventtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html#cfn-cloudfront-distribution-functionassociation-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-functionassociation.html#cfn-cloudfront-distribution-functionassociation-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionAssociationProperty> {
            java.lang.String eventType;
            java.lang.String functionArn;

            /**
             * Sets the value of {@link FunctionAssociationProperty#getEventType}
             * @param eventType The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code> .
             *                  You cannot use origin-facing event types ( <code>origin-request</code> and <code>origin-response</code> ) with a CloudFront function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link FunctionAssociationProperty#getFunctionArn}
             * @param functionArn The Amazon Resource Name (ARN) of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionAssociationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionAssociationProperty {
            private final java.lang.String eventType;
            private final java.lang.String functionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = builder.eventType;
                this.functionArn = builder.functionArn;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getFunctionArn() != null) {
                    data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.FunctionAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionAssociationProperty.Jsii$Proxy that = (FunctionAssociationProperty.Jsii$Proxy) o;

                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                return this.functionArn != null ? this.functionArn.equals(that.functionArn) : that.functionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType != null ? this.eventType.hashCode() : 0;
                result = 31 * result + (this.functionArn != null ? this.functionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that controls the countries in which your content is distributed.
     * <p>
     * CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases. To disable geo restriction, remove the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions">Restrictions</a> property from your stack template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * GeoRestrictionProperty geoRestrictionProperty = GeoRestrictionProperty.builder()
     *         .restrictionType("restrictionType")
     *         // the properties below are optional
     *         .locations(List.of("locations"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.GeoRestrictionProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoRestrictionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoRestrictionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The method that you want to use to restrict distribution of your content by country:.
         * <p>
         * <ul>
         * <li><code>none</code> : No geo restriction is enabled, meaning access to content is not restricted by client geo location.</li>
         * <li><code>blacklist</code> : The <code>Location</code> elements specify the countries in which you don't want CloudFront to distribute your content.</li>
         * <li><code>whitelist</code> : The <code>Location</code> elements specify the countries in which you want CloudFront to distribute your content.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-restrictiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-restrictiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRestrictionType();

        /**
         * A complex type that contains a <code>Location</code> element for each country in which you want CloudFront either to distribute your content ( <code>whitelist</code> ) or not distribute your content ( <code>blacklist</code> ).
         * <p>
         * The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to include in your <code>blacklist</code> or <code>whitelist</code> . Include one <code>Location</code> element for each country.
         * <p>
         * CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <em>International Organization for Standardization</em> website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-locations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoRestrictionProperty> {
            java.lang.String restrictionType;
            java.util.List<java.lang.String> locations;

            /**
             * Sets the value of {@link GeoRestrictionProperty#getRestrictionType}
             * @param restrictionType The method that you want to use to restrict distribution of your content by country:. This parameter is required.
             *                        <ul>
             *                        <li><code>none</code> : No geo restriction is enabled, meaning access to content is not restricted by client geo location.</li>
             *                        <li><code>blacklist</code> : The <code>Location</code> elements specify the countries in which you don't want CloudFront to distribute your content.</li>
             *                        <li><code>whitelist</code> : The <code>Location</code> elements specify the countries in which you want CloudFront to distribute your content.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictionType(java.lang.String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            /**
             * Sets the value of {@link GeoRestrictionProperty#getLocations}
             * @param locations A complex type that contains a <code>Location</code> element for each country in which you want CloudFront either to distribute your content ( <code>whitelist</code> ) or not distribute your content ( <code>blacklist</code> ).
             *                  The <code>Location</code> element is a two-letter, uppercase country code for a country that you want to include in your <code>blacklist</code> or <code>whitelist</code> . Include one <code>Location</code> element for each country.
             *                  <p>
             *                  CloudFront and <code>MaxMind</code> both use <code>ISO 3166</code> country codes. For the current list of countries and the corresponding codes, see <code>ISO 3166-1-alpha-2</code> code on the <em>International Organization for Standardization</em> website. You can also refer to the country list on the CloudFront console, which includes both country names and codes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locations(java.util.List<java.lang.String> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoRestrictionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoRestrictionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoRestrictionProperty {
            private final java.lang.String restrictionType;
            private final java.util.List<java.lang.String> locations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictionType = software.amazon.jsii.Kernel.get(this, "restrictionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictionType = java.util.Objects.requireNonNull(builder.restrictionType, "restrictionType is required");
                this.locations = builder.locations;
            }

            @Override
            public final java.lang.String getRestrictionType() {
                return this.restrictionType;
            }

            @Override
            public final java.util.List<java.lang.String> getLocations() {
                return this.locations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictionType", om.valueToTree(this.getRestrictionType()));
                if (this.getLocations() != null) {
                    data.set("locations", om.valueToTree(this.getLocations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.GeoRestrictionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoRestrictionProperty.Jsii$Proxy that = (GeoRestrictionProperty.Jsii$Proxy) o;

                if (!restrictionType.equals(that.restrictionType)) return false;
                return this.locations != null ? this.locations.equals(that.locations) : that.locations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.restrictionType.hashCode();
                result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that contains a Lambda&#64;Edge function association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * LambdaFunctionAssociationProperty lambdaFunctionAssociationProperty = LambdaFunctionAssociationProperty.builder()
     *         .eventType("eventType")
     *         .includeBody(false)
     *         .lambdaFunctionArn("lambdaFunctionArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LambdaFunctionAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the event type that triggers a Lambda&#64;Edge function invocation. You can specify the following values:.
         * <p>
         * <ul>
         * <li><code>viewer-request</code> : The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.</li>
         * <li><code>origin-request</code> : The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.</li>
         * <li><code>origin-response</code> : The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</li>
         * <li><code>viewer-response</code> : The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.</li>
         * </ul>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-eventtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
            return null;
        }

        /**
         * A flag that allows a Lambda&#64;Edge function to have read access to the body content.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-includebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-includebody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeBody() {
            return null;
        }

        /**
         * The ARN of the Lambda&#64;Edge function.
         * <p>
         * You must specify the ARN of a function version; you can't specify an alias or $LATEST.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-lambdafunctionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-lambdafunctionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionAssociationProperty> {
            java.lang.String eventType;
            java.lang.Object includeBody;
            java.lang.String lambdaFunctionArn;

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getEventType}
             * @param eventType Specifies the event type that triggers a Lambda&#64;Edge function invocation. You can specify the following values:.
             *                  <ul>
             *                  <li><code>viewer-request</code> : The function executes when CloudFront receives a request from a viewer and before it checks to see whether the requested object is in the edge cache.</li>
             *                  <li><code>origin-request</code> : The function executes only when CloudFront sends a request to your origin. When the requested object is in the edge cache, the function doesn't execute.</li>
             *                  <li><code>origin-response</code> : The function executes after CloudFront receives a response from the origin and before it caches the object in the response. When the requested object is in the edge cache, the function doesn't execute.</li>
             *                  <li><code>viewer-response</code> : The function executes before CloudFront returns the requested object to the viewer. The function executes regardless of whether the object was already in the edge cache.</li>
             *                  </ul>
             *                  <p>
             *                  If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody A flag that allows a Lambda&#64;Edge function to have read access to the body content.
             *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(java.lang.Boolean includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody A flag that allows a Lambda&#64;Edge function to have read access to the body content.
             *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-include-body-access.html">Accessing the Request Body by Choosing the Include Body Option</a> in the Amazon CloudFront Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(software.amazon.awscdk.IResolvable includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn The ARN of the Lambda&#64;Edge function.
             *                          You must specify the ARN of a function version; you can't specify an alias or $LATEST.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionAssociationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionAssociationProperty {
            private final java.lang.String eventType;
            private final java.lang.Object includeBody;
            private final java.lang.String lambdaFunctionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeBody = software.amazon.jsii.Kernel.get(this, "includeBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = builder.eventType;
                this.includeBody = builder.includeBody;
                this.lambdaFunctionArn = builder.lambdaFunctionArn;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.Object getIncludeBody() {
                return this.includeBody;
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getIncludeBody() != null) {
                    data.set("includeBody", om.valueToTree(this.getIncludeBody()));
                }
                if (this.getLambdaFunctionArn() != null) {
                    data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LambdaFunctionAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionAssociationProperty.Jsii$Proxy that = (LambdaFunctionAssociationProperty.Jsii$Proxy) o;

                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                if (this.includeBody != null ? !this.includeBody.equals(that.includeBody) : that.includeBody != null) return false;
                return this.lambdaFunctionArn != null ? this.lambdaFunctionArn.equals(that.lambdaFunctionArn) : that.lambdaFunctionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType != null ? this.eventType.hashCode() : 0;
                result = 31 * result + (this.includeBody != null ? this.includeBody.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionArn != null ? this.lambdaFunctionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * LegacyCustomOriginProperty legacyCustomOriginProperty = LegacyCustomOriginProperty.builder()
     *         .dnsName("dnsName")
     *         .originProtocolPolicy("originProtocolPolicy")
     *         .originSslProtocols(List.of("originSslProtocols"))
     *         // the properties below are optional
     *         .httpPort(123)
     *         .httpsPort(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyCustomOriginProperty")
    @software.amazon.jsii.Jsii.Proxy(LegacyCustomOriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LegacyCustomOriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-dnsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-dnsname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-originprotocolpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-originprotocolpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginProtocolPolicy();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-originsslprotocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-originsslprotocols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOriginSslProtocols();

        /**
         * Default: - 80
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-httpport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-httpport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
            return null;
        }

        /**
         * Default: - 443
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-httpsport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacycustomorigin.html#cfn-cloudfront-distribution-legacycustomorigin-httpsport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LegacyCustomOriginProperty> {
            java.lang.String dnsName;
            java.lang.String originProtocolPolicy;
            java.util.List<java.lang.String> originSslProtocols;
            java.lang.Number httpPort;
            java.lang.Number httpsPort;

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getDnsName}
             * @param dnsName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getOriginProtocolPolicy}
             * @param originProtocolPolicy the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originProtocolPolicy(java.lang.String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getOriginSslProtocols}
             * @param originSslProtocols the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSslProtocols(java.util.List<java.lang.String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getHttpPort}
             * @param httpPort the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPort(java.lang.Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getHttpsPort}
             * @param httpsPort the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPort(java.lang.Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LegacyCustomOriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LegacyCustomOriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LegacyCustomOriginProperty {
            private final java.lang.String dnsName;
            private final java.lang.String originProtocolPolicy;
            private final java.util.List<java.lang.String> originSslProtocols;
            private final java.lang.Number httpPort;
            private final java.lang.Number httpsPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originProtocolPolicy = software.amazon.jsii.Kernel.get(this, "originProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(builder.dnsName, "dnsName is required");
                this.originProtocolPolicy = java.util.Objects.requireNonNull(builder.originProtocolPolicy, "originProtocolPolicy is required");
                this.originSslProtocols = java.util.Objects.requireNonNull(builder.originSslProtocols, "originSslProtocols is required");
                this.httpPort = builder.httpPort;
                this.httpsPort = builder.httpsPort;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.String getOriginProtocolPolicy() {
                return this.originProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getOriginSslProtocols() {
                return this.originSslProtocols;
            }

            @Override
            public final java.lang.Number getHttpPort() {
                return this.httpPort;
            }

            @Override
            public final java.lang.Number getHttpsPort() {
                return this.httpsPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
                data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
                if (this.getHttpPort() != null) {
                    data.set("httpPort", om.valueToTree(this.getHttpPort()));
                }
                if (this.getHttpsPort() != null) {
                    data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyCustomOriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LegacyCustomOriginProperty.Jsii$Proxy that = (LegacyCustomOriginProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                if (!originProtocolPolicy.equals(that.originProtocolPolicy)) return false;
                if (!originSslProtocols.equals(that.originSslProtocols)) return false;
                if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
                return this.httpsPort != null ? this.httpsPort.equals(that.httpsPort) : that.httpsPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.originProtocolPolicy.hashCode());
                result = 31 * result + (this.originSslProtocols.hashCode());
                result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
                result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * LegacyS3OriginProperty legacyS3OriginProperty = LegacyS3OriginProperty.builder()
     *         .dnsName("dnsName")
     *         // the properties below are optional
     *         .originAccessIdentity("originAccessIdentity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyS3OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(LegacyS3OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LegacyS3OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html#cfn-cloudfront-distribution-legacys3origin-dnsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html#cfn-cloudfront-distribution-legacys3origin-dnsname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html#cfn-cloudfront-distribution-legacys3origin-originaccessidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-legacys3origin.html#cfn-cloudfront-distribution-legacys3origin-originaccessidentity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessIdentity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LegacyS3OriginProperty> {
            java.lang.String dnsName;
            java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link LegacyS3OriginProperty#getDnsName}
             * @param dnsName the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link LegacyS3OriginProperty#getOriginAccessIdentity}
             * @param originAccessIdentity the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LegacyS3OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LegacyS3OriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LegacyS3OriginProperty {
            private final java.lang.String dnsName;
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(builder.dnsName, "dnsName is required");
                this.originAccessIdentity = builder.originAccessIdentity;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                if (this.getOriginAccessIdentity() != null) {
                    data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyS3OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LegacyS3OriginProperty.Jsii$Proxy that = (LegacyS3OriginProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                return this.originAccessIdentity != null ? this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that controls whether access logs are written for the distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * LoggingProperty loggingProperty = LoggingProperty.builder()
     *         .bucket("bucket")
     *         // the properties below are optional
     *         .includeCookies(false)
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for <code>IncludeCookies</code> .
         * <p>
         * If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code> for <code>IncludeCookies</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-includecookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-includecookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeCookies() {
            return null;
        }

        /**
         * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this distribution, for example, <code>myprefix/</code> .
         * <p>
         * If you want to enable logging, but you don't want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            java.lang.String bucket;
            java.lang.Object includeCookies;
            java.lang.String prefix;

            /**
             * Sets the value of {@link LoggingProperty#getBucket}
             * @param bucket The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for <code>IncludeCookies</code> .
             *                       If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code> for <code>IncludeCookies</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(java.lang.Boolean includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for <code>IncludeCookies</code> .
             *                       If you choose to include cookies in logs, CloudFront logs all cookies regardless of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code> for <code>IncludeCookies</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(software.amazon.awscdk.IResolvable includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getPrefix}
             * @param prefix An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this distribution, for example, <code>myprefix/</code> .
             *               If you want to enable logging, but you don't want to specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.String bucket;
            private final java.lang.Object includeCookies;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeCookies = software.amazon.jsii.Kernel.get(this, "includeCookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.includeCookies = builder.includeCookies;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getIncludeCookies() {
                return this.includeCookies;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getIncludeCookies() != null) {
                    data.set("includeCookies", om.valueToTree(this.getIncludeCookies()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.includeCookies != null ? !this.includeCookies.equals(that.includeCookies) : that.includeCookies != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.includeCookies != null ? this.includeCookies.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that contains <code>HeaderName</code> and <code>HeaderValue</code> elements, if any, for this distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginCustomHeaderProperty originCustomHeaderProperty = OriginCustomHeaderProperty.builder()
     *         .headerName("headerName")
     *         .headerValue("headerValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginCustomHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginCustomHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginCustomHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a header that you want CloudFront to send to your origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * The value for the header that you specified in the <code>HeaderName</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

        /**
         * @return a {@link Builder} of {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginCustomHeaderProperty> {
            java.lang.String headerName;
            java.lang.String headerValue;

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderName}
             * @param headerName The name of a header that you want CloudFront to send to your origin. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderValue}
             * @param headerValue The value for the header that you specified in the <code>HeaderName</code> field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerValue(java.lang.String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginCustomHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginCustomHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginCustomHeaderProperty {
            private final java.lang.String headerName;
            private final java.lang.String headerValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerValue = software.amazon.jsii.Kernel.get(this, "headerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
                this.headerValue = java.util.Objects.requireNonNull(builder.headerValue, "headerValue is required");
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getHeaderValue() {
                return this.headerValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("headerValue", om.valueToTree(this.getHeaderValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginCustomHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginCustomHeaderProperty.Jsii$Proxy that = (OriginCustomHeaderProperty.Jsii$Proxy) o;

                if (!headerName.equals(that.headerName)) return false;
                return this.headerValue.equals(that.headerValue);
            }

            @Override
            public final int hashCode() {
                int result = this.headerName.hashCode();
                result = 31 * result + (this.headerValue.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex data type that includes information about the failover criteria for an origin group, including the status codes for which CloudFront will failover from the primary origin to the second origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginGroupFailoverCriteriaProperty originGroupFailoverCriteriaProperty = OriginGroupFailoverCriteriaProperty.builder()
     *         .statusCodes(StatusCodesProperty.builder()
     *                 .items(List.of(123))
     *                 .quantity(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupFailoverCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupFailoverCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html#cfn-cloudfront-distribution-origingroupfailovercriteria-statuscodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html#cfn-cloudfront-distribution-origingroupfailovercriteria-statuscodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatusCodes();

        /**
         * @return a {@link Builder} of {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupFailoverCriteriaProperty> {
            java.lang.Object statusCodes;

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.IResolvable statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes The status codes that, when returned from the primary origin, will trigger CloudFront to failover to the second origin. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.services.cloudfront.CfnDistribution.StatusCodesProperty statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupFailoverCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupFailoverCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupFailoverCriteriaProperty {
            private final java.lang.Object statusCodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCodes = software.amazon.jsii.Kernel.get(this, "statusCodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCodes = java.util.Objects.requireNonNull(builder.statusCodes, "statusCodes is required");
            }

            @Override
            public final java.lang.Object getStatusCodes() {
                return this.statusCodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCodes", om.valueToTree(this.getStatusCodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupFailoverCriteriaProperty.Jsii$Proxy that = (OriginGroupFailoverCriteriaProperty.Jsii$Proxy) o;

                return this.statusCodes.equals(that.statusCodes);
            }

            @Override
            public final int hashCode() {
                int result = this.statusCodes.hashCode();
                return result;
            }
        }
    }
    /**
     * An origin in an origin group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginGroupMemberProperty originGroupMemberProperty = OriginGroupMemberProperty.builder()
     *         .originId("originId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMemberProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMemberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMemberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID for an origin in an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html#cfn-cloudfront-distribution-origingroupmember-originid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html#cfn-cloudfront-distribution-origingroupmember-originid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginId();

        /**
         * @return a {@link Builder} of {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMemberProperty> {
            java.lang.String originId;

            /**
             * Sets the value of {@link OriginGroupMemberProperty#getOriginId}
             * @param originId The ID for an origin in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originId(java.lang.String originId) {
                this.originId = originId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMemberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMemberProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMemberProperty {
            private final java.lang.String originId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originId = software.amazon.jsii.Kernel.get(this, "originId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originId = java.util.Objects.requireNonNull(builder.originId, "originId is required");
            }

            @Override
            public final java.lang.String getOriginId() {
                return this.originId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originId", om.valueToTree(this.getOriginId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMemberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMemberProperty.Jsii$Proxy that = (OriginGroupMemberProperty.Jsii$Proxy) o;

                return this.originId.equals(that.originId);
            }

            @Override
            public final int hashCode() {
                int result = this.originId.hashCode();
                return result;
            }
        }
    }
    /**
     * A complex data type for the origins included in an origin group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginGroupMembersProperty originGroupMembersProperty = OriginGroupMembersProperty.builder()
     *         .items(List.of(OriginGroupMemberProperty.builder()
     *                 .originId("originId")
     *                 .build()))
     *         .quantity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMembersProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMembersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMembersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Items (origins) in an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * The number of origins in an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-quantity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-quantity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMembersProperty> {
            java.lang.Object items;
            java.lang.Number quantity;

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items Items (origins) in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items Items (origins) in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getQuantity}
             * @param quantity The number of origins in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMembersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMembersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMembersProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(builder.quantity, "quantity is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMembersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMembersProperty.Jsii$Proxy that = (OriginGroupMembersProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     * An origin group includes two origins (a primary origin and a second origin to failover to) and a failover criteria that you specify.
     * <p>
     * You create an origin group to support origin failover in CloudFront. When you create or update a distribution, you can specify the origin group instead of a single origin, and CloudFront will failover from the primary origin to the second origin under the failover conditions that you've chosen.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginGroupProperty originGroupProperty = OriginGroupProperty.builder()
     *         .failoverCriteria(OriginGroupFailoverCriteriaProperty.builder()
     *                 .statusCodes(StatusCodesProperty.builder()
     *                         .items(List.of(123))
     *                         .quantity(123)
     *                         .build())
     *                 .build())
     *         .id("id")
     *         .members(OriginGroupMembersProperty.builder()
     *                 .items(List.of(OriginGroupMemberProperty.builder()
     *                         .originId("originId")
     *                         .build()))
     *                 .quantity(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A complex type that contains information about the failover criteria for an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-failovercriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-failovercriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFailoverCriteria();

        /**
         * The origin group's ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * A complex type that contains information about the origins in an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-members</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMembers();

        /**
         * @return a {@link Builder} of {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupProperty> {
            java.lang.Object failoverCriteria;
            java.lang.String id;
            java.lang.Object members;

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria A complex type that contains information about the failover criteria for an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.IResolvable failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria A complex type that contains information about the failover criteria for an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getId}
             * @param id The origin group's ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members A complex type that contains information about the origins in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.IResolvable members) {
                this.members = members;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members A complex type that contains information about the origins in an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupMembersProperty members) {
                this.members = members;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupProperty {
            private final java.lang.Object failoverCriteria;
            private final java.lang.String id;
            private final java.lang.Object members;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverCriteria = software.amazon.jsii.Kernel.get(this, "failoverCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.members = software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverCriteria = java.util.Objects.requireNonNull(builder.failoverCriteria, "failoverCriteria is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.members = java.util.Objects.requireNonNull(builder.members, "members is required");
            }

            @Override
            public final java.lang.Object getFailoverCriteria() {
                return this.failoverCriteria;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getMembers() {
                return this.members;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failoverCriteria", om.valueToTree(this.getFailoverCriteria()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("members", om.valueToTree(this.getMembers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupProperty.Jsii$Proxy that = (OriginGroupProperty.Jsii$Proxy) o;

                if (!failoverCriteria.equals(that.failoverCriteria)) return false;
                if (!id.equals(that.id)) return false;
                return this.members.equals(that.members);
            }

            @Override
            public final int hashCode() {
                int result = this.failoverCriteria.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.members.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex data type for the origin groups specified for a distribution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginGroupsProperty originGroupsProperty = OriginGroupsProperty.builder()
     *         .quantity(123)
     *         // the properties below are optional
     *         .items(List.of(OriginGroupProperty.builder()
     *                 .failoverCriteria(OriginGroupFailoverCriteriaProperty.builder()
     *                         .statusCodes(StatusCodesProperty.builder()
     *                                 .items(List.of(123))
     *                                 .quantity(123)
     *                                 .build())
     *                         .build())
     *                 .id("id")
     *                 .members(OriginGroupMembersProperty.builder()
     *                         .items(List.of(OriginGroupMemberProperty.builder()
     *                                 .originId("originId")
     *                                 .build()))
     *                         .quantity(123)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of origin groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-quantity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-quantity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * The items (origin groups) in a distribution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupsProperty> {
            java.lang.Number quantity;
            java.lang.Object items;

            /**
             * Sets the value of {@link OriginGroupsProperty#getQuantity}
             * @param quantity The number of origin groups. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items The items (origin groups) in a distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items The items (origin groups) in a distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupsProperty {
            private final java.lang.Number quantity;
            private final java.lang.Object items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.quantity = java.util.Objects.requireNonNull(builder.quantity, "quantity is required");
                this.items = builder.items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("quantity", om.valueToTree(this.getQuantity()));
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupsProperty.Jsii$Proxy that = (OriginGroupsProperty.Jsii$Proxy) o;

                if (!quantity.equals(that.quantity)) return false;
                return this.items != null ? this.items.equals(that.items) : that.items == null;
            }

            @Override
            public final int hashCode() {
                int result = this.quantity.hashCode();
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An origin.
     * <p>
     * An origin is the location where content is stored, and from which CloudFront gets content to serve to viewers. To specify an origin:
     * <p>
     * <ul>
     * <li>Use <code>S3OriginConfig</code> to specify an Amazon S3 bucket that is not configured with static website hosting.</li>
     * <li>Use <code>CustomOriginConfig</code> to specify all other kinds of origins, including:</li>
     * <li>An Amazon S3 bucket that is configured with static website hosting</li>
     * <li>An Elastic Load Balancing load balancer</li>
     * <li>An AWS Elemental MediaPackage endpoint</li>
     * <li>An AWS Elemental MediaStore container</li>
     * <li>Any other HTTP server, running on an Amazon EC2 instance or any other kind of host</li>
     * </ul>
     * <p>
     * For the current maximum number of origins that you can specify per distribution, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions">General Quotas on Web Distributions</a> in the <em>Amazon CloudFront Developer Guide</em> (quotas were formerly referred to as limits).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginProperty originProperty = OriginProperty.builder()
     *         .domainName("domainName")
     *         .id("id")
     *         // the properties below are optional
     *         .connectionAttempts(123)
     *         .connectionTimeout(123)
     *         .customOriginConfig(CustomOriginConfigProperty.builder()
     *                 .originProtocolPolicy("originProtocolPolicy")
     *                 // the properties below are optional
     *                 .httpPort(123)
     *                 .httpsPort(123)
     *                 .originKeepaliveTimeout(123)
     *                 .originReadTimeout(123)
     *                 .originSslProtocols(List.of("originSslProtocols"))
     *                 .build())
     *         .originAccessControlId("originAccessControlId")
     *         .originCustomHeaders(List.of(OriginCustomHeaderProperty.builder()
     *                 .headerName("headerName")
     *                 .headerValue("headerValue")
     *                 .build()))
     *         .originPath("originPath")
     *         .originShield(OriginShieldProperty.builder()
     *                 .enabled(false)
     *                 .originShieldRegion("originShieldRegion")
     *                 .build())
     *         .s3OriginConfig(S3OriginConfigProperty.builder()
     *                 .originAccessIdentity("originAccessIdentity")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain name for the origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * A unique identifier for the origin. This value must be unique within the distribution.
         * <p>
         * Use this value to specify the <code>TargetOriginId</code> in a <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The number of times that CloudFront attempts to connect to the origin.
         * <p>
         * The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
         * <p>
         * For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectionattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectionattempts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionAttempts() {
            return null;
        }

        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionTimeout() {
            return null;
        }

        /**
         * Use this type to specify an origin that is not an Amazon S3 bucket, with one exception.
         * <p>
         * If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the <code>S3OriginConfig</code> type instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-customoriginconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-customoriginconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOriginConfig() {
            return null;
        }

        /**
         * The unique identifier of an origin access control for this origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Restricting access to an Amazon S3 origin</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originaccesscontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originaccesscontrolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessControlId() {
            return null;
        }

        /**
         * A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-origincustomheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-origincustomheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginCustomHeaders() {
            return null;
        }

        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
            return null;
        }

        /**
         * CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originshield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originshield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginShield() {
            return null;
        }

        /**
         * Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting.
         * <p>
         * To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the <code>CustomOriginConfig</code> type instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-s3originconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-s3originconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3OriginConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginProperty> {
            java.lang.String domainName;
            java.lang.String id;
            java.lang.Number connectionAttempts;
            java.lang.Number connectionTimeout;
            java.lang.Object customOriginConfig;
            java.lang.String originAccessControlId;
            java.lang.Object originCustomHeaders;
            java.lang.String originPath;
            java.lang.Object originShield;
            java.lang.Object s3OriginConfig;

            /**
             * Sets the value of {@link OriginProperty#getDomainName}
             * @param domainName The domain name for the origin. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName">Origin Domain Name</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getId}
             * @param id A unique identifier for the origin. This value must be unique within the distribution. This parameter is required.
             *           Use this value to specify the <code>TargetOriginId</code> in a <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionAttempts}
             * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin.
             *                           The minimum number is 1, the maximum is 3, and the default (if you don't specify otherwise) is 3.
             *                           <p>
             *                           For a custom origin (including an Amazon S3 bucket that's configured with static website hosting), this value also specifies the number of times that CloudFront attempts to get a response from the origin, in the case of an <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout">Origin Response Timeout</a> .
             *                           <p>
             *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts">Origin Connection Attempts</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAttempts(java.lang.Number connectionAttempts) {
                this.connectionAttempts = connectionAttempts;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionTimeout}
             * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
             *                          The minimum timeout is 1 second, the maximum is 10 seconds, and the default (if you don't specify otherwise) is 10 seconds.
             *                          <p>
             *                          For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout">Origin Connection Timeout</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionTimeout(java.lang.Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig Use this type to specify an origin that is not an Amazon S3 bucket, with one exception.
             *                           If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the <code>S3OriginConfig</code> type instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.IResolvable customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig Use this type to specify an origin that is not an Amazon S3 bucket, with one exception.
             *                           If the Amazon S3 bucket is configured with static website hosting, use this type. If the Amazon S3 bucket is not configured with static website hosting, use the <code>S3OriginConfig</code> type instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginAccessControlId}
             * @param originAccessControlId The unique identifier of an origin access control for this origin.
             *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html">Restricting access to an Amazon S3 origin</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessControlId(java.lang.String originAccessControlId) {
                this.originAccessControlId = originAccessControlId;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(software.amazon.awscdk.IResolvable originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders A list of HTTP header names and values that CloudFront adds to the requests that it sends to the origin.
             *                            For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html">Adding Custom Headers to Origin Requests</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(java.util.List<? extends java.lang.Object> originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginPath}
             * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath">Origin Path</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originPath(java.lang.String originPath) {
                this.originPath = originPath;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginShield}
             * @param originShield CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
             *                     For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShield(software.amazon.awscdk.IResolvable originShield) {
                this.originShield = originShield;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginShield}
             * @param originShield CloudFront Origin Shield. Using Origin Shield can help reduce the load on your origin.
             *                     For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShield(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginShieldProperty originShield) {
                this.originShield = originShield;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting.
             *                       To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the <code>CustomOriginConfig</code> type instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.IResolvable s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig Use this type to specify an origin that is an Amazon S3 bucket that is not configured with static website hosting.
             *                       To specify any other type of origin, including an Amazon S3 bucket that is configured with static website hosting, use the <code>CustomOriginConfig</code> type instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginProperty {
            private final java.lang.String domainName;
            private final java.lang.String id;
            private final java.lang.Number connectionAttempts;
            private final java.lang.Number connectionTimeout;
            private final java.lang.Object customOriginConfig;
            private final java.lang.String originAccessControlId;
            private final java.lang.Object originCustomHeaders;
            private final java.lang.String originPath;
            private final java.lang.Object originShield;
            private final java.lang.Object s3OriginConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customOriginConfig = software.amazon.jsii.Kernel.get(this, "customOriginConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originAccessControlId = software.amazon.jsii.Kernel.get(this, "originAccessControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originCustomHeaders = software.amazon.jsii.Kernel.get(this, "originCustomHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originShield = software.amazon.jsii.Kernel.get(this, "originShield", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3OriginConfig = software.amazon.jsii.Kernel.get(this, "s3OriginConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.connectionAttempts = builder.connectionAttempts;
                this.connectionTimeout = builder.connectionTimeout;
                this.customOriginConfig = builder.customOriginConfig;
                this.originAccessControlId = builder.originAccessControlId;
                this.originCustomHeaders = builder.originCustomHeaders;
                this.originPath = builder.originPath;
                this.originShield = builder.originShield;
                this.s3OriginConfig = builder.s3OriginConfig;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getConnectionAttempts() {
                return this.connectionAttempts;
            }

            @Override
            public final java.lang.Number getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public final java.lang.Object getCustomOriginConfig() {
                return this.customOriginConfig;
            }

            @Override
            public final java.lang.String getOriginAccessControlId() {
                return this.originAccessControlId;
            }

            @Override
            public final java.lang.Object getOriginCustomHeaders() {
                return this.originCustomHeaders;
            }

            @Override
            public final java.lang.String getOriginPath() {
                return this.originPath;
            }

            @Override
            public final java.lang.Object getOriginShield() {
                return this.originShield;
            }

            @Override
            public final java.lang.Object getS3OriginConfig() {
                return this.s3OriginConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("id", om.valueToTree(this.getId()));
                if (this.getConnectionAttempts() != null) {
                    data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
                }
                if (this.getConnectionTimeout() != null) {
                    data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
                }
                if (this.getCustomOriginConfig() != null) {
                    data.set("customOriginConfig", om.valueToTree(this.getCustomOriginConfig()));
                }
                if (this.getOriginAccessControlId() != null) {
                    data.set("originAccessControlId", om.valueToTree(this.getOriginAccessControlId()));
                }
                if (this.getOriginCustomHeaders() != null) {
                    data.set("originCustomHeaders", om.valueToTree(this.getOriginCustomHeaders()));
                }
                if (this.getOriginPath() != null) {
                    data.set("originPath", om.valueToTree(this.getOriginPath()));
                }
                if (this.getOriginShield() != null) {
                    data.set("originShield", om.valueToTree(this.getOriginShield()));
                }
                if (this.getS3OriginConfig() != null) {
                    data.set("s3OriginConfig", om.valueToTree(this.getS3OriginConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginProperty.Jsii$Proxy that = (OriginProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                if (!id.equals(that.id)) return false;
                if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
                if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
                if (this.customOriginConfig != null ? !this.customOriginConfig.equals(that.customOriginConfig) : that.customOriginConfig != null) return false;
                if (this.originAccessControlId != null ? !this.originAccessControlId.equals(that.originAccessControlId) : that.originAccessControlId != null) return false;
                if (this.originCustomHeaders != null ? !this.originCustomHeaders.equals(that.originCustomHeaders) : that.originCustomHeaders != null) return false;
                if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
                if (this.originShield != null ? !this.originShield.equals(that.originShield) : that.originShield != null) return false;
                return this.s3OriginConfig != null ? this.s3OriginConfig.equals(that.s3OriginConfig) : that.s3OriginConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
                result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
                result = 31 * result + (this.customOriginConfig != null ? this.customOriginConfig.hashCode() : 0);
                result = 31 * result + (this.originAccessControlId != null ? this.originAccessControlId.hashCode() : 0);
                result = 31 * result + (this.originCustomHeaders != null ? this.originCustomHeaders.hashCode() : 0);
                result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
                result = 31 * result + (this.originShield != null ? this.originShield.hashCode() : 0);
                result = 31 * result + (this.s3OriginConfig != null ? this.s3OriginConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * CloudFront Origin Shield.
     * <p>
     * Using Origin Shield can help reduce the load on your origin. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * OriginShieldProperty originShieldProperty = OriginShieldProperty.builder()
     *         .enabled(false)
     *         .originShieldRegion("originShieldRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginShieldProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginShieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginShieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A flag that specifies whether Origin Shield is enabled.
         * <p>
         * When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html#cfn-cloudfront-distribution-originshield-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html#cfn-cloudfront-distribution-originshield-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The AWS Region for Origin Shield.
         * <p>
         * Specify the AWS Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as <code>us-east-2</code> .
         * <p>
         * When you enable CloudFront Origin Shield, you must specify the AWS Region for Origin Shield. For the list of AWS Regions that you can specify, and for help choosing the best Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the AWS Region for Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html#cfn-cloudfront-distribution-originshield-originshieldregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-originshield.html#cfn-cloudfront-distribution-originshield-originshieldregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginShieldRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginShieldProperty> {
            java.lang.Object enabled;
            java.lang.String originShieldRegion;

            /**
             * Sets the value of {@link OriginShieldProperty#getEnabled}
             * @param enabled A flag that specifies whether Origin Shield is enabled.
             *                When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OriginShieldProperty#getEnabled}
             * @param enabled A flag that specifies whether Origin Shield is enabled.
             *                When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional edge caches.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OriginShieldProperty#getOriginShieldRegion}
             * @param originShieldRegion The AWS Region for Origin Shield.
             *                           Specify the AWS Region that has the lowest latency to your origin. To specify a region, use the region code, not the region name. For example, specify the US East (Ohio) region as <code>us-east-2</code> .
             *                           <p>
             *                           When you enable CloudFront Origin Shield, you must specify the AWS Region for Origin Shield. For the list of AWS Regions that you can specify, and for help choosing the best Region for your origin, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region">Choosing the AWS Region for Origin Shield</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShieldRegion(java.lang.String originShieldRegion) {
                this.originShieldRegion = originShieldRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginShieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginShieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginShieldProperty {
            private final java.lang.Object enabled;
            private final java.lang.String originShieldRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originShieldRegion = software.amazon.jsii.Kernel.get(this, "originShieldRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.originShieldRegion = builder.originShieldRegion;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getOriginShieldRegion() {
                return this.originShieldRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getOriginShieldRegion() != null) {
                    data.set("originShieldRegion", om.valueToTree(this.getOriginShieldRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginShieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginShieldProperty.Jsii$Proxy that = (OriginShieldProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.originShieldRegion != null ? this.originShieldRegion.equals(that.originShieldRegion) : that.originShieldRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.originShieldRegion != null ? this.originShieldRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A complex type that identifies ways in which you want to restrict distribution of your content.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * RestrictionsProperty restrictionsProperty = RestrictionsProperty.builder()
     *         .geoRestriction(GeoRestrictionProperty.builder()
     *                 .restrictionType("restrictionType")
     *                 // the properties below are optional
     *                 .locations(List.of("locations"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.RestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A complex type that controls the countries in which your content is distributed.
         * <p>
         * CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases. To disable geo restriction, remove the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions">Restrictions</a> property from your stack template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html#cfn-cloudfront-distribution-restrictions-georestriction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html#cfn-cloudfront-distribution-restrictions-georestriction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeoRestriction();

        /**
         * @return a {@link Builder} of {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictionsProperty> {
            java.lang.Object geoRestriction;

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction A complex type that controls the countries in which your content is distributed. This parameter is required.
             *                       CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases. To disable geo restriction, remove the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions">Restrictions</a> property from your stack template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.IResolvable geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction A complex type that controls the countries in which your content is distributed. This parameter is required.
             *                       CloudFront determines the location of your users using <code>MaxMind</code> GeoIP databases. To disable geo restriction, remove the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions">Restrictions</a> property from your stack template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.services.cloudfront.CfnDistribution.GeoRestrictionProperty geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictionsProperty {
            private final java.lang.Object geoRestriction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoRestriction = software.amazon.jsii.Kernel.get(this, "geoRestriction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoRestriction = java.util.Objects.requireNonNull(builder.geoRestriction, "geoRestriction is required");
            }

            @Override
            public final java.lang.Object getGeoRestriction() {
                return this.geoRestriction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("geoRestriction", om.valueToTree(this.getGeoRestriction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.RestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictionsProperty.Jsii$Proxy that = (RestrictionsProperty.Jsii$Proxy) o;

                return this.geoRestriction.equals(that.geoRestriction);
            }

            @Override
            public final int hashCode() {
                int result = this.geoRestriction.hashCode();
                return result;
            }
        }
    }
    /**
     * A complex type that contains information about the Amazon S3 origin.
     * <p>
     * If the origin is a custom origin or an S3 bucket that is configured as a website endpoint, use the <code>CustomOriginConfig</code> element instead.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * S3OriginConfigProperty s3OriginConfigProperty = S3OriginConfigProperty.builder()
     *         .originAccessIdentity("originAccessIdentity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.S3OriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <blockquote><p>If you're using origin access control (OAC) instead of origin access identity, specify an empty <code>OriginAccessIdentity</code> element.<p></blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html">Restricting access to an AWS</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can <em>only</em> access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
         * <p>
         * <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
         * <p>
         * The <code>*ID-of-origin-access-identity*</code> is the value that CloudFront returned in the <code>ID</code> element when you created the origin access identity.
         * <p>
         * If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
         * <p>
         * For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * Default: - ""
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html#cfn-cloudfront-distribution-s3originconfig-originaccessidentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html#cfn-cloudfront-distribution-s3originconfig-originaccessidentity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessIdentity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OriginConfigProperty> {
            java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link S3OriginConfigProperty#getOriginAccessIdentity}
             * @param originAccessIdentity <blockquote><p>If you're using origin access control (OAC) instead of origin access identity, specify an empty <code>OriginAccessIdentity</code> element.<p></blockquote>
             *                             For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html">Restricting access to an AWS</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                             <p>
             *                             The CloudFront origin access identity to associate with the origin. Use an origin access identity to configure the origin so that viewers can <em>only</em> access objects in an Amazon S3 bucket through CloudFront. The format of the value is:
             *                             <p>
             *                             <code>origin-access-identity/cloudfront/ID-of-origin-access-identity</code>
             *                             <p>
             *                             The <code>*ID-of-origin-access-identity*</code> is the value that CloudFront returned in the <code>ID</code> element when you created the origin access identity.
             *                             <p>
             *                             If you want viewers to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify an empty <code>OriginAccessIdentity</code> element.
             *                             <p>
             *                             To delete the origin access identity from an existing distribution, update the distribution configuration and include an empty <code>OriginAccessIdentity</code> element.
             *                             <p>
             *                             To replace the origin access identity, update the distribution configuration and specify the new origin access identity.
             *                             <p>
             *                             For more information about the origin access identity, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private Content through CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OriginConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginConfigProperty {
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originAccessIdentity = builder.originAccessIdentity;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOriginAccessIdentity() != null) {
                    data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.S3OriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OriginConfigProperty.Jsii$Proxy that = (S3OriginConfigProperty.Jsii$Proxy) o;

                return this.originAccessIdentity != null ? this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A complex data type for the status codes that you specify that, when returned by a primary origin, trigger CloudFront to failover to a second origin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * StatusCodesProperty statusCodesProperty = StatusCodesProperty.builder()
     *         .items(List.of(123))
     *         .quantity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.StatusCodesProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusCodesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusCodesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The items (status codes) for an origin group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * The number of status codes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-quantity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-quantity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusCodesProperty> {
            java.lang.Object items;
            java.lang.Number quantity;

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items The items (status codes) for an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items The items (status codes) for an origin group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Number> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getQuantity}
             * @param quantity The number of status codes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusCodesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusCodesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusCodesProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(builder.items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(builder.quantity, "quantity is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.StatusCodesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusCodesProperty.Jsii$Proxy that = (StatusCodesProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     * <p>
     * If the distribution doesn't use <code>Aliases</code> (also known as alternate domain names or CNAMEs)—that is, if the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> —set <code>CloudFrontDefaultCertificate</code> to <code>true</code> and leave all other fields empty.
     * <p>
     * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), use the fields in this type to specify the following settings:
     * <p>
     * <ul>
     * <li>Which viewers the distribution accepts HTTPS connections from: only viewers that support <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication">server name indication (SNI)</a> (recommended), or all viewers including those that don't support SNI.</li>
     * <li>To accept HTTPS connections from only viewers that support SNI, set <code>SSLSupportMethod</code> to <code>sni-only</code> . This is recommended. Most browsers and clients support SNI. (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)</li>
     * <li>To accept HTTPS connections from all viewers, including those that don't support SNI, set <code>SSLSupportMethod</code> to <code>vip</code> . This is not recommended, and results in additional monthly charges from CloudFront. (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)</li>
     * <li>The minimum SSL/TLS protocol version that the distribution can use to communicate with viewers. To specify a minimum version, choose a value for <code>MinimumProtocolVersion</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> in the <em>Amazon CloudFront Developer Guide</em> .</li>
     * <li>The location of the SSL/TLS certificate, <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">AWS Certificate Manager (ACM)</a> (recommended) or <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">AWS Identity and Access Management (IAM)</a> . You specify the location by setting a value in one of the following fields (not both):</li>
     * <li><code>ACMCertificateArn</code> (In CloudFormation, this field name is <code>AcmCertificateArn</code> . Note the different capitalization.)</li>
     * <li><code>IAMCertificateId</code> (In CloudFormation, this field name is <code>IamCertificateId</code> . Note the different capitalization.)</li>
     * </ul>
     * <p>
     * All distributions support HTTPS connections from viewers. To require viewers to use HTTPS only, or to redirect them from HTTP to HTTPS, use <code>ViewerProtocolPolicy</code> in the <code>CacheBehavior</code> or <code>DefaultCacheBehavior</code> . To specify how CloudFront should use SSL/TLS to communicate with your custom origin, use <code>CustomOriginConfig</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https.html">Using HTTPS with CloudFront</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-https-alternate-domain-names.html">Using Alternate Domain Names and HTTPS</a> in the <em>Amazon CloudFront Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudfront.*;
     * ViewerCertificateProperty viewerCertificateProperty = ViewerCertificateProperty.builder()
     *         .acmCertificateArn("acmCertificateArn")
     *         .cloudFrontDefaultCertificate(false)
     *         .iamCertificateId("iamCertificateId")
     *         .minimumProtocolVersion("minimumProtocolVersion")
     *         .sslSupportMethod("sslSupportMethod")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.ViewerCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ViewerCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ViewerCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <blockquote><p>In CloudFormation, this field name is <code>AcmCertificateArn</code> . Note the different capitalization.<p></blockquote>
         * <p>
         * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">AWS Certificate Manager (ACM)</a> , provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region ( <code>us-east-1</code> ).
         * <p>
         * If you specify an ACM certificate ARN, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code> . (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-acmcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-acmcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcmCertificateArn() {
            return null;
        }

        /**
         * If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> , set this field to <code>true</code> .
         * <p>
         * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
         * <p>
         * <ul>
         * <li><code>AcmCertificateArn</code> or <code>IamCertificateId</code> (specify a value for one, not both)</li>
         * <li><code>MinimumProtocolVersion</code></li>
         * <li><code>SslSupportMethod</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-cloudfrontdefaultcertificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-cloudfrontdefaultcertificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFrontDefaultCertificate() {
            return null;
        }

        /**
         * <blockquote><p>In CloudFormation, this field name is <code>IamCertificateId</code> . Note the different capitalization.<p></blockquote>
         * <p>
         * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">AWS Identity and Access Management (IAM)</a> , provide the ID of the IAM certificate.
         * <p>
         * If you specify an IAM certificate ID, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code> . (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-iamcertificateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-iamcertificateid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamCertificateId() {
            return null;
        }

        /**
         * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers.
         * <p>
         * The security policy determines two settings:
         * <p>
         * <ul>
         * <li>The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.</li>
         * <li>The ciphers that CloudFront can use to encrypt the content that it returns to viewers.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * On the CloudFront console, this setting is called <em>Security Policy</em> .
         * <p>
         * </blockquote>
         * <p>
         * When you're using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code> ), you must specify <code>TLSv1</code> or higher. (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
         * <p>
         * If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> (you set <code>CloudFrontDefaultCertificate</code> to <code>true</code> ), CloudFront automatically sets the security policy to <code>TLSv1</code> regardless of the value that you set here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-minimumprotocolversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-minimumprotocolversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinimumProtocolVersion() {
            return null;
        }

        /**
         * <blockquote><p>In CloudFormation, this field name is <code>SslSupportMethod</code> . Note the different capitalization.<p></blockquote>
         * <p>
         * If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
         * <p>
         * <ul>
         * <li><code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that support <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication">server name indication (SNI)</a> . This is recommended. Most browsers and clients support SNI.</li>
         * <li><code>vip</code> – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.</li>
         * <li><code>static-ip</code> - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the <a href="https://docs.aws.amazon.com/support/home">AWS Support Center</a> .</li>
         * </ul>
         * <p>
         * If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> , don't set a value for this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-sslsupportmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-sslsupportmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSupportMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ViewerCertificateProperty> {
            java.lang.String acmCertificateArn;
            java.lang.Object cloudFrontDefaultCertificate;
            java.lang.String iamCertificateId;
            java.lang.String minimumProtocolVersion;
            java.lang.String sslSupportMethod;

            /**
             * Sets the value of {@link ViewerCertificateProperty#getAcmCertificateArn}
             * @param acmCertificateArn <blockquote><p>In CloudFormation, this field name is <code>AcmCertificateArn</code> . Note the different capitalization.<p></blockquote>
             *                          If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-overview.html">AWS Certificate Manager (ACM)</a> , provide the Amazon Resource Name (ARN) of the ACM certificate. CloudFront only supports ACM certificates in the US East (N. Virginia) Region ( <code>us-east-1</code> ).
             *                          <p>
             *                          If you specify an ACM certificate ARN, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code> . (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acmCertificateArn(java.lang.String acmCertificateArn) {
                this.acmCertificateArn = acmCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> , set this field to <code>true</code> .
             *                                     If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
             *                                     <p>
             *                                     <ul>
             *                                     <li><code>AcmCertificateArn</code> or <code>IamCertificateId</code> (specify a value for one, not both)</li>
             *                                     <li><code>MinimumProtocolVersion</code></li>
             *                                     <li><code>SslSupportMethod</code></li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(java.lang.Boolean cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> , set this field to <code>true</code> .
             *                                     If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), omit this field and specify values for the following fields:
             *                                     <p>
             *                                     <ul>
             *                                     <li><code>AcmCertificateArn</code> or <code>IamCertificateId</code> (specify a value for one, not both)</li>
             *                                     <li><code>MinimumProtocolVersion</code></li>
             *                                     <li><code>SslSupportMethod</code></li>
             *                                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(software.amazon.awscdk.IResolvable cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getIamCertificateId}
             * @param iamCertificateId <blockquote><p>In CloudFormation, this field name is <code>IamCertificateId</code> . Note the different capitalization.<p></blockquote>
             *                         If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs) and the SSL/TLS certificate is stored in <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">AWS Identity and Access Management (IAM)</a> , provide the ID of the IAM certificate.
             *                         <p>
             *                         If you specify an IAM certificate ID, you must also specify values for <code>MinimumProtocolVersion</code> and <code>SSLSupportMethod</code> . (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamCertificateId(java.lang.String iamCertificateId) {
                this.iamCertificateId = iamCertificateId;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getMinimumProtocolVersion}
             * @param minimumProtocolVersion If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify the security policy that you want CloudFront to use for HTTPS connections with viewers.
             *                               The security policy determines two settings:
             *                               <p>
             *                               <ul>
             *                               <li>The minimum SSL/TLS protocol that CloudFront can use to communicate with viewers.</li>
             *                               <li>The ciphers that CloudFront can use to encrypt the content that it returns to viewers.</li>
             *                               </ul>
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValues-security-policy">Security Policy</a> and <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html#secure-connections-supported-ciphers">Supported Protocols and Ciphers Between Viewers and CloudFront</a> in the <em>Amazon CloudFront Developer Guide</em> .
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               On the CloudFront console, this setting is called <em>Security Policy</em> .
             *                               <p>
             *                               </blockquote>
             *                               <p>
             *                               When you're using SNI only (you set <code>SSLSupportMethod</code> to <code>sni-only</code> ), you must specify <code>TLSv1</code> or higher. (In CloudFormation, the field name is <code>SslSupportMethod</code> . Note the different capitalization.)
             *                               <p>
             *                               If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> (you set <code>CloudFrontDefaultCertificate</code> to <code>true</code> ), CloudFront automatically sets the security policy to <code>TLSv1</code> regardless of the value that you set here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumProtocolVersion(java.lang.String minimumProtocolVersion) {
                this.minimumProtocolVersion = minimumProtocolVersion;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getSslSupportMethod}
             * @param sslSupportMethod <blockquote><p>In CloudFormation, this field name is <code>SslSupportMethod</code> . Note the different capitalization.<p></blockquote>
             *                         If the distribution uses <code>Aliases</code> (alternate domain names or CNAMEs), specify which viewers the distribution accepts HTTPS connections from.
             *                         <p>
             *                         <ul>
             *                         <li><code>sni-only</code> – The distribution accepts HTTPS connections from only viewers that support <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/Server_Name_Indication">server name indication (SNI)</a> . This is recommended. Most browsers and clients support SNI.</li>
             *                         <li><code>vip</code> – The distribution accepts HTTPS connections from all viewers including those that don't support SNI. This is not recommended, and results in additional monthly charges from CloudFront.</li>
             *                         <li><code>static-ip</code> - Do not specify this value unless your distribution has been enabled for this feature by the CloudFront team. If you have a use case that requires static IP addresses for a distribution, contact CloudFront through the <a href="https://docs.aws.amazon.com/support/home">AWS Support Center</a> .</li>
             *                         </ul>
             *                         <p>
             *                         If the distribution uses the CloudFront domain name such as <code>d111111abcdef8.cloudfront.net</code> , don't set a value for this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSupportMethod(java.lang.String sslSupportMethod) {
                this.sslSupportMethod = sslSupportMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ViewerCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ViewerCertificateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ViewerCertificateProperty {
            private final java.lang.String acmCertificateArn;
            private final java.lang.Object cloudFrontDefaultCertificate;
            private final java.lang.String iamCertificateId;
            private final java.lang.String minimumProtocolVersion;
            private final java.lang.String sslSupportMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acmCertificateArn = software.amazon.jsii.Kernel.get(this, "acmCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cloudFrontDefaultCertificate = software.amazon.jsii.Kernel.get(this, "cloudFrontDefaultCertificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamCertificateId = software.amazon.jsii.Kernel.get(this, "iamCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimumProtocolVersion = software.amazon.jsii.Kernel.get(this, "minimumProtocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslSupportMethod = software.amazon.jsii.Kernel.get(this, "sslSupportMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acmCertificateArn = builder.acmCertificateArn;
                this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
                this.iamCertificateId = builder.iamCertificateId;
                this.minimumProtocolVersion = builder.minimumProtocolVersion;
                this.sslSupportMethod = builder.sslSupportMethod;
            }

            @Override
            public final java.lang.String getAcmCertificateArn() {
                return this.acmCertificateArn;
            }

            @Override
            public final java.lang.Object getCloudFrontDefaultCertificate() {
                return this.cloudFrontDefaultCertificate;
            }

            @Override
            public final java.lang.String getIamCertificateId() {
                return this.iamCertificateId;
            }

            @Override
            public final java.lang.String getMinimumProtocolVersion() {
                return this.minimumProtocolVersion;
            }

            @Override
            public final java.lang.String getSslSupportMethod() {
                return this.sslSupportMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcmCertificateArn() != null) {
                    data.set("acmCertificateArn", om.valueToTree(this.getAcmCertificateArn()));
                }
                if (this.getCloudFrontDefaultCertificate() != null) {
                    data.set("cloudFrontDefaultCertificate", om.valueToTree(this.getCloudFrontDefaultCertificate()));
                }
                if (this.getIamCertificateId() != null) {
                    data.set("iamCertificateId", om.valueToTree(this.getIamCertificateId()));
                }
                if (this.getMinimumProtocolVersion() != null) {
                    data.set("minimumProtocolVersion", om.valueToTree(this.getMinimumProtocolVersion()));
                }
                if (this.getSslSupportMethod() != null) {
                    data.set("sslSupportMethod", om.valueToTree(this.getSslSupportMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.ViewerCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ViewerCertificateProperty.Jsii$Proxy that = (ViewerCertificateProperty.Jsii$Proxy) o;

                if (this.acmCertificateArn != null ? !this.acmCertificateArn.equals(that.acmCertificateArn) : that.acmCertificateArn != null) return false;
                if (this.cloudFrontDefaultCertificate != null ? !this.cloudFrontDefaultCertificate.equals(that.cloudFrontDefaultCertificate) : that.cloudFrontDefaultCertificate != null) return false;
                if (this.iamCertificateId != null ? !this.iamCertificateId.equals(that.iamCertificateId) : that.iamCertificateId != null) return false;
                if (this.minimumProtocolVersion != null ? !this.minimumProtocolVersion.equals(that.minimumProtocolVersion) : that.minimumProtocolVersion != null) return false;
                return this.sslSupportMethod != null ? this.sslSupportMethod.equals(that.sslSupportMethod) : that.sslSupportMethod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acmCertificateArn != null ? this.acmCertificateArn.hashCode() : 0;
                result = 31 * result + (this.cloudFrontDefaultCertificate != null ? this.cloudFrontDefaultCertificate.hashCode() : 0);
                result = 31 * result + (this.iamCertificateId != null ? this.iamCertificateId.hashCode() : 0);
                result = 31 * result + (this.minimumProtocolVersion != null ? this.minimumProtocolVersion.hashCode() : 0);
                result = 31 * result + (this.sslSupportMethod != null ? this.sslSupportMethod.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder();
        }

        /**
         * The distribution's configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig</a>
         * @param distributionConfig The distribution's configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.IResolvable distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }
        /**
         * The distribution's configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig</a>
         * @param distributionConfig The distribution's configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        /**
         * A complex type that contains zero or more <code>Tag</code> elements.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags</a>
         * @param tags A complex type that contains zero or more <code>Tag</code> elements. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CfnDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
