package software.amazon.awscdk.services.cloudtrail;

/**
 * Options for adding an event selector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudtrail.*;
 * Bucket sourceBucket;
 * Artifact sourceOutput = new Artifact();
 * String key = "some/key.zip";
 * Trail trail = new Trail(this, "CloudTrail");
 * trail.addS3EventSelector(List.of(S3EventSelector.builder()
 *         .bucket(sourceBucket)
 *         .objectPrefix(key)
 *         .build()), AddEventSelectorOptions.builder()
 *         .readWriteType(ReadWriteType.WRITE_ONLY)
 *         .build());
 * S3SourceAction sourceAction = S3SourceAction.Builder.create()
 *         .actionName("S3Source")
 *         .bucketKey(key)
 *         .bucket(sourceBucket)
 *         .output(sourceOutput)
 *         .trigger(S3Trigger.EVENTS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.372Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.AddEventSelectorOptions")
@software.amazon.jsii.Jsii.Proxy(AddEventSelectorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddEventSelectorOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * An optional list of service event sources from which you do not want management events to be logged on your trail.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources> getExcludeManagementEventSources() {
        return null;
    }

    /**
     * Specifies whether the event selector includes management events for the trail.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeManagementEvents() {
        return null;
    }

    /**
     * Specifies whether to log read-only events, write-only events, or all events.
     * <p>
     * Default: ReadWriteType.All
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.ReadWriteType getReadWriteType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddEventSelectorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddEventSelectorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddEventSelectorOptions> {
        java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources> excludeManagementEventSources;
        java.lang.Boolean includeManagementEvents;
        software.amazon.awscdk.services.cloudtrail.ReadWriteType readWriteType;

        /**
         * Sets the value of {@link AddEventSelectorOptions#getExcludeManagementEventSources}
         * @param excludeManagementEventSources An optional list of service event sources from which you do not want management events to be logged on your trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder excludeManagementEventSources(java.util.List<? extends software.amazon.awscdk.services.cloudtrail.ManagementEventSources> excludeManagementEventSources) {
            this.excludeManagementEventSources = (java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources>)excludeManagementEventSources;
            return this;
        }

        /**
         * Sets the value of {@link AddEventSelectorOptions#getIncludeManagementEvents}
         * @param includeManagementEvents Specifies whether the event selector includes management events for the trail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeManagementEvents(java.lang.Boolean includeManagementEvents) {
            this.includeManagementEvents = includeManagementEvents;
            return this;
        }

        /**
         * Sets the value of {@link AddEventSelectorOptions#getReadWriteType}
         * @param readWriteType Specifies whether to log read-only events, write-only events, or all events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readWriteType(software.amazon.awscdk.services.cloudtrail.ReadWriteType readWriteType) {
            this.readWriteType = readWriteType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddEventSelectorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddEventSelectorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddEventSelectorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddEventSelectorOptions {
        private final java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources> excludeManagementEventSources;
        private final java.lang.Boolean includeManagementEvents;
        private final software.amazon.awscdk.services.cloudtrail.ReadWriteType readWriteType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.excludeManagementEventSources = software.amazon.jsii.Kernel.get(this, "excludeManagementEventSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudtrail.ManagementEventSources.class)));
            this.includeManagementEvents = software.amazon.jsii.Kernel.get(this, "includeManagementEvents", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readWriteType = software.amazon.jsii.Kernel.get(this, "readWriteType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudtrail.ReadWriteType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.excludeManagementEventSources = (java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources>)builder.excludeManagementEventSources;
            this.includeManagementEvents = builder.includeManagementEvents;
            this.readWriteType = builder.readWriteType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudtrail.ManagementEventSources> getExcludeManagementEventSources() {
            return this.excludeManagementEventSources;
        }

        @Override
        public final java.lang.Boolean getIncludeManagementEvents() {
            return this.includeManagementEvents;
        }

        @Override
        public final software.amazon.awscdk.services.cloudtrail.ReadWriteType getReadWriteType() {
            return this.readWriteType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExcludeManagementEventSources() != null) {
                data.set("excludeManagementEventSources", om.valueToTree(this.getExcludeManagementEventSources()));
            }
            if (this.getIncludeManagementEvents() != null) {
                data.set("includeManagementEvents", om.valueToTree(this.getIncludeManagementEvents()));
            }
            if (this.getReadWriteType() != null) {
                data.set("readWriteType", om.valueToTree(this.getReadWriteType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.AddEventSelectorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddEventSelectorOptions.Jsii$Proxy that = (AddEventSelectorOptions.Jsii$Proxy) o;

            if (this.excludeManagementEventSources != null ? !this.excludeManagementEventSources.equals(that.excludeManagementEventSources) : that.excludeManagementEventSources != null) return false;
            if (this.includeManagementEvents != null ? !this.includeManagementEvents.equals(that.includeManagementEvents) : that.includeManagementEvents != null) return false;
            return this.readWriteType != null ? this.readWriteType.equals(that.readWriteType) : that.readWriteType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.excludeManagementEventSources != null ? this.excludeManagementEventSources.hashCode() : 0;
            result = 31 * result + (this.includeManagementEvents != null ? this.includeManagementEvents.hashCode() : 0);
            result = 31 * result + (this.readWriteType != null ? this.readWriteType.hashCode() : 0);
            return result;
        }
    }
}
