package software.amazon.awscdk.services.codebuild;

/**
 * An object that represents a group of filter conditions for a webhook.
 * <p>
 * Every condition in a given FilterGroup must be true in order for the whole group to be true.
 * You construct instances of it by calling the <code>#inEventOf</code> static factory method,
 * and then calling various <code>andXyz</code> instance methods to create modified instances of it
 * (this class is immutable).
 * <p>
 * You pass instances of this class to the <code>webhookFilters</code> property when constructing a source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISource gitHubSource = Source.gitHub(GitHubSourceProps.builder()
 *         .owner("awslabs")
 *         .repo("aws-cdk")
 *         .webhook(true) // optional, default: true if `webhookFilters` were provided, false otherwise
 *         .webhookTriggersBatchBuild(true) // optional, default is false
 *         .webhookFilters(List.of(FilterGroup.inEventOf(EventAction.PUSH).andBranchIs("main").andCommitMessageIs("the commit message")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:29.632Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.FilterGroup")
public class FilterGroup extends software.amazon.jsii.JsiiObject {

    protected FilterGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FilterGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new event FilterGroup that triggers on any of the provided actions.
     * <p>
     * @param actions the actions to trigger the webhook on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup inEventOf(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.EventAction... actions) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.FilterGroup.class, "inEventOf", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), java.util.Arrays.<Object>stream(actions).toArray(Object[]::new));
    }

    /**
     * Create a new FilterGroup with an added condition: the account ID of the actor initiating the event must match the given pattern.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andActorAccountIs(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andActorAccountIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the account ID of the actor initiating the event must not match the given pattern.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andActorAccountIsNot(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andActorAccountIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must target the given base branch.
     * <p>
     * Note that you cannot use this method if this Group contains the <code>PUSH</code> event action.
     * <p>
     * @param branchName the name of the branch (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBaseBranchIs(final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.Kernel.call(this, "andBaseBranchIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must not target the given base branch.
     * <p>
     * Note that you cannot use this method if this Group contains the <code>PUSH</code> event action.
     * <p>
     * @param branchName the name of the branch (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBaseBranchIsNot(final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.Kernel.call(this, "andBaseBranchIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must target the given Git reference.
     * <p>
     * Note that you cannot use this method if this Group contains the <code>PUSH</code> event action.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBaseRefIs(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andBaseRefIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the Pull Request that is the source of the event must not target the given Git reference.
     * <p>
     * Note that you cannot use this method if this Group contains the <code>PUSH</code> event action.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBaseRefIsNot(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andBaseRefIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must affect the given branch.
     * <p>
     * @param branchName the name of the branch (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBranchIs(final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.Kernel.call(this, "andBranchIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must not affect the given branch.
     * <p>
     * @param branchName the name of the branch (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andBranchIsNot(final @org.jetbrains.annotations.NotNull java.lang.String branchName) {
        return software.amazon.jsii.Kernel.call(this, "andBranchIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(branchName, "branchName is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must affect a head commit with the given message.
     * <p>
     * @param commitMessage the commit message (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andCommitMessageIs(final @org.jetbrains.annotations.NotNull java.lang.String commitMessage) {
        return software.amazon.jsii.Kernel.call(this, "andCommitMessageIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(commitMessage, "commitMessage is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must not affect a head commit with the given message.
     * <p>
     * @param commitMessage the commit message (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andCommitMessageIsNot(final @org.jetbrains.annotations.NotNull java.lang.String commitMessage) {
        return software.amazon.jsii.Kernel.call(this, "andCommitMessageIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(commitMessage, "commitMessage is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the push that is the source of the event must affect a file that matches the given pattern.
     * <p>
     * Note that you can only use this method if this Group contains only the <code>PUSH</code> event action,
     * and only for GitHub, Bitbucket and GitHubEnterprise sources.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andFilePathIs(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andFilePathIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the push that is the source of the event must not affect a file that matches the given pattern.
     * <p>
     * Note that you can only use this method if this Group contains only the <code>PUSH</code> event action,
     * and only for GitHub, Bitbucket and GitHubEnterprise sources.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andFilePathIsNot(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andFilePathIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must affect a Git reference (ie., a branch or a tag) that matches the given pattern.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andHeadRefIs(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andHeadRefIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must not affect a Git reference (ie., a branch or a tag) that matches the given pattern.
     * <p>
     * @param pattern a regular expression. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andHeadRefIsNot(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
        return software.amazon.jsii.Kernel.call(this, "andHeadRefIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must affect the given tag.
     * <p>
     * @param tagName the name of the tag (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andTagIs(final @org.jetbrains.annotations.NotNull java.lang.String tagName) {
        return software.amazon.jsii.Kernel.call(this, "andTagIs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(tagName, "tagName is required") });
    }

    /**
     * Create a new FilterGroup with an added condition: the event must not affect the given tag.
     * <p>
     * @param tagName the name of the tag (can be a regular expression). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.FilterGroup andTagIsNot(final @org.jetbrains.annotations.NotNull java.lang.String tagName) {
        return software.amazon.jsii.Kernel.call(this, "andTagIsNot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.FilterGroup.class), new Object[] { java.util.Objects.requireNonNull(tagName, "tagName is required") });
    }
}
