package software.amazon.awscdk.services.ec2;

/**
 * This represents a single EC2 instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * // instance to add as the target for load balancer.
 * Instance instance = Instance.Builder.create(this, "targetInstance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(AmazonLinuxImage.Builder.create().generation(AmazonLinuxGeneration.AMAZON_LINUX_2).build())
 *         .build();
 * lb.addTarget(new InstanceTarget(instance));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:31.484Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.Instance")
public class Instance extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ec2.IInstance {

    protected Instance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Instance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Instance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add the security group to the instance.
     * <p>
     * @param securityGroup : The security group to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(securityGroup, "securityGroup is required") });
    }

    /**
     * Adds a statement to the IAM role assumed by the instance.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Add command to the startup script of the instance.
     * <p>
     * The command must be in the scripting language supported by the instance's OS (i.e. Linux/Windows).
     * <p>
     * @param commands This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addUserData(final @org.jetbrains.annotations.NotNull java.lang.String... commands) {
        software.amazon.jsii.Kernel.call(this, "addUserData", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(commands).toArray(Object[]::new));
    }

    /**
     * Allows specify security group connections for the instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * the underlying instance resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnInstance getInstance() {
        return software.amazon.jsii.Kernel.get(this, "instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CfnInstance.class));
    }

    /**
     * The availability zone the instance was launched in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "instanceAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The instance's ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceId() {
        return software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Private DNS name for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateDnsName() {
        return software.amazon.jsii.Kernel.get(this, "instancePrivateDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Private IP for this instance.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePrivateIp() {
        return software.amazon.jsii.Kernel.get(this, "instancePrivateIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Publicly-routable DNS name for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicDnsName() {
        return software.amazon.jsii.Kernel.get(this, "instancePublicDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Publicly-routable IP  address for this instance.
     * <p>
     * (May be an empty string if the instance does not have a public IP).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstancePublicIp() {
        return software.amazon.jsii.Kernel.get(this, "instancePublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of OS the instance is running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getOsType() {
        return software.amazon.jsii.Kernel.get(this, "osType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
    }

    /**
     * The IAM role assumed by the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * UserData for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData getUserData() {
        return software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Instance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Instance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.InstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.InstanceProps.Builder();
        }

        /**
         * Type of instance to launch.
         * <p>
         * @return {@code this}
         * @param instanceType Type of instance to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * AMI to launch.
         * <p>
         * @return {@code this}
         * @param machineImage AMI to launch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(final software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.props.machineImage(machineImage);
            return this;
        }

        /**
         * VPC to launch the instance in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the instance in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Whether the instance could initiate IPv6 connections to anywhere by default.
         * <p>
         * This property is only used when you do not provide a security group.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param allowAllIpv6Outbound Whether the instance could initiate IPv6 connections to anywhere by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllIpv6Outbound(final java.lang.Boolean allowAllIpv6Outbound) {
            this.props.allowAllIpv6Outbound(allowAllIpv6Outbound);
            return this;
        }

        /**
         * Whether the instance could initiate connections to anywhere by default.
         * <p>
         * This property is only used when you do not provide a security group.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * Whether to associate a public IP address to the primary network interface attached to this instance.
         * <p>
         * Default: - public IP address is automatically assigned based on default behavior
         * <p>
         * @return {@code this}
         * @param associatePublicIpAddress Whether to associate a public IP address to the primary network interface attached to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(final java.lang.Boolean associatePublicIpAddress) {
            this.props.associatePublicIpAddress(associatePublicIpAddress);
            return this;
        }

        /**
         * In which AZ to place the instance within the VPC.
         * <p>
         * Default: - Random zone.
         * <p>
         * @return {@code this}
         * @param availabilityZone In which AZ to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(final java.lang.String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        /**
         * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         * <p>
         * Each instance that is launched has an associated root device volume,
         * either an Amazon EBS volume or an instance store volume.
         * You can use block device mappings to specify additional EBS volumes or
         * instance store volumes to attach to an instance when it is launched.
         * <p>
         * Default: - Uses the block device mapping of the AMI
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDevices(final java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.props.blockDevices(blockDevices);
            return this;
        }

        /**
         * Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://aws.amazon.com/cloudwatch/pricing/">http://aws.amazon.com/cloudwatch/pricing/</a>
         * @param detailedMonitoring Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(final java.lang.Boolean detailedMonitoring) {
            this.props.detailedMonitoring(detailedMonitoring);
            return this;
        }

        /**
         * Apply the given CloudFormation Init configuration to the instance at startup.
         * <p>
         * Default: - no CloudFormation init
         * <p>
         * @return {@code this}
         * @param init Apply the given CloudFormation Init configuration to the instance at startup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder init(final software.amazon.awscdk.services.ec2.CloudFormationInit init) {
            this.props.init(init);
            return this;
        }

        /**
         * Use the given options for applying CloudFormation Init.
         * <p>
         * Describes the configsets to use and the timeout to wait
         * <p>
         * Default: - default options
         * <p>
         * @return {@code this}
         * @param initOptions Use the given options for applying CloudFormation Init. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initOptions(final software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions) {
            this.props.initOptions(initOptions);
            return this;
        }

        /**
         * The name of the instance.
         * <p>
         * Default: - CDK generated name
         * <p>
         * @return {@code this}
         * @param instanceName The name of the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(final java.lang.String instanceName) {
            this.props.instanceName(instanceName);
            return this;
        }

        /**
         * (deprecated) Name of SSH keypair to grant access to instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @deprecated <ul>
         * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
         * </ul>
         * @param keyName Name of SSH keypair to grant access to instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(final java.lang.String keyName) {
            this.props.keyName(keyName);
            return this;
        }

        /**
         * The SSH keypair to grant access to the instance.
         * <p>
         * Default: - No SSH access will be possible.
         * <p>
         * @return {@code this}
         * @param keyPair The SSH keypair to grant access to the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(final software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.props.keyPair(keyPair);
            return this;
        }

        /**
         * Defines a private IP address to associate with an instance.
         * <p>
         * Private IP should be available within the VPC that the instance is build within.
         * <p>
         * Default: - no association
         * <p>
         * @return {@code this}
         * @param privateIpAddress Defines a private IP address to associate with an instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(final java.lang.String privateIpAddress) {
            this.props.privateIpAddress(privateIpAddress);
            return this;
        }

        /**
         * Propagate the EC2 instance tags to the EBS volumes.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param propagateTagsToVolumeOnCreation Propagate the EC2 instance tags to the EBS volumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(final java.lang.Boolean propagateTagsToVolumeOnCreation) {
            this.props.propagateTagsToVolumeOnCreation(propagateTagsToVolumeOnCreation);
            return this;
        }

        /**
         * Whether IMDSv2 should be required on this instance.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param requireImdsv2 Whether IMDSv2 should be required on this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(final java.lang.Boolean requireImdsv2) {
            this.props.requireImdsv2(requireImdsv2);
            return this;
        }

        /**
         * The length of time to wait for the resourceSignalCount.
         * <p>
         * The maximum value is 43200 (12 hours).
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(final software.amazon.awscdk.Duration resourceSignalTimeout) {
            this.props.resourceSignalTimeout(resourceSignalTimeout);
            return this;
        }

        /**
         * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         * <p>
         * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         * <p>
         * Default: - A role will automatically be created, it can be accessed via the `role` property
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * Role role = Role.Builder.create(this, "MyRole")
         *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Security Group to assign to this instance.
         * <p>
         * Default: - create new security group
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Specifies whether to enable an instance launched in a VPC to perform NAT.
         * <p>
         * This controls whether source/destination checking is enabled on the instance.
         * A value of true means that checking is enabled, and false means that checking is disabled.
         * The value must be false for the instance to perform NAT.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(final java.lang.Boolean sourceDestCheck) {
            this.props.sourceDestCheck(sourceDestCheck);
            return this;
        }

        /**
         * Add SSM session permissions to the instance role.
         * <p>
         * Setting this to <code>true</code> adds the necessary permissions to connect
         * to the instance using SSM Session Manager. You can do this
         * from the AWS Console.
         * <p>
         * NOTE: Setting this flag to <code>true</code> may not be enough by itself.
         * You must also use an AMI that comes with the SSM Agent, or install
         * the SSM Agent yourself. See
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
         * in the SSM Developer Guide.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ssmSessionPermissions Add SSM session permissions to the instance role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(final java.lang.Boolean ssmSessionPermissions) {
            this.props.ssmSessionPermissions(ssmSessionPermissions);
            return this;
        }

        /**
         * Specific UserData to use.
         * <p>
         * The UserData may still be mutated after creation.
         * <p>
         * Default: - A UserData object appropriate for the MachineImage's
         * Operating System is created.
         * <p>
         * @return {@code this}
         * @param userData Specific UserData to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props.userData(userData);
            return this;
        }

        /**
         * Changes to the UserData force replacement.
         * <p>
         * Depending the EC2 instance type, changing UserData either
         * restarts the instance or replaces the instance.
         * <p>
         * <ul>
         * <li>Instance store-backed instances are replaced.</li>
         * <li>EBS-backed instances are restarted.</li>
         * </ul>
         * <p>
         * By default, restarting does not execute the new UserData so you
         * will need a different mechanism to ensure the instance is restarted.
         * <p>
         * Setting this to <code>true</code> will make the instance's Logical ID depend on the
         * UserData, which will cause CloudFormation to replace it if the UserData
         * changes.
         * <p>
         * Default: - true iff `initOptions` is specified, false otherwise.
         * <p>
         * @return {@code this}
         * @param userDataCausesReplacement Changes to the UserData force replacement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userDataCausesReplacement(final java.lang.Boolean userDataCausesReplacement) {
            this.props.userDataCausesReplacement(userDataCausesReplacement);
            return this;
        }

        /**
         * Where to place the instance within the VPC.
         * <p>
         * Default: - Private subnets.
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instance within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.Instance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Instance build() {
            return new software.amazon.awscdk.services.ec2.Instance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
