package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * What kind of addresses to allocate to the load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         // Whether HTTP/2 is enabled
 *         .http2Enabled(false)
 *         // The idle timeout value, in seconds
 *         .idleTimeout(Duration.seconds(1000))
 *         // Whether HTTP headers with header fields thatare not valid
 *         // are removed by the load balancer (true), or routed to targets
 *         .dropInvalidHeaderFields(true)
 *         // How the load balancer handles requests that might
 *         // pose a security risk to your application
 *         .desyncMitigationMode(DesyncMitigationMode.DEFENSIVE)
 *         // The type of IP addresses to use.
 *         .ipAddressType(IpAddressType.IPV4)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:32.490Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.IpAddressType")
public enum IpAddressType {
    /**
     * Allocate IPv4 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Allocate both IPv4 and IPv6 addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUAL_STACK,
}
