package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::CoreDefinition</code> resource represents a core definition for AWS IoT Greengrass .
 * <p>
 * Core definitions are used to organize your core definition versions.
 * <p>
 * Core definitions can reference multiple core definition versions. All core definition versions must be associated with a core definition. Each core definition version can contain one Greengrass core.
 * <p>
 * <blockquote>
 * <p>
 * When you create a core definition, you can optionally include an initial core definition version. To associate a core definition version later, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html"><code>AWS::Greengrass::CoreDefinitionVersion</code></a> resource and specify the ID of this core definition.
 * <p>
 * After you create the core definition version that contains the core you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object tags;
 * CfnCoreDefinition cfnCoreDefinition = CfnCoreDefinition.Builder.create(this, "MyCfnCoreDefinition")
 *         .name("name")
 *         // the properties below are optional
 *         .initialVersion(CoreDefinitionVersionProperty.builder()
 *                 .cores(List.of(CoreProperty.builder()
 *                         .certificateArn("certificateArn")
 *                         .id("id")
 *                         .thingArn("thingArn")
 *                         // the properties below are optional
 *                         .syncShadow(false)
 *                         .build()))
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:33.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnCoreDefinition")
public class CfnCoreDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCoreDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCoreDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnCoreDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCoreDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnCoreDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the <code>CoreDefinition</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/cores/1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the <code>CoreDefinition</code> , such as <code>1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the last <code>CoreDefinitionVersion</code> that was added to the <code>CoreDefinition</code> , such as <code>arn:aws:greengrass:us-east-1:  :/greengrass/definition/cores/1234a5b6-78cd-901e-2fgh-3i45j6k178l9/versions/9876ac30-4bdb-4f9d-95af-b5fdb66be1a2</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLatestVersionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>CoreDefinition</code> , such as <code>MyCoreDefinition</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the core definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the core definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The core definition version to include when the core definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialVersion() {
        return software.amazon.jsii.Kernel.get(this, "initialVersion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The core definition version to include when the core definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * The core definition version to include when the core definition is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialVersion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrass.CfnCoreDefinition.CoreDefinitionVersionProperty value) {
        software.amazon.jsii.Kernel.set(this, "initialVersion", value);
    }

    /**
     * Application-specific metadata to attach to the core definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Application-specific metadata to attach to the core definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A core definition version contains a Greengrass <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html">core</a> .
     * <p>
     * <blockquote>
     * <p>
     * After you create a core definition version that contains the core you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>CoreDefinitionVersion</code> is the property type of the <code>InitialVersion</code> property in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html"><code>AWS::Greengrass::CoreDefinition</code></a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * CoreDefinitionVersionProperty coreDefinitionVersionProperty = CoreDefinitionVersionProperty.builder()
     *         .cores(List.of(CoreProperty.builder()
     *                 .certificateArn("certificateArn")
     *                 .id("id")
     *                 .thingArn("thingArn")
     *                 // the properties below are optional
     *                 .syncShadow(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnCoreDefinition.CoreDefinitionVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(CoreDefinitionVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CoreDefinitionVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Greengrass core in this version.
         * <p>
         * Currently, the <code>Cores</code> property for a core definition version can contain only one core.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html#cfn-greengrass-coredefinition-coredefinitionversion-cores">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html#cfn-greengrass-coredefinition-coredefinitionversion-cores</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCores();

        /**
         * @return a {@link Builder} of {@link CoreDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CoreDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CoreDefinitionVersionProperty> {
            java.lang.Object cores;

            /**
             * Sets the value of {@link CoreDefinitionVersionProperty#getCores}
             * @param cores The Greengrass core in this version. This parameter is required.
             *              Currently, the <code>Cores</code> property for a core definition version can contain only one core.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cores(software.amazon.awscdk.IResolvable cores) {
                this.cores = cores;
                return this;
            }

            /**
             * Sets the value of {@link CoreDefinitionVersionProperty#getCores}
             * @param cores The Greengrass core in this version. This parameter is required.
             *              Currently, the <code>Cores</code> property for a core definition version can contain only one core.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cores(java.util.List<? extends java.lang.Object> cores) {
                this.cores = cores;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CoreDefinitionVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CoreDefinitionVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CoreDefinitionVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoreDefinitionVersionProperty {
            private final java.lang.Object cores;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cores = software.amazon.jsii.Kernel.get(this, "cores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cores = java.util.Objects.requireNonNull(builder.cores, "cores is required");
            }

            @Override
            public final java.lang.Object getCores() {
                return this.cores;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cores", om.valueToTree(this.getCores()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnCoreDefinition.CoreDefinitionVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CoreDefinitionVersionProperty.Jsii$Proxy that = (CoreDefinitionVersionProperty.Jsii$Proxy) o;

                return this.cores.equals(that.cores);
            }

            @Override
            public final int hashCode() {
                int result = this.cores.hashCode();
                return result;
            }
        }
    }
    /**
     * A core is an AWS IoT device that runs the AWS IoT Greengrass core software and manages local processes for a Greengrass group.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/what-is-gg.html">What Is AWS IoT Greengrass ?</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Cores</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-coredefinitionversion.html"><code>CoreDefinitionVersion</code></a> property type contains a list of <code>Core</code> property types. Currently, the list can contain only one core.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * CoreProperty coreProperty = CoreProperty.builder()
     *         .certificateArn("certificateArn")
     *         .id("id")
     *         .thingArn("thingArn")
     *         // the properties below are optional
     *         .syncShadow(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnCoreDefinition.CoreProperty")
    @software.amazon.jsii.Jsii.Proxy(CoreProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CoreProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the device certificate for the core.
         * <p>
         * This X.509 certificate is used to authenticate the core with AWS IoT and AWS IoT Greengrass services.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn();

        /**
         * A descriptive or arbitrary ID for the core.
         * <p>
         * This value must be unique within the core definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The ARN of the core, which is an AWS IoT device (thing).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-thingarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-thingarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThingArn();

        /**
         * Indicates whether the core's local shadow is synced with the cloud automatically.
         * <p>
         * The default is false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-syncshadow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html#cfn-greengrass-coredefinition-core-syncshadow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSyncShadow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CoreProperty> {
            java.lang.String certificateArn;
            java.lang.String id;
            java.lang.String thingArn;
            java.lang.Object syncShadow;

            /**
             * Sets the value of {@link CoreProperty#getCertificateArn}
             * @param certificateArn The Amazon Resource Name (ARN) of the device certificate for the core. This parameter is required.
             *                       This X.509 certificate is used to authenticate the core with AWS IoT and AWS IoT Greengrass services.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link CoreProperty#getId}
             * @param id A descriptive or arbitrary ID for the core. This parameter is required.
             *           This value must be unique within the core definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link CoreProperty#getThingArn}
             * @param thingArn The ARN of the core, which is an AWS IoT device (thing). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingArn(java.lang.String thingArn) {
                this.thingArn = thingArn;
                return this;
            }

            /**
             * Sets the value of {@link CoreProperty#getSyncShadow}
             * @param syncShadow Indicates whether the core's local shadow is synced with the cloud automatically.
             *                   The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder syncShadow(java.lang.Boolean syncShadow) {
                this.syncShadow = syncShadow;
                return this;
            }

            /**
             * Sets the value of {@link CoreProperty#getSyncShadow}
             * @param syncShadow Indicates whether the core's local shadow is synced with the cloud automatically.
             *                   The default is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder syncShadow(software.amazon.awscdk.IResolvable syncShadow) {
                this.syncShadow = syncShadow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CoreProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CoreProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CoreProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String id;
            private final java.lang.String thingArn;
            private final java.lang.Object syncShadow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.syncShadow = software.amazon.jsii.Kernel.get(this, "syncShadow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = java.util.Objects.requireNonNull(builder.certificateArn, "certificateArn is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.thingArn = java.util.Objects.requireNonNull(builder.thingArn, "thingArn is required");
                this.syncShadow = builder.syncShadow;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getThingArn() {
                return this.thingArn;
            }

            @Override
            public final java.lang.Object getSyncShadow() {
                return this.syncShadow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("thingArn", om.valueToTree(this.getThingArn()));
                if (this.getSyncShadow() != null) {
                    data.set("syncShadow", om.valueToTree(this.getSyncShadow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnCoreDefinition.CoreProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CoreProperty.Jsii$Proxy that = (CoreProperty.Jsii$Proxy) o;

                if (!certificateArn.equals(that.certificateArn)) return false;
                if (!id.equals(that.id)) return false;
                if (!thingArn.equals(that.thingArn)) return false;
                return this.syncShadow != null ? this.syncShadow.equals(that.syncShadow) : that.syncShadow == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.thingArn.hashCode());
                result = 31 * result + (this.syncShadow != null ? this.syncShadow.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnCoreDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnCoreDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnCoreDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnCoreDefinitionProps.Builder();
        }

        /**
         * The name of the core definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-name</a>
         * @param name The name of the core definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The core definition version to include when the core definition is created.
         * <p>
         * Currently, a core definition version can contain only one <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html"><code>core</code></a> .
         * <p>
         * <blockquote>
         * <p>
         * To associate a core definition version after the core definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html"><code>AWS::Greengrass::CoreDefinitionVersion</code></a> resource and specify the ID of this core definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion</a>
         * @param initialVersion The core definition version to include when the core definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.IResolvable initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }
        /**
         * The core definition version to include when the core definition is created.
         * <p>
         * Currently, a core definition version can contain only one <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-coredefinition-core.html"><code>core</code></a> .
         * <p>
         * <blockquote>
         * <p>
         * To associate a core definition version after the core definition is created, create an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinitionversion.html"><code>AWS::Greengrass::CoreDefinitionVersion</code></a> resource and specify the ID of this core definition.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-initialversion</a>
         * @param initialVersion The core definition version to include when the core definition is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialVersion(final software.amazon.awscdk.services.greengrass.CfnCoreDefinition.CoreDefinitionVersionProperty initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        /**
         * Application-specific metadata to attach to the core definition.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/tagging.html">Tagging Your AWS IoT Greengrass Resources</a> in the <em>Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-coredefinition.html#cfn-greengrass-coredefinition-tags</a>
         * @param tags Application-specific metadata to attach to the core definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnCoreDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnCoreDefinition build() {
            return new software.amazon.awscdk.services.greengrass.CfnCoreDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
