package software.amazon.awscdk.services.lambda;

/**
 * Lambda service will automatically captures system logs about function invocation generated by the Lambda service (known as system logs) and sends these logs to a default CloudWatch log group named after the Lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.ILogGroup;
 * ILogGroup logGroup;
 * Function.Builder.create(this, "Lambda")
 *         .code(new InlineCode("foo"))
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .loggingFormat(LoggingFormat.JSON)
 *         .systemLogLevel(SystemLogLevel.INFO)
 *         .applicationLogLevel(ApplicationLogLevel.INFO)
 *         .logGroup(logGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:34.594Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.SystemLogLevel")
public enum SystemLogLevel {
    /**
     * Lambda will capture only logs at info level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Lambda will capture only logs at debug level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEBUG,
    /**
     * Lambda will capture only logs at warn level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WARN,
}
