package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a <code>CfnInAppTemplate</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object customConfig;
 * Object tags;
 * CfnInAppTemplateProps cfnInAppTemplateProps = CfnInAppTemplateProps.builder()
 *         .templateName("templateName")
 *         // the properties below are optional
 *         .content(List.of(InAppMessageContentProperty.builder()
 *                 .backgroundColor("backgroundColor")
 *                 .bodyConfig(BodyConfigProperty.builder()
 *                         .alignment("alignment")
 *                         .body("body")
 *                         .textColor("textColor")
 *                         .build())
 *                 .headerConfig(HeaderConfigProperty.builder()
 *                         .alignment("alignment")
 *                         .header("header")
 *                         .textColor("textColor")
 *                         .build())
 *                 .imageUrl("imageUrl")
 *                 .primaryBtn(ButtonConfigProperty.builder()
 *                         .android(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .borderRadius(123)
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .text("text")
 *                                 .textColor("textColor")
 *                                 .build())
 *                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .web(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .build())
 *                 .secondaryBtn(ButtonConfigProperty.builder()
 *                         .android(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .defaultConfig(DefaultButtonConfigurationProperty.builder()
 *                                 .backgroundColor("backgroundColor")
 *                                 .borderRadius(123)
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .text("text")
 *                                 .textColor("textColor")
 *                                 .build())
 *                         .ios(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .web(OverrideButtonConfigurationProperty.builder()
 *                                 .buttonAction("buttonAction")
 *                                 .link("link")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .customConfig(customConfig)
 *         .layout("layout")
 *         .tags(tags)
 *         .templateDescription("templateDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:35.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnInAppTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnInAppTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInAppTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the in-app message template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateName();

    /**
     * An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-content</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContent() {
        return null;
    }

    /**
     * Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-customconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-customconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConfig() {
        return null;
    }

    /**
     * A string that determines the appearance of the in-app message. You can specify one of the following:.
     * <p>
     * <ul>
     * <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
     * <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
     * <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
     * <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
     * <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
     * <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-layout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-layout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLayout() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * An optional description of the in-app template.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatedescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatedescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInAppTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInAppTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInAppTemplateProps> {
        java.lang.String templateName;
        java.lang.Object content;
        java.lang.Object customConfig;
        java.lang.String layout;
        java.lang.Object tags;
        java.lang.String templateDescription;

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getTemplateName}
         * @param templateName The name of the in-app message template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(java.lang.String templateName) {
            this.templateName = templateName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getContent}
         * @param content An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.IResolvable content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getContent}
         * @param content An object that contains information about the content of an in-app message, including its title and body text, text colors, background colors, images, buttons, and behaviors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(java.util.List<? extends java.lang.Object> content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getCustomConfig}
         * @param customConfig Custom data, in the form of key-value pairs, that is included in an in-app messaging payload.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customConfig(java.lang.Object customConfig) {
            this.customConfig = customConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getLayout}
         * @param layout A string that determines the appearance of the in-app message. You can specify one of the following:.
         *               <ul>
         *               <li><code>BOTTOM_BANNER</code> – a message that appears as a banner at the bottom of the page.</li>
         *               <li><code>TOP_BANNER</code> – a message that appears as a banner at the top of the page.</li>
         *               <li><code>OVERLAYS</code> – a message that covers entire screen.</li>
         *               <li><code>MOBILE_FEED</code> – a message that appears in a window in front of the page.</li>
         *               <li><code>MIDDLE_BANNER</code> – a message that appears as a banner in the middle of the page.</li>
         *               <li><code>CAROUSEL</code> – a scrollable layout of up to five unique messages.</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layout(java.lang.String layout) {
            this.layout = layout;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInAppTemplateProps#getTemplateDescription}
         * @param templateDescription An optional description of the in-app template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateDescription(java.lang.String templateDescription) {
            this.templateDescription = templateDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInAppTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInAppTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInAppTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInAppTemplateProps {
        private final java.lang.String templateName;
        private final java.lang.Object content;
        private final java.lang.Object customConfig;
        private final java.lang.String layout;
        private final java.lang.Object tags;
        private final java.lang.String templateDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateName = software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customConfig = software.amazon.jsii.Kernel.get(this, "customConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.layout = software.amazon.jsii.Kernel.get(this, "layout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateDescription = software.amazon.jsii.Kernel.get(this, "templateDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateName = java.util.Objects.requireNonNull(builder.templateName, "templateName is required");
            this.content = builder.content;
            this.customConfig = builder.customConfig;
            this.layout = builder.layout;
            this.tags = builder.tags;
            this.templateDescription = builder.templateDescription;
        }

        @Override
        public final java.lang.String getTemplateName() {
            return this.templateName;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.lang.Object getCustomConfig() {
            return this.customConfig;
        }

        @Override
        public final java.lang.String getLayout() {
            return this.layout;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateDescription() {
            return this.templateDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateName", om.valueToTree(this.getTemplateName()));
            if (this.getContent() != null) {
                data.set("content", om.valueToTree(this.getContent()));
            }
            if (this.getCustomConfig() != null) {
                data.set("customConfig", om.valueToTree(this.getCustomConfig()));
            }
            if (this.getLayout() != null) {
                data.set("layout", om.valueToTree(this.getLayout()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateDescription() != null) {
                data.set("templateDescription", om.valueToTree(this.getTemplateDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnInAppTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInAppTemplateProps.Jsii$Proxy that = (CfnInAppTemplateProps.Jsii$Proxy) o;

            if (!templateName.equals(that.templateName)) return false;
            if (this.content != null ? !this.content.equals(that.content) : that.content != null) return false;
            if (this.customConfig != null ? !this.customConfig.equals(that.customConfig) : that.customConfig != null) return false;
            if (this.layout != null ? !this.layout.equals(that.layout) : that.layout != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.templateDescription != null ? this.templateDescription.equals(that.templateDescription) : that.templateDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.templateName.hashCode();
            result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
            result = 31 * result + (this.customConfig != null ? this.customConfig.hashCode() : 0);
            result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateDescription != null ? this.templateDescription.hashCode() : 0);
            return result;
        }
    }
}
