package software.amazon.awscdk.services.rds;

/**
 * The versions for the MySQL instance engines (those returned by <code>DatabaseInstanceEngine.mysql</code>).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance iopsInstance = DatabaseInstance.Builder.create(this, "IopsInstance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_30).build()))
 *         .vpc(vpc)
 *         .storageType(StorageType.IO1)
 *         .iops(5000)
 *         .build();
 * DatabaseInstance gp3Instance = DatabaseInstance.Builder.create(this, "Gp3Instance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_30).build()))
 *         .vpc(vpc)
 *         .allocatedStorage(500)
 *         .storageType(StorageType.GP3)
 *         .storageThroughput(500)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:38.865Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.MysqlEngineVersion")
public class MysqlEngineVersion extends software.amazon.jsii.JsiiObject {

    protected MysqlEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MysqlEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_5_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_30 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_30", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_33 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_33", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_36 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_36", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_37 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_37", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_38 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_38", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_39 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_39", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_40 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_40", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_41 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_41", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_42 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_42", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_43 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_43", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_27 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_27", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_30 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_30", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_33 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_33", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
    }

    /**
     * Create a new MysqlEngineVersion with an arbitrary version.
     * <p>
     * @param mysqlFullVersion the full version string, for example "8.1.43". This parameter is required.
     * @param mysqlMajorVersion the major version of the engine, for example "8.1". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MysqlEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String mysqlFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String mysqlMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(mysqlFullVersion, "mysqlFullVersion is required"), java.util.Objects.requireNonNull(mysqlMajorVersion, "mysqlMajorVersion is required") });
    }

    /**
     * Version "5.7" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7;

    /**
     * Version "5.7.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_16;

    /**
     * Version "5.7.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_17;

    /**
     * Version "5.7.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_19;

    /**
     * Version "5.7.21".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_21;

    /**
     * Version "5.7.22".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_22;

    /**
     * Version "5.7.23".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_23;

    /**
     * Version "5.7.24".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_24;

    /**
     * Version "5.7.25".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_25;

    /**
     * Version "5.7.26".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_26;

    /**
     * Version "5.7.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_28;

    /**
     * Version "5.7.30".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_30;

    /**
     * Version "5.7.31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_31;

    /**
     * Version "5.7.33".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_33;

    /**
     * Version "5.7.34".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_34;

    /**
     * Version "5.7.35".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_35;

    /**
     * Version "5.7.36".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_36;

    /**
     * Version "5.7.37".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_37;

    /**
     * Version "5.7.38".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_38;

    /**
     * Version "5.7.39".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_39;

    /**
     * Version "5.7.40".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_40;

    /**
     * Version "5.7.41".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_41;

    /**
     * Version "5.7.42".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_42;

    /**
     * Version "5.7.43".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_43;

    /**
     * Version "5.7.44".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44;

    /**
     * Version "8.0" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0;

    /**
     * Version "8.0.11".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_11;

    /**
     * Version "8.0.13".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_13;

    /**
     * Version "8.0.15".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_15;

    /**
     * Version "8.0.16".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_16;

    /**
     * Version "8.0.17".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_17;

    /**
     * Version "8.0.19".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_19;

    /**
     * Version "8.0.20 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_20;

    /**
     * Version "8.0.21 ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_21;

    /**
     * Version "8.0.23".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_23;

    /**
     * Version "8.0.25".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_25;

    /**
     * Version "8.0.26".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_26;

    /**
     * Version "8.0.27".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_27;

    /**
     * Version "8.0.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_28;

    /**
     * Version "8.0.30".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_30;

    /**
     * Version "8.0.31".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_31;

    /**
     * Version "8.0.32".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_32;

    /**
     * Version "8.0.33".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_33;

    /**
     * Version "8.0.34".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_34;

    /**
     * Version "8.0.35".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_35;

    /**
     * The full version string, for example, "10.5.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMysqlFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "mysqlFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "10.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMysqlMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "mysqlMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
