package software.amazon.awscdk.services.route53recoverycontrol;

/**
 * Properties for defining a <code>CfnSafetyRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoverycontrol.*;
 * CfnSafetyRuleProps cfnSafetyRuleProps = CfnSafetyRuleProps.builder()
 *         .controlPanelArn("controlPanelArn")
 *         .name("name")
 *         .ruleConfig(RuleConfigProperty.builder()
 *                 .inverted(false)
 *                 .threshold(123)
 *                 .type("type")
 *                 .build())
 *         // the properties below are optional
 *         .assertionRule(AssertionRuleProperty.builder()
 *                 .assertedControls(List.of("assertedControls"))
 *                 .waitPeriodMs(123)
 *                 .build())
 *         .gatingRule(GatingRuleProperty.builder()
 *                 .gatingControls(List.of("gatingControls"))
 *                 .targetControls(List.of("targetControls"))
 *                 .waitPeriodMs(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:39.186Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnSafetyRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSafetyRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the control panel.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-controlpanelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-controlpanelarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getControlPanelArn();

    /**
     * The name of the assertion rule.
     * <p>
     * The name must be unique within a control panel. You can use any non-white space character in the name except the following: &amp; &gt; &lt; ' (single quote) " (double quote) ; (semicolon)
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction.
     * <p>
     * For example, if you have three assertion controls, you might specify <code>ATLEAST 2</code> for your rule configuration. This means that at least two assertion controls must be <code>ON</code> , so that at least two AWS Regions have traffic flowing to them.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-ruleconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRuleConfig();

    /**
     * An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
     * <p>
     * Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-assertionrule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssertionRule() {
        return null;
    }

    /**
     * A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
     * <p>
     * For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-gatingrule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGatingRule() {
        return null;
    }

    /**
     * The tags associated with the safety rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoverycontrol-safetyrule.html#cfn-route53recoverycontrol-safetyrule-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSafetyRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSafetyRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSafetyRuleProps> {
        java.lang.String controlPanelArn;
        java.lang.String name;
        java.lang.Object ruleConfig;
        java.lang.Object assertionRule;
        java.lang.Object gatingRule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getControlPanelArn}
         * @param controlPanelArn The Amazon Resource Name (ARN) of the control panel. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder controlPanelArn(java.lang.String controlPanelArn) {
            this.controlPanelArn = controlPanelArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getName}
         * @param name The name of the assertion rule. This parameter is required.
         *             The name must be unique within a control panel. You can use any non-white space character in the name except the following: &amp; &gt; &lt; ' (single quote) " (double quote) ; (semicolon)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getRuleConfig}
         * @param ruleConfig The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction. This parameter is required.
         *                   For example, if you have three assertion controls, you might specify <code>ATLEAST 2</code> for your rule configuration. This means that at least two assertion controls must be <code>ON</code> , so that at least two AWS Regions have traffic flowing to them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleConfig(software.amazon.awscdk.IResolvable ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getRuleConfig}
         * @param ruleConfig The criteria that you set for specific assertion controls (routing controls) that designate how many control states must be <code>ON</code> as the result of a transaction. This parameter is required.
         *                   For example, if you have three assertion controls, you might specify <code>ATLEAST 2</code> for your rule configuration. This means that at least two assertion controls must be <code>ON</code> , so that at least two AWS Regions have traffic flowing to them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleConfig(software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.RuleConfigProperty ruleConfig) {
            this.ruleConfig = ruleConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getAssertionRule}
         * @param assertionRule An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
         *                      Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionRule(software.amazon.awscdk.IResolvable assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getAssertionRule}
         * @param assertionRule An assertion rule enforces that, when you change a routing control state, that the criteria that you set in the rule configuration is met.
         *                      Otherwise, the change to the routing control is not accepted. For example, the criteria might be that at least one routing control state is <code>On</code> after the transaction so that traffic continues to flow to at least one cell for the application. This ensures that you avoid a fail-open scenario.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionRule(software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.AssertionRuleProperty assertionRule) {
            this.assertionRule = assertionRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getGatingRule}
         * @param gatingRule A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
         *                   For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatingRule(software.amazon.awscdk.IResolvable gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getGatingRule}
         * @param gatingRule A gating rule verifies that a gating routing control or set of gating routing controls, evaluates as true, based on a rule configuration that you specify, which allows a set of routing control state changes to complete.
         *                   For example, if you specify one gating routing control and you set the <code>Type</code> in the rule configuration to <code>OR</code> , that indicates that you must set the gating routing control to <code>On</code> for the rule to evaluate as true; that is, for the gating control switch to be On. When you do that, then you can update the routing control states for the target routing controls that you specify in the gating rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatingRule(software.amazon.awscdk.services.route53recoverycontrol.CfnSafetyRule.GatingRuleProperty gatingRule) {
            this.gatingRule = gatingRule;
            return this;
        }

        /**
         * Sets the value of {@link CfnSafetyRuleProps#getTags}
         * @param tags The tags associated with the safety rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSafetyRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSafetyRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSafetyRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSafetyRuleProps {
        private final java.lang.String controlPanelArn;
        private final java.lang.String name;
        private final java.lang.Object ruleConfig;
        private final java.lang.Object assertionRule;
        private final java.lang.Object gatingRule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.controlPanelArn = software.amazon.jsii.Kernel.get(this, "controlPanelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleConfig = software.amazon.jsii.Kernel.get(this, "ruleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assertionRule = software.amazon.jsii.Kernel.get(this, "assertionRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.gatingRule = software.amazon.jsii.Kernel.get(this, "gatingRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.controlPanelArn = java.util.Objects.requireNonNull(builder.controlPanelArn, "controlPanelArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.ruleConfig = java.util.Objects.requireNonNull(builder.ruleConfig, "ruleConfig is required");
            this.assertionRule = builder.assertionRule;
            this.gatingRule = builder.gatingRule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getControlPanelArn() {
            return this.controlPanelArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRuleConfig() {
            return this.ruleConfig;
        }

        @Override
        public final java.lang.Object getAssertionRule() {
            return this.assertionRule;
        }

        @Override
        public final java.lang.Object getGatingRule() {
            return this.gatingRule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("controlPanelArn", om.valueToTree(this.getControlPanelArn()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("ruleConfig", om.valueToTree(this.getRuleConfig()));
            if (this.getAssertionRule() != null) {
                data.set("assertionRule", om.valueToTree(this.getAssertionRule()));
            }
            if (this.getGatingRule() != null) {
                data.set("gatingRule", om.valueToTree(this.getGatingRule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoverycontrol.CfnSafetyRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSafetyRuleProps.Jsii$Proxy that = (CfnSafetyRuleProps.Jsii$Proxy) o;

            if (!controlPanelArn.equals(that.controlPanelArn)) return false;
            if (!name.equals(that.name)) return false;
            if (!ruleConfig.equals(that.ruleConfig)) return false;
            if (this.assertionRule != null ? !this.assertionRule.equals(that.assertionRule) : that.assertionRule != null) return false;
            if (this.gatingRule != null ? !this.gatingRule.equals(that.gatingRule) : that.gatingRule != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.controlPanelArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.ruleConfig.hashCode());
            result = 31 * result + (this.assertionRule != null ? this.assertionRule.hashCode() : 0);
            result = 31 * result + (this.gatingRule != null ? this.gatingRule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
