package software.amazon.awscdk.services.s3;

/**
 * The <code>AWS::S3::StorageLensGroup</code> resource creates an S3 Storage Lens group.
 * <p>
 * A Storage Lens group is a custom grouping of objects that include filters for prefixes, suffixes, object tags, object size, or object age. You can create an S3 Storage Lens group that includes a single filter or multiple filter conditions. To specify multiple filter conditions, you use <code>AND</code> or <code>OR</code> logical operators. For more information about S3 Storage Lens groups, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-lens-groups-overview.html">Working with S3 Storage Lens groups</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * CfnStorageLensGroup cfnStorageLensGroup = CfnStorageLensGroup.Builder.create(this, "MyCfnStorageLensGroup")
 *         .filter(FilterProperty.builder()
 *                 .and(AndProperty.builder()
 *                         .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                         .matchAnySuffix(List.of("matchAnySuffix"))
 *                         .matchAnyTag(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .matchObjectAge(MatchObjectAgeProperty.builder()
 *                                 .daysGreaterThan(123)
 *                                 .daysLessThan(123)
 *                                 .build())
 *                         .matchObjectSize(MatchObjectSizeProperty.builder()
 *                                 .bytesGreaterThan(123)
 *                                 .bytesLessThan(123)
 *                                 .build())
 *                         .build())
 *                 .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                 .matchAnySuffix(List.of("matchAnySuffix"))
 *                 .matchAnyTag(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .matchObjectAge(MatchObjectAgeProperty.builder()
 *                         .daysGreaterThan(123)
 *                         .daysLessThan(123)
 *                         .build())
 *                 .matchObjectSize(MatchObjectSizeProperty.builder()
 *                         .bytesGreaterThan(123)
 *                         .bytesLessThan(123)
 *                         .build())
 *                 .or(OrProperty.builder()
 *                         .matchAnyPrefix(List.of("matchAnyPrefix"))
 *                         .matchAnySuffix(List.of("matchAnySuffix"))
 *                         .matchAnyTag(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .matchObjectAge(MatchObjectAgeProperty.builder()
 *                                 .daysGreaterThan(123)
 *                                 .daysLessThan(123)
 *                                 .build())
 *                         .matchObjectSize(MatchObjectSizeProperty.builder()
 *                                 .bytesGreaterThan(123)
 *                                 .bytesLessThan(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:39.355Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup")
public class CfnStorageLensGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStorageLensGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStorageLensGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.s3.CfnStorageLensGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStorageLensGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnStorageLensGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN for the Amazon S3 Storage Lens Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLensGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLensGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * This property contains the criteria for the Storage Lens group data that is displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFilter() {
        return software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This property contains the criteria for the Storage Lens group data that is displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "filter", java.util.Objects.requireNonNull(value, "filter is required"));
    }

    /**
     * This property contains the criteria for the Storage Lens group data that is displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.CfnStorageLensGroup.FilterProperty value) {
        software.amazon.jsii.Kernel.set(this, "filter", java.util.Objects.requireNonNull(value, "filter is required"));
    }

    /**
     * This property contains the Storage Lens group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * This property contains the Storage Lens group name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * This property contains the AWS resource tags that you're adding to your Storage Lens group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * This property contains the AWS resource tags that you're adding to your Storage Lens group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * This resource is a logical operator that allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data.
     * <p>
     * Objects must match all of the listed filter conditions that are joined by the <code>And</code> logical operator. Only one of each filter condition is allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * AndProperty andProperty = AndProperty.builder()
     *         .matchAnyPrefix(List.of("matchAnyPrefix"))
     *         .matchAnySuffix(List.of("matchAnySuffix"))
     *         .matchAnyTag(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .matchObjectAge(MatchObjectAgeProperty.builder()
     *                 .daysGreaterThan(123)
     *                 .daysLessThan(123)
     *                 .build())
     *         .matchObjectSize(MatchObjectSizeProperty.builder()
     *                 .bytesGreaterThan(123)
     *                 .bytesLessThan(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup.AndProperty")
    @software.amazon.jsii.Jsii.Proxy(AndProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AndProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains a list of prefixes.
         * <p>
         * At least one prefix must be specified. Up to 10 prefixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnyPrefix() {
            return null;
        }

        /**
         * This property contains a list of suffixes.
         * <p>
         * At least one suffix must be specified. Up to 10 suffixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanysuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanysuffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnySuffix() {
            return null;
        }

        /**
         * This property contains the list of object tags.
         * <p>
         * At least one object tag must be specified. Up to 10 object tags are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanytag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchanytag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchAnyTag() {
            return null;
        }

        /**
         * This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> properties to define the object age range (minimum and maximum number of days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchobjectage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchobjectage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectAge() {
            return null;
        }

        /**
         * This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchobjectsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-and.html#cfn-s3-storagelensgroup-and-matchobjectsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AndProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AndProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AndProperty> {
            java.util.List<java.lang.String> matchAnyPrefix;
            java.util.List<java.lang.String> matchAnySuffix;
            java.lang.Object matchAnyTag;
            java.lang.Object matchObjectAge;
            java.lang.Object matchObjectSize;

            /**
             * Sets the value of {@link AndProperty#getMatchAnyPrefix}
             * @param matchAnyPrefix This property contains a list of prefixes.
             *                       At least one prefix must be specified. Up to 10 prefixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyPrefix(java.util.List<java.lang.String> matchAnyPrefix) {
                this.matchAnyPrefix = matchAnyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchAnySuffix}
             * @param matchAnySuffix This property contains a list of suffixes.
             *                       At least one suffix must be specified. Up to 10 suffixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnySuffix(java.util.List<java.lang.String> matchAnySuffix) {
                this.matchAnySuffix = matchAnySuffix;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(software.amazon.awscdk.IResolvable matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(java.util.List<? extends java.lang.Object> matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchObjectAge}
             * @param matchObjectAge This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> properties to define the object age range (minimum and maximum number of days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.IResolvable matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchObjectAge}
             * @param matchObjectAge This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> properties to define the object age range (minimum and maximum number of days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectAgeProperty matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.IResolvable matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Sets the value of {@link AndProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectSizeProperty matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AndProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AndProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AndProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AndProperty {
            private final java.util.List<java.lang.String> matchAnyPrefix;
            private final java.util.List<java.lang.String> matchAnySuffix;
            private final java.lang.Object matchAnyTag;
            private final java.lang.Object matchObjectAge;
            private final java.lang.Object matchObjectSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchAnyPrefix = software.amazon.jsii.Kernel.get(this, "matchAnyPrefix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnySuffix = software.amazon.jsii.Kernel.get(this, "matchAnySuffix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnyTag = software.amazon.jsii.Kernel.get(this, "matchAnyTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectAge = software.amazon.jsii.Kernel.get(this, "matchObjectAge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectSize = software.amazon.jsii.Kernel.get(this, "matchObjectSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchAnyPrefix = builder.matchAnyPrefix;
                this.matchAnySuffix = builder.matchAnySuffix;
                this.matchAnyTag = builder.matchAnyTag;
                this.matchObjectAge = builder.matchObjectAge;
                this.matchObjectSize = builder.matchObjectSize;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnyPrefix() {
                return this.matchAnyPrefix;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnySuffix() {
                return this.matchAnySuffix;
            }

            @Override
            public final java.lang.Object getMatchAnyTag() {
                return this.matchAnyTag;
            }

            @Override
            public final java.lang.Object getMatchObjectAge() {
                return this.matchObjectAge;
            }

            @Override
            public final java.lang.Object getMatchObjectSize() {
                return this.matchObjectSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMatchAnyPrefix() != null) {
                    data.set("matchAnyPrefix", om.valueToTree(this.getMatchAnyPrefix()));
                }
                if (this.getMatchAnySuffix() != null) {
                    data.set("matchAnySuffix", om.valueToTree(this.getMatchAnySuffix()));
                }
                if (this.getMatchAnyTag() != null) {
                    data.set("matchAnyTag", om.valueToTree(this.getMatchAnyTag()));
                }
                if (this.getMatchObjectAge() != null) {
                    data.set("matchObjectAge", om.valueToTree(this.getMatchObjectAge()));
                }
                if (this.getMatchObjectSize() != null) {
                    data.set("matchObjectSize", om.valueToTree(this.getMatchObjectSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroup.AndProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AndProperty.Jsii$Proxy that = (AndProperty.Jsii$Proxy) o;

                if (this.matchAnyPrefix != null ? !this.matchAnyPrefix.equals(that.matchAnyPrefix) : that.matchAnyPrefix != null) return false;
                if (this.matchAnySuffix != null ? !this.matchAnySuffix.equals(that.matchAnySuffix) : that.matchAnySuffix != null) return false;
                if (this.matchAnyTag != null ? !this.matchAnyTag.equals(that.matchAnyTag) : that.matchAnyTag != null) return false;
                if (this.matchObjectAge != null ? !this.matchObjectAge.equals(that.matchObjectAge) : that.matchObjectAge != null) return false;
                return this.matchObjectSize != null ? this.matchObjectSize.equals(that.matchObjectSize) : that.matchObjectSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchAnyPrefix != null ? this.matchAnyPrefix.hashCode() : 0;
                result = 31 * result + (this.matchAnySuffix != null ? this.matchAnySuffix.hashCode() : 0);
                result = 31 * result + (this.matchAnyTag != null ? this.matchAnyTag.hashCode() : 0);
                result = 31 * result + (this.matchObjectAge != null ? this.matchObjectAge.hashCode() : 0);
                result = 31 * result + (this.matchObjectSize != null ? this.matchObjectSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource sets the criteria for the Storage Lens group data that is displayed.
     * <p>
     * For multiple filter conditions, the <code>AND</code> or <code>OR</code> logical operator is used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * FilterProperty filterProperty = FilterProperty.builder()
     *         .and(AndProperty.builder()
     *                 .matchAnyPrefix(List.of("matchAnyPrefix"))
     *                 .matchAnySuffix(List.of("matchAnySuffix"))
     *                 .matchAnyTag(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .matchObjectAge(MatchObjectAgeProperty.builder()
     *                         .daysGreaterThan(123)
     *                         .daysLessThan(123)
     *                         .build())
     *                 .matchObjectSize(MatchObjectSizeProperty.builder()
     *                         .bytesGreaterThan(123)
     *                         .bytesLessThan(123)
     *                         .build())
     *                 .build())
     *         .matchAnyPrefix(List.of("matchAnyPrefix"))
     *         .matchAnySuffix(List.of("matchAnySuffix"))
     *         .matchAnyTag(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .matchObjectAge(MatchObjectAgeProperty.builder()
     *                 .daysGreaterThan(123)
     *                 .daysLessThan(123)
     *                 .build())
     *         .matchObjectSize(MatchObjectSizeProperty.builder()
     *                 .bytesGreaterThan(123)
     *                 .bytesLessThan(123)
     *                 .build())
     *         .or(OrProperty.builder()
     *                 .matchAnyPrefix(List.of("matchAnyPrefix"))
     *                 .matchAnySuffix(List.of("matchAnySuffix"))
     *                 .matchAnyTag(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .matchObjectAge(MatchObjectAgeProperty.builder()
     *                         .daysGreaterThan(123)
     *                         .daysLessThan(123)
     *                         .build())
     *                 .matchObjectSize(MatchObjectSizeProperty.builder()
     *                         .bytesGreaterThan(123)
     *                         .bytesLessThan(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup.FilterProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains the <code>And</code> logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data.
         * <p>
         * Objects must match all of the listed filter conditions that are joined by the <code>And</code> logical operator. Only one of each filter condition is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-and">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-and</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnd() {
            return null;
        }

        /**
         * This property contains a list of prefixes.
         * <p>
         * At least one prefix must be specified. Up to 10 prefixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnyPrefix() {
            return null;
        }

        /**
         * This property contains a list of suffixes.
         * <p>
         * At least one suffix must be specified. Up to 10 suffixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanysuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanysuffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnySuffix() {
            return null;
        }

        /**
         * This property contains the list of S3 object tags.
         * <p>
         * At least one object tag must be specified. Up to 10 object tags are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanytag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchanytag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchAnyTag() {
            return null;
        }

        /**
         * This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchobjectage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchobjectage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectAge() {
            return null;
        }

        /**
         * This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchobjectsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-matchobjectsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectSize() {
            return null;
        }

        /**
         * This property contains the <code>Or</code> logical operator, which allows multiple filter conditions to be joined.
         * <p>
         * Objects can match any of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-or">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-filter.html#cfn-s3-storagelensgroup-filter-or</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterProperty> {
            java.lang.Object and;
            java.util.List<java.lang.String> matchAnyPrefix;
            java.util.List<java.lang.String> matchAnySuffix;
            java.lang.Object matchAnyTag;
            java.lang.Object matchObjectAge;
            java.lang.Object matchObjectSize;
            java.lang.Object or;

            /**
             * Sets the value of {@link FilterProperty#getAnd}
             * @param and This property contains the <code>And</code> logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data.
             *            Objects must match all of the listed filter conditions that are joined by the <code>And</code> logical operator. Only one of each filter condition is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.IResolvable and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getAnd}
             * @param and This property contains the <code>And</code> logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data.
             *            Objects must match all of the listed filter conditions that are joined by the <code>And</code> logical operator. Only one of each filter condition is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.services.s3.CfnStorageLensGroup.AndProperty and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchAnyPrefix}
             * @param matchAnyPrefix This property contains a list of prefixes.
             *                       At least one prefix must be specified. Up to 10 prefixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyPrefix(java.util.List<java.lang.String> matchAnyPrefix) {
                this.matchAnyPrefix = matchAnyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchAnySuffix}
             * @param matchAnySuffix This property contains a list of suffixes.
             *                       At least one suffix must be specified. Up to 10 suffixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnySuffix(java.util.List<java.lang.String> matchAnySuffix) {
                this.matchAnySuffix = matchAnySuffix;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of S3 object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(software.amazon.awscdk.IResolvable matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of S3 object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(java.util.List<? extends java.lang.Object> matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchObjectAge}
             * @param matchObjectAge This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.IResolvable matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchObjectAge}
             * @param matchObjectAge This property contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectAgeProperty matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.IResolvable matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains <code>BytesGreaterThan</code> and <code>BytesLessThan</code> to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectSizeProperty matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getOr}
             * @param or This property contains the <code>Or</code> logical operator, which allows multiple filter conditions to be joined.
             *           Objects can match any of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(software.amazon.awscdk.IResolvable or) {
                this.or = or;
                return this;
            }

            /**
             * Sets the value of {@link FilterProperty#getOr}
             * @param or This property contains the <code>Or</code> logical operator, which allows multiple filter conditions to be joined.
             *           Objects can match any of the listed filter conditions, which are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(software.amazon.awscdk.services.s3.CfnStorageLensGroup.OrProperty or) {
                this.or = or;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterProperty {
            private final java.lang.Object and;
            private final java.util.List<java.lang.String> matchAnyPrefix;
            private final java.util.List<java.lang.String> matchAnySuffix;
            private final java.lang.Object matchAnyTag;
            private final java.lang.Object matchObjectAge;
            private final java.lang.Object matchObjectSize;
            private final java.lang.Object or;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.and = software.amazon.jsii.Kernel.get(this, "and", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchAnyPrefix = software.amazon.jsii.Kernel.get(this, "matchAnyPrefix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnySuffix = software.amazon.jsii.Kernel.get(this, "matchAnySuffix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnyTag = software.amazon.jsii.Kernel.get(this, "matchAnyTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectAge = software.amazon.jsii.Kernel.get(this, "matchObjectAge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectSize = software.amazon.jsii.Kernel.get(this, "matchObjectSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.or = software.amazon.jsii.Kernel.get(this, "or", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.and = builder.and;
                this.matchAnyPrefix = builder.matchAnyPrefix;
                this.matchAnySuffix = builder.matchAnySuffix;
                this.matchAnyTag = builder.matchAnyTag;
                this.matchObjectAge = builder.matchObjectAge;
                this.matchObjectSize = builder.matchObjectSize;
                this.or = builder.or;
            }

            @Override
            public final java.lang.Object getAnd() {
                return this.and;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnyPrefix() {
                return this.matchAnyPrefix;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnySuffix() {
                return this.matchAnySuffix;
            }

            @Override
            public final java.lang.Object getMatchAnyTag() {
                return this.matchAnyTag;
            }

            @Override
            public final java.lang.Object getMatchObjectAge() {
                return this.matchObjectAge;
            }

            @Override
            public final java.lang.Object getMatchObjectSize() {
                return this.matchObjectSize;
            }

            @Override
            public final java.lang.Object getOr() {
                return this.or;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnd() != null) {
                    data.set("and", om.valueToTree(this.getAnd()));
                }
                if (this.getMatchAnyPrefix() != null) {
                    data.set("matchAnyPrefix", om.valueToTree(this.getMatchAnyPrefix()));
                }
                if (this.getMatchAnySuffix() != null) {
                    data.set("matchAnySuffix", om.valueToTree(this.getMatchAnySuffix()));
                }
                if (this.getMatchAnyTag() != null) {
                    data.set("matchAnyTag", om.valueToTree(this.getMatchAnyTag()));
                }
                if (this.getMatchObjectAge() != null) {
                    data.set("matchObjectAge", om.valueToTree(this.getMatchObjectAge()));
                }
                if (this.getMatchObjectSize() != null) {
                    data.set("matchObjectSize", om.valueToTree(this.getMatchObjectSize()));
                }
                if (this.getOr() != null) {
                    data.set("or", om.valueToTree(this.getOr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroup.FilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterProperty.Jsii$Proxy that = (FilterProperty.Jsii$Proxy) o;

                if (this.and != null ? !this.and.equals(that.and) : that.and != null) return false;
                if (this.matchAnyPrefix != null ? !this.matchAnyPrefix.equals(that.matchAnyPrefix) : that.matchAnyPrefix != null) return false;
                if (this.matchAnySuffix != null ? !this.matchAnySuffix.equals(that.matchAnySuffix) : that.matchAnySuffix != null) return false;
                if (this.matchAnyTag != null ? !this.matchAnyTag.equals(that.matchAnyTag) : that.matchAnyTag != null) return false;
                if (this.matchObjectAge != null ? !this.matchObjectAge.equals(that.matchObjectAge) : that.matchObjectAge != null) return false;
                if (this.matchObjectSize != null ? !this.matchObjectSize.equals(that.matchObjectSize) : that.matchObjectSize != null) return false;
                return this.or != null ? this.or.equals(that.or) : that.or == null;
            }

            @Override
            public final int hashCode() {
                int result = this.and != null ? this.and.hashCode() : 0;
                result = 31 * result + (this.matchAnyPrefix != null ? this.matchAnyPrefix.hashCode() : 0);
                result = 31 * result + (this.matchAnySuffix != null ? this.matchAnySuffix.hashCode() : 0);
                result = 31 * result + (this.matchAnyTag != null ? this.matchAnyTag.hashCode() : 0);
                result = 31 * result + (this.matchObjectAge != null ? this.matchObjectAge.hashCode() : 0);
                result = 31 * result + (this.matchObjectSize != null ? this.matchObjectSize.hashCode() : 0);
                result = 31 * result + (this.or != null ? this.or.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource contains <code>DaysGreaterThan</code> and <code>DaysLessThan</code> to define the object age range (minimum and maximum number of days).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * MatchObjectAgeProperty matchObjectAgeProperty = MatchObjectAgeProperty.builder()
     *         .daysGreaterThan(123)
     *         .daysLessThan(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup.MatchObjectAgeProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchObjectAgeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchObjectAgeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property indicates the minimum object age in days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html#cfn-s3-storagelensgroup-matchobjectage-daysgreaterthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html#cfn-s3-storagelensgroup-matchobjectage-daysgreaterthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDaysGreaterThan() {
            return null;
        }

        /**
         * This property indicates the maximum object age in days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html#cfn-s3-storagelensgroup-matchobjectage-dayslessthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectage.html#cfn-s3-storagelensgroup-matchobjectage-dayslessthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDaysLessThan() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatchObjectAgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchObjectAgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchObjectAgeProperty> {
            java.lang.Number daysGreaterThan;
            java.lang.Number daysLessThan;

            /**
             * Sets the value of {@link MatchObjectAgeProperty#getDaysGreaterThan}
             * @param daysGreaterThan This property indicates the minimum object age in days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysGreaterThan(java.lang.Number daysGreaterThan) {
                this.daysGreaterThan = daysGreaterThan;
                return this;
            }

            /**
             * Sets the value of {@link MatchObjectAgeProperty#getDaysLessThan}
             * @param daysLessThan This property indicates the maximum object age in days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daysLessThan(java.lang.Number daysLessThan) {
                this.daysLessThan = daysLessThan;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchObjectAgeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchObjectAgeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchObjectAgeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchObjectAgeProperty {
            private final java.lang.Number daysGreaterThan;
            private final java.lang.Number daysLessThan;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daysGreaterThan = software.amazon.jsii.Kernel.get(this, "daysGreaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.daysLessThan = software.amazon.jsii.Kernel.get(this, "daysLessThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daysGreaterThan = builder.daysGreaterThan;
                this.daysLessThan = builder.daysLessThan;
            }

            @Override
            public final java.lang.Number getDaysGreaterThan() {
                return this.daysGreaterThan;
            }

            @Override
            public final java.lang.Number getDaysLessThan() {
                return this.daysLessThan;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDaysGreaterThan() != null) {
                    data.set("daysGreaterThan", om.valueToTree(this.getDaysGreaterThan()));
                }
                if (this.getDaysLessThan() != null) {
                    data.set("daysLessThan", om.valueToTree(this.getDaysLessThan()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroup.MatchObjectAgeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchObjectAgeProperty.Jsii$Proxy that = (MatchObjectAgeProperty.Jsii$Proxy) o;

                if (this.daysGreaterThan != null ? !this.daysGreaterThan.equals(that.daysGreaterThan) : that.daysGreaterThan != null) return false;
                return this.daysLessThan != null ? this.daysLessThan.equals(that.daysLessThan) : that.daysLessThan == null;
            }

            @Override
            public final int hashCode() {
                int result = this.daysGreaterThan != null ? this.daysGreaterThan.hashCode() : 0;
                result = 31 * result + (this.daysLessThan != null ? this.daysLessThan.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource filters objects that match the specified object size range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * MatchObjectSizeProperty matchObjectSizeProperty = MatchObjectSizeProperty.builder()
     *         .bytesGreaterThan(123)
     *         .bytesLessThan(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup.MatchObjectSizeProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchObjectSizeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchObjectSizeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property specifies the minimum object size in bytes.
         * <p>
         * The value must be a positive number, greater than 0 and less than 5 TB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html#cfn-s3-storagelensgroup-matchobjectsize-bytesgreaterthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html#cfn-s3-storagelensgroup-matchobjectsize-bytesgreaterthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesGreaterThan() {
            return null;
        }

        /**
         * This property specifies the maximum object size in bytes.
         * <p>
         * The value must be a positive number, greater than the minimum object size and less than 5 TB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html#cfn-s3-storagelensgroup-matchobjectsize-byteslessthan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-matchobjectsize.html#cfn-s3-storagelensgroup-matchobjectsize-byteslessthan</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesLessThan() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MatchObjectSizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchObjectSizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchObjectSizeProperty> {
            java.lang.Number bytesGreaterThan;
            java.lang.Number bytesLessThan;

            /**
             * Sets the value of {@link MatchObjectSizeProperty#getBytesGreaterThan}
             * @param bytesGreaterThan This property specifies the minimum object size in bytes.
             *                         The value must be a positive number, greater than 0 and less than 5 TB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesGreaterThan(java.lang.Number bytesGreaterThan) {
                this.bytesGreaterThan = bytesGreaterThan;
                return this;
            }

            /**
             * Sets the value of {@link MatchObjectSizeProperty#getBytesLessThan}
             * @param bytesLessThan This property specifies the maximum object size in bytes.
             *                      The value must be a positive number, greater than the minimum object size and less than 5 TB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesLessThan(java.lang.Number bytesLessThan) {
                this.bytesLessThan = bytesLessThan;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchObjectSizeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchObjectSizeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchObjectSizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchObjectSizeProperty {
            private final java.lang.Number bytesGreaterThan;
            private final java.lang.Number bytesLessThan;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bytesGreaterThan = software.amazon.jsii.Kernel.get(this, "bytesGreaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bytesLessThan = software.amazon.jsii.Kernel.get(this, "bytesLessThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bytesGreaterThan = builder.bytesGreaterThan;
                this.bytesLessThan = builder.bytesLessThan;
            }

            @Override
            public final java.lang.Number getBytesGreaterThan() {
                return this.bytesGreaterThan;
            }

            @Override
            public final java.lang.Number getBytesLessThan() {
                return this.bytesLessThan;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBytesGreaterThan() != null) {
                    data.set("bytesGreaterThan", om.valueToTree(this.getBytesGreaterThan()));
                }
                if (this.getBytesLessThan() != null) {
                    data.set("bytesLessThan", om.valueToTree(this.getBytesLessThan()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroup.MatchObjectSizeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchObjectSizeProperty.Jsii$Proxy that = (MatchObjectSizeProperty.Jsii$Proxy) o;

                if (this.bytesGreaterThan != null ? !this.bytesGreaterThan.equals(that.bytesGreaterThan) : that.bytesGreaterThan != null) return false;
                return this.bytesLessThan != null ? this.bytesLessThan.equals(that.bytesLessThan) : that.bytesLessThan == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bytesGreaterThan != null ? this.bytesGreaterThan.hashCode() : 0;
                result = 31 * result + (this.bytesLessThan != null ? this.bytesLessThan.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This resource contains the <code>Or</code> logical operator, which allows multiple filter conditions to be joined for more complex comparisons of Storage Lens group data.
     * <p>
     * Objects can match any of the listed filter conditions that are joined by the <code>Or</code> logical operator. Only one of each filter condition is allowed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.s3.*;
     * OrProperty orProperty = OrProperty.builder()
     *         .matchAnyPrefix(List.of("matchAnyPrefix"))
     *         .matchAnySuffix(List.of("matchAnySuffix"))
     *         .matchAnyTag(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .matchObjectAge(MatchObjectAgeProperty.builder()
     *                 .daysGreaterThan(123)
     *                 .daysLessThan(123)
     *                 .build())
     *         .matchObjectSize(MatchObjectSizeProperty.builder()
     *                 .bytesGreaterThan(123)
     *                 .bytesLessThan(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnStorageLensGroup.OrProperty")
    @software.amazon.jsii.Jsii.Proxy(OrProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This property contains a list of prefixes.
         * <p>
         * At least one prefix must be specified. Up to 10 prefixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnyPrefix() {
            return null;
        }

        /**
         * This property contains the list of suffixes.
         * <p>
         * At least one suffix must be specified. Up to 10 suffixes are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanysuffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanysuffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchAnySuffix() {
            return null;
        }

        /**
         * This property contains the list of S3 object tags.
         * <p>
         * At least one object tag must be specified. Up to 10 object tags are allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanytag">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchanytag</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchAnyTag() {
            return null;
        }

        /**
         * This property filters objects that match the specified object age range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchobjectage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchobjectage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectAge() {
            return null;
        }

        /**
         * This property contains the <code>BytesGreaterThan</code> and <code>BytesLessThan</code> values to define the object size range (minimum and maximum number of Bytes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchobjectsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-storagelensgroup-or.html#cfn-s3-storagelensgroup-or-matchobjectsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatchObjectSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrProperty> {
            java.util.List<java.lang.String> matchAnyPrefix;
            java.util.List<java.lang.String> matchAnySuffix;
            java.lang.Object matchAnyTag;
            java.lang.Object matchObjectAge;
            java.lang.Object matchObjectSize;

            /**
             * Sets the value of {@link OrProperty#getMatchAnyPrefix}
             * @param matchAnyPrefix This property contains a list of prefixes.
             *                       At least one prefix must be specified. Up to 10 prefixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyPrefix(java.util.List<java.lang.String> matchAnyPrefix) {
                this.matchAnyPrefix = matchAnyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchAnySuffix}
             * @param matchAnySuffix This property contains the list of suffixes.
             *                       At least one suffix must be specified. Up to 10 suffixes are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnySuffix(java.util.List<java.lang.String> matchAnySuffix) {
                this.matchAnySuffix = matchAnySuffix;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of S3 object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(software.amazon.awscdk.IResolvable matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchAnyTag}
             * @param matchAnyTag This property contains the list of S3 object tags.
             *                    At least one object tag must be specified. Up to 10 object tags are allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchAnyTag(java.util.List<? extends java.lang.Object> matchAnyTag) {
                this.matchAnyTag = matchAnyTag;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchObjectAge}
             * @param matchObjectAge This property filters objects that match the specified object age range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.IResolvable matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchObjectAge}
             * @param matchObjectAge This property filters objects that match the specified object age range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectAge(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectAgeProperty matchObjectAge) {
                this.matchObjectAge = matchObjectAge;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains the <code>BytesGreaterThan</code> and <code>BytesLessThan</code> values to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.IResolvable matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Sets the value of {@link OrProperty#getMatchObjectSize}
             * @param matchObjectSize This property contains the <code>BytesGreaterThan</code> and <code>BytesLessThan</code> values to define the object size range (minimum and maximum number of Bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchObjectSize(software.amazon.awscdk.services.s3.CfnStorageLensGroup.MatchObjectSizeProperty matchObjectSize) {
                this.matchObjectSize = matchObjectSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrProperty {
            private final java.util.List<java.lang.String> matchAnyPrefix;
            private final java.util.List<java.lang.String> matchAnySuffix;
            private final java.lang.Object matchAnyTag;
            private final java.lang.Object matchObjectAge;
            private final java.lang.Object matchObjectSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchAnyPrefix = software.amazon.jsii.Kernel.get(this, "matchAnyPrefix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnySuffix = software.amazon.jsii.Kernel.get(this, "matchAnySuffix", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.matchAnyTag = software.amazon.jsii.Kernel.get(this, "matchAnyTag", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectAge = software.amazon.jsii.Kernel.get(this, "matchObjectAge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchObjectSize = software.amazon.jsii.Kernel.get(this, "matchObjectSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchAnyPrefix = builder.matchAnyPrefix;
                this.matchAnySuffix = builder.matchAnySuffix;
                this.matchAnyTag = builder.matchAnyTag;
                this.matchObjectAge = builder.matchObjectAge;
                this.matchObjectSize = builder.matchObjectSize;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnyPrefix() {
                return this.matchAnyPrefix;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchAnySuffix() {
                return this.matchAnySuffix;
            }

            @Override
            public final java.lang.Object getMatchAnyTag() {
                return this.matchAnyTag;
            }

            @Override
            public final java.lang.Object getMatchObjectAge() {
                return this.matchObjectAge;
            }

            @Override
            public final java.lang.Object getMatchObjectSize() {
                return this.matchObjectSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMatchAnyPrefix() != null) {
                    data.set("matchAnyPrefix", om.valueToTree(this.getMatchAnyPrefix()));
                }
                if (this.getMatchAnySuffix() != null) {
                    data.set("matchAnySuffix", om.valueToTree(this.getMatchAnySuffix()));
                }
                if (this.getMatchAnyTag() != null) {
                    data.set("matchAnyTag", om.valueToTree(this.getMatchAnyTag()));
                }
                if (this.getMatchObjectAge() != null) {
                    data.set("matchObjectAge", om.valueToTree(this.getMatchObjectAge()));
                }
                if (this.getMatchObjectSize() != null) {
                    data.set("matchObjectSize", om.valueToTree(this.getMatchObjectSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnStorageLensGroup.OrProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrProperty.Jsii$Proxy that = (OrProperty.Jsii$Proxy) o;

                if (this.matchAnyPrefix != null ? !this.matchAnyPrefix.equals(that.matchAnyPrefix) : that.matchAnyPrefix != null) return false;
                if (this.matchAnySuffix != null ? !this.matchAnySuffix.equals(that.matchAnySuffix) : that.matchAnySuffix != null) return false;
                if (this.matchAnyTag != null ? !this.matchAnyTag.equals(that.matchAnyTag) : that.matchAnyTag != null) return false;
                if (this.matchObjectAge != null ? !this.matchObjectAge.equals(that.matchObjectAge) : that.matchObjectAge != null) return false;
                return this.matchObjectSize != null ? this.matchObjectSize.equals(that.matchObjectSize) : that.matchObjectSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchAnyPrefix != null ? this.matchAnyPrefix.hashCode() : 0;
                result = 31 * result + (this.matchAnySuffix != null ? this.matchAnySuffix.hashCode() : 0);
                result = 31 * result + (this.matchAnyTag != null ? this.matchAnyTag.hashCode() : 0);
                result = 31 * result + (this.matchObjectAge != null ? this.matchObjectAge.hashCode() : 0);
                result = 31 * result + (this.matchObjectSize != null ? this.matchObjectSize.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.s3.CfnStorageLensGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.s3.CfnStorageLensGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.s3.CfnStorageLensGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.s3.CfnStorageLensGroupProps.Builder();
        }

        /**
         * This property contains the criteria for the Storage Lens group data that is displayed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter</a>
         * @param filter This property contains the criteria for the Storage Lens group data that is displayed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(final software.amazon.awscdk.IResolvable filter) {
            this.props.filter(filter);
            return this;
        }
        /**
         * This property contains the criteria for the Storage Lens group data that is displayed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-filter</a>
         * @param filter This property contains the criteria for the Storage Lens group data that is displayed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filter(final software.amazon.awscdk.services.s3.CfnStorageLensGroup.FilterProperty filter) {
            this.props.filter(filter);
            return this;
        }

        /**
         * This property contains the Storage Lens group name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-name</a>
         * @param name This property contains the Storage Lens group name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * This property contains the AWS resource tags that you're adding to your Storage Lens group.
         * <p>
         * This parameter is optional.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3-storagelensgroup.html#cfn-s3-storagelensgroup-tags</a>
         * @param tags This property contains the AWS resource tags that you're adding to your Storage Lens group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.s3.CfnStorageLensGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.s3.CfnStorageLensGroup build() {
            return new software.amazon.awscdk.services.s3.CfnStorageLensGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
