package software.amazon.awscdk.services.s3.deployment;

/**
 * Properties for <code>BucketDeployment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket websiteBucket;
 * BucketDeployment deployment = BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(List.of(Source.asset(join(__dirname, "my-website"))))
 *         .destinationBucket(websiteBucket)
 *         .build();
 * new ConstructThatReadsFromTheBucket(this, "Consumer", Map.of(
 *         // Use 'deployment.deployedBucket' instead of 'websiteBucket' here
 *         "bucket", deployment.getDeployedBucket()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:39.400Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.BucketDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(BucketDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket to sync the contents of the zip file to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getDestinationBucket();

    /**
     * The sources from which to deploy the contents of this bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources();

    /**
     * System-defined x-amz-acl metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl">https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
        return null;
    }

    /**
     * System-defined cache-control metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
        return null;
    }

    /**
     * System-defined cache-disposition metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentDisposition() {
        return null;
    }

    /**
     * System-defined content-encoding metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
        return null;
    }

    /**
     * System-defined content-language metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentLanguage() {
        return null;
    }

    /**
     * System-defined content-type metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
        return null;
    }

    /**
     * Key prefix in the destination bucket.
     * <p>
     * Must be &lt;=104 characters
     * <p>
     * Default: "/" (unzip to root of the destination bucket)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationKeyPrefix() {
        return null;
    }

    /**
     * The CloudFront distribution using the destination bucket as an origin.
     * <p>
     * Files in the distribution's edge caches will be invalidated after
     * files are uploaded to the destination bucket.
     * <p>
     * Default: - No invalidation occurs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
        return null;
    }

    /**
     * The file paths to invalidate in the CloudFront distribution.
     * <p>
     * Default: - All files under the destination bucket key prefix will be invalidated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDistributionPaths() {
        return null;
    }

    /**
     * The size of the AWS Lambda function’s /tmp directory in MiB.
     * <p>
     * Default: 512 MiB
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getEphemeralStorageSize() {
        return null;
    }

    /**
     * If this is set, matching files or objects will be excluded from the deployment's sync command.
     * <p>
     * This can be used to exclude a file from being pruned in the destination bucket.
     * <p>
     * If you want to just exclude files from the deployment package (which excludes these files
     * evaluated when invalidating the asset), you should leverage the <code>exclude</code> property of
     * <code>AssetOptions</code> when defining your source.
     * <p>
     * Default: - No exclude filters are used
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters">https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
        return null;
    }

    /**
     * System-defined expires metadata to be set on all objects in the deployment.
     * <p>
     * Default: - The objects in the distribution will not expire.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Expiration getExpires() {
        return null;
    }

    /**
     * If this is set, the zip file will be synced to the destination S3 bucket and extracted.
     * <p>
     * If false, the file will remain zipped in the destination bucket.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExtract() {
        return null;
    }

    /**
     * If this is set, matching files or objects will be included with the deployment's sync command.
     * <p>
     * Since all files from the deployment package are included by default, this property
     * is usually leveraged alongside an <code>exclude</code> filter.
     * <p>
     * Default: - No include filters are used and all files are included with the sync command
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters">https://docs.aws.amazon.com/cli/latest/reference/s3/index.html#use-of-exclude-and-include-filters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
        return null;
    }

    /**
     * The Log Group used for logging of events emitted by the custom resource's lambda function.
     * <p>
     * Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
     * If you are deploying to another type of region, please check regional availability first.
     * <p>
     * Default: - a default log group created by AWS Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * The number of days that the lambda function's log events are kept in CloudWatch Logs.
     * <p>
     * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
     * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
     * <p>
     * If you are deploying large files, you will need to increase this number
     * accordingly.
     * <p>
     * Default: 128
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimit() {
        return null;
    }

    /**
     * User-defined object metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No user metadata is set
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#UserMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getMetadata() {
        return null;
    }

    /**
     * If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html">https://docs.aws.amazon.com/cli/latest/reference/s3/sync.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrune() {
        return null;
    }

    /**
     * If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
     * <p>
     * NOTICE: Configuring this to "false" might have operational implications. Please
     * visit to the package documentation referred below to make sure you fully understand those implications.
     * <p>
     * Default: true - when resource is deleted/updated, files are retained
     * <p>
     * @see <a href="https://github.com/aws/aws-cdk/tree/main/packages/aws-cdk-lib/aws-s3-deployment#retain-on-delete">https://github.com/aws/aws-cdk/tree/main/packages/aws-cdk-lib/aws-s3-deployment#retain-on-delete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRetainOnDelete() {
        return null;
    }

    /**
     * Execution role associated with this function.
     * <p>
     * Default: - A role is automatically created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Server side encryption is not used.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionAwsKmsKeyId() {
        return null;
    }

    /**
     * System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
     * <p>
     * Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
     * <p>
     * Default: - Not set.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro">https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html#sse-c-how-to-programmatically-intro</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideEncryptionCustomerAlgorithm() {
        return null;
    }

    /**
     * If set to true, uploads will precompute the value of <code>x-amz-content-sha256</code> and include it in the signed S3 request headers.
     * <p>
     * Default: - `x-amz-content-sha256` will not be computed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSignContent() {
        return null;
    }

    /**
     * System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
     * <p>
     * Default: - Default storage-class for the bucket is used.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
        return null;
    }

    /**
     * Mount an EFS file system.
     * <p>
     * Enable this if your assets are large and you encounter disk space errors.
     * Enabling this option will require a VPC to be specified.
     * <p>
     * Default: - No EFS. Lambda has access only to 512MB of disk space.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseEfs() {
        return null;
    }

    /**
     * The VPC network to place the deployment lambda handler in.
     * <p>
     * This is required if <code>useEfs</code> is set.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Where in the VPC to place the deployment lambda handler.
     * <p>
     * Only used if 'vpc' is supplied.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
     * <p>
     * Default: - No website redirection.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#SysMetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWebsiteRedirectLocation() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketDeploymentProps> {
        software.amazon.awscdk.services.s3.IBucket destinationBucket;
        java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        java.lang.String contentDisposition;
        java.lang.String contentEncoding;
        java.lang.String contentLanguage;
        java.lang.String contentType;
        java.lang.String destinationKeyPrefix;
        software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        java.util.List<java.lang.String> distributionPaths;
        software.amazon.awscdk.Size ephemeralStorageSize;
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.Expiration expires;
        java.lang.Boolean extract;
        java.util.List<java.lang.String> include;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        java.lang.Number memoryLimit;
        java.util.Map<java.lang.String, java.lang.String> metadata;
        java.lang.Boolean prune;
        java.lang.Boolean retainOnDelete;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        java.lang.String serverSideEncryptionAwsKmsKeyId;
        java.lang.String serverSideEncryptionCustomerAlgorithm;
        java.lang.Boolean signContent;
        software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        java.lang.Boolean useEfs;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        java.lang.String websiteRedirectLocation;

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationBucket}
         * @param destinationBucket The S3 bucket to sync the contents of the zip file to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationBucket(software.amazon.awscdk.services.s3.IBucket destinationBucket) {
            this.destinationBucket = destinationBucket;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getSources}
         * @param sources The sources from which to deploy the contents of this bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sources(java.util.List<? extends software.amazon.awscdk.services.s3.deployment.ISource> sources) {
            this.sources = (java.util.List<software.amazon.awscdk.services.s3.deployment.ISource>)sources;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getAccessControl}
         * @param accessControl System-defined x-amz-acl metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessControl(software.amazon.awscdk.services.s3.BucketAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getCacheControl}
         * @param cacheControl System-defined cache-control metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cacheControl(java.util.List<? extends software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl) {
            this.cacheControl = (java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl>)cacheControl;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentDisposition}
         * @param contentDisposition System-defined cache-disposition metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentDisposition(java.lang.String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentEncoding}
         * @param contentEncoding System-defined content-encoding metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentEncoding(java.lang.String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentLanguage}
         * @param contentLanguage System-defined content-language metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentLanguage(java.lang.String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getContentType}
         * @param contentType System-defined content-type metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDestinationKeyPrefix}
         * @param destinationKeyPrefix Key prefix in the destination bucket.
         *                             Must be &lt;=104 characters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationKeyPrefix(java.lang.String destinationKeyPrefix) {
            this.destinationKeyPrefix = destinationKeyPrefix;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistribution}
         * @param distribution The CloudFront distribution using the destination bucket as an origin.
         *                     Files in the distribution's edge caches will be invalidated after
         *                     files are uploaded to the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distribution(software.amazon.awscdk.services.cloudfront.IDistribution distribution) {
            this.distribution = distribution;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getDistributionPaths}
         * @param distributionPaths The file paths to invalidate in the CloudFront distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionPaths(java.util.List<java.lang.String> distributionPaths) {
            this.distributionPaths = distributionPaths;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getEphemeralStorageSize}
         * @param ephemeralStorageSize The size of the AWS Lambda function’s /tmp directory in MiB.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageSize(software.amazon.awscdk.Size ephemeralStorageSize) {
            this.ephemeralStorageSize = ephemeralStorageSize;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExclude}
         * @param exclude If this is set, matching files or objects will be excluded from the deployment's sync command.
         *                This can be used to exclude a file from being pruned in the destination bucket.
         *                <p>
         *                If you want to just exclude files from the deployment package (which excludes these files
         *                evaluated when invalidating the asset), you should leverage the <code>exclude</code> property of
         *                <code>AssetOptions</code> when defining your source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExpires}
         * @param expires System-defined expires metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expires(software.amazon.awscdk.Expiration expires) {
            this.expires = expires;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getExtract}
         * @param extract If this is set, the zip file will be synced to the destination S3 bucket and extracted.
         *                If false, the file will remain zipped in the destination bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extract(java.lang.Boolean extract) {
            this.extract = extract;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getInclude}
         * @param include If this is set, matching files or objects will be included with the deployment's sync command.
         *                Since all files from the deployment package are included by default, this property
         *                is usually leveraged alongside an <code>exclude</code> filter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder include(java.util.List<java.lang.String> include) {
            this.include = include;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getLogGroup}
         * @param logGroup The Log Group used for logging of events emitted by the custom resource's lambda function.
         *                 Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
         *                 If you are deploying to another type of region, please check regional availability first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getLogRetention}
         * @param logRetention The number of days that the lambda function's log events are kept in CloudWatch Logs.
         *                     This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         *                     <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMemoryLimit}
         * @param memoryLimit The amount of memory (in MiB) to allocate to the AWS Lambda function which replicates the files from the CDK bucket to the destination bucket.
         *                    If you are deploying large files, you will need to increase this number
         *                    accordingly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimit(java.lang.Number memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getMetadata}
         * @param metadata User-defined object metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(java.util.Map<java.lang.String, java.lang.String> metadata) {
            this.metadata = metadata;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getPrune}
         * @param prune If this is set to false, files in the destination bucket that do not exist in the asset, will NOT be deleted during deployment (create/update).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRetainOnDelete}
         * @param retainOnDelete If this is set to "false", the destination files will be deleted when the resource is deleted or the destination is updated.
         *                       NOTICE: Configuring this to "false" might have operational implications. Please
         *                       visit to the package documentation referred below to make sure you fully understand those implications.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retainOnDelete(java.lang.Boolean retainOnDelete) {
            this.retainOnDelete = retainOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getRole}
         * @param role Execution role associated with this function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryption}
         * @param serverSideEncryption System-defined x-amz-server-side-encryption metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryption(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionAwsKmsKeyId}
         * @param serverSideEncryptionAwsKmsKeyId System-defined x-amz-server-side-encryption-aws-kms-key-id metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionAwsKmsKeyId(java.lang.String serverSideEncryptionAwsKmsKeyId) {
            this.serverSideEncryptionAwsKmsKeyId = serverSideEncryptionAwsKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getServerSideEncryptionCustomerAlgorithm}
         * @param serverSideEncryptionCustomerAlgorithm System-defined x-amz-server-side-encryption-customer-algorithm metadata to be set on all objects in the deployment.
         *                                              Warning: This is not a useful parameter until this bug is fixed: https://github.com/aws/aws-cdk/issues/6080
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionCustomerAlgorithm(java.lang.String serverSideEncryptionCustomerAlgorithm) {
            this.serverSideEncryptionCustomerAlgorithm = serverSideEncryptionCustomerAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getSignContent}
         * @param signContent If set to true, uploads will precompute the value of <code>x-amz-content-sha256</code> and include it in the signed S3 request headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signContent(java.lang.Boolean signContent) {
            this.signContent = signContent;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getStorageClass}
         * @param storageClass System-defined x-amz-storage-class metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageClass(software.amazon.awscdk.services.s3.deployment.StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getUseEfs}
         * @param useEfs Mount an EFS file system.
         *               Enable this if your assets are large and you encounter disk space errors.
         *               Enabling this option will require a VPC to be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useEfs(java.lang.Boolean useEfs) {
            this.useEfs = useEfs;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getVpc}
         * @param vpc The VPC network to place the deployment lambda handler in.
         *            This is required if <code>useEfs</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getVpcSubnets}
         * @param vpcSubnets Where in the VPC to place the deployment lambda handler.
         *                   Only used if 'vpc' is supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link BucketDeploymentProps#getWebsiteRedirectLocation}
         * @param websiteRedirectLocation System-defined x-amz-website-redirect-location metadata to be set on all objects in the deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder websiteRedirectLocation(java.lang.String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketDeploymentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BucketDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketDeploymentProps {
        private final software.amazon.awscdk.services.s3.IBucket destinationBucket;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> sources;
        private final software.amazon.awscdk.services.s3.BucketAccessControl accessControl;
        private final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> cacheControl;
        private final java.lang.String contentDisposition;
        private final java.lang.String contentEncoding;
        private final java.lang.String contentLanguage;
        private final java.lang.String contentType;
        private final java.lang.String destinationKeyPrefix;
        private final software.amazon.awscdk.services.cloudfront.IDistribution distribution;
        private final java.util.List<java.lang.String> distributionPaths;
        private final software.amazon.awscdk.Size ephemeralStorageSize;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.Expiration expires;
        private final java.lang.Boolean extract;
        private final java.util.List<java.lang.String> include;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final java.lang.Number memoryLimit;
        private final java.util.Map<java.lang.String, java.lang.String> metadata;
        private final java.lang.Boolean prune;
        private final java.lang.Boolean retainOnDelete;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption serverSideEncryption;
        private final java.lang.String serverSideEncryptionAwsKmsKeyId;
        private final java.lang.String serverSideEncryptionCustomerAlgorithm;
        private final java.lang.Boolean signContent;
        private final software.amazon.awscdk.services.s3.deployment.StorageClass storageClass;
        private final java.lang.Boolean useEfs;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final java.lang.String websiteRedirectLocation;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationBucket = software.amazon.jsii.Kernel.get(this, "destinationBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.sources = software.amazon.jsii.Kernel.get(this, "sources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class)));
            this.accessControl = software.amazon.jsii.Kernel.get(this, "accessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.BucketAccessControl.class));
            this.cacheControl = software.amazon.jsii.Kernel.get(this, "cacheControl", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.CacheControl.class)));
            this.contentDisposition = software.amazon.jsii.Kernel.get(this, "contentDisposition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentEncoding = software.amazon.jsii.Kernel.get(this, "contentEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentLanguage = software.amazon.jsii.Kernel.get(this, "contentLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationKeyPrefix = software.amazon.jsii.Kernel.get(this, "destinationKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distribution = software.amazon.jsii.Kernel.get(this, "distribution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IDistribution.class));
            this.distributionPaths = software.amazon.jsii.Kernel.get(this, "distributionPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ephemeralStorageSize = software.amazon.jsii.Kernel.get(this, "ephemeralStorageSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.expires = software.amazon.jsii.Kernel.get(this, "expires", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Expiration.class));
            this.extract = software.amazon.jsii.Kernel.get(this, "extract", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.memoryLimit = software.amazon.jsii.Kernel.get(this, "memoryLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.retainOnDelete = software.amazon.jsii.Kernel.get(this, "retainOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.serverSideEncryption = software.amazon.jsii.Kernel.get(this, "serverSideEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ServerSideEncryption.class));
            this.serverSideEncryptionAwsKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionAwsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverSideEncryptionCustomerAlgorithm = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionCustomerAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signContent = software.amazon.jsii.Kernel.get(this, "signContent", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.storageClass = software.amazon.jsii.Kernel.get(this, "storageClass", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.StorageClass.class));
            this.useEfs = software.amazon.jsii.Kernel.get(this, "useEfs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.websiteRedirectLocation = software.amazon.jsii.Kernel.get(this, "websiteRedirectLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationBucket = java.util.Objects.requireNonNull(builder.destinationBucket, "destinationBucket is required");
            this.sources = (java.util.List<software.amazon.awscdk.services.s3.deployment.ISource>)java.util.Objects.requireNonNull(builder.sources, "sources is required");
            this.accessControl = builder.accessControl;
            this.cacheControl = (java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl>)builder.cacheControl;
            this.contentDisposition = builder.contentDisposition;
            this.contentEncoding = builder.contentEncoding;
            this.contentLanguage = builder.contentLanguage;
            this.contentType = builder.contentType;
            this.destinationKeyPrefix = builder.destinationKeyPrefix;
            this.distribution = builder.distribution;
            this.distributionPaths = builder.distributionPaths;
            this.ephemeralStorageSize = builder.ephemeralStorageSize;
            this.exclude = builder.exclude;
            this.expires = builder.expires;
            this.extract = builder.extract;
            this.include = builder.include;
            this.logGroup = builder.logGroup;
            this.logRetention = builder.logRetention;
            this.memoryLimit = builder.memoryLimit;
            this.metadata = builder.metadata;
            this.prune = builder.prune;
            this.retainOnDelete = builder.retainOnDelete;
            this.role = builder.role;
            this.serverSideEncryption = builder.serverSideEncryption;
            this.serverSideEncryptionAwsKmsKeyId = builder.serverSideEncryptionAwsKmsKeyId;
            this.serverSideEncryptionCustomerAlgorithm = builder.serverSideEncryptionCustomerAlgorithm;
            this.signContent = builder.signContent;
            this.storageClass = builder.storageClass;
            this.useEfs = builder.useEfs;
            this.vpc = builder.vpc;
            this.vpcSubnets = builder.vpcSubnets;
            this.websiteRedirectLocation = builder.websiteRedirectLocation;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getDestinationBucket() {
            return this.destinationBucket;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.deployment.ISource> getSources() {
            return this.sources;
        }

        @Override
        public final software.amazon.awscdk.services.s3.BucketAccessControl getAccessControl() {
            return this.accessControl;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.deployment.CacheControl> getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final java.lang.String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final java.lang.String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final java.lang.String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDestinationKeyPrefix() {
            return this.destinationKeyPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IDistribution getDistribution() {
            return this.distribution;
        }

        @Override
        public final java.util.List<java.lang.String> getDistributionPaths() {
            return this.distributionPaths;
        }

        @Override
        public final software.amazon.awscdk.Size getEphemeralStorageSize() {
            return this.ephemeralStorageSize;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.Expiration getExpires() {
            return this.expires;
        }

        @Override
        public final java.lang.Boolean getExtract() {
            return this.extract;
        }

        @Override
        public final java.util.List<java.lang.String> getInclude() {
            return this.include;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final java.lang.Number getMemoryLimit() {
            return this.memoryLimit;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.lang.Boolean getRetainOnDelete() {
            return this.retainOnDelete;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.ServerSideEncryption getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final java.lang.String getServerSideEncryptionAwsKmsKeyId() {
            return this.serverSideEncryptionAwsKmsKeyId;
        }

        @Override
        public final java.lang.String getServerSideEncryptionCustomerAlgorithm() {
            return this.serverSideEncryptionCustomerAlgorithm;
        }

        @Override
        public final java.lang.Boolean getSignContent() {
            return this.signContent;
        }

        @Override
        public final software.amazon.awscdk.services.s3.deployment.StorageClass getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final java.lang.Boolean getUseEfs() {
            return this.useEfs;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final java.lang.String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationBucket", om.valueToTree(this.getDestinationBucket()));
            data.set("sources", om.valueToTree(this.getSources()));
            if (this.getAccessControl() != null) {
                data.set("accessControl", om.valueToTree(this.getAccessControl()));
            }
            if (this.getCacheControl() != null) {
                data.set("cacheControl", om.valueToTree(this.getCacheControl()));
            }
            if (this.getContentDisposition() != null) {
                data.set("contentDisposition", om.valueToTree(this.getContentDisposition()));
            }
            if (this.getContentEncoding() != null) {
                data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
            }
            if (this.getContentLanguage() != null) {
                data.set("contentLanguage", om.valueToTree(this.getContentLanguage()));
            }
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDestinationKeyPrefix() != null) {
                data.set("destinationKeyPrefix", om.valueToTree(this.getDestinationKeyPrefix()));
            }
            if (this.getDistribution() != null) {
                data.set("distribution", om.valueToTree(this.getDistribution()));
            }
            if (this.getDistributionPaths() != null) {
                data.set("distributionPaths", om.valueToTree(this.getDistributionPaths()));
            }
            if (this.getEphemeralStorageSize() != null) {
                data.set("ephemeralStorageSize", om.valueToTree(this.getEphemeralStorageSize()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getExpires() != null) {
                data.set("expires", om.valueToTree(this.getExpires()));
            }
            if (this.getExtract() != null) {
                data.set("extract", om.valueToTree(this.getExtract()));
            }
            if (this.getInclude() != null) {
                data.set("include", om.valueToTree(this.getInclude()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getMemoryLimit() != null) {
                data.set("memoryLimit", om.valueToTree(this.getMemoryLimit()));
            }
            if (this.getMetadata() != null) {
                data.set("metadata", om.valueToTree(this.getMetadata()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getRetainOnDelete() != null) {
                data.set("retainOnDelete", om.valueToTree(this.getRetainOnDelete()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getServerSideEncryption() != null) {
                data.set("serverSideEncryption", om.valueToTree(this.getServerSideEncryption()));
            }
            if (this.getServerSideEncryptionAwsKmsKeyId() != null) {
                data.set("serverSideEncryptionAwsKmsKeyId", om.valueToTree(this.getServerSideEncryptionAwsKmsKeyId()));
            }
            if (this.getServerSideEncryptionCustomerAlgorithm() != null) {
                data.set("serverSideEncryptionCustomerAlgorithm", om.valueToTree(this.getServerSideEncryptionCustomerAlgorithm()));
            }
            if (this.getSignContent() != null) {
                data.set("signContent", om.valueToTree(this.getSignContent()));
            }
            if (this.getStorageClass() != null) {
                data.set("storageClass", om.valueToTree(this.getStorageClass()));
            }
            if (this.getUseEfs() != null) {
                data.set("useEfs", om.valueToTree(this.getUseEfs()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getWebsiteRedirectLocation() != null) {
                data.set("websiteRedirectLocation", om.valueToTree(this.getWebsiteRedirectLocation()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_deployment.BucketDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketDeploymentProps.Jsii$Proxy that = (BucketDeploymentProps.Jsii$Proxy) o;

            if (!destinationBucket.equals(that.destinationBucket)) return false;
            if (!sources.equals(that.sources)) return false;
            if (this.accessControl != null ? !this.accessControl.equals(that.accessControl) : that.accessControl != null) return false;
            if (this.cacheControl != null ? !this.cacheControl.equals(that.cacheControl) : that.cacheControl != null) return false;
            if (this.contentDisposition != null ? !this.contentDisposition.equals(that.contentDisposition) : that.contentDisposition != null) return false;
            if (this.contentEncoding != null ? !this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding != null) return false;
            if (this.contentLanguage != null ? !this.contentLanguage.equals(that.contentLanguage) : that.contentLanguage != null) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.destinationKeyPrefix != null ? !this.destinationKeyPrefix.equals(that.destinationKeyPrefix) : that.destinationKeyPrefix != null) return false;
            if (this.distribution != null ? !this.distribution.equals(that.distribution) : that.distribution != null) return false;
            if (this.distributionPaths != null ? !this.distributionPaths.equals(that.distributionPaths) : that.distributionPaths != null) return false;
            if (this.ephemeralStorageSize != null ? !this.ephemeralStorageSize.equals(that.ephemeralStorageSize) : that.ephemeralStorageSize != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.expires != null ? !this.expires.equals(that.expires) : that.expires != null) return false;
            if (this.extract != null ? !this.extract.equals(that.extract) : that.extract != null) return false;
            if (this.include != null ? !this.include.equals(that.include) : that.include != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.memoryLimit != null ? !this.memoryLimit.equals(that.memoryLimit) : that.memoryLimit != null) return false;
            if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.retainOnDelete != null ? !this.retainOnDelete.equals(that.retainOnDelete) : that.retainOnDelete != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.serverSideEncryption != null ? !this.serverSideEncryption.equals(that.serverSideEncryption) : that.serverSideEncryption != null) return false;
            if (this.serverSideEncryptionAwsKmsKeyId != null ? !this.serverSideEncryptionAwsKmsKeyId.equals(that.serverSideEncryptionAwsKmsKeyId) : that.serverSideEncryptionAwsKmsKeyId != null) return false;
            if (this.serverSideEncryptionCustomerAlgorithm != null ? !this.serverSideEncryptionCustomerAlgorithm.equals(that.serverSideEncryptionCustomerAlgorithm) : that.serverSideEncryptionCustomerAlgorithm != null) return false;
            if (this.signContent != null ? !this.signContent.equals(that.signContent) : that.signContent != null) return false;
            if (this.storageClass != null ? !this.storageClass.equals(that.storageClass) : that.storageClass != null) return false;
            if (this.useEfs != null ? !this.useEfs.equals(that.useEfs) : that.useEfs != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            return this.websiteRedirectLocation != null ? this.websiteRedirectLocation.equals(that.websiteRedirectLocation) : that.websiteRedirectLocation == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationBucket.hashCode();
            result = 31 * result + (this.sources.hashCode());
            result = 31 * result + (this.accessControl != null ? this.accessControl.hashCode() : 0);
            result = 31 * result + (this.cacheControl != null ? this.cacheControl.hashCode() : 0);
            result = 31 * result + (this.contentDisposition != null ? this.contentDisposition.hashCode() : 0);
            result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
            result = 31 * result + (this.contentLanguage != null ? this.contentLanguage.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.destinationKeyPrefix != null ? this.destinationKeyPrefix.hashCode() : 0);
            result = 31 * result + (this.distribution != null ? this.distribution.hashCode() : 0);
            result = 31 * result + (this.distributionPaths != null ? this.distributionPaths.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorageSize != null ? this.ephemeralStorageSize.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
            result = 31 * result + (this.extract != null ? this.extract.hashCode() : 0);
            result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.memoryLimit != null ? this.memoryLimit.hashCode() : 0);
            result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.retainOnDelete != null ? this.retainOnDelete.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryption != null ? this.serverSideEncryption.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionAwsKmsKeyId != null ? this.serverSideEncryptionAwsKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionCustomerAlgorithm != null ? this.serverSideEncryptionCustomerAlgorithm.hashCode() : 0);
            result = 31 * result + (this.signContent != null ? this.signContent.hashCode() : 0);
            result = 31 * result + (this.storageClass != null ? this.storageClass.hashCode() : 0);
            result = 31 * result + (this.useEfs != null ? this.useEfs.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.websiteRedirectLocation != null ? this.websiteRedirectLocation.hashCode() : 0);
            return result;
        }
    }
}
