package software.amazon.awscdk.services.ses;

/**
 * Options for BYO DKIM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IPublicHostedZone myHostedZone;
 * EmailIdentity.Builder.create(this, "Identity")
 *         .identity(Identity.publicHostedZone(myHostedZone))
 *         .dkimIdentity(DkimIdentity.byoDkim(ByoDkimOptions.builder()
 *                 .privateKey(SecretValue.secretsManager("dkim-private-key"))
 *                 .publicKey("...base64-encoded-public-key...")
 *                 .selector("selector")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.070Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.ByoDkimOptions")
@software.amazon.jsii.Jsii.Proxy(ByoDkimOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ByoDkimOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The private key that's used to generate a DKIM signature.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getPrivateKey();

    /**
     * A string that's used to identify a public key in the DNS configuration for a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSelector();

    /**
     * The public key.
     * <p>
     * If specified, a TXT record with the public key is created.
     * <p>
     * Default: - the validation TXT record with the public key is not created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ByoDkimOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ByoDkimOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ByoDkimOptions> {
        software.amazon.awscdk.SecretValue privateKey;
        java.lang.String selector;
        java.lang.String publicKey;

        /**
         * Sets the value of {@link ByoDkimOptions#getPrivateKey}
         * @param privateKey The private key that's used to generate a DKIM signature. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateKey(software.amazon.awscdk.SecretValue privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        /**
         * Sets the value of {@link ByoDkimOptions#getSelector}
         * @param selector A string that's used to identify a public key in the DNS configuration for a domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selector(java.lang.String selector) {
            this.selector = selector;
            return this;
        }

        /**
         * Sets the value of {@link ByoDkimOptions#getPublicKey}
         * @param publicKey The public key.
         *                  If specified, a TXT record with the public key is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKey(java.lang.String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ByoDkimOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ByoDkimOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ByoDkimOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ByoDkimOptions {
        private final software.amazon.awscdk.SecretValue privateKey;
        private final java.lang.String selector;
        private final java.lang.String publicKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.selector = software.amazon.jsii.Kernel.get(this, "selector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicKey = software.amazon.jsii.Kernel.get(this, "publicKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.privateKey = java.util.Objects.requireNonNull(builder.privateKey, "privateKey is required");
            this.selector = java.util.Objects.requireNonNull(builder.selector, "selector is required");
            this.publicKey = builder.publicKey;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final java.lang.String getSelector() {
            return this.selector;
        }

        @Override
        public final java.lang.String getPublicKey() {
            return this.publicKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("privateKey", om.valueToTree(this.getPrivateKey()));
            data.set("selector", om.valueToTree(this.getSelector()));
            if (this.getPublicKey() != null) {
                data.set("publicKey", om.valueToTree(this.getPublicKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.ByoDkimOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ByoDkimOptions.Jsii$Proxy that = (ByoDkimOptions.Jsii$Proxy) o;

            if (!privateKey.equals(that.privateKey)) return false;
            if (!selector.equals(that.selector)) return false;
            return this.publicKey != null ? this.publicKey.equals(that.publicKey) : that.publicKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.privateKey.hashCode();
            result = 31 * result + (this.selector.hashCode());
            result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
            return result;
        }
    }
}
