package software.amazon.awscdk.services.synthetics;

/**
 * Different ways to clean up underlying Canary resources when the Canary is deleted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Canary canary = Canary.Builder.create(this, "Canary")
 *         .test(Test.custom(CustomTestOptions.builder()
 *                 .handler("index.handler")
 *                 .code(Code.fromInline("/* Synthetics handler code"))
 *                 .build()))
 *         .cleanup(Cleanup.LAMBDA)
 *         .runtime(Runtime.SYNTHETICS_NODEJS_PUPPETEER_6_2)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-02-23T02:06:40.733Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_synthetics.Cleanup")
public enum Cleanup {
    /**
     * Clean up nothing.
     * <p>
     * The user is responsible for cleaning up
     * all resources left behind by the Canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NOTHING,
    /**
     * Clean up the underlying Lambda function only.
     * <p>
     * The user is
     * responsible for cleaning up all other resources left behind
     * by the Canary.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
}
