/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.IStage;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.MethodProps;
import software.amazon.awscdk.services.apigateway.MethodResponse;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigateway.Method")
public class Method
extends Resource {
    protected Method(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Method(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Method(@NotNull Construct scope, @NotNull String id, @NotNull MethodProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addMethodResponse(@NotNull MethodResponse methodResponse) {
        Kernel.call((Object)this, (String)"addMethodResponse", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(methodResponse, "methodResponse is required")});
    }

    @NotNull
    public Grant grantExecute(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantExecute", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricCacheHitCount(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheHitCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricCacheHitCount(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheHitCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricCacheMissCount(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheMissCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricCacheMissCount(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricCacheMissCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricClientError(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricClientError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricClientError(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricClientError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricCount(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricCount(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricIntegrationLatency(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIntegrationLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricIntegrationLatency(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricIntegrationLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricLatency(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricLatency(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public Metric metricServerError(@NotNull IStage stage, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricServerError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required"), props});
    }

    @NotNull
    public Metric metricServerError(@NotNull IStage stage) {
        return (Metric)Kernel.call((Object)this, (String)"metricServerError", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(stage, "stage is required")});
    }

    @NotNull
    public IRestApi getApi() {
        return (IRestApi)Kernel.get((Object)this, (String)"api", (NativeType)NativeType.forClass(IRestApi.class));
    }

    @NotNull
    public String getHttpMethod() {
        return (String)Kernel.get((Object)this, (String)"httpMethod", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getMethodArn() {
        return (String)Kernel.get((Object)this, (String)"methodArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getMethodId() {
        return (String)Kernel.get((Object)this, (String)"methodId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResource getResource() {
        return (IResource)Kernel.get((Object)this, (String)"resource", (NativeType)NativeType.forClass(IResource.class));
    }

    @NotNull
    public String getTestMethodArn() {
        return (String)Kernel.get((Object)this, (String)"testMethodArn", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Method> {
        private final Construct scope;
        private final String id;
        private final MethodProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new MethodProps.Builder();
        }

        public Builder httpMethod(String httpMethod) {
            this.props.httpMethod(httpMethod);
            return this;
        }

        public Builder resource(IResource resource) {
            this.props.resource(resource);
            return this;
        }

        public Builder integration(Integration integration) {
            this.props.integration(integration);
            return this;
        }

        public Builder options(MethodOptions options) {
            this.props.options(options);
            return this;
        }

        public Method build() {
            return new Method(this.scope, this.id, this.props.build());
        }
    }
}

